/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.RepaintManager;
import javax.swing.UIManager;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CDFEdit
extends JFrame
implements ActionListener,
ItemListener,
MouseListener,
FocusListener,
CDFConstants,
Runnable {
    static int INITIAL_WIDTH = 400;
    static int INITIAL_HEIGHT = 200;
    static boolean defaultModal = false;
    static String osName = System.getProperty("os.name");
    private CDFEdit cdfedit;
    protected JDialog dialog;
    public MYEditor aCDFEditor;
    protected JFrame parentDriver;
    protected CDF sourceCDF;
    private String channelFile;
    private boolean cdfHandling;
    private boolean MacOS;
    private boolean WindowsOS;
    private ButtonGroup selectgp;
    private JRadioButton select0;
    private JRadioButton select1;
    private JButton entrb;
    private JButton helpb;
    private JButton quitb;
    private JButton slt1;
    private JButton slt2;
    private JCheckBox abc;
    protected JTextArea info;
    private JTextField cdf1;
    private JTextField cdf2;
    private JScrollPane scroller;
    protected String cdfspec;
    private int editSelection;
    private String currentdir;
    private String[] cdfs;
    private SimpleFileFilter cdffilter;
    private JTextField focused;
    private JTextField prevfocused;
    protected int ROWS;
    protected int COLUMNS;
    private JMenuBar menuBar;
    private JMenu menuFile;
    private JMenu menuEdit;
    private JMenu menuHelp;
    private JMenuItem menuEditCopy;
    private JMenuItem menuEditCut;
    private JMenuItem menuEditPaste;
    private JMenuItem menuFileOpen;
    private JMenuItem menuFileCreate;
    private JMenuItem menuFileExit;
    private JMenuItem menuHelpHelp;
    private int istart;
    private int iend;
    private GridBagLayout gbl;
    private GridBagConstraints gbc;
    Dimension hpad5;
    Dimension hpad10;
    Dimension hpad20;
    Dimension hpad25;
    Dimension hpad30;
    Dimension hpad40;
    Dimension hpad80;
    Dimension vpad5;
    Dimension vpad10;
    Dimension vpad20;
    Dimension vpad25;
    Dimension vpad30;
    Dimension vpad40;
    Dimension vpad80;
    Font defaultFont;
    Font boldFont;
    Font bigFont;
    Font bigboldFont;
    boolean modal;
    int frommain;

    public void run() {
        this.buildDailog();
        this.dialog.pack();
        Dimension dimension = this.dialog.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        this.dialog.setLocation(dimension2.width / 2 - dimension.width / 2, dimension2.height / 2 - dimension.height / 2);
        this.dialog.setVisible(true);
        if (this.parentDriver != null) {
            this.parentDriver.setVisible(false);
        }
    }

    public void reEnter() {
        this.dialog.setVisible(true);
        if (this.parentDriver != null) {
            this.parentDriver.setVisible(false);
        }
    }

    private final void buildDailog() {
        WindowAdapter windowAdapter = new WindowAdapter(){

            public final void windowClosing(WindowEvent windowEvent) {
                if (CDFEdit.this.frommain == 0) {
                    if (CDFEdit.this.modal) {
                        CDFEdit.this.dialog.dispose();
                    } else {
                        CDFEdit.this.dialog.setVisible(false);
                    }
                    if (CDFEdit.this.parentDriver != null) {
                        CDFEdit.this.parentDriver.setVisible(true);
                    }
                } else {
                    System.exit(1);
                }
            }
        };
        this.dialog.addWindowListener(windowAdapter);
        this.dialog.setTitle("Enter   Selections  for  CDFEdit");
        this.dialog.setSize(INITIAL_WIDTH, INITIAL_HEIGHT);
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.buildMenu();
        this.buildGUIs();
        JPanel jPanel = new JPanel(new GridLayout(4, 1), true);
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1), true);
        JPanel jPanel3 = new JPanel(new BorderLayout(), true);
        JPanel jPanel4 = new JPanel(new BorderLayout(), true);
        JLabel jLabel = new JLabel("    File Name: ");
        jPanel2.add(this.select0);
        jPanel4.add((Component)jLabel, "West");
        jPanel4.add((Component)this.cdf1, "East");
        jPanel3.add((Component)jPanel4, "West");
        jPanel3.add((Component)this.slt1, "East");
        jPanel2.add(jPanel3);
        JPanel jPanel5 = new JPanel(new GridLayout(2, 1), true);
        JPanel jPanel6 = new JPanel(new BorderLayout(), true);
        JPanel jPanel7 = new JPanel(new BorderLayout(), true);
        JLabel jLabel2 = new JLabel("    File Name: ");
        jPanel5.add(this.select1);
        jPanel7.add((Component)jLabel2, "West");
        jPanel7.add((Component)this.cdf2, "East");
        jPanel6.add((Component)jPanel7, "West");
        jPanel6.add((Component)this.slt2, "East");
        jPanel5.add(jPanel6);
        jPanel.add(jPanel2);
        jPanel.add(jPanel5);
        jPanel.add(Box.createRigidArea(this.vpad5));
        JPanel jPanel8 = new JPanel(new GridLayout(1, 5), true);
        jPanel8.add(this.abc);
        jPanel8.add(Box.createRigidArea(this.hpad10));
        jPanel8.add(Box.createRigidArea(this.hpad10));
        jPanel8.add(Box.createRigidArea(this.hpad10));
        jPanel8.add(Box.createRigidArea(this.hpad10));
        jPanel.add(jPanel8);
        this.dialog.getContentPane().add((Component)jPanel, "Center");
        JPanel jPanel9 = new JPanel(new BorderLayout(), true);
        JPanel jPanel10 = new JPanel(new GridLayout(1, 5, 50, 20), true);
        jPanel10.add(Box.createRigidArea(new Dimension(10, 1)));
        jPanel10.add(this.entrb);
        jPanel10.add(this.helpb);
        jPanel10.add(this.quitb);
        jPanel10.add(Box.createRigidArea(new Dimension(10, 1)));
        jPanel9.add((Component)jPanel10, "North");
        jPanel9.add((Component)this.scroller, "South");
        this.dialog.getContentPane().add((Component)jPanel9, "South");
    }

    private final void buildGUIs() {
        this.slt1 = new JButton("Select");
        this.slt1.addActionListener(this);
        this.slt1.setToolTipText("Select an existing CDF file for editing");
        this.cdf1 = new JTextField("", 30);
        this.cdf1.addActionListener(this);
        this.cdf1.addMouseListener(this);
        this.cdf1.addFocusListener(this);
        this.cdf1.setToolTipText("Enter an existing CDF (without extension) for editing");
        this.slt2 = new JButton("Select");
        this.slt2.addActionListener(this);
        this.slt2.setToolTipText("Select a directory/file for creating a new CDF file");
        this.cdf2 = new JTextField("", 30);
        this.cdf2.addActionListener(this);
        this.cdf2.addMouseListener(this);
        this.cdf2.addFocusListener(this);
        this.cdf2.setToolTipText("Enter a new CDF file name (without extension) to create");
        this.selectgp = new ButtonGroup();
        this.select0 = new JRadioButton("Open an existing CDF file");
        this.select1 = new JRadioButton("Create a new CDF file");
        SelectListener selectListener = new SelectListener();
        this.select0.setActionCommand("0");
        this.select1.setActionCommand("1");
        this.select0.addActionListener(selectListener);
        this.select1.addActionListener(selectListener);
        this.select0.setSelected(true);
        this.selectgp.add(this.select0);
        this.selectgp.add(this.select1);
        this.select0.setToolTipText("Edit an existing CDF");
        this.select1.setToolTipText("Create a new CDF and edit its contents");
        this.abc = new JCheckBox("About");
        this.abc.addItemListener(this);
        this.abc.setToolTipText("Check the CDF library version");
        this.entrb = new JButton(" Enter ");
        this.helpb = new JButton(" Help ");
        this.quitb = new JButton(" Quit ");
        this.entrb.addActionListener(this);
        this.helpb.addActionListener(this);
        this.quitb.addActionListener(this);
        this.entrb.setToolTipText("Continue processing...");
        this.helpb.setToolTipText("Get the help information");
        this.quitb.setToolTipText("Exit CDFEdit");
        this.info = new JTextArea(15, 20);
        this.info.setEditable(false);
        this.info.setVisible(true);
        this.scroller = new JScrollPane(){

            public final Dimension getPreferredSize() {
                return new Dimension(80, 160);
            }

            public final float getAlignmentX() {
                return 0.0f;
            }
        };
        this.scroller.getViewport().add(this.info);
    }

    private final void buildMenu() {
        this.menuBar = new JMenuBar();
        this.menuFile = new JMenu("File");
        this.menuEdit = new JMenu("Edit");
        this.menuHelp = new JMenu("Help");
        this.menuEditCopy = new JMenuItem("Copy");
        this.menuEditCut = new JMenuItem("Cut");
        this.menuEditPaste = new JMenuItem("Paste");
        this.menuFileOpen = new JMenuItem("Open");
        this.menuFileCreate = new JMenuItem("Create");
        this.menuFileExit = new JMenuItem("Exit");
        this.menuHelpHelp = new JMenuItem("Help");
        this.dialog.setJMenuBar(this.menuBar);
        this.menuBar.add(this.menuFile);
        this.menuFile.add(this.menuFileOpen);
        this.menuFile.add(this.menuFileCreate);
        this.menuFile.add(this.menuFileExit);
        this.menuFileOpen.addActionListener(this);
        this.menuFileCreate.addActionListener(this);
        this.menuFileExit.addActionListener(this);
        this.menuBar.add(this.menuEdit);
        this.menuEdit.add(this.menuEditCopy);
        this.menuEdit.add(this.menuEditCut);
        this.menuEdit.add(this.menuEditPaste);
        this.menuEditCopy.addActionListener(this);
        this.menuEditCut.addActionListener(this);
        this.menuEditPaste.addActionListener(this);
        this.menuBar.add(this.menuHelp);
        this.menuHelp.add(this.menuHelpHelp);
        this.menuHelpHelp.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.quitb || object == this.menuFileExit) {
            if (this.frommain == 0) {
                if (this.modal) {
                    this.dialog.dispose();
                } else {
                    this.dialog.setVisible(false);
                }
                if (this.parentDriver != null) {
                    this.parentDriver.setVisible(true);
                }
            } else {
                System.exit(1);
            }
        } else if (object == this.menuFileOpen || object == this.slt1) {
            this.cdf2.setText("");
            String string = CDFToolUtils.doFileChooser("Select/Enter the Source CDF File Name", 1, this.cdffilter, this.currentdir, this.cdfedit);
            if (string != null && string.trim().length() != 0) {
                if (this.MacOS) {
                    this.currentdir = string.substring(0, string.lastIndexOf(47));
                    if (string.startsWith(":") || string.startsWith("/")) {
                        string = string.substring(1);
                    }
                    string = string.replace('/', ':');
                } else {
                    int n = this.WindowsOS ? string.lastIndexOf(92) : string.lastIndexOf(47);
                    this.currentdir = n != -1 ? string.substring(0, n) : System.getProperty("user.dir");
                }
                this.cdf1.setText(string);
                System.getProperties().put("user.dir", this.currentdir);
            }
            this.select0.setSelected(true);
        } else if (object == this.menuFileCreate || object == this.slt2) {
            this.cdf1.setText("");
            String string = CDFToolUtils.doFileChooser("Select/Enter the New CDF File Name", 1, this.cdffilter, this.currentdir, this.cdfedit);
            if (string != null && string.trim().length() != 0) {
                if (this.MacOS) {
                    this.currentdir = string.substring(0, string.lastIndexOf(47));
                    if (string.startsWith(":") || string.startsWith("/")) {
                        string = string.substring(1);
                    }
                    string = string.replace('/', ':');
                } else {
                    int n = this.WindowsOS ? string.lastIndexOf(92) : string.lastIndexOf(47);
                    this.currentdir = n != -1 ? string.substring(0, n) : System.getProperty("user.dir");
                }
                this.cdf2.setText(string);
                System.getProperties().put("user.dir", this.currentdir);
            }
            this.select1.setSelected(true);
        } else if (object == this.helpb || object == this.menuHelpHelp) {
            this.info.setText("");
            try {
                InputStream inputStream = this.cdfedit.getClass().getResourceAsStream("cdfedit.txt");
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                this.info.read(inputStreamReader, null);
                this.info.setCaretPosition(0);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.info.setText("Help info is not available...");
            }
            catch (IOException iOException) {
                this.info.setText("Help info is not available...");
            }
            catch (Exception exception) {
                this.info.setText("Help info is not available...");
            }
        } else if (object == this.entrb) {
            String string = this.selectgp.getSelection().getActionCommand();
            if (string.equals("0")) {
                this.cdfspec = this.cdf1.getText();
                if (this.cdfspec == null || this.cdfspec.equals("") || this.cdfspec.trim().length() == 0) {
                    this.info.setText("Please enter the source CDF file name");
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                this.editSelection = 0;
            } else {
                this.cdfspec = this.cdf2.getText();
                if (this.cdfspec == null || this.cdfspec.equals("") || this.cdfspec.trim().length() == 0) {
                    this.info.setText("Please enter the new CDF file name");
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                this.editSelection = 1;
            }
            if (this.MacOS) {
                this.cdfspec = this.cdfspec.replace('/', ':');
                if (this.cdfspec.startsWith(":")) {
                    this.cdfspec = this.cdfspec.substring(1);
                }
            }
            if (this.getCDF()) {
                if (this.aCDFEditor != null) {
                    this.aCDFEditor = null;
                }
                this.aCDFEditor = new MYEditor(this.cdfedit, this.cdfspec);
            }
        } else if (object == this.cdf1) {
            this.cdfspec = this.cdf1.getText();
            if (this.MacOS) {
                this.cdfspec = this.cdfspec.replace('/', ':');
                if (this.cdfspec.startsWith(":")) {
                    this.cdfspec = this.cdfspec.substring(1);
                }
            }
            this.select0.setSelected(true);
        } else if (object == this.cdf2) {
            this.cdfspec = this.cdf2.getText();
            if (this.MacOS) {
                this.cdfspec = this.cdfspec.replace('/', ':');
                if (this.cdfspec.startsWith(":")) {
                    this.cdfspec = this.cdfspec.substring(1);
                }
            }
            this.select1.setSelected(true);
        } else if (object == this.menuEditCopy) {
            if (this.istart == -1) {
                this.info.setText("Where to copy from?");
                Toolkit.getDefaultToolkit().beep();
            } else {
                this.focused.setSelectionStart(this.istart);
                this.focused.setSelectionEnd(this.iend);
                this.focused.copy();
            }
        } else if (object == this.menuEditCut) {
            if (this.istart == -1) {
                this.info.setText("What to cut?");
                Toolkit.getDefaultToolkit().beep();
            } else {
                this.focused.setSelectionStart(this.istart);
                this.focused.setSelectionEnd(this.iend);
                this.focused.cut();
            }
        } else if (object == this.menuEditPaste) {
            if (this.focused == null) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                if (this.istart != -1) {
                    this.focused.setSelectionStart(this.istart);
                    this.focused.setSelectionEnd(this.iend);
                }
                try {
                    String string = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this).getTransferData(DataFlavor.stringFlavor);
                    if (string == null) {
                        this.info.setText("No current selection on clipboard");
                        Toolkit.getDefaultToolkit().beep();
                    } else if (string.indexOf("\n") != -1) {
                        this.info.setText("Multiple lines selection on clipboard - not allowed:");
                        this.info.append("\n\n");
                        this.info.append(string);
                        Toolkit.getDefaultToolkit().beep();
                    } else {
                        this.focused.paste();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    boolean getCDF() {
        try {
            int n;
            this.sourceCDF = this.editSelection == 0 ? CDF.open(this.cdfspec, 0L) : CDF.create(this.cdfspec);
            if (this.sourceCDF == null && (n = JOptionPane.showConfirmDialog(this, "Do you want to create this CDF? ", "CDF: " + this.cdfspec + " not exists!", 0)) == 0) {
                this.sourceCDF = CDF.create(this.cdfspec);
            }
            return this.sourceCDF != null;
        }
        catch (CDFException cDFException) {
            Toolkit.getDefaultToolkit().beep();
            if (this.editSelection == 0) {
                JOptionPane.showMessageDialog(this, CDFException.getStatusMsg(cDFException.getCurrentStatus()), "CDFEditor: Error", 0);
                return false;
            }
            int n = JOptionPane.showConfirmDialog(this, "Do you want to delete and re-create this CDF? ", "CDF: " + this.cdfspec + " already exists!", 0);
            if (n == 0) {
                try {
                    this.sourceCDF = CDF.open(this.cdfspec, 0L);
                    this.sourceCDF.delete();
                    this.sourceCDF = CDF.create(this.cdfspec);
                }
                catch (CDFException cDFException2) {
                    this.sourceCDF = null;
                }
            }
            return this.sourceCDF != null;
        }
    }

    void reset() {
        this.ROWS = 26;
        this.COLUMNS = 9;
    }

    public void focusGained(FocusEvent focusEvent) {
        this.focused = (JTextField)focusEvent.getSource();
        if (this.prevfocused != null) {
            this.prevfocused.setText(this.prevfocused.getText());
            if (this.iend != -1) {
                if (this.iend < this.focused.getText().length()) {
                    this.prevfocused.setCaretPosition(this.iend);
                } else {
                    this.focused.setCaretPosition(this.focused.getText().length());
                }
            }
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.istart != -1) {
            this.focused.setSelectionStart(this.istart);
            this.focused.setSelectionEnd(this.iend);
            this.prevfocused = this.focused;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.focused != null) {
            String string = this.focused.getSelectedText();
            if (string != null) {
                this.istart = this.focused.getSelectionStart();
                this.iend = this.focused.getSelectionEnd();
            } else {
                this.istart = -1;
                this.iend = -1;
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.abc && this.abc.isSelected()) {
            try {
                this.info.setText("CDF library distribution: " + CDF.getLibraryVersion());
            }
            catch (CDFException cDFException) {
                System.err.println("error: " + cDFException);
            }
            this.abc.setSelected(false);
        }
    }

    private final void makeJButton(GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, Container container, Object object, int n, int n2, int n3, int n4, double d, double d2) {
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        Component component = object instanceof String ? new JButton((String)object) : (Component)object;
        container.add(component);
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }

    protected JDialog getDialog() {
        return this.dialog;
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {}
        CDFEdit cDFEdit = new CDFEdit();
        cDFEdit.frommain = 1;
        String string = System.getProperty("os.version");
        String string2 = System.getProperty("java.version");
        if (osName.toLowerCase().indexOf("windows") != -1 && string.compareTo("5.0") >= 0 && string2.compareTo("1.4") >= 0) {
            try {
                Runtime runtime = Runtime.getRuntime();
                Process process = runtime.exec("cmd /c assoc .cdf");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()), 8192);
                try {
                    process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("Error with assoc... 1 " + interruptedException);
                }
                cDFEdit.channelFile = bufferedReader.readLine();
                if (cDFEdit.channelFile != null && cDFEdit.channelFile.toLowerCase().equals(".cdf=channelfile")) {
                    process = runtime.exec("cmd /c assoc .cdf=");
                    bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()), 8192);
                    String string3 = bufferedReader.readLine();
                    try {
                        process.waitFor();
                        runtime.addShutdownHook(new RestoreChannelDefinition(cDFEdit.channelFile));
                    }
                    catch (InterruptedException interruptedException) {
                        System.err.println("Error with assoc... 2 " + interruptedException);
                    }
                }
            }
            catch (IOException iOException) {}
        }
        cDFEdit.run();
    }

    private final /* synthetic */ void this() {
        this.aCDFEditor = null;
        this.sourceCDF = null;
        this.cdfHandling = false;
        this.MacOS = false;
        this.WindowsOS = false;
        this.editSelection = -1;
        this.currentdir = System.getProperty("user.dir");
        this.cdfs = new String[]{"cdf", "CDF"};
        this.cdffilter = new SimpleFileFilter(this.cdfs, " CDF files (*.cdf, *.CDF)");
        this.focused = null;
        this.prevfocused = null;
        this.ROWS = 26;
        this.COLUMNS = 9;
        this.istart = -1;
        this.iend = -1;
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.hpad5 = new Dimension(5, 1);
        this.hpad10 = new Dimension(10, 1);
        this.hpad20 = new Dimension(20, 1);
        this.hpad25 = new Dimension(25, 1);
        this.hpad30 = new Dimension(30, 1);
        this.hpad40 = new Dimension(40, 1);
        this.hpad80 = new Dimension(80, 1);
        this.vpad5 = new Dimension(1, 5);
        this.vpad10 = new Dimension(1, 10);
        this.vpad20 = new Dimension(1, 20);
        this.vpad25 = new Dimension(1, 25);
        this.vpad30 = new Dimension(1, 30);
        this.vpad40 = new Dimension(1, 40);
        this.vpad80 = new Dimension(1, 80);
        this.defaultFont = new Font("Dialog", 0, 12);
        this.boldFont = new Font("Dialog", 1, 12);
        this.bigFont = new Font("Dialog", 0, 18);
        this.bigboldFont = new Font("Dialog", 1, 18);
        this.frommain = 0;
    }

    CDFEdit() {
        this(null, defaultModal);
    }

    CDFEdit(JFrame jFrame) {
        this(jFrame, defaultModal);
    }

    CDFEdit(JFrame jFrame, boolean bl) {
        this.this();
        this.cdfedit = this;
        this.parentDriver = jFrame;
        this.dialog = new JDialog((Frame)this, bl);
        this.modal = bl;
        if (osName.indexOf("Mac OS") != -1 && osName.indexOf("Mac OS X") == -1) {
            this.MacOS = true;
        }
        if (osName.indexOf("Windows") != -1) {
            this.WindowsOS = true;
        }
        RepaintManager.currentManager(null).setDoubleBufferingEnabled(true);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class SelectListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            CDFEdit.this.info.setText("");
        }

        private SelectListener() {
        }
    }

    private static class RestoreChannelDefinition
    extends Thread {
        String channelDefinition;

        public void run() {
            try {
                Process process = Runtime.getRuntime().exec("cmd /c assoc " + this.channelDefinition);
                try {
                    process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("Error with assoc... 3 " + interruptedException);
                }
            }
            catch (IOException iOException) {
                System.err.println("Error running assoc on Windows...(3): " + iOException);
            }
        }

        RestoreChannelDefinition(String string) {
            this.channelDefinition = string;
        }
    }
}

