;------------------------------------------------------------------------------
;
;  NSSDC/CDF				      IDL/CDF Interface, parseEPOCH3.
;
;  Version 1.0, 9-Sep-96, Hughes STX.
;
;  Modification history:
;
;   V1.0   9-Sep-96, J Love	Original version.
;
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
; parseEPOCH3.
;------------------------------------------------------------------------------

;+
; NAME:
;       parseEPOCH3
;
; PURPOSE:
;       `parseEPOCH3' is used to parse a CDF_EPOCH value from the alternate/3
;       EPOCH character string.
;
;       This function is part of the CDF interface provided with the CDF
;       distribution.  IDL also provides its own built-in interface to CDFs.
;
; CALLING SEQUENCE:
;       epoch = parseEPOCH3 (epString)
;
; INPUTS:
;       epString:       STRING.  The alternate/3 EPOCH character string.  The
;                       syntax of this string is `yyyy-mo-ddThh:mm:ss.cccZ'
;                       where `yyyy' is the year, `mm' is the month (1-12),
;                       `dd' is the day of the month (1-31), `hh' is the hour
;                       (0-23), `mm' is the minute (0-59), `ss' is the second
;                       (0-59), and `ccc' is the millisecond (0-999).
;
;       All input variables must have been created/initialized before calling
;       `parseEPOCH3'.
;
; OUTPUTS:
;       epoch:          DOUBLE (double precision floating-point).  The
;                       parsed CDF_EPOCH value.
;
;       All output variables are (re)created/assigned by `parseEPOCH3'.
;
; EXAMPLE:
;       IDL> epString = '1996-09-09T12:34:56.789Z'
;       IDL> epoch = parseEPOCH3 (epString)
;
; RESTRICTIONS:
;       None.
;
; REVISION HISTORY:
;        9-Sep-96       Original version.
;-

function parseEPOCH3, epString
on_error, 1
idl_parsepoch3, epString, epoch
return, epoch
end
