/*
 * Decompiled with CFR 0.152.
 */
package gsfc.nssdc.cdf;

import gsfc.nssdc.cdf.Attribute;
import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFData;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.CDFObject;
import gsfc.nssdc.cdf.Entry;
import gsfc.nssdc.cdf.util.CDFUtils;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class Variable
implements CDFObject,
CDFConstants {
    private CDF myCDF;
    private String name = null;
    private long id;
    private long cType;
    private long cTypeX;
    private long cPct;
    private long[] cParms = new long[1];
    private long[] cParmsX = new long[1];
    private long dataType;
    private long xdataType;
    private long numDims;
    private long numElements;
    private long xnumElements;
    private long[] dimSizes;
    private long[] dimVariances;
    private long[] dimVariancesX;
    private long maxRec;
    private Object data = null;
    private String dataSignature;
    private long recNum;
    private long recCount;
    private long recInterval;
    private long[] dimCounts;
    private long[] dimIndices;
    private long[] dimIntervals;
    private long num0toRecords;
    private long numRecords;
    private long numAllocRecords;
    private long maxAllocRecord;
    private long nRecords;
    private Object padValue = null;
    private Object padValueX = null;
    private long sparseRecords;
    private long sparseRecordsX;
    private long recVariance;
    private long recVarianceX;
    private long blockingFactor;
    private long blockingFactorX;
    private long cacheSize;
    private long reservePercent;
    private long firstRec;
    private long lastRec;

    protected static final Variable retrieve(CDF cDF, long l) throws CDFException {
        Variable variable = new Variable(cDF);
        variable.id = l;
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        Vector<String> vector5 = new Vector<String>();
        Vector<String> vector6 = new Vector<String>();
        Vector<String> vector7 = new Vector<String>();
        Vector<String> vector8 = new Vector<String>();
        Vector<String> vector9 = new Vector<String>();
        Vector<String> vector10 = new Vector<String>();
        Vector<String> vector11 = new Vector<String>();
        vector.addElement(new Long(1007L));
        vector.addElement(new Long(58L));
        vector2.addElement("name");
        vector2.addElement("Ljava/lang/String;");
        vector.addElement(vector2);
        vector.addElement(new Long(60L));
        vector3.addElement("numElements");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(59L));
        vector4.addElement("dataType");
        vector4.addElement("J");
        vector.addElement(vector4);
        vector.addElement(new Long(61L));
        vector5.addElement("numDims");
        vector5.addElement("J");
        vector.addElement(vector5);
        vector.addElement(new Long(63L));
        vector6.addElement("recVariance");
        vector6.addElement("J");
        vector.addElement(vector6);
        vector.addElement(new Long(75L));
        vector7.addElement("blockingFactor");
        vector7.addElement("J");
        vector.addElement(vector7);
        vector.addElement(new Long(132L));
        vector8.addElement("sparseRecords");
        vector8.addElement("J");
        vector.addElement(vector8);
        vector.addElement(new Long(131L));
        vector9.addElement("cType");
        vector9.addElement("J");
        vector.addElement(vector9);
        vector10.addElement("cParms");
        vector10.addElement("[J");
        vector.addElement(vector10);
        vector11.addElement("cPct");
        vector11.addElement("J");
        vector.addElement(vector11);
        vector.addElement(new Long(1000L));
        cDF.executeCommand(variable, vector);
        vector.removeAllElements();
        vector2.removeAllElements();
        vector3.removeAllElements();
        if (variable.numDims > 0L) {
            variable.dimSizes = new long[(int)variable.numDims];
            variable.dimVariances = new long[(int)variable.numDims];
            variable.dimCounts = new long[(int)variable.numDims];
            variable.dimIndices = new long[(int)variable.numDims];
            variable.dimIntervals = new long[(int)variable.numDims];
            vector.addElement(new Long(1007L));
            vector.addElement(new Long(62L));
            vector2.addElement("dimSizes");
            vector2.addElement("[J");
            vector.addElement(vector2);
            vector.addElement(new Long(64L));
            vector3.addElement("dimVariances");
            vector3.addElement("[J");
            vector.addElement(vector3);
            vector.addElement(new Long(1000L));
            cDF.executeCommand(variable, vector);
        }
        vector.removeAllElements();
        vector2.removeAllElements();
        variable.setSignature();
        vector.addElement(new Long(1007L));
        vector.addElement(new Long(73L));
        vector2.addElement("padValue");
        vector2.addElement("Ljava/lang/Object;");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        cDF.executeCommand(variable, vector);
        cDF.addVariable(variable);
        return variable;
    }

    public static Variable create(CDF cDF, String string, long l, long l2, long l3, long[] lArray, long l4, long[] lArray2) throws CDFException {
        long l5 = cDF.getVariableID(string);
        if (l5 != -1L) {
            throw new CDFException(-2025L);
        }
        if (string == null || string.length() == 0) {
            throw new CDFException(-2045L);
        }
        Variable variable = new Variable(cDF);
        variable.myCDF = cDF;
        variable.name = string;
        variable.dataType = l;
        variable.numElements = l2;
        variable.numDims = l3;
        variable.dimSizes = lArray;
        variable.recVariance = l4;
        variable.dimVariances = lArray2;
        variable.dimIndices = new long[(int)l3];
        variable.dimCounts = new long[(int)l3];
        variable.dimIntervals = new long[(int)l3];
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        Vector<String> vector5 = new Vector<String>();
        Vector<String> vector6 = new Vector<String>();
        Vector<String> vector7 = new Vector<String>();
        Vector<String> vector8 = new Vector<String>();
        Vector<String> vector9 = new Vector<String>();
        vector.addElement(new Long(1001L));
        vector.addElement(new Long(57L));
        vector2.addElement("name");
        vector2.addElement("Ljava/lang/String;");
        vector.addElement(vector2);
        vector3.addElement("dataType");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector4.addElement("numElements");
        vector4.addElement("J");
        vector.addElement(vector4);
        vector5.addElement("numDims");
        vector5.addElement("J");
        vector.addElement(vector5);
        vector6.addElement("dimSizes");
        vector6.addElement("[J");
        vector.addElement(vector6);
        vector7.addElement("recVariance");
        vector7.addElement("J");
        vector.addElement(vector7);
        vector8.addElement("dimVariances");
        vector8.addElement("[J");
        vector.addElement(vector8);
        vector9.addElement("id");
        vector9.addElement("J");
        vector.addElement(vector9);
        vector.addElement(new Long(1000L));
        cDF.executeCommand(variable, vector);
        variable.setSignature();
        cDF.addVariable(variable);
        return variable;
    }

    public void delete() throws CDFException {
        Vector<Long> vector = new Vector<Long>();
        this.id = this.getID();
        vector.addElement(new Long(1003L));
        vector.addElement(new Long(57L));
        vector.addElement(new Long(1000L));
        this.myCDF.executeCommand(this, vector);
        this.myCDF.removeVariable(this);
    }

    public void rename(String string) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        this.select();
        this.name = string;
        vector.addElement(new Long(1008L));
        vector.addElement(new Long(58L));
        vector2.addElement("name");
        vector2.addElement("Ljava/lang/String;");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.myCDF.executeCommand(this, vector);
    }

    public Variable copy(String string) throws CDFException {
        return this.copy(this.myCDF, string);
    }

    public Variable copy(CDF cDF, String string) throws CDFException {
        long[] lArray;
        long[] lArray2;
        long l = cDF.getVariableID(string);
        if (l != -1L) {
            throw new CDFException(-2025L);
        }
        if (this.getNumDims() == 0L) {
            lArray2 = new long[]{1L};
            lArray = new long[]{-1L};
        } else {
            lArray2 = this.dimSizes;
            lArray = this.dimVariances;
        }
        Variable variable = Variable.create(cDF, string, this.dataType, this.numElements, this.numDims, lArray2, this.recVariance, lArray);
        Vector vector = this.myCDF.getAttributes();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (attribute.getScope() != 2L) continue;
            try {
                Entry entry = attribute.getEntry(this.getID());
                if (this.myCDF != cDF) {
                    Attribute attribute2 = cDF.getAttributeID(attribute.getName()) == -1L ? Attribute.create(cDF, attribute.getName(), 2L) : cDF.getAttribute(attribute.getName());
                    Entry.create(attribute2, variable.getID(), entry.getDataType(), entry.getData());
                    continue;
                }
                Entry.create(attribute, variable.getID(), entry.getDataType(), entry.getData());
            }
            catch (CDFException cDFException) {
                // empty catch block
            }
        }
        return variable;
    }

    public Variable duplicate(String string) throws CDFException {
        return this.duplicate(this.myCDF, string);
    }

    public Variable duplicate(CDF cDF, String string) throws CDFException {
        long[] lArray;
        long[] lArray2;
        long[] lArray3;
        Variable variable = null;
        if (this.numDims > 0L) {
            lArray3 = new long[(int)this.numDims];
            lArray2 = new long[(int)this.numDims];
            lArray = this.dimSizes;
            int n = 0;
            while ((long)n < this.numDims) {
                lArray3[n] = 0L;
                lArray2[n] = 1L;
                ++n;
            }
        } else {
            lArray = new long[]{1L};
            lArray3 = new long[]{1L};
            lArray2 = new long[]{1L};
        }
        long l = this.getMaxWrittenRecord();
        variable = this.copy(cDF, string);
        variable.setBlockingFactor(this.blockingFactor);
        variable.setCompression(this.cType, this.cParms);
        variable.setSparseRecords(this.sparseRecords);
        if (this.padValue != null) {
            variable.setPadValue(this.padValue);
        }
        if (l > -1L) {
            this.recNum = 0L;
            while (this.recNum <= l) {
                this.firstRec = this.getAllocatedFrom(this.recNum);
                this.lastRec = this.getAllocatedTo(this.firstRec);
                this.lastRec = this.lastRec > l ? l : this.lastRec;
                Object object = this.getHyperData(this.firstRec, this.lastRec - this.firstRec + 1L, 1L, lArray3, lArray, lArray2);
                variable.putHyperData(this.firstRec, this.lastRec - this.firstRec + 1L, 1L, lArray3, lArray, lArray2, object);
                this.recNum = this.lastRec + 1L;
            }
        }
        return variable;
    }

    public void copyDataRecords(Variable variable) throws CDFException {
        this.copyDataRecords(variable, 1L);
    }

    private void copyDataRecords(Variable variable, long l) throws CDFException {
        long[] lArray;
        long[] lArray2;
        long[] lArray3;
        if (this.dataType != variable.dataType || this.numElements != variable.numElements || this.numDims != variable.numDims) {
            throw new CDFException(-2104L);
        }
        int n = 0;
        while ((long)n < this.numDims) {
            if (this.dimSizes[n] != variable.dimSizes[n] || this.dimVariances[n] != variable.dimVariances[n]) {
                throw new CDFException(-2104L);
            }
            ++n;
        }
        if (this.numDims > 0L) {
            lArray3 = new long[(int)this.numDims];
            lArray2 = new long[(int)this.numDims];
            lArray = this.dimSizes;
            int n2 = 0;
            while ((long)n2 < this.numDims) {
                lArray3[n2] = 0L;
                lArray2[n2] = 1L;
                ++n2;
            }
        } else {
            lArray3 = new long[]{1L};
            lArray2 = new long[]{1L};
            lArray = new long[]{1L};
        }
        long l2 = this.getMaxWrittenRecord();
        long l3 = l == 1L ? 0L : variable.getMaxWrittenRecord() + 1L;
        if (l2 > -1L) {
            this.recNum = 0L;
            while (this.recNum <= l2) {
                this.firstRec = this.getAllocatedFrom(this.recNum);
                this.lastRec = this.getAllocatedTo(this.firstRec);
                this.lastRec = this.lastRec > l2 ? l2 : this.lastRec;
                Object object = this.getHyperData(this.firstRec, this.lastRec - this.firstRec + 1L, 1L, lArray3, lArray, lArray2);
                variable.putHyperData(l3 + this.firstRec, this.lastRec - this.firstRec + 1L, 1L, lArray3, lArray, lArray2, object);
                this.recNum = this.lastRec + 1L;
            }
        }
    }

    public void concatenateDataRecords(Variable variable) throws CDFException {
        this.copyDataRecords(variable, 2L);
    }

    public Object getEntryData(String string) throws CDFException {
        Attribute attribute = this.myCDF.getAttribute(string);
        Object object = attribute.getEntry(this).getData();
        return object;
    }

    public Object getSingleData(long l, long[] lArray) throws CDFException {
        return this.getSingleDataObject(l, lArray).getData();
    }

    public CDFData getSingleDataObject(long l, long[] lArray) throws CDFException {
        long[] lArray2;
        long[] lArray3;
        long[] lArray4;
        if (this.numDims > 0L) {
            lArray4 = new long[(int)this.numDims];
            lArray3 = new long[(int)this.numDims];
            lArray2 = lArray;
            int n = 0;
            while ((long)n < this.numDims) {
                lArray3[n] = 1L;
                lArray4[n] = 1L;
                ++n;
            }
        } else {
            lArray2 = new long[]{1L};
            lArray4 = new long[]{1L};
            lArray3 = new long[]{1L};
        }
        return CDFData.get(this, l, 1L, 1L, lArray2, lArray3, lArray4);
    }

    public Object getRecord(long l) throws CDFException {
        return this.getRecordObject(l).getData();
    }

    public CDFData getRecordObject(long l) throws CDFException {
        return this.getRecordsObject(l, 1L);
    }

    public CDFData getRecordsObject(long l, long l2) throws CDFException {
        long[] lArray;
        long[] lArray2;
        long[] lArray3;
        if (this.numDims == 0L) {
            lArray3 = new long[]{1L};
            lArray2 = new long[]{1L};
            lArray = new long[]{1L};
        } else {
            lArray3 = this.dimSizes;
            lArray2 = new long[(int)this.numDims];
            lArray = new long[(int)this.numDims];
            int n = 0;
            while ((long)n < this.numDims) {
                lArray2[n] = 0L;
                lArray[n] = 1L;
                ++n;
            }
        }
        return CDFData.get(this, l, l2, 1L, lArray2, lArray3, lArray);
    }

    public Object getScalarData() throws CDFException {
        return this.getScalarDataObject(0L).getData();
    }

    public Object getScalarData(long l) throws CDFException {
        return this.getScalarDataObject(l).getData();
    }

    public CDFData getScalarDataObject() throws CDFException {
        return this.getScalarDataObject(0L);
    }

    public CDFData getScalarDataObject(long l) throws CDFException {
        long[] lArray = new long[]{1L};
        long[] lArray2 = new long[]{1L};
        long[] lArray3 = new long[]{1L};
        return CDFData.get(this, l, 1L, 1L, lArray, lArray3, lArray2);
    }

    public Object getHyperData(long l, long l2, long l3, long[] lArray, long[] lArray2, long[] lArray3) throws CDFException {
        return CDFData.get(this, l, l2, l3, lArray, lArray2, lArray3).getData();
    }

    public CDFData getHyperDataObject(long l, long l2, long l3, long[] lArray, long[] lArray2, long[] lArray3) throws CDFException {
        return CDFData.get(this, l, l2, l3, lArray, lArray2, lArray3);
    }

    public void putEntry(String string, long l, Object object) throws CDFException {
        this.select();
        Entry.create(this.myCDF.getAttribute(string), this.getID(), l, object);
    }

    public void putEntry(Attribute attribute, long l, Object object) throws CDFException {
        this.select();
        Entry.create(attribute, this.getID(), l, object);
    }

    public CDFData putSingleData(long l, long[] lArray, Object object) throws CDFException {
        long[] lArray2;
        long[] lArray3;
        long[] lArray4;
        if (this.numDims > 0L) {
            lArray4 = new long[(int)this.numDims];
            lArray3 = new long[(int)this.numDims];
            lArray2 = lArray;
            int n = 0;
            while ((long)n < this.numDims) {
                lArray3[n] = 1L;
                lArray4[n] = 1L;
                ++n;
            }
        } else {
            lArray3 = new long[]{1L};
            lArray2 = new long[]{1L};
            lArray4 = new long[]{1L};
        }
        return CDFData.put(this, l, 1L, 1L, lArray2, lArray3, lArray4, object);
    }

    public CDFData putScalarData(long l, Object object) throws CDFException {
        return this.putSingleData(l, new long[]{0L}, object);
    }

    public CDFData putScalarData(Object object) throws CDFException {
        return this.putSingleData(0L, new long[]{0L}, object);
    }

    public CDFData putRecord(long l, Object object) throws CDFException {
        long[] lArray;
        long[] lArray2;
        long[] lArray3;
        if (this.numDims > 0L) {
            lArray3 = new long[(int)this.numDims];
            lArray2 = new long[(int)this.numDims];
            lArray = this.dimSizes;
            int n = 0;
            while ((long)n < this.numDims) {
                lArray3[n] = 0L;
                lArray2[n] = 1L;
                ++n;
            }
        } else {
            lArray = new long[]{1L};
            lArray3 = new long[]{1L};
            lArray2 = new long[]{1L};
        }
        return CDFData.put(this, l, 1L, 1L, lArray3, lArray, lArray2, object);
    }

    public CDFData putRecord(Object object) throws CDFException {
        return this.putRecord(0L, object);
    }

    public CDFData putHyperData(long l, long l2, long l3, long[] lArray, long[] lArray2, long[] lArray3, Object object) throws CDFException {
        return CDFData.put(this, l, l2, l3, lArray, lArray2, lArray3, object);
    }

    private final void select() throws CDFException {
        Vector<Long> vector = new Vector<Long>();
        this.id = this.getID();
        vector.addElement(new Long(1000L));
        this.myCDF.executeCommand(this, vector);
    }

    protected final void select(long l, long[] lArray) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        this.recNum = l;
        int n = 0;
        while ((long)n < this.numDims) {
            this.dimIndices[n] = lArray[n];
            ++n;
        }
        this.id = this.getID();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(57L));
        vector2.addElement("id");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(79L));
        vector3.addElement("recNum");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(82L));
        vector4.addElement("dimIndices");
        vector4.addElement("[J");
        vector.addElement(vector4);
        vector.addElement(new Long(1000L));
        this.myCDF.executeCommand(this, vector);
    }

    protected final void select(long l, long l2, long l3, long[] lArray, long[] lArray2, long[] lArray3) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        Vector<String> vector5 = new Vector<String>();
        Vector<String> vector6 = new Vector<String>();
        Vector<String> vector7 = new Vector<String>();
        Vector<String> vector8 = new Vector<String>();
        this.recNum = l;
        this.recCount = l2;
        this.recInterval = l3;
        this.dimIndices = lArray;
        this.dimCounts = lArray2;
        this.dimIntervals = lArray3;
        this.id = this.getID();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(57L));
        vector2.addElement("id");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(79L));
        vector3.addElement("recNum");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(80L));
        vector4.addElement("recCount");
        vector4.addElement("J");
        vector.addElement(vector4);
        vector.addElement(new Long(81L));
        vector5.addElement("recInterval");
        vector5.addElement("J");
        vector.addElement(vector5);
        vector.addElement(new Long(82L));
        vector6.addElement("dimIndices");
        vector6.addElement("[J");
        vector.addElement(vector6);
        vector.addElement(new Long(83L));
        vector7.addElement("dimCounts");
        vector7.addElement("[J");
        vector.addElement(vector7);
        vector.addElement(new Long(84L));
        vector8.addElement("dimIntervals");
        vector8.addElement("[J");
        vector.addElement(vector8);
        vector.addElement(new Long(1000L));
        this.myCDF.executeCommand(this, vector);
    }

    public CDF getMyCDF() {
        return this.myCDF;
    }

    public long getCompressionType() {
        return this.cType;
    }

    public long getCompressionPct() {
        return this.cPct;
    }

    public long[] getCompressionParms() {
        return this.cParms;
    }

    public void setCompression(long l, long[] lArray) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        this.cTypeX = l;
        this.cParmsX = lArray;
        this.id = this.getID();
        vector.addElement(new Long(1008L));
        vector.addElement(new Long(131L));
        vector2.addElement("cTypeX");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector3.addElement("cParmsX");
        vector3.addElement("[J");
        vector.addElement(vector3);
        vector.addElement(new Long(1000L));
        this.myCDF.executeCommand(this, vector);
        this.cType = l;
        this.cParms = lArray;
    }

    public String getCompression() throws CDFException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.cType == 0L) {
            stringBuffer.append("No compression");
        } else {
            stringBuffer.append(CDFUtils.getStringCompressionType(this.cType)).append(".").append(this.cParms[0]);
        }
        return stringBuffer.toString();
    }

    public long getNumDims() {
        return this.numDims;
    }

    public long[] getDimSizes() {
        return this.dimSizes;
    }

    public long getNumElements() {
        return this.numElements;
    }

    public String getName() {
        return this.name;
    }

    public long getID() {
        return this.myCDF.getVariableID(this.name);
    }

    public String toString() {
        return this.name;
    }

    public void setRecVariance(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        this.recVarianceX = l;
        this.id = this.getID();
        vector.addElement(new Long(1008L));
        vector.addElement(new Long(63L));
        vector2.addElement("recVarianceX");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.myCDF.executeCommand(this, vector);
        this.recVariance = l;
    }

    public boolean getRecVariance() {
        return this.recVariance == -1L;
    }

    public void setDimVariances(long[] lArray) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        this.dimVariancesX = lArray;
        this.id = this.getID();
        vector.addElement(new Long(1008L));
        vector.addElement(new Long(64L));
        vector2.addElement("dimVariancesX");
        vector2.addElement("[J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.myCDF.executeCommand(this, vector);
        this.dimVariances = lArray;
    }

    public long[] getDimVariances() {
        return this.dimVariances;
    }

    public long getDataType() {
        return this.dataType;
    }

    private void setSignature() {
        switch ((int)this.dataType) {
            case 1: 
            case 41: {
                this.dataSignature = "Ljava/lang/Byte;";
                break;
            }
            case 2: 
            case 11: {
                this.dataSignature = "Ljava/lang/Short;";
                break;
            }
            case 4: 
            case 12: {
                this.dataSignature = "Ljava/lang/Integer;";
                break;
            }
            case 14: {
                this.dataSignature = "Ljava/lang/Long;";
                break;
            }
            case 21: 
            case 44: {
                this.dataSignature = "Ljava/lang/Float;";
                break;
            }
            case 22: 
            case 31: 
            case 45: {
                this.dataSignature = "Ljava/lang/Double;";
                break;
            }
            case 51: 
            case 52: {
                this.dataSignature = "Ljava/lang/String;";
                break;
            }
        }
    }

    public void deleteRecords(long l, long l2) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        this.firstRec = l;
        this.lastRec = l2;
        this.id = this.getID();
        vector.addElement(new Long(1003L));
        vector.addElement(new Long(153L));
        vector2.addElement("firstRec");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector3.addElement("lastRec");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(1000L));
        this.myCDF.executeCommand(this, vector);
    }

    public void allocateBlock(long l, long l2) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        this.firstRec = l;
        this.lastRec = l2;
        this.id = this.getID();
        vector.addElement(new Long(1008L));
        vector.addElement(new Long(134L));
        vector2.addElement("firstRec");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector3.addElement("lastRec");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(1000L));
        this.myCDF.executeCommand(this, vector);
    }

    public void allocateRecords(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        this.num0toRecords = l;
        this.id = this.getID();
        vector.addElement(new Long(1008L));
        vector.addElement(new Long(124L));
        vector2.addElement("num0toRecords");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.myCDF.executeCommand(this, vector);
    }

    public long getNumWrittenRecords() throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        this.id = this.getID();
        vector.addElement(new Long(1007L));
        vector.addElement(new Long(135L));
        vector2.addElement("numRecords");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.myCDF.executeCommand(this, vector);
        return this.numRecords;
    }

    public long getMaxWrittenRecord() throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        this.id = this.getID();
        vector.addElement(new Long(1007L));
        vector.addElement(new Long(70L));
        vector2.addElement("maxRec");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.myCDF.executeCommand(this, vector);
        return this.maxRec;
    }

    public long getNumAllocatedRecords() throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        this.id = this.getID();
        vector.addElement(new Long(1007L));
        vector.addElement(new Long(136L));
        vector2.addElement("numAllocRecords");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.myCDF.executeCommand(this, vector);
        return this.numAllocRecords;
    }

    public long getMaxAllocatedRecord() throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        this.id = this.getID();
        vector.addElement(new Long(1007L));
        vector.addElement(new Long(71L));
        vector2.addElement("maxAllocRecord");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.myCDF.executeCommand(this, vector);
        return this.maxAllocRecord;
    }

    public void setPadValue(Object object) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        this.padValueX = this.padValue;
        this.padValue = object;
        this.id = this.getID();
        try {
            vector.addElement(new Long(1008L));
            vector.addElement(new Long(73L));
            vector2.addElement("padValue");
            vector2.addElement("Ljava/lang/Object;");
            vector.addElement(vector2);
            vector.addElement(new Long(1000L));
            this.myCDF.executeCommand(this, vector);
        }
        catch (CDFException cDFException) {
            this.padValue = this.padValueX;
            throw new CDFException(-2051L);
        }
    }

    public long checkPadValueExistence() throws CDFException {
        Vector<Long> vector = new Vector<Long>();
        this.id = this.getID();
        try {
            vector.addElement(new Long(1006L));
            vector.addElement(new Long(73L));
            vector.addElement(new Long(1000L));
            this.myCDF.executeCommand(this, vector);
            return this.myCDF.getStatus();
        }
        catch (CDFException cDFException) {
            throw new CDFException(-2034L);
        }
    }

    public Object getPadValue() {
        return this.padValue;
    }

    public void setSparseRecords(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        this.sparseRecordsX = l;
        this.id = this.getID();
        vector.addElement(new Long(1008L));
        vector.addElement(new Long(132L));
        vector2.addElement("sparseRecordsX");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.myCDF.executeCommand(this, vector);
        this.sparseRecords = l;
    }

    public long getSparseRecords() {
        return this.sparseRecords;
    }

    public void setBlockingFactor(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        this.blockingFactorX = l;
        this.id = this.getID();
        vector.addElement(new Long(1008L));
        vector.addElement(new Long(75L));
        vector2.addElement("blockingFactorX");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.myCDF.executeCommand(this, vector);
        this.blockingFactor = l;
    }

    public long getBlockingFactor() throws CDFException {
        return this.blockingFactor;
    }

    public void setInitialRecords(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        this.nRecords = l;
        this.id = this.getID();
        vector.addElement(new Long(1008L));
        vector.addElement(new Long(74L));
        vector2.addElement("nRecords");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.myCDF.executeCommand(this, vector);
    }

    public void selectCacheSize(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        this.cacheSize = l;
        this.id = this.getID();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(121L));
        vector2.addElement("cacheSize");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.myCDF.executeCommand(this, vector);
    }

    public long confirmCacheSize() throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        this.id = this.getID();
        vector.addElement(new Long(1006L));
        vector.addElement(new Long(121L));
        vector2.addElement("cacheSize");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.myCDF.executeCommand(this, vector);
        return this.cacheSize;
    }

    public void selectReservePercent(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        this.reservePercent = l;
        this.id = this.getID();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(151L));
        vector2.addElement("reservePercent");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.myCDF.executeCommand(this, vector);
    }

    public long confirmReservePercent() throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        this.id = this.getID();
        vector.addElement(new Long(1006L));
        vector.addElement(new Long(151L));
        vector2.addElement("reservePercent");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.myCDF.executeCommand(this, vector);
        return this.reservePercent;
    }

    public long confirmPadValue() throws CDFException {
        Vector<Long> vector = new Vector<Long>();
        this.id = this.getID();
        vector.addElement(new Long(1006L));
        vector.addElement(new Long(73L));
        vector.addElement(new Long(1000L));
        this.myCDF.executeCommand(this, vector);
        return this.myCDF.getStatus();
    }

    public long getAllocatedFrom(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        this.recNum = l;
        vector.addElement(new Long(1007L));
        vector.addElement(new Long(145L));
        vector2.addElement("recNum");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector3.addElement("firstRec");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(1000L));
        this.myCDF.executeCommand(this, vector);
        return this.firstRec;
    }

    public long getAllocatedTo(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        this.firstRec = l;
        vector.addElement(new Long(1007L));
        vector.addElement(new Long(146L));
        vector2.addElement("firstRec");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector3.addElement("lastRec");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(1000L));
        this.myCDF.executeCommand(this, vector);
        return this.lastRec;
    }

    public void updateDataSpec(long l, long l2) throws CDFException {
        this.xdataType = l;
        this.xnumElements = l2;
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        this.id = this.getID();
        this.select();
        vector.addElement(new Long(1008L));
        vector.addElement(new Long(72L));
        vector2.addElement("xdataType");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector3.addElement("xnumElements");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(1000L));
        this.myCDF.executeCommand(this, vector);
        this.dataType = l;
        this.numElements = l2;
        this.setSignature();
    }

    public Vector getAttributes() {
        Variable variable = null;
        try {
            variable = this.myCDF.getVariable(this.getName());
        }
        catch (CDFException cDFException) {
            // empty catch block
        }
        Vector<Attribute> vector = new Vector<Attribute>();
        Vector vector2 = this.myCDF.getVariableAttributes();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            try {
                Entry entry = attribute.getEntry(variable);
                if (entry == null) continue;
                vector.addElement(attribute);
            }
            catch (CDFException cDFException) {
                // empty catch block
            }
        }
        return vector;
    }

    private Variable(CDF cDF) {
        this.myCDF = cDF;
    }
}

