/*
 * Decompiled with CFR 0.152.
 */
package gsfc.nssdc.cdf;

import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.CDFObject;
import gsfc.nssdc.cdf.Entry;
import gsfc.nssdc.cdf.Variable;
import java.io.Serializable;
import java.util.Vector;

public class Attribute
implements CDFConstants,
CDFObject {
    private CDF myCDF;
    private long scope;
    private long id;
    private String name;
    private long numEntries;
    private long maxEntryNumber;
    private Vector entries;

    protected static final Attribute retrieve(CDF cDF, long l) throws CDFException {
        Attribute attribute = new Attribute(cDF);
        attribute.id = l;
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        vector.addElement(new Long(1007L));
        vector.addElement(new Long(87L));
        vector2.addElement("name");
        vector2.addElement("Ljava/lang/String;");
        vector.addElement(vector2);
        vector.addElement(new Long(86L));
        vector3.addElement("scope");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(1000L));
        cDF.executeCommand(attribute, vector);
        vector.removeAllElements();
        vector2.removeAllElements();
        vector3.removeAllElements();
        vector.addElement(new Long(1007L));
        vector.addElement(attribute.getScope() == 1L ? new Long(90L) : new Long(94L));
        vector2.addElement("numEntries");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(attribute.getScope() == 1L ? new Long(89L) : new Long(93L));
        vector3.addElement("maxEntryNumber");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(1000L));
        cDF.executeCommand(attribute, vector);
        long l2 = -1L;
        long l3 = 0L;
        if (attribute.numEntries != 0L) {
            while (true) {
                try {
                    Entry entry = Entry.retrieve(attribute, ++l2);
                    if (++l3 != attribute.numEntries) continue;
                }
                catch (CDFException cDFException) {
                    attribute.entries.addElement(null);
                    continue;
                }
                break;
            }
        }
        attribute.myCDF.addAttribute(attribute);
        return attribute;
    }

    public static Attribute create(CDF cDF, String string, long l) throws CDFException {
        if (l != 1L && l != 2L) {
            throw new CDFException(-2010L);
        }
        long l2 = cDF.getAttributeID(string);
        if (l2 != -1L) {
            throw new CDFException(-2001L);
        }
        if (string == null || string.length() == 0) {
            throw new CDFException(-2044L);
        }
        Attribute attribute = new Attribute(cDF);
        attribute.name = string;
        attribute.scope = l;
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        vector.addElement(new Long(1001L));
        vector.addElement(new Long(85L));
        vector2.addElement("name");
        vector2.addElement("Ljava/lang/String;");
        vector.addElement(vector2);
        vector3.addElement("scope");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector4.addElement("id");
        vector4.addElement("J");
        vector.addElement(vector4);
        vector.addElement(new Long(1000L));
        attribute.myCDF.executeCommand(attribute, vector);
        attribute.myCDF.addAttribute(attribute);
        if (l == 2L) {
            int n = 0;
            while (n < (int)attribute.myCDF.getNumVars()) {
                attribute.entries.addElement(null);
                ++n;
            }
        }
        return attribute;
    }

    public void delete() throws CDFException {
        Vector<Long> vector = new Vector<Long>();
        this.id = this.getID();
        vector.addElement(new Long(1003L));
        vector.addElement(new Long(85L));
        vector.addElement(new Long(1000L));
        this.myCDF.executeCommand(this, vector);
        this.myCDF.removeAttribute(this);
    }

    public Entry getEntry(long l) throws CDFException {
        if ((long)this.entries.size() <= l) {
            throw new CDFException(-2018L);
        }
        if (this.entries.elementAt((int)l) == null) {
            throw new CDFException(-2018L);
        }
        return (Entry)this.entries.elementAt((int)l);
    }

    public Entry getEntry(Variable variable) throws CDFException {
        if (this.scope != 2L) {
            throw new CDFException(-2010L);
        }
        if (variable.getID() < 0L) {
            throw new CDFException(-2019L);
        }
        return this.getEntry(variable.getID());
    }

    protected final void addEntry(Entry entry, int n) {
        int n2 = this.entries.size();
        if (n2 > n) {
            this.entries.insertElementAt(entry, n);
            this.entries.removeElementAt(n + 1);
        } else {
            if (this.scope == 1L && n2 < n) {
                int n3 = 0;
                while (n3 < n - n2) {
                    this.entries.addElement(null);
                    ++n3;
                }
            }
            this.entries.addElement(entry);
        }
    }

    protected final void removeEntry(Entry entry) {
        int n = this.entries.indexOf(entry);
        if (this.scope == 2L || this.scope == 1L && n != this.entries.size() - 1) {
            this.entries.insertElementAt(null, n);
            this.entries.removeElementAt(n + 1);
        } else {
            this.entries.removeElementAt(n);
        }
    }

    protected final void removeEntry(int n) {
        this.entries.removeElementAt(n);
    }

    protected final void addNullEntry() {
        this.entries.addElement(null);
    }

    public void deleteEntry(long l) throws CDFException {
        if (l < 0L) {
            throw new CDFException(-2043L);
        }
        if (this.entries.elementAt((int)l) == null) {
            throw new CDFException(-2018L);
        }
        ((Entry)this.entries.elementAt((int)l)).delete();
    }

    public void deleteEntry(Variable variable) throws CDFException {
        if (this.scope != 2L) {
            throw new CDFException(-2010L);
        }
        if (variable.getID() < 0L) {
            throw new CDFException(-2019L);
        }
        this.deleteEntry(variable.getID());
    }

    public synchronized Vector getEntries() {
        return this.entries;
    }

    public long getEntryID(Entry entry) {
        return this.entries.indexOf(entry);
    }

    public void rename(String string) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        this.select();
        this.name = string;
        vector.addElement(new Long(1008L));
        vector.addElement(new Long(87L));
        vector2.addElement("name");
        vector2.addElement("Ljava/lang/String;");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.myCDF.executeCommand(this, vector);
    }

    protected final void select() throws CDFException {
        Vector<Long> vector = new Vector<Long>();
        this.id = this.getID();
        vector.addElement(new Long(1000L));
        this.myCDF.executeCommand(this, vector);
    }

    public long getNumEntries() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.entries.size()) {
            if (this.entries.elementAt(n2) != null) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public long getMaxEntryNumber() {
        return this.entries.size();
    }

    public long getID() {
        return this.myCDF.getAttributeID(this.name);
    }

    public CDF getMyCDF() {
        return this.myCDF;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public long getScope() {
        return this.scope;
    }

    private Attribute(CDF cDF) {
        this.myCDF = cDF;
        this.entries = new Vector();
    }
}

