/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.Attribute;
import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.Entry;
import gsfc.nssdc.cdf.Variable;
import gsfc.nssdc.cdf.util.CDFUtils;
import gsfc.nssdc.cdf.util.Epoch;
import gsfc.nssdc.cdf.util.Epoch16;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Stack;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CDFML2CDF
extends DefaultHandler
implements CDFConstants {
    private static final int NONE = 0;
    private static final int GAttributes = 1;
    private static final int VAttributes = 2;
    private static final int VarRecordData = 3;
    private static final int VarElementData = 4;
    private static String[] CDFelements = new String[]{"record", "element", "entry", "variable", "attribute", "cdfVarInfo", "cdfVAttributes", "cdfVarData", "cdfGAttributes", "CDF", "cdfFileInfo"};
    private static String newCDFName = null;
    private static boolean removeOldCDF = false;
    private static boolean loadData = true;
    private static boolean progressReport = false;
    private static boolean validateCDFML = false;
    private static boolean entryNumFlag;
    private static String cdfmlFileName;
    private static String outputDir;
    private CDF cdf;
    private Variable var;
    private Entry entry;
    private Attribute attribute;
    private String cdfName;
    private String varName;
    private String attrName;
    private String elementDelimiter;
    private String indexString;
    private long attrNum;
    private long varNum;
    private long scope;
    private long varDataType;
    private long entryDataType;
    private long numElements;
    private long recNum;
    private long[] dimSizes;
    private long[] dimVariances;
    private long[] dimIndex;
    private long[] dimIndices;
    private long[] dimCounts;
    private long[] dimIntervals;
    private long recCount;
    private long recInterval;
    private long dim;
    private long recVariance;
    private int phyDims;
    private int physicalSize;
    private Object dataObject;
    private long entryNum;
    private int inScope;
    private boolean entryBlock;
    private boolean recordBlock;
    private boolean elementBlock;
    private boolean processElement;
    private Stack stack;
    private CDFML2CDF aXML2CDF;
    private StringBuffer dataBuffer;

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            CDFML2CDF.howto();
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].charAt(0) == '-' || n != stringArray.length - 1 && stringArray[n].charAt(0) == '/') {
                if (stringArray[n].substring(1).equalsIgnoreCase("delete")) {
                    removeOldCDF = true;
                    ++n;
                    continue;
                }
                if (stringArray[n].substring(1).equalsIgnoreCase("nodelete")) {
                    removeOldCDF = false;
                    ++n;
                    continue;
                }
                if (stringArray[n].substring(1).equalsIgnoreCase("validate")) {
                    validateCDFML = true;
                    ++n;
                    continue;
                }
                if (stringArray[n].substring(1).equalsIgnoreCase("novalidate")) {
                    validateCDFML = false;
                    ++n;
                    continue;
                }
                if (stringArray[n].substring(1).equalsIgnoreCase("progress")) {
                    progressReport = true;
                    ++n;
                    continue;
                }
                if (stringArray[n].length() > 4 && stringArray[n].substring(1, 4).equalsIgnoreCase("cdf")) {
                    newCDFName = stringArray[n].substring(5);
                    ++n;
                    continue;
                }
                if (stringArray[n].substring(1).equalsIgnoreCase("data")) {
                    loadData = true;
                    ++n;
                    continue;
                }
                if (stringArray[n].substring(1).equalsIgnoreCase("nodata")) {
                    loadData = false;
                    ++n;
                    continue;
                }
                CDFML2CDF.howto();
                continue;
            }
            cdfmlFileName = stringArray[n++];
        }
        if (cdfmlFileName == null) {
            CDFML2CDF.howto();
        }
        CDFML2CDF.checkCDFMLFile(cdfmlFileName);
        if (newCDFName != null) {
            CDFML2CDF.checkCDFFile(newCDFName);
        }
        CDFML2CDF cDFML2CDF = new CDFML2CDF();
    }

    private static final void checkCDFMLFile(String string) {
        File file = new File(string);
        if (!file.exists()) {
            System.err.println("*** Error: cdfml file:" + file + " does not exist! ***");
            System.exit(0);
        }
    }

    private static final void checkCDFFile(String string) {
        if (string == null) {
            return;
        }
        File file = new File(string);
        if (file.isDirectory()) {
            outputDir = string.endsWith(System.getProperty("file.separator")) ? string : string + System.getProperty("file.separator");
            return;
        }
        String string2 = null;
        String string3 = null;
        if (string.indexOf(".cdf") == -1 && string.indexOf(".CDF") == -1) {
            string2 = string + ".cdf";
            string3 = string + ".CDF";
        } else {
            string2 = string;
        }
        File file2 = new File(string2);
        boolean bl = true;
        if (file2.exists()) {
            if (removeOldCDF) {
                file2.delete();
                bl = false;
            } else {
                System.err.println("\nError... CDF: " + string2 + " already exists...");
                System.exit(0);
            }
        }
        if (bl && string3 != null) {
            bl = false;
            File file3 = new File(string3);
            if (file3.exists()) {
                if (removeOldCDF) {
                    file3.delete();
                } else {
                    System.err.println("\nError... CDF: " + string3 + " already exists...");
                    System.exit(0);
                }
            }
        }
    }

    private final void startProcessing() {
        Object object;
        this.dimSizes = null;
        this.dimVariances = null;
        this.dimIndices = null;
        this.inScope = 0;
        this.dataBuffer = new StringBuffer();
        this.stack = new Stack();
        try {
            object = XMLReaderFactory.createXMLReader();
            if (validateCDFML) {
                object.setFeature("http://xml.org/sax/features/validation", true);
            }
            object.setErrorHandler(this.aXML2CDF);
            object.setContentHandler(this.aXML2CDF);
            object.parse(new InputSource(CDFML2CDF.fileToURL(new File(cdfmlFileName))));
        }
        catch (Throwable throwable) {
            System.setProperty("org.xml.sax.driver", "org.apache.crimson.parser.XMLReaderImpl");
            try {
                XMLReader xMLReader = XMLReaderFactory.createXMLReader();
                if (validateCDFML) {
                    xMLReader.setFeature("http://xml.org/sax/features/validation", true);
                }
                xMLReader.setErrorHandler(this.aXML2CDF);
                xMLReader.setContentHandler(this.aXML2CDF);
                xMLReader.parse(new InputSource(CDFML2CDF.fileToURL(new File(cdfmlFileName))));
            }
            catch (Throwable throwable2) {
                System.err.println(" ");
                throwable2.printStackTrace();
                System.exit(0);
            }
        }
        object = new StringBuffer(this.cdfName);
        if (this.cdfName.indexOf(".cdf") == -1 && this.cdfName.indexOf(".CDF") == -1) {
            ((StringBuffer)object).append(".cdf");
        }
        System.err.println("Completed!  CDF file: " + ((StringBuffer)object).toString() + " is created.");
        System.exit(1);
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string2;
        if ("".equals(string4)) {
            string4 = string3;
        }
        int n = 0;
        while (n < CDFelements.length) {
            if (string4.equalsIgnoreCase(CDFelements[n])) {
                try {
                    this.dataBuffer.setLength(0);
                    this.handleStartCDFelement(string4, attributes);
                    break;
                }
                catch (CDFException cDFException) {
                    System.err.println("\n ***** CDFException 1..: " + (Object)((Object)cDFException));
                    System.exit(0);
                }
            }
            ++n;
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = "".equals(string2) ? string3 : string2;
        int n = 0;
        while (n < CDFelements.length) {
            if (string4.equalsIgnoreCase(CDFelements[n])) {
                try {
                    this.handleEndCDFelement(string4);
                    break;
                }
                catch (CDFException cDFException) {
                    System.err.println("\n ****** CDFException 2..: " + (Object)((Object)cDFException));
                    System.exit(0);
                }
            }
            ++n;
        }
        this.dataBuffer.setLength(0);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.dataBuffer.append(cArray, n, n2);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
    }

    public void warning(SAXParseException sAXParseException) {
        System.err.println("[Warning] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    public void error(SAXParseException sAXParseException) {
        System.err.println("[Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        System.err.println("[Fatal Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    private final String getLocationString(SAXParseException sAXParseException) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = sAXParseException.getSystemId();
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            stringBuffer.append(string);
        }
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getLineNumber());
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getColumnNumber());
        return stringBuffer.toString();
    }

    private final void handleStartCDFelement(String string, Attributes attributes) throws CDFException, SAXException {
        this.stack.push(string);
        if (string.equalsIgnoreCase("variable")) {
            this.setVariable(attributes);
        } else if (string.equalsIgnoreCase("cdfVarInfo")) {
            this.createVariable(attributes);
        } else if (string.equalsIgnoreCase("cdfVAttributes")) {
            this.scope = 2;
            this.inScope = 2;
        } else if (string.equalsIgnoreCase("cdfVarData")) {
            this.recNum = 0L;
        } else if (string.equalsIgnoreCase("attribute")) {
            this.createAttribute(attributes);
        } else if (string.equalsIgnoreCase("entry")) {
            if (this.entryBlock) {
                throw new SAXException("entry element error: previous entry not closed");
            }
            this.entryBlock = true;
            this.setEntry(attributes);
        } else if (string.equalsIgnoreCase("record")) {
            if (this.recordBlock) {
                throw new SAXException("record element error: previous record not closed");
            }
            this.elementDelimiter = null;
            this.recordBlock = true;
            this.processElement = false;
            if (attributes != null) {
                int n = 0;
                while (n < attributes.getLength()) {
                    String string2 = attributes.getLocalName(n);
                    if ("".equals(string2)) {
                        string2 = attributes.getQName(n);
                    }
                    if (string2.equalsIgnoreCase("recNum")) {
                        this.recNum = new Long(attributes.getValue(n));
                    } else if (string2.equalsIgnoreCase("elementDelimiter")) {
                        this.elementDelimiter = attributes.getValue(n);
                    }
                    ++n;
                }
            }
            this.inScope = 3;
        } else if (string.equalsIgnoreCase("element")) {
            if (this.elementBlock) {
                throw new SAXException("element error: previous data element not closed");
            }
            this.elementDelimiter = null;
            this.elementBlock = true;
            this.processElement = true;
            if (attributes != null) {
                int n = 0;
                while (n < attributes.getLength()) {
                    String string3 = attributes.getLocalName(n);
                    if ("".equals(string3)) {
                        string3 = attributes.getQName(n);
                    }
                    if (string3.equalsIgnoreCase("index")) {
                        this.indexString = attributes.getValue(n);
                    } else if (string3.equalsIgnoreCase("elementDelimiter")) {
                        this.elementDelimiter = attributes.getValue(n);
                    }
                    ++n;
                }
            } else {
                throw new SAXException("Index is missing for single element data ");
            }
            this.inScope = 4;
        } else if (string.equalsIgnoreCase("CDF")) {
            this.createCDF(attributes);
        } else if (string.equalsIgnoreCase("cdfFileInfo")) {
            this.setCDF(attributes);
        } else if (string.equalsIgnoreCase("cdfGAttributes")) {
            this.scope = 1L;
            this.inScope = 1;
        }
    }

    private final void handleEndCDFelement(String string) throws CDFException, SAXException {
        if (!this.stack.peek().equals(string)) {
            throw new SAXException("parsing problem...the start element:" + this.stack.peek() + " doesn't match to the close element " + string);
        }
        this.stack.pop();
        if (string.equalsIgnoreCase("record")) {
            this.recordBlock = false;
            if (this.processElement) {
                ++this.recNum;
                return;
            }
            try {
                this.processCDFEntryORVarData();
                this.inScope = 0;
                this.elementDelimiter = null;
            }
            catch (SAXException sAXException) {
                System.err.println("\n SAXException....: " + sAXException);
                System.exit(0);
            }
        } else if (string.equalsIgnoreCase("entry")) {
            this.entryBlock = false;
            try {
                this.processCDFEntryORVarData();
                this.elementDelimiter = null;
            }
            catch (SAXException sAXException) {
                System.err.println("\n SAXException....: " + sAXException);
                System.exit(0);
            }
        } else if (string.equalsIgnoreCase("element")) {
            this.elementBlock = false;
            if (this.dataBuffer.length() == 0) {
                return;
            }
            try {
                this.processCDFEntryORVarData();
                this.inScope = 0;
                this.elementDelimiter = null;
            }
            catch (SAXException sAXException) {
                System.err.println("\n SAXException....: " + sAXException);
                System.exit(0);
            }
        } else if (string.equalsIgnoreCase("variable")) {
            this.dimSizes = null;
            this.dimVariances = null;
            this.dimIndices = null;
            this.dimCounts = null;
            this.dimIntervals = null;
        } else if (string.equalsIgnoreCase("cdfVariables")) {
            this.inScope = 0;
        } else if (string.equalsIgnoreCase("cdfVAttributes")) {
            this.inScope = 0;
        } else {
            if (string.equalsIgnoreCase("attribute")) {
                return;
            }
            if (string.equalsIgnoreCase("cdfGAttributes")) {
                return;
            }
            if (string.equalsIgnoreCase("cdfFileInfo")) {
                return;
            }
            if (string.equalsIgnoreCase("CDF")) {
                this.closeCDF();
            }
        }
    }

    private final void processCDFEntryORVarData() throws SAXException {
        if (this.dataBuffer.length() == 0) {
            return;
        }
        String string = this.dataBuffer.toString();
        if (((this.inScope == 1 || this.inScope == 2) && this.entryDataType != 51L && this.entryDataType != 52L || loadData && (this.inScope == 3 || this.inScope == 4) && this.varDataType != 51L && this.varDataType != 52L) && (string = string.trim()).length() > 0) {
            string = this.handleNumbers(string);
        }
        try {
            if (this.inScope == 1 || this.inScope == 2) {
                this.createEntry(string);
            } else if (loadData) {
                if (this.inScope == 3) {
                    this.loadVarRecordData(string);
                } else if (this.inScope == 4) {
                    this.loadVarElementData(string);
                }
            }
        }
        catch (CDFException cDFException) {
            System.err.println("\n CDFException 3..: " + (Object)((Object)cDFException));
            System.exit(0);
        }
        this.dataBuffer.setLength(0);
    }

    private final String handleNumbers(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.elementDelimiter != null) {
            string = this.removeSpaces(string, this.elementDelimiter);
            StringTokenizer stringTokenizer = new StringTokenizer(string, this.elementDelimiter);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.length() == 0) continue;
                stringBuffer.append(string2).append(" ");
            }
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n = stringTokenizer.countTokens();
            if (n > 0) {
                while (stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append(stringTokenizer.nextToken()).append(" ");
                }
                stringBuffer.setLength(stringBuffer.length() - 1);
            }
        }
        return stringBuffer.toString();
    }

    private final void createCDF(Attributes attributes) throws CDFException {
        if (newCDFName != null && outputDir == null) {
            this.cdfName = newCDFName;
        } else {
            if (attributes != null) {
                int n = 0;
                while (n < attributes.getLength()) {
                    String string = attributes.getLocalName(n);
                    if ("".equals(string)) {
                        string = attributes.getQName(n);
                    }
                    if (string.equalsIgnoreCase("name")) {
                        this.cdfName = attributes.getValue(n);
                    }
                    ++n;
                }
            }
            this.cdfName = this.cdfName.substring(this.cdfName.lastIndexOf(System.getProperty("file.separator")) + 1);
            if (outputDir != null) {
                this.cdfName = outputDir + this.cdfName;
            }
            CDFML2CDF.checkCDFFile(this.cdfName);
        }
        this.cdf = CDF.create((String)this.cdfName);
        this.entryBlock = false;
        this.recordBlock = false;
    }

    private final void closeCDF() throws CDFException {
        this.cdf.close();
    }

    private final void setCDF(Attributes attributes) throws CDFException {
        if (attributes != null) {
            int n = 0;
            while (n < attributes.getLength()) {
                long l;
                String string = attributes.getLocalName(n);
                if ("".equals(string)) {
                    string = attributes.getQName(n);
                }
                if (string.equalsIgnoreCase("fileFormat")) {
                    l = CDFUtils.getLongFormat((String)attributes.getValue(n));
                    this.cdf.setFormat(l);
                } else if (string.equalsIgnoreCase("compression")) {
                    long l2;
                    long l3;
                    String string2 = attributes.getValue(n);
                    if (string2.length() > 4 && string2.substring(0, 4).equalsIgnoreCase("gzip")) {
                        l3 = CDFUtils.getLongCompressionType((String)string2.substring(0, 4));
                        l2 = new Long(string2.substring(5));
                    } else {
                        l3 = CDFUtils.getLongCompressionType((String)string2);
                        l2 = l3 == 0L ? 0L : 1L;
                    }
                    this.cdf.setCompression(l3, new long[]{l2});
                } else if (string.equalsIgnoreCase("majority")) {
                    l = CDFUtils.getLongMajority((String)attributes.getValue(n));
                    this.cdf.setMajority(l);
                } else if (string.equalsIgnoreCase("encoding")) {
                    l = CDFUtils.getLongEncoding((String)attributes.getValue(n));
                    this.cdf.setEncoding(l);
                } else if (string.equalsIgnoreCase("NEGtoPOSfp0")) {
                    l = attributes.getValue(n).equalsIgnoreCase("ENABLE") ? (long)-1 : 0L;
                    this.cdf.selectNegtoPosfp0(l);
                } else if (string.equalsIgnoreCase("CDFCacheSize")) {
                    l = new Long(attributes.getValue(n));
                    this.cdf.selectCDFCacheSize(l);
                } else if (string.equalsIgnoreCase("CompressCacheSize")) {
                    l = new Long(attributes.getValue(n));
                    this.cdf.selectCompressCacheSize(l);
                } else if (string.equalsIgnoreCase("StageCacheSize")) {
                    l = new Long(attributes.getValue(n));
                    this.cdf.selectStageCacheSize(l);
                }
                ++n;
            }
        }
    }

    private final void createAttribute(Attributes attributes) throws CDFException {
        if (attributes != null) {
            int n = 0;
            while (n < attributes.getLength()) {
                String string = attributes.getLocalName(n);
                if ("".equals(string)) {
                    string = attributes.getQName(n);
                }
                if (string.equalsIgnoreCase("name")) {
                    this.attrName = attributes.getValue(n);
                }
                ++n;
            }
        }
        if (this.scope == 1L) {
            this.attribute = Attribute.create((CDF)this.cdf, (String)this.attrName, (long)1L);
            if (progressReport) {
                System.err.println("  Created global attribute: " + this.attrName + " and start loading entries");
            }
        } else {
            long l = this.cdf.getAttributeID(this.attrName);
            this.attribute = l == (long)-1 ? Attribute.create((CDF)this.cdf, (String)this.attrName, (long)2) : this.cdf.getAttribute(l);
        }
    }

    private final void setEntry(Attributes attributes) {
        entryNumFlag = false;
        if (attributes != null) {
            int n = 0;
            while (n < attributes.getLength()) {
                String string = attributes.getLocalName(n);
                if ("".equals(string)) {
                    string = attributes.getQName(n);
                }
                if (string.equalsIgnoreCase("entryNum")) {
                    entryNumFlag = true;
                    this.entryNum = new Long(attributes.getValue(n));
                } else if (string.equalsIgnoreCase("cdfDatatype")) {
                    this.entryDataType = CDFUtils.getDataTypeValue((String)attributes.getValue(n));
                } else if (string.equalsIgnoreCase("numElements")) {
                    this.numElements = new Long(attributes.getValue(n));
                }
                ++n;
            }
        }
    }

    private final void createEntry(String string) throws CDFException {
        Object object = this.createEntryObject(string);
        if (object != null) {
            if (this.inScope == 1) {
                if (!entryNumFlag) {
                    ++this.entryNum;
                }
                Entry.create((Attribute)this.attribute, (long)this.entryNum, (long)this.entryDataType, (Object)object);
            } else {
                Entry.create((Attribute)this.attribute, (long)this.var.getID(), (long)this.entryDataType, (Object)object);
            }
        }
    }

    private final Object createEntryObject(String string) throws CDFException {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n = stringTokenizer.countTokens();
        if (this.entryDataType == 1L || this.entryDataType == 41L) {
            object = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                object[n2] = new Byte(stringTokenizer.nextToken());
                ++n2;
            }
        } else if (this.entryDataType == (long)2 || this.entryDataType == 11L) {
            object = new short[n];
            int n3 = 0;
            while (n3 < n) {
                ((short[])object)[n3] = new Short(stringTokenizer.nextToken());
                ++n3;
            }
        } else if (this.entryDataType == (long)4 || this.entryDataType == 12L) {
            object = new int[n];
            int n4 = 0;
            while (n4 < n) {
                ((int[])object)[n4] = new Integer(stringTokenizer.nextToken());
                ++n4;
            }
        } else if (this.entryDataType == 14L) {
            object = new long[n];
            int n5 = 0;
            while (n5 < n) {
                ((long[])object)[n5] = new Long(stringTokenizer.nextToken());
                ++n5;
            }
        } else if (this.entryDataType == 21L || this.entryDataType == 44L) {
            object = new float[n];
            int n6 = 0;
            while (n6 < n) {
                ((float[])object)[n6] = new Float(stringTokenizer.nextToken()).floatValue();
                ++n6;
            }
        } else if (this.entryDataType == 22L || this.entryDataType == 45L) {
            object = new double[n];
            int n7 = 0;
            while (n7 < n) {
                ((double[])object)[n7] = new Double(stringTokenizer.nextToken());
                ++n7;
            }
        } else if (this.entryDataType == 51L || this.entryDataType == 52L) {
            object = string;
        } else if (this.entryDataType == 31L) {
            object = new double[n / 2];
            int n8 = 0;
            while (n8 < n / 2) {
                ((double[])object)[n8] = Epoch.parse((String)(stringTokenizer.nextToken() + ' ' + stringTokenizer.nextToken()));
                ++n8;
            }
        } else if (this.entryDataType == 32L) {
            object = new double[n];
            Object object2 = new double[2];
            int n9 = 0;
            int n10 = 0;
            while (n9 < n / 2) {
                object2 = Epoch16.parse((String)(stringTokenizer.nextToken() + ' ' + stringTokenizer.nextToken()));
                ((double[])object)[n10++] = object2[0];
                ((double[])object)[n10++] = object2[1];
                ++n9;
            }
        } else {
            object = null;
        }
        return object;
    }

    private final void setVariable(Attributes attributes) {
        if (attributes != null) {
            int n = 0;
            while (n < attributes.getLength()) {
                String string = attributes.getLocalName(n);
                if ("".equals(string)) {
                    string = attributes.getQName(n);
                }
                if (string.equalsIgnoreCase("name")) {
                    this.varName = attributes.getValue(n);
                }
                ++n;
            }
        }
    }

    private final void createVariable(Attributes attributes) throws CDFException {
        long l = 0L;
        long l2 = 0L;
        Object object = null;
        long l3 = -1;
        long l4 = -1;
        long l5 = -1;
        long l6 = -1;
        long l7 = -1;
        long l8 = -1;
        if (attributes != null) {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            boolean bl9 = false;
            boolean bl10 = false;
            this.varDataType = -1;
            this.dim = -1;
            int n = 0;
            while (n < attributes.getLength()) {
                int n2;
                int n3;
                StringTokenizer stringTokenizer;
                String string = attributes.getLocalName(n);
                if ("".equals(string)) {
                    string = attributes.getQName(n);
                }
                if (string.equalsIgnoreCase("cdfDatatype")) {
                    this.varDataType = CDFUtils.getDataTypeValue((String)attributes.getValue(n));
                } else if (string.equalsIgnoreCase("dim")) {
                    this.dim = new Long(attributes.getValue(n));
                    int n4 = (int)(this.dim > 0L ? this.dim : 1L);
                    this.dimSizes = new long[n4];
                    this.dimVariances = new long[n4];
                    this.dimIndex = new long[n4];
                } else if (string.equalsIgnoreCase("dimSizes")) {
                    bl = true;
                    String string2 = attributes.getValue(n);
                    stringTokenizer = new StringTokenizer(string2, ",");
                    n3 = stringTokenizer.countTokens();
                    if (this.dim != (long)-1 && this.dim != (long)n3 && this.dim != (long)(n3 = (stringTokenizer = new StringTokenizer(string2, " ")).countTokens())) {
                        System.err.println("Var:" + this.varName + " dim=" + this.dim + " dimSizes=" + n3 + " don't match");
                        return;
                    }
                    if (this.dimSizes == null) {
                        this.dimSizes = new long[stringTokenizer.countTokens()];
                    }
                    if (!"".equals(string2) && n3 > 0) {
                        n2 = 0;
                        while (stringTokenizer.hasMoreTokens()) {
                            this.dimSizes[n2++] = new Long(stringTokenizer.nextToken());
                        }
                    } else {
                        this.dimSizes[0] = 0L;
                    }
                } else if (string.equalsIgnoreCase("dimVariances")) {
                    bl2 = true;
                    String string3 = attributes.getValue(n);
                    stringTokenizer = new StringTokenizer(string3, ",");
                    n3 = stringTokenizer.countTokens();
                    if (this.dim != (long)-1 && this.dim != (long)n3 && this.dim != (long)(n3 = (stringTokenizer = new StringTokenizer(string3, " ")).countTokens())) {
                        System.err.println("Var:" + this.varName + " dim=" + this.dim + " dimVariances=" + n3 + " don't match");
                        return;
                    }
                    if (this.dimVariances == null) {
                        this.dimVariances = new long[stringTokenizer.countTokens()];
                    }
                    if (!"".equals(string3) && n3 > 0) {
                        n2 = 0;
                        while (stringTokenizer.hasMoreTokens()) {
                            this.dimVariances[n2] = stringTokenizer.nextToken().equalsIgnoreCase("VARY") ? (long)-1 : 0L;
                            ++n2;
                        }
                    } else {
                        this.dimVariances[0] = 0L;
                    }
                } else if (string.equalsIgnoreCase("recVariance")) {
                    this.recVariance = attributes.getValue(n).equalsIgnoreCase("VARY") ? (long)-1 : 0L;
                } else if (string.equalsIgnoreCase("numElements")) {
                    this.numElements = new Long(attributes.getValue(n));
                } else if (string.equalsIgnoreCase("compression")) {
                    String string4 = attributes.getValue(n);
                    if (string4.length() > 4 && string4.substring(0, 4).equalsIgnoreCase("gzip")) {
                        l = CDFUtils.getLongCompressionType((String)string4.substring(0, 4));
                        l2 = new Long(string4.substring(5));
                    } else {
                        l = CDFUtils.getLongCompressionType((String)string4);
                        l2 = l == 0L ? 0L : 1L;
                    }
                    bl3 = true;
                } else if (string.equalsIgnoreCase("sparseRecords")) {
                    bl5 = true;
                    l3 = CDFUtils.getLongSparseRecord((String)attributes.getValue(n));
                } else if (string.equalsIgnoreCase("blockingFactor")) {
                    bl6 = true;
                    l4 = new Long(attributes.getValue(n));
                } else if (string.equalsIgnoreCase("numInitialRecords")) {
                    bl7 = true;
                    l5 = new Long(attributes.getValue(n));
                } else if (string.equalsIgnoreCase("numRecordsAllocate")) {
                    if (!bl3) {
                        bl8 = true;
                        l6 = new Long(attributes.getValue(n));
                    }
                } else if (string.equalsIgnoreCase("cacheSize")) {
                    bl9 = true;
                    l7 = new Long(attributes.getValue(n));
                } else if (string.equalsIgnoreCase("reservePercent")) {
                    if (bl3) {
                        bl10 = true;
                        l8 = new Long(attributes.getValue(n));
                    }
                } else if (string.equalsIgnoreCase("padValue")) {
                    bl4 = true;
                    String string5 = attributes.getValue(n);
                    if (this.varDataType == 1L || this.varDataType == 41L) {
                        object = new Byte(string5);
                    } else if (this.varDataType == (long)2 || this.varDataType == 11L) {
                        object = new Short(string5);
                    } else if (this.varDataType == (long)4 || this.varDataType == 12L) {
                        object = new Integer(string5);
                    } else if (this.varDataType == 14L) {
                        object = new Long(string5);
                    } else if (this.varDataType == 21L || this.varDataType == 44L) {
                        object = new Float(string5);
                    } else if (this.varDataType == 22L || this.varDataType == 45L) {
                        object = new Double(string5);
                    } else if (this.varDataType == 51L || this.varDataType == 52L) {
                        object = string5;
                    } else if (this.varDataType == 31L) {
                        object = new Double(Epoch.parse((String)string5));
                    } else if (this.varDataType == 32L) {
                        object = new double[2];
                        object = Epoch16.parse((String)string5);
                    }
                }
                ++n;
            }
            if (this.dim > 0L) {
                if (!bl || !bl2) {
                    System.err.println("\nError... dimSizes or dimVariances not provided for variable:" + this.varName + '!');
                    return;
                }
                this.phyDims = (int)this.dim;
                this.physicalSize = 1;
                n = 0;
                while ((long)n < this.dim) {
                    this.physicalSize *= (int)this.dimSizes[n];
                    ++n;
                }
            } else {
                this.dimSizes[0] = 1L;
                this.dimVariances[0] = -1;
                this.phyDims = 1;
                this.physicalSize = 1;
            }
            this.var = Variable.create((CDF)this.cdf, (String)this.varName, (long)this.varDataType, (long)this.numElements, (long)this.dim, (long[])this.dimSizes, (long)this.recVariance, (long[])this.dimVariances);
            if (progressReport) {
                String string = loadData ? " and start loading its data" : " ";
                System.err.println("  Created variable " + this.var.getID() + ": " + this.varName + string);
            }
            if (bl3) {
                this.var.setCompression(l, new long[]{l2});
            }
            if (bl4) {
                this.var.setPadValue(object);
            }
            if (bl5) {
                this.var.setSparseRecords(l3);
            }
            if (bl6) {
                this.var.setBlockingFactor(l4);
            }
            if (bl9) {
                this.var.selectCacheSize(l7);
            }
            if (bl10) {
                this.var.selectReservePercent(l8);
            }
            if (bl7 && l5 > 0L) {
                this.var.setInitialRecords(l5);
            }
            if (bl8 && l6 > 0L) {
                this.var.allocateRecords(l6);
            }
        }
    }

    private final void loadVarRecordData(String string) throws CDFException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n = stringTokenizer.countTokens();
        this.recInterval = 1L;
        this.recCount = 1L;
        if (this.dimIndices == null) {
            this.dimIndices = new long[this.phyDims];
            this.dimCounts = new long[this.phyDims];
            this.dimIntervals = new long[this.phyDims];
            int n2 = 0;
            while (n2 < this.phyDims) {
                this.dimIndices[n2] = 0L;
                this.dimCounts[n2] = this.dimSizes[n2];
                this.dimIntervals[n2] = 1L;
                ++n2;
            }
            this.dataObject = this.createObject(this.phyDims, this.dimSizes, this.varDataType);
        }
        Object[] objectArray = null;
        if (this.varDataType == 1L || this.varDataType == 41L) {
            objectArray = (byte[])this.convertData(n, stringTokenizer, this.varDataType);
        } else if (this.varDataType == (long)2 || this.varDataType == 11L) {
            objectArray = (short[])this.convertData(n, stringTokenizer, this.varDataType);
        } else if (this.varDataType == (long)4 || this.varDataType == 12L) {
            objectArray = (int[])this.convertData(n, stringTokenizer, this.varDataType);
        } else if (this.varDataType == 14L) {
            objectArray = (long[])this.convertData(n, stringTokenizer, this.varDataType);
        } else if (this.varDataType == 21L || this.varDataType == 44L) {
            objectArray = (float[])this.convertData(n, stringTokenizer, this.varDataType);
        } else if (this.varDataType == 22L || this.varDataType == 45L) {
            objectArray = (double[])this.convertData(n, stringTokenizer, this.varDataType);
        } else if (this.varDataType == 51L || this.varDataType == 52L) {
            objectArray = new byte[(int)((long)this.physicalSize * this.numElements)];
            byte[] byArray = new String(" ").getBytes();
            byte by = byArray[0];
            int n3 = 0;
            while ((long)n3 < (long)this.physicalSize * this.numElements) {
                objectArray[n3] = by;
                ++n3;
            }
            if (this.elementDelimiter != null) {
                string = this.removeSpaces(string, this.elementDelimiter);
                StringTokenizer stringTokenizer2 = new StringTokenizer(string, this.elementDelimiter);
                int n4 = 0;
                n = 0;
                while (stringTokenizer2.hasMoreTokens()) {
                    String string2 = stringTokenizer2.nextToken();
                    if (string2.length() == 0) continue;
                    System.arraycopy(string2.getBytes(), 0, objectArray, (int)((long)n4 * this.numElements), string2.length());
                    ++n;
                    if (++n4 != this.physicalSize) {
                        continue;
                    }
                    break;
                }
            } else {
                n = 1;
                System.arraycopy(string.getBytes(), 0, objectArray, 0, string.length());
            }
        } else if (this.varDataType == 31L) {
            objectArray = new double[n / 2];
            int n5 = 0;
            int n6 = 0;
            while (n5 < n) {
                ((double[])objectArray)[n6++] = Epoch.parse((String)(stringTokenizer.nextToken() + ' ' + stringTokenizer.nextToken()));
                n5 += 2;
            }
        } else if (this.varDataType == 32L) {
            objectArray = new double[n];
            Object object = new double[2];
            int n7 = 0;
            int n8 = 0;
            while (n7 < n / 2) {
                object = Epoch16.parse((String)(stringTokenizer.nextToken() + ' ' + stringTokenizer.nextToken()));
                ((double[])objectArray)[n8++] = object[0];
                ((double[])objectArray)[n8++] = object[1];
                ++n7;
            }
        }
        if (this.varDataType == 31L || this.varDataType == 32L) {
            int n9 = n / 2;
        } else {
            int n10 = n;
        }
        if (objectArray != null) {
            this.var.putHyperData(this.recNum, this.recCount, this.recInterval, this.dimIndices, this.dimCounts, this.dimIntervals, (Object)objectArray);
            ++this.recNum;
        }
    }

    private final void loadVarElementData(String string) throws CDFException {
        StringTokenizer stringTokenizer = new StringTokenizer(this.indexString, ",");
        int n = stringTokenizer.countTokens();
        int n2 = 0;
        while (n2 < this.phyDims) {
            this.dimIndex[n2] = new Long(stringTokenizer.nextToken());
            ++n2;
        }
        Object object = null;
        if (this.varDataType == 1L || this.varDataType == 41L) {
            object = new Byte(string);
        } else if (this.varDataType == (long)2 || this.varDataType == 11L) {
            object = new Short(string);
        } else if (this.varDataType == (long)4 || this.varDataType == 12L) {
            object = new Integer(string);
        } else if (this.varDataType == 14L) {
            object = new Long(string);
        } else if (this.varDataType == 21L || this.varDataType == 44L) {
            object = new Float(string);
        } else if (this.varDataType == 22L || this.varDataType == 45L) {
            object = new Double(string);
        } else if (this.varDataType == 51L || this.varDataType == 52L) {
            object = (long)string.length() > this.numElements ? string.substring(0, (int)this.numElements) : string;
        } else if (this.varDataType == 31L) {
            object = new Double(Epoch.parse((String)string));
        } else if (this.varDataType == 32L) {
            object = new double[2];
            object = Epoch16.parse((String)string);
        }
        if (object != null) {
            this.var.putSingleData(this.recNum, this.dimIndex, object);
        }
    }

    private final Object createObject(long l, long[] lArray, long l2) throws CDFException {
        Object object = null;
        Class<Number> clazz = null;
        int[] nArray = new int[(int)l];
        int n = 0;
        while ((long)n < l) {
            nArray[n] = (int)lArray[n];
            ++n;
        }
        if (l2 == 32L) {
            if (l == 0L) {
                nArray[0] = 2;
            } else {
                nArray[(int)l - 1] = 2 * nArray[(int)l - 1];
            }
        }
        switch ((int)l2) {
            case 51: 
            case 52: {
                clazz = new String().getClass();
                break;
            }
            case 1: 
            case 41: {
                clazz = Byte.TYPE;
                break;
            }
            case 2: 
            case 11: {
                clazz = Short.TYPE;
                break;
            }
            case 4: 
            case 12: {
                clazz = Integer.TYPE;
                break;
            }
            case 14: {
                clazz = Long.TYPE;
                break;
            }
            case 21: 
            case 44: {
                clazz = Float.TYPE;
                break;
            }
            case 22: 
            case 31: 
            case 32: 
            case 45: {
                clazz = Double.TYPE;
                break;
            }
        }
        try {
            object = Array.newInstance(clazz, nArray);
        }
        catch (Exception exception) {
            throw new CDFException(-2022L);
        }
        return object;
    }

    private final Object convertData(int n, StringTokenizer stringTokenizer, long l) throws CDFException {
        Object[] objectArray = null;
        switch ((int)l) {
            case 51: 
            case 52: {
                objectArray = new String[n];
                int n2 = 0;
                while (n2 < n) {
                    objectArray[n2] = stringTokenizer.nextToken();
                    ++n2;
                }
                break;
            }
            case 1: 
            case 41: {
                objectArray = new byte[n];
                int n3 = 0;
                while (n3 < n) {
                    ((byte[])objectArray)[n3] = new Byte(stringTokenizer.nextToken());
                    ++n3;
                }
                break;
            }
            case 2: 
            case 11: {
                objectArray = new short[n];
                int n4 = 0;
                while (n4 < n) {
                    ((short[])objectArray)[n4] = new Short(stringTokenizer.nextToken());
                    ++n4;
                }
                break;
            }
            case 4: 
            case 12: {
                objectArray = new int[n];
                int n5 = 0;
                while (n5 < n) {
                    ((int[])objectArray)[n5] = new Integer(stringTokenizer.nextToken());
                    ++n5;
                }
                break;
            }
            case 14: {
                objectArray = new long[n];
                int n6 = 0;
                while (n6 < n) {
                    ((long[])objectArray)[n6] = new Long(stringTokenizer.nextToken());
                    ++n6;
                }
                break;
            }
            case 21: 
            case 44: {
                objectArray = new float[n];
                int n7 = 0;
                while (n7 < n) {
                    ((float[])objectArray)[n7] = new Float(stringTokenizer.nextToken()).floatValue();
                    ++n7;
                }
                break;
            }
            case 22: 
            case 45: {
                objectArray = new double[n];
                int n8 = 0;
                while (n8 < n) {
                    ((double[])objectArray)[n8] = new Double(stringTokenizer.nextToken());
                    ++n8;
                }
                break;
            }
            case 31: {
                objectArray = new double[n / 2];
                int n9 = 0;
                while (n9 < n / 2) {
                    ((double[])objectArray)[n9] = Epoch.parse((String)(stringTokenizer.nextToken() + ' ' + stringTokenizer.nextToken()));
                    ++n9;
                }
                break;
            }
            case 32: {
                objectArray = new double[n];
                Object object = new double[2];
                int n10 = 0;
                int n11 = 0;
                while (n10 < n / 2) {
                    object = Epoch16.parse((String)(stringTokenizer.nextToken() + ' ' + stringTokenizer.nextToken()));
                    ((double[])objectArray)[n11++] = object[0];
                    ((double[])objectArray)[n11++] = object[1];
                    ++n10;
                }
                break;
            }
        }
        return objectArray;
    }

    private static final String fileToURL(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("No such file: " + file.getName());
        }
        String string = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            string = string.replace(File.separatorChar, '/');
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (!string.endsWith("/") && file.isDirectory()) {
            string = string + '/';
        }
        return "file:" + string;
    }

    /*
     * Unable to fully structure code
     */
    private final String removeSpaces(String var1_1, String var2_2) {
        var3_3 = new StringBuffer();
        var4_4 = var2_2.length();
        var5_5 = 0;
        var6_6 = -1;
        var7_7 = var1_1.length();
        var8_8 = -1;
        if (var7_7 != 0) ** GOTO lbl14
        return null;
        while ((var8_8 = var1_1.substring(var5_5).indexOf(var2_2)) != -1 && (var8_8 = var1_1.substring((var5_5 += var8_8) + var4_4).indexOf(var2_2)) != -1) {
            var6_6 = var5_5 + var4_4 + var8_8;
            var3_3.append(var1_1.substring(var5_5, var6_6 + var4_4));
            var5_5 = var6_6 + var4_4;
lbl14:
            // 2 sources

            if (var5_5 < var7_7) continue;
        }
        return var3_3.toString();
    }

    private static final void howto() {
        System.err.println(" ");
        System.err.println("Description:");
        System.err.println("    This program converts a cdfml (an xml) file that conforms to the");
        System.err.println("    cdf.dtd or cdf.xsd into a CDF file.");
        System.err.println(" ");
        System.err.println("Usage: java [-Dorg.xml.sax.driver=...] CDFML2CDF [Options] xmlFileName");
        System.err.println(" ");
        System.err.println("    The SAX2 parser is used to parse the cdfml document. ");
        System.err.println("    The default SAX2 parser can be set up through a system resource ");
        System.err.println("    at SAX2 JAR file's META-INF/services/org.xml.sax.driver if ");
        System.err.println("    your SAX2 distribution supports it through the class loader.");
        System.err.println("    Otherwise, the system property for org.xml.sax.dirver has to be");
        System.err.println("    set for the parser. The parser classes are JVM/SAX2-dependent.");
        System.err.println("    If Sun's Java V1.4 is used, you don't have to specify the");
        System.err.println("    parser as its Crimson will be used as the default.\n");
        System.err.println("    For Xerces: org.apache.xerces.parsers.SAXParser");
        System.err.println("        Crimson (SUN 1.4): org.apache.crimson.parser.XMLReaderImpl");
        System.err.println("        AElfred2: gnu.xml.aelfred2.XmlReader (validating) or ");
        System.err.println("                  gnu.xml.aelfred2.SAXDriver (non-validating)");
        System.err.println("        Oracle: oracle.xml.parser.v2.SAXParser");
        System.err.println(" ");
        System.err.println("Options: ");
        System.err.println("   -[no]Validate       Whether to validate the cdfml file during the process. ");
        System.err.println("                       It's parser dependent. -noValidate is the default. ");
        System.err.println("   -[no]Delete         Whether to delete the CDF file if it already exists. ");
        System.err.println("                       -noDelete is the default. ");
        System.err.println("   -cdf:cdfFileName    A new CDF file name to replace the given name at CDF element's");
        System.err.println("     or cdfDirecotry   name attribute in the cdfml file. No .cdf extension is needed.");
        System.err.println("                       Or, provide an existing directory. The directory  is to combine");
        System.err.println("                       with the cdfml's CDF element's name attribute to constitute");
        System.err.println("                       the full path name.");
        System.err.println("   -[no]Data           Whether to load the variable record data values if they are");
        System.err.println("                       in the cdfml file to the CDF file. -Data is the default. ");
        System.err.println("   -[no]Progress       Whether to display the progress.");
        System.err.println("                       -noProgress is the default. ");
        System.err.println(" ");
        System.err.println("Examples: \n");
        System.err.println(" 1) java CDFML2CDF -Validate testcdfml.xml ");
        System.err.println("         if your JAR file's META-INF/services/org.xml.sax.driver is defined,");
        System.err.println("         such as Xerces and AElfred2's parsers. ");
        System.err.println(" 2) java -Dorg.xml.sax.driver=org.apache.xerces.parsers.SAXParser CDFML2CDF -Delete");
        System.err.println("         -CDF:test1 testcdfml.xml ");
        System.err.println("         use Xerces's Parser and create a CDF file, test1.cdf. ");
        System.err.println(" 3) java -Dorg.xml.sax.driver=org.apache.crimson.parser.XMLReaderImpl CDFML2CDF");
        System.err.println("         -CDF:test1 -noData testcdfml.xml ");
        System.err.println("         use Sun's Java V1.4 and create test1.cdf but passing the variable record data.");
        System.err.println(" 4) java -Dorg.xml.sax.driver=oracle.xml.parser.v2.SAXParser CDFML2CDF");
        System.err.println("         -CDF:/home/mydir -delete -noData myCDFML.xml ");
        System.err.println("          use Oracle's parser and create /home/mydir/xxxx.cdf where xxxx comes from");
        System.err.println("          the name attribute at the CDF element in myCDFML.xml.");
        System.err.println(" ");
        System.exit(1);
    }

    private final /* synthetic */ void this() {
        this.entryNum = -1;
    }

    CDFML2CDF() {
        this.this();
        this.aXML2CDF = this;
        System.err.println("Start processing");
        this.aXML2CDF.startProcessing();
    }

    static {
        outputDir = null;
    }
}

