;------------------------------------------------------------------------------
;
;  NSSDC/CDF				    IDL/CDF Interface, encodeEPOCH.
;
;  Version 1.1, 16-Aug-96, Hughes STX.
;
;  Modification history:
;
;   V1.0  12-Jun-95, J Love	Original version.
;   V1.0a 26-Jun-95, J Love	Expanded online help.
;   V1.1  16-Aug-96, J Love	CDF V2.6.
;
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
; encodeEPOCHx.
;------------------------------------------------------------------------------

;+
; NAME:
;       encodeEPOCHx
;
; PURPOSE:
;       `encodeEPOCHx' is used to encode a CDF_EPOCH value into a customized
;       EPOCH character string.
;
;       This procedure is part of the CDF interface provided with the CDF
;       distribution.  IDL also provides its own built-in interface to CDFs.
;
; CALLING SEQUENCE:
;       encodeEPOCHx, epoch, format, epString
;
; INPUTS:
;       epoch:          DOUBLE (double precision floating-point).  The
;                       CDF_EPOCH value to be encoded.
;
;       format:         STRING.  The format specification to be used when
;                       encoding the CDF_EPOCH value.
;
;                       The format specification consists of EPOCH components
;                       which are encoded and text which is simply copied to
;                       the encoded string.  Components are enclosed in angle
;                       brackets and consist of a component token and an
;                       optional width.  The syntax of a component is...
;
;                                         <token[.width]>.
;
;                       If the optional width contains a leading zero, then
;                       the component will be encoded with leading zeroes
;                       (rather than leading blanks).  The supported component
;                       tokens and their default widths are as follows...
;
;                         Token   Meaning                         Default
;                         -----   -------                         -------
;                         dom     Day of month (1-31)             <dom.0>
;                         doy     Day of year (001-366)           <doy.03>
;                         month   Month (`Jan',`Feb',...,`Dec')   <month>
;                         mm      Month (1,2,...,12)              <mm.0>
;                         year    Year (4-digit)                  <year.04>
;                         yr      Year (2-digit)                  <yr.02>
;                         hour    Hour (00-23)                    <hour.02>
;                         min     Minute (00-59)                  <min.02>
;                         sec     Second (00-59)                  <sec.02>
;                         fos     Fraction of second.             <fos.3>
;                         fod     Fraction of day.                <fod.8>
;
;                       Note that a width of zero indicates that as many
;                       digits as necessary should be used to encoded the
;                       component.  The <month> component is always encoded
;                       with three characters.  The <fos> and <fod> components
;                       are always encoded with leading zeroes.
;
;                       If a left angle bracket is desired in the encoded
;                       string, then simply specify two left angle brackets
;                       (`<<') in the format specification (character
;                       stuffing).
;
;       All input variables must have been created/initialized before calling
;       `encodeEPOCHx'.
;
; OUTPUTS:
;       epString:       STRING.  The customized EPOCH character string.
;
;       All output variables are (re)created/assigned by `encodeEPOCHx'.
;
; EXAMPLE:
;       IDL> epoch = 6.297d13
;       IDL> format = '<dom.02>-<month>-<year> <hour>:<min>:<sec>.<fos>'
;       IDL> encodeEPOCHx, epoch, format, epString
;       IDL> print, epString
;       10-Jun-1995 10:40:00.000
;
; RESTRICTIONS:
;       None.
;
; REVISION HISTORY:
;       12-Jun-95       Original version.
;       26-Jun-95       Expanded online help.
;       16-Aug-96       CDF V2.6.
;-

pro encodeEPOCHx, epoch, format, epString
on_error, 1
idl_encodepochx, epoch, format, epString
return
end
