;------------------------------------------------------------------------------
;
;  NSSDC/CDF					 IDL/CDF Interface, CDFvarGet.
;
;  Version 1.4, 21-Aug-96, Hughes STX.
;
;  Modification history:
;
;   V1.0  21-Sep-92, H Leckner	Original version.
;   V1.1  10-Dec-92, H Leckner	Removed print/help debug statements.
;   V1.2  13-Sep-93, J Love	CDF V2.4 (`idl_cdf.pro' split into separate
;                               files as required for online help in IDL).
;   V1.3   1-Nov-94, J Love	CDF V2.5.
;   V1.3a 26-Jun-95, J Love	IDL 4.0.
;   V1.4  21-Aug-96, J Love	CDF V2.6.
;
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
; CDFvarGet.
;------------------------------------------------------------------------------

;+
; NAME:
;       CDFvarGet
;
; PURPOSE:
;       `CDFvarGet' is used to read a single value from an rVariable.
;
;       This function is part of the CDF interface provided with the CDF
;       distribution.  IDL also provides its own built-in interface to CDFs.
;
; CALLING SEQUENCE:
;       status = CDFvarGet (id, varNum, recNum, dimIndices, value)
;
; INPUTS:
;       id:             LONG.  Identifier of the CDF being accessed.  This
;                       identifier must have been returned from a successful
;                       call to `CDFcreate' or `CDFopen'.
;       varNum:         LONG.  The number of the rVariable.
;       recNum:         LONG.  The record number at which to read the value.
;                       Record numbers begin at zero (0).
;       dimIndices:     LONG array.  The dimension indices at which to read
;                       the value.  Indices begin at zero (0).
;
;       All input variables must have been created/initialized before calling
;       `CDFvarGet'.
;
; OUTPUTS:
;       value:          DATA TYPE DEPENDENT.  The value which was read.  The
;                       rVariable's CDF data type will determine which IDL
;                       data type is used for this IDL variable.
;
;       status:         LONG.  A completion status code.  CDF_OK indicates
;                       success.  The possible status codes are defined by
;                       `cdf0x.pro'.
;
;       All output variables are (re)created/assigned by `CDFvarGet'.
;
; EXAMPLE:
;       IDL> @cdf0x.pro
;       IDL> indices = lonarr(2)
;       IDL> indices(0) = 5
;       IDL> indices(1) = 10
;       IDL> recNum = 4L
;       IDL> status = CDFvarGet (id, CDFvarNum(id, 'Flux'), recNum, indices, $
;                                value)
;       IDL> if (status lt CDFx.CDF_WARN) print, 'CDFvarGet failed.'
;
; RESTRICTIONS:
;       None.
;
; REVISION HISTORY:
;       13-Sep-93       Original version.
;        1-Nov-94       CDF V2.5.
;       26-Jun-95       IDL 4.0.
;       21-Aug-96       CDF V2.6.
;-

function CDFvarGet, CDF_id,var_num,record_num,indices,value
common cdfcurrent_, cdfid_, cdfstatus_
on_error, 1
idl_cdfvarget, cdfid_, cdfstatus_, status, $
	       CDF_id, var_num, record_num, indices, value
return, status
end
