;------------------------------------------------------------------------------
;
;  NSSDC/CDF					   IDL/CDF Interface, CDFopen.
;
;  Version 1.4, 21-Aug-96, Hughes STX.
;
;  Modification history:
;
;   V1.0  21-Sep-92, H Leckner	Original version.
;   V1.1  10-Dec-92, H Leckner	Removed print/help debug statements.
;   V1.2  13-May-93, J Love	CDF V2.4 (`idl_cdf.pro' split into separate
;                               files as required for online help in IDL).
;   V1.3   1-Nov-94, J Love	CDF V2.5.
;   V1.3a 26-Jun-95, J Love	IDL 4.0.
;   V1.4  21-Aug-96, J Love	CDF V2.6.
;
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
; CDFopen.
;------------------------------------------------------------------------------

;+
; NAME:
;       CDFopen
;
; PURPOSE:
;       `CDFopen' is used to open an existing CDF for read/write access.
;
;       This function is part of the CDF interface provided with the CDF
;       distribution.  IDL also provides its own built-in interface to CDFs.
;
; CALLING SEQUENCE:
;       status = CDFopen (CDFname, id)
;
; INPUTS:
;       CDFname:        STRING.  The pathname of the CDF to open.  The `.cdf'
;                       extension should not be specified.
;
;       All input variables must have been created/initialized before calling
;       `CDFopen'.
;
; OUTPUTS:
;       id:             LONG.  A unique identifier for the opened CDF.  This
;                       identifier must be used in all subsequent calls when
;                       referring to this CDF.
;
;       status:         LONG.  A completion status code.  CDF_OK indicates
;                       success.  The possible status codes are defined by
;                       `cdf0x.pro'.
;
;       All output variables are (re)created/assigned by `CDFopen'.
;
; EXAMPLE:
;       IDL> @cdf0x.pro
;       IDL> CDFname = 'rain2'
;       IDL> status = CDFopen (CDFname, id)
;       IDL> if (status lt CDFx.CDF_WARN) print, 'CDFopen failed.'
;
; RESTRICTIONS:
;       None.
;
; REVISION HISTORY:
;       13-May-93       Original version.
;        1-Nov-94       CDF V2.5.
;       26-Jun-95       IDL 4.0.
;       21-Aug-96       CDF V2.6.
;-

function CDFopen, CDF_name,CDF_id
common cdfcurrent_, cdfid_, cdfstatus_
on_error, 1
idl_cdfopen, cdfid_, cdfstatus_, status, CDF_name, CDF_id
return, status
end
