;------------------------------------------------------------------------------
;
;  NSSDC/CDF					 IDL/CDF Interface, CDFcreate.
;
;  Version 1.4, 21-Aug-96, Hughes STX.
;
;  Modification history:
;
;   V1.0  21-Sep-92, H Leckner	Original version.
;   V1.1  10-Dec-92, H Leckner	Removed print/help debug statements.
;   V1.2  13-May-93, J Love	CDF V2.4 (`idl_cdf.pro' split into separate
;                               files as required for online help in IDL).
;   V1.3   1-Nov-94, J Love	CDF V2.5.
;   V1.3a 26-Jun-95, J Love	IDL 4.0.
;   V1.4  21-Aug-96, J Love	CDF V2.6.
;
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
; CDFcreate.
;------------------------------------------------------------------------------

;+
; NAME:
;       CDFcreate
;
; PURPOSE:
;       `CDFcreate' is used to create a new CDF.
;
;       This function is part of the CDF interface provided with the CDF
;       distribution.  IDL also provides its own built-in interface to CDFs.
;
; CALLING SEQUENCE:
;       status = CDFcreate (CDFname, numDims, dimSizes, encoding, majority, id)
;
; INPUTS:
;       CDFname:        STRING.  The pathname of the CDF to create.  The
;                       `.cdf' extension should not be specified.
;       numDims:        LONG.  The number of rVariable dimensions.
;       dimSizes:       LONG array.  The rVariable dimension sizes.
;       encoding:       LONG.  The variable/attribute entry encoding.  Use
;                       one of the encodings defined by `cdf0x.pro'.
;       majority:       LONG.  The variable majority.  Use one of the
;                       majorities defined by `cdf0x.pro'.
;
;       All input variables must have been created/initialized before calling
;       `CDFcreate'.
;
; OUTPUTS:
;       id:             LONG.  A unique identifier for the created CDF.  This
;                       identifier must be used in all subsequent calls when
;                       referring to this CDF.
;
;       status:         LONG.  A completion status code.  CDF_OK indicates
;                       success.  The possible status codes are defined by
;                       `cdf0x.pro'.
;
;       All output variables are (re)created/assigned by `CDFcreate'.
;
; EXAMPLE:
;       IDL> @cdf0x.pro
;       IDL> dimSizes = lonarr(2)
;       IDL> dimSizes(0) = 180
;       IDL> dimSizes(1) = 360
;       IDL> status = CDFcreate ('rain2x', 2L, dimSizes, $
;                                CDFen.NETWORK_ENCODING, CDFx.ROW_MAJORITY, id)
;       IDL> if (status lt CDFx.CDF_WARN) print, 'CDFcreate failed.'
;
; RESTRICTIONS:
;       The CDF must not already exist (an existing CDF with the same name
;       will not be overwritten).
;
; REVISION HISTORY:
;       13-May-93       Original version.
;        1-Nov-94       CDF V2.5.
;       26-Jun-95       IDL 4.0.
;       21-Aug-96       CDF V2.6.
;-

function CDFcreate, CDF_name,num_dims,dim_sizes,encoding,majority,CDF_id
common cdfcurrent_, cdfid_, cdfstatus_
on_error, 1
idl_cdfcreate, cdfid_, cdfstatus_, status, $
	       CDF_name, num_dims, dim_sizes, encoding, majority, CDF_id
return, status
end
