/******************************************************************************
*
*  NSSDC/CDF                                            CDFlist.  Part 4 of 4.
*
*  Version 1.1, 22-Jul-96, Hughes STX.
*
*  Modification history:
*
*   V1.0  31-Aug-94, J Love	Original version.
*   V1.0a 10-Jan-95, J Love	Uppercase file extensions on the Macintosh.
*   V1.0b 28-Sep-95, J Love	Macintosh dialog filtering.  Outline default
*				button.
*   V1.1  22-Jul-96, J Love	CDF V2.6.
*
******************************************************************************/

#include "cdflist.h"

/******************************************************************************
* ListQOPs.
*    Returns TRUE if execution should continue.
******************************************************************************/

#if defined(mac)
Logical ListQOPs (argC, argV)
int *argC;
char **argV[];
{
  DialogPtr dialogP;
  DialogRecord dRecord;
  WindowPtr behind = (WindowPtr) -1;
  ControlHandle controlHs[MAXIMUMin+1];
  Rect iRect;
#ifdef __MWERKS__
  ModalFilterUPP FilterDialogQOPfsiUPP;
  FileFilterUPP FilterForCDFsUPP;
  UserItemUPP OutlineDefaultButtonUPP;
#endif
  short itemN, iType, i;

  static Logical zMode = DEFAULTzModeLIST;
  static Logical eraseNew = DEFAULTeraseLIST;
  static Logical useFilters = DEFAULTfilterLIST;
  static Logical useFormat = DEFAULTformatLIST;
  static Logical useFillval = DEFAULTfillLIST;
  static Logical negToPos = DEFAULT_NEGtoPOSfp0;
  static int newFormat = BOO(DEFAULTsingleLIST,0,1);
  static int newEncoding = BOO(DEFAULTnetworkLIST,1,0);
  static int zModeFormat = BOO(DEFAULThorizontalLIST,0,1);
  static int epochFormat = BOO(DEFAULTepochLIST,0,1);
  static Str255 cacheText = "\p";
  static Str255 CDFtext = "\p";

  /****************************************************************************
  * Create the dialog and get the control handles.
  ****************************************************************************/

  dialogP = GetNewDialog (QOPri, &dRecord, behind);
  
  for (itemN = 1; itemN <= MAXIMUMin; itemN++) {
     GetDItem (dialogP, itemN, &iType, (Handle *) &controlHs[itemN], &iRect);
  }

  /****************************************************************************
  * Set the control values.
  ****************************************************************************/

  SetIText ((Handle) controlHs[CDFTEXTin], CDFtext);
  SetIText ((Handle) controlHs[CACHEin], cacheText);

  if (zMode) SetCtlValue (controlHs[ZMODEin], 1);
  if (eraseNew) SetCtlValue (controlHs[ERASEin], 1);
  if (useFilters) SetCtlValue (controlHs[FILTERin], 1);
  if (useFormat) SetCtlValue (controlHs[FORMATin], 1);
  if (useFillval) SetCtlValue (controlHs[FILLin], 1);
  if (negToPos) SetCtlValue (controlHs[NEGZin], 1);

  SetCtlValue (controlHs[FORMATinBASE+newFormat], 1);
  SetCtlValue (controlHs[ENCODINGinBASE+newEncoding], 1);
  SetCtlValue (controlHs[zFORMATinBASE+zModeFormat], 1);
  SetCtlValue (controlHs[eFORMATinBASE+epochFormat], 1);

#ifndef __MWERKS__
  SetDItem (dialogP, (short) ODBin, (short) userItem,
	    (Handle) OutlineDefaultButton, &iRect);
#else
  OutlineDefaultButtonUPP = NewUserItemProc (OutlineDefaultButton);
  SetDItem (dialogP, (short) ODBin, (short) userItem,
	    (Handle) OutlineDefaultButtonUPP, &iRect);
#endif

  /****************************************************************************
  * Display the dialog and wait for user actions.
  ****************************************************************************/
    
  ShowWindow ((WindowPtr) dialogP);
  SetCursor (ARROW_CURSOR);
#ifdef __MWERKS__
  FilterDialogQOPfsiUPP = NewModalFilterProc (FilterDialogQOPfsi);
#endif

  for (;;) {
#ifndef __MWERKS__
    ModalDialog (FilterDialogQOPfsi, &itemN);
#else
    ModalDialog (FilterDialogQOPfsiUPP, &itemN);
#endif
    switch (itemN) {
      /************************************************************************
      * Ok.
      ************************************************************************/
      case OKin: {
		int n;
		char tempS[5+1+7+1+8+1+6+1+8+1+12+1+6+1+7+1+10+1+6+1];
		char *formats[2] = { ",single", ",multi" },
	 	    *encodings[2] = { ",host", ",network" },
	 	    *zFormats[2] = { ",horizontal", ",vertical" },
	 	    *eFormats[2] = { ",epoch", ",epoch1" };
		/**********************************************************************
		* Get the value of each control.
		**********************************************************************/

		GetIText ((Handle) controlHs[CDFTEXTin], CDFtext);
		GetIText ((Handle) controlHs[CACHEin], cacheText);

		zMode = GetCtlValue (controlHs[ZMODEin]);
		eraseNew = GetCtlValue (controlHs[ERASEin]);
		useFilters = GetCtlValue (controlHs[FILTERin]);
		useFormat = GetCtlValue (controlHs[FORMATin]);
		useFillval = GetCtlValue (controlHs[FILLin]);
		negToPos = GetCtlValue (controlHs[NEGZin]);

		for (zModeFormat = 0; zModeFormat < 2; zModeFormat++) {
		   if (GetCtlValue(controlHs[zFORMATinBASE+zModeFormat])) break;
		}
		for (newFormat = 0; newFormat < 2; newFormat++) {
		   if (GetCtlValue(controlHs[FORMATinBASE+newFormat])) break;
		}
		for (newEncoding = 0; newEncoding < 2; newEncoding++) {
		   if (GetCtlValue(controlHs[ENCODINGinBASE+newEncoding])) break;
		}
		for (epochFormat = 0; epochFormat < 2; epochFormat++) {
		   if (GetCtlValue(controlHs[eFORMATinBASE+epochFormat])) break;
		}

		/**********************************************************************
		* Build argc/argv.
		**********************************************************************/

        *argC = 3 + BOO(NULpString(CDFtext),0,1) +
		    BOO(NULpString(cacheText),0,2);
        *argV = (char **) cdf_AllocateMemory (*argC * sizeof(char *),
					  FatalError);
	
		n = 0;
		MAKEstrARGv (argV, n, pgmName)

		if (!NULpString(CDFtext)) {
		  PtoCstr (CDFtext);
		  MAKEstrARGv (argV, n, (char *) CDFtext)
		  CtoPstr ((char *) CDFtext);
		}

		MAKEstrARGv (argV, n, "-initial");
		strcpyX (tempS, BOO(zMode,"zmode,",""), 0);
		strcatX (tempS, BOO(eraseNew,"erase","noerase"), 0);
		strcatX (tempS, BOO(useFilters,",filter",",nofilter"), 0);
		strcatX (tempS, BOO(useFormat,",format",",noformat"), 0);
		strcatX (tempS, BOO(useFillval,",fill",",nofill"), 0);
		strcatX (tempS, BOO(negToPos,",neg2posfp0",",noneg2posfp0"), 0);
		strcatX (tempS, formats[newFormat], 0);
		strcatX (tempS, encodings[newEncoding], 0);
		strcatX (tempS, zFormats[zModeFormat], 0);
		strcatX (tempS, eFormats[epochFormat], 0);
		MAKEstrARGv (argV, n, tempS);

		if (!NULpString(cacheText)) {
		  MAKEstrARGv (argV, n, "-cache")
		  PtoCstr (cacheText);
		  MAKEstrARGv (argV, n, (char *) cacheText)
		  CtoPstr ((char *) cacheText);
		}

		/**********************************************************************
		* Close the dialog and return.
		**********************************************************************/
        CloseDialog (dialogP);
#ifdef __MWERKS__
        DisposeRoutineDescriptor (FilterDialogQOPfsiUPP);
		DisposeRoutineDescriptor (OutlineDefaultButtonUPP);
#endif
        return TRUE;
      }
     /************************************************************************
      * Cancel.
      ************************************************************************/
      case CANCELin:
        CloseDialog (dialogP);
#ifdef __MWERKS__
        DisposeRoutineDescriptor (FilterDialogQOPfsiUPP);
		DisposeRoutineDescriptor (OutlineDefaultButtonUPP);
#endif
        return FALSE;
      /************************************************************************
      * Select CDF specification.
      ************************************************************************/
      case CDFSELECTin: {
		StandardFileReply CDFreply;
		char CDFpath[DU_MAX_PATH_LEN+1];
#ifndef __MWERKS__
		StandardGetFile (FilterForCDFs, -1, NULL, &CDFreply);
#else
		FilterForCDFsUPP = NewFileFilterProc((ProcPtr) FilterForCDFs);
		StandardGetFile (FilterForCDFsUPP, -1, NULL, &CDFreply);
		DisposeRoutineDescriptor (FilterForCDFsUPP);
#endif
		if (CDFreply.sfGood && !CDFreply.sfIsFolder && !CDFreply.sfIsVolume) {
		  BuildMacPath (&CDFreply.sfFile, CDFpath, TRUE);
		  CDFtext[0] = strlen (CDFpath);
		  strcpyX ((char *) &CDFtext[1], CDFpath, 255);
		  SetIText ((Handle) controlHs[CDFTEXTin], CDFtext);
		}
		break;
      }
      /************************************************************************
      * Check boxes.
      ************************************************************************/
      case ZMODEin:
      case ERASEin:
      case FILTERin:
      case FORMATin:
      case FILLin:
      case NEGZin:
        SetCtlValue (controlHs[itemN], BOO(GetCtlValue(controlHs[itemN]),0,1));
        break;
      /************************************************************************
      * Radio buttons.
      ************************************************************************/
      case FORMATinBASE+0:
      case FORMATinBASE+1:
        for (i = 0; i < 2; i++) SetCtlValue (controlHs[FORMATinBASE+i], 0);
        SetCtlValue (controlHs[itemN], 1);
        break;
      case ENCODINGinBASE+0:
      case ENCODINGinBASE+1:
        for (i = 0; i < 2; i++) SetCtlValue (controlHs[ENCODINGinBASE+i], 0);
        SetCtlValue (controlHs[itemN], 1);
        break;
      case zFORMATinBASE+0:
      case zFORMATinBASE+1:
        for (i = 0; i < 2; i++) SetCtlValue (controlHs[zFORMATinBASE+i], 0);
        SetCtlValue (controlHs[itemN], 1);
        break;
      case eFORMATinBASE+0:
      case eFORMATinBASE+1:
        for (i = 0; i < 2; i++) SetCtlValue (controlHs[eFORMATinBASE+i], 0);
        SetCtlValue (controlHs[itemN], 1);
        break;
    }
  }
}
#endif
