;------------------------------------------------------------------------------
;
;  NSSDC/CDF				    IDL/CDF Interface, CDFvarHyperGet.
;
;  Version 1.4, 21-Aug-96, Hughes STX.
;
;  Modification history:
;
;   V1.0  21-Sep-92, H Leckner	Original version.
;   V1.1  10-Dec-92, H Leckner	Removed print/help debug statements.
;   V1.2  13-Sep-93, J Love	CDF V2.4 (`idl_cdf.pro' split into separate
;                               files as required for online help in IDL).
;   V1.3   1-Nov-94, J Love	CDF V2.5.
;   V1.3a 26-Jun-95, J Love	IDL 4.0.
;   V1.4  21-Aug-96, J Love	CDF V2.6.
;
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
; CDFvarHyperGet.
;------------------------------------------------------------------------------

;+
; NAME:
;       CDFvarHyperGet
;
; PURPOSE:
;       `CDFvarHyperGet' is used to read multiple values from an rVariable.
;
;       This function is part of the CDF interface provided with the CDF
;       distribution.  IDL also provides its own built-in interface to CDFs.
;
; CALLING SEQUENCE:
;       status = CDFvarHyperGet (id, varNum, recNum, recCount, recInterval,
;                                dimIndices, dimCounts, dimIntervals, values)
;
; INPUTS:
;       id:             LONG.  Identifier of the CDF being accessed.  This
;                       identifier must have been returned from a successful
;                       call to `CDFcreate' or `CDFopen'.
;       varNum:         LONG.  The number of the rVariable.
;       recNum:         LONG.  The record number at which to begin reading
;                       the values.  Record numbers begin at zero (0).
;       recCount:       LONG.  The number of records to read.
;       recInterval:    LONG.  The interval between records to be read.  An
;                       interval of one (1) means read consecutive records,
;                       an interval of two (2) means read every other record,
;                       etc.
;       dimIndices:     LONG array.  The indices at which to begin reading
;                       the values (within each record).  Indices begin at
;                       zero (0).
;       dimCounts:      LONG array.  The number of values to read along each
;                       dimension.
;       dimIntervals:   LONG array.  The interval between values along each
;                       dimension to be read.  An interval of one (1) means
;                       read consecutive values along a dimension, an
;                       interval of two (2) means read every other value
;                       along a dimension, etc.
;
;       All input variables must have been created/initialized before calling
;       `CDFvarHyperGet'.
;
; OUTPUTS:
;       values:         DATA TYPE DEPENDENT.  The values which were read.
;                       The rVariable's CDF data type will determine which
;                       IDL data type is used for this IDL variable.  The
;                       majority of this IDL variable is dependent on the
;                       variable majority of the CDF.
;
;       status:         LONG.  A completion status code.  CDF_OK indicates
;                       success.  The possible status codes are defined by
;                       `cdf0x.pro'.
;
;       All output variables are (re)created/assigned by `CDFvarHyperGet'.
;
; EXAMPLE:
;       IDL> @cdf0x.pro
;       IDL> indices = lonarr(2)
;       IDL> indices(0) = 0
;       IDL> indices(1) = 0
;       IDL> counts = lonarr(2)
;       IDL> counts(0) = 180
;       IDL> counts(1) = 360
;       IDL> intervals = lonarr(2)
;       IDL> intervals(0) = 1
;       IDL> intervals(1) = 1
;       IDL> recNum = 4L
;       IDL> status = CDFvarHyperGet (id, CDFvarNum(id,'SST'), recNum, 10L, 2L,
;       IDL>                          indices, counts, intervals, values)
;       IDL> if (status lt CDFx.CDF_WARN) print, 'CDFvarHyperGet failed.'
;
; RESTRICTIONS:
;       None.
;
; REVISION HISTORY:
;       13-Sep-93       Original version.
;        1-Nov-94       CDF V2.5.
;       26-Jun-95       IDL 4.0.
;       21-Aug-96       CDF V2.6.
;-

function CDFvarHyperGet, CDF_id,var_num,recStart,recCount, $
			 recInterval,indices,counts,intervals,data
common cdfcurrent_, cdfid_, cdfstatus_
on_error, 1
idl_cdfhypget, cdfid_, cdfstatus_, status, $
	       CDF_id, var_num, recStart, recCount, $
	       recInterval, indices, counts, intervals, data
return, status
end
