/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.Attribute;
import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFData;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.Entry;
import gsfc.nssdc.cdf.Variable;
import gsfc.nssdc.cdf.util.CDFUtils;
import gsfc.nssdc.cdf.util.Epoch;
import gsfc.nssdc.cdf.util.Epoch16;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Vector;

public class CDF2CDFML
implements CDFConstants {
    private static CDF cdf = null;
    private static PrintWriter out = null;
    private static boolean debug = false;
    private static int indent = 0;
    private static int MAX_STR = 80;
    private static String recordTerminator = "&#10;";
    private static final String CDATA_BEGIN = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    private static String inFile = null;
    private static String outFile = null;
    private static String varData = "yes";
    private static String mode = "dtd";
    private static String defaultStrDelimiter = "@~";
    private static String strDelimiter = null;
    private static boolean showProgress = false;
    private static String indentation = "   ";

    public static void main(String[] stringArray) throws Exception {
        try {
            CDF2CDFML.parseCmdLine(stringArray);
            String string = inFile;
            inFile = CDF2CDFML.removeFilePath(inFile);
            if (!inFile.endsWith(".cdf") && !inFile.endsWith(".CDF")) {
                inFile = inFile + ".cdf";
            }
            if (outFile == null) {
                outFile = CDF2CDFML.getDefaultOutputFileName();
            }
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(outFile), 4096), "UTF-8");
            out = new PrintWriter((Writer)outputStreamWriter, false);
            cdf = CDF.open((String)string, (long)0L);
            CDF2CDFML.printHeader();
            CDF2CDFML.printCDFFileInfo();
            CDF2CDFML.printGlobalAttributes();
            CDF2CDFML.printVariables();
            if (!mode.equalsIgnoreCase("cdfxdf")) {
                CDF2CDFML.printOrphanAttributes();
            }
            cdf.close();
            out.println("</CDF>");
            out.flush();
            System.out.println("\nTranslation completed successfully.\n");
            System.out.println("   Input file name: " + string);
            System.out.println("  Output file name: " + outFile);
            System.out.println("");
        }
        catch (Exception exception) {
            if (cdf != null) {
                cdf.close();
            }
            System.out.println("Exception occurred in main.\n" + exception);
        }
    }

    private static final void parseCmdLine(String[] stringArray) {
        int n;
        String string = null;
        if (stringArray.length == 0) {
            CDF2CDFML.exit("");
        } else {
            n = 0;
            while (n < stringArray.length) {
                if (n == stringArray.length - 1) {
                    inFile = stringArray[n];
                    if (!CDFUtils.cdfFileExists((String)inFile)) {
                        System.out.println("** Error: file '" + inFile + "' does not exist **");
                        System.exit(1);
                    }
                } else {
                    int n2 = stringArray[n].indexOf(":");
                    if (stringArray[n].startsWith("-mode:")) {
                        mode = stringArray[n].substring(n2 + 1);
                        if (!(mode.equalsIgnoreCase("dtd") || mode.equalsIgnoreCase("xsd") || mode.equalsIgnoreCase("cdfxdf"))) {
                            CDF2CDFML.exit("** Error: Invalid -mode entered **");
                        }
                    } else if (stringArray[n].startsWith("-varData:")) {
                        varData = stringArray[n].substring(n2 + 1);
                        if (!varData.equalsIgnoreCase("yes") && !varData.equalsIgnoreCase("no")) {
                            CDF2CDFML.exit("** Error: Invalid -varData entered **");
                        }
                    } else if (stringArray[n].startsWith("-output:")) {
                        outFile = stringArray[n].substring(n2 + 1);
                        if (!(outFile.endsWith(".xml") || outFile.endsWith(".XML") || outFile.endsWith(".cdfml") || outFile.endsWith(".CDFML"))) {
                            outFile = outFile + ".xml";
                        }
                    } else if (stringArray[n].startsWith("-indentation:")) {
                        string = stringArray[n].substring(n2 + 1);
                        int n3 = Integer.valueOf(string);
                        indentation = "";
                        int n4 = 0;
                        while (n4 < n3) {
                            indentation = indentation + ' ';
                            ++n4;
                        }
                    } else if (stringArray[n].startsWith("-strDelimiter:")) {
                        strDelimiter = stringArray[n].substring(n2 + 1);
                    } else if (stringArray[n].equalsIgnoreCase("-showProgress")) {
                        showProgress = true;
                    } else if (stringArray[n].startsWith("-debug:")) {
                        String string2 = stringArray[n].substring(n2 + 1);
                        if (string2.equalsIgnoreCase("true")) {
                            debug = true;
                        }
                    } else {
                        CDF2CDFML.exit("** Error: Invalid option entered **");
                    }
                }
                ++n;
            }
        }
        if (debug) {
            n = 0;
            while (n < stringArray.length) {
                System.out.println("args[" + n + "] = " + stringArray[n]);
                ++n;
            }
            System.out.println("inFile=" + inFile + ", outputFile=" + outFile + ", mode=" + mode + ", vardata= " + varData + ", indentation=" + string + ", strDelimiter=" + strDelimiter + "**, showProgress=" + showProgress);
        }
        if (inFile == null) {
            CDF2CDFML.exit("** Error: CDF file name not specified **");
        }
    }

    private static final void printHeader() {
        out.println("<?xml version=\"1.0\" standalone=\"no\"?>");
        if (mode.equalsIgnoreCase("dtd")) {
            out.println("<!-- Change \"http://cdf.gsfc.nasa.gov/cdf.dtd\" to \"cdf.dtd\" if you want to");
            out.println("     use a local version of cdf.dtd. -->");
            out.println("<!DOCTYPE CDF SYSTEM \"http://cdf.gsfc.nasa.gov/cdf.dtd\">");
        } else if (mode.equalsIgnoreCase("xsd")) {
            out.println("<CDF xmlns=\"http://cdf.gsfc.nasa.gov/\"");
            out.println("     name=\"" + inFile + "\">");
        } else if (mode.equalsIgnoreCase("cdfxdf")) {
            out.println("<!DOCTYPE CDF SYSTEM \"cdfxdf.dtd\">");
        }
        if (!mode.equalsIgnoreCase("xsd")) {
            out.println("<CDF name=\"" + inFile + "\">");
        }
    }

    private static final void outputIndentation(int n) {
        GetMyCDFData.outputIndentation(out, n, indentation);
    }

    private static final void printCompression(long l, long[] lArray) {
        if (l != 0L) {
            String string = CDFUtils.getStringCompressionType((long)l);
            out.print(" compression=\"" + string);
            if (l == (long)5) {
                out.print("." + lArray[0] + '\"');
            } else {
                out.print("\"");
            }
        }
    }

    private static final void printCDFFileInfo() {
        try {
            String string = CDFUtils.getStringFormat((CDF)cdf);
            String string2 = CDFUtils.getStringMajority((CDF)cdf);
            String string3 = CDFUtils.getStringEncoding((CDF)cdf);
            CDF2CDFML.outputIndentation(++indent);
            out.print("<cdfFileInfo ");
            out.print("fileFormat=\"" + string + '\"');
            long l = cdf.getCompressionType();
            long[] lArray = cdf.getCompressionParms();
            CDF2CDFML.printCompression(l, lArray);
            out.print(" majority=\"" + string2 + '\"');
            out.print(" encoding=\"" + string3 + '\"');
            long l2 = cdf.confirmNegtoPosfp0();
            if (l2 == (long)-1) {
                out.print(" negToPosFp0=\"ENABLE\"");
            } else {
                out.print(" negToPosFp0=\"DISABLE\"");
            }
            out.println("/>");
        }
        catch (Exception exception) {
            System.out.println("** Error occurred in printCDFFileInfo");
            System.out.println(exception);
            System.exit(1);
        }
    }

    private static final void printGlobalAttributes() {
        try {
            Attribute attribute = null;
            String string = null;
            long l = cdf.getNumGattrs();
            Vector vector = cdf.getGlobalAttributes();
            if (l > 0L) {
                CDF2CDFML.outputIndentation(indent);
                out.println("<cdfGAttributes>");
                ++indent;
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    attribute = (Attribute)enumeration.nextElement();
                    string = attribute.getName();
                    long l2 = attribute.getNumEntries();
                    CDF2CDFML.outputIndentation(indent);
                    String[] stringArray = CDF2CDFML.getAttributeAndEntryTagNames();
                    out.println("<" + stringArray[0] + " name=\"" + string + "\">");
                    ++indent;
                    if (mode.equalsIgnoreCase("cdfxdf")) {
                        CDF2CDFML.outputIndentation(indent);
                        out.println("<units><unitless/></units>");
                    }
                    Vector vector2 = attribute.getEntries();
                    Enumeration enumeration2 = vector2.elements();
                    while (enumeration2.hasMoreElements()) {
                        Entry entry = (Entry)enumeration2.nextElement();
                        if (entry == null) continue;
                        long l3 = entry.getDataType();
                        CDF2CDFML.outputIndentation(indent);
                        out.print("<" + stringArray[1] + " entryNum=\"" + entry.getID() + "\" cdfDatatype=\"" + CDFUtils.getStringDataType((long)l3) + "\">");
                        Object object = entry.getData();
                        int n = 0;
                        if (l3 == 31L) {
                            n = 1;
                        }
                        if (l3 == 32L) {
                            n = 2;
                        }
                        if (l3 == 51L || l3 == 52L) {
                            out.print(CDATA_BEGIN);
                        }
                        CDFUtils.printData((Object)object, (PrintWriter)out, (int)n);
                        if (l3 == 51L || l3 == 52L) {
                            out.print(CDATA_END);
                        }
                        out.println("</" + stringArray[1] + "> ");
                    }
                    CDF2CDFML.outputIndentation(--indent);
                    out.println("</" + stringArray[0] + '>');
                }
                CDF2CDFML.outputIndentation(--indent);
                out.println("</cdfGAttributes>");
            }
        }
        catch (Exception exception) {
            System.out.println("** Error occurred in printGlobalAttributes");
            System.out.println(exception);
            System.exit(1);
        }
    }

    private static final void printVariables() {
        try {
            int n = 1;
            long l = cdf.getNumVars();
            if (l > 0L) {
                CDF2CDFML.outputIndentation(indent);
                out.println("<cdfVariables>");
                ++indent;
                Vector vector = cdf.getVariables();
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    Variable variable = (Variable)enumeration.nextElement();
                    String string = variable.getName();
                    if (showProgress) {
                        long l2 = variable.getMaxWrittenRecord() + 1L;
                        System.out.print("Variable " + n + " of " + l + " (" + l2 + " records): " + string);
                        ++n;
                    }
                    CDF2CDFML.outputIndentation(indent);
                    out.println("<variable name=\"" + string + "\">");
                    CDF2CDFML.printVarInfo(variable);
                    CDF2CDFML.printVarAttributes(variable);
                    CDF2CDFML.printVarData(variable);
                }
                CDF2CDFML.outputIndentation(--indent);
                out.println("</cdfVariables>");
            }
        }
        catch (Exception exception) {
            System.out.println("** Error occurred in printVariables");
            System.out.println(exception);
            System.exit(1);
        }
    }

    private static final void printVarInfo(Variable variable) {
        try {
            int n;
            long[] lArray = new long[]{1L};
            Object object = null;
            long l = variable.getDataType();
            long l2 = variable.getNumDims();
            lArray = variable.getDimSizes();
            long l3 = variable.getNumElements();
            long[] lArray2 = variable.getDimVariances();
            String string = variable.getRecVariance() ? "VARY" : "NOVARY";
            object = variable.getPadValue();
            long l4 = variable.getBlockingFactor();
            String string2 = CDFUtils.getStringSparseRecord((Variable)variable);
            CDF2CDFML.outputIndentation(++indent);
            String string3 = CDFUtils.getStringDataType((long)l);
            out.print("<cdfVarInfo cdfDatatype=\"" + string3 + '\"');
            if (showProgress) {
                System.out.print("\t" + string3 + '/');
            }
            out.print(" numElements=\"" + l3 + '\"');
            if (showProgress) {
                System.out.print("" + l3 + '\t');
            }
            out.print(" dim=\"" + l2 + '\"');
            if (showProgress) {
                System.out.print(l2 + ":[");
            }
            if (l2 > 0L) {
                out.print(" dimSizes=\"");
                n = 0;
                while ((long)n < l2) {
                    if (n > 0) {
                        out.print(",");
                        if (showProgress) {
                            System.out.print(",");
                        }
                    }
                    out.print(lArray[n]);
                    if (showProgress) {
                        System.out.print(lArray[n]);
                    }
                    ++n;
                }
                out.print("\"");
            }
            if (showProgress) {
                System.out.print("]\t");
            }
            out.print(" recVariance=\"" + string + '\"');
            if (showProgress) {
                if (string.equals("VARY")) {
                    System.out.print("T/");
                } else {
                    System.out.print("F/");
                }
            }
            if (l2 > 0L) {
                out.print(" dimVariances=\"");
                n = 0;
                while ((long)n < l2) {
                    if (n > 0) {
                        out.print(",");
                    }
                    String string4 = lArray2[n] == (long)-1 ? "VARY" : "NOVARY";
                    out.print(string4);
                    if (showProgress) {
                        if (string4.equals("VARY")) {
                            System.out.print("T");
                        } else {
                            System.out.print("F");
                        }
                    }
                    ++n;
                }
                out.print("\"");
            }
            if (showProgress) {
                System.out.println("");
            }
            long l5 = variable.getCompressionType();
            long[] lArray3 = variable.getCompressionParms();
            CDF2CDFML.printCompression(l5, lArray3);
            if (string2.equals("None")) {
                long l6 = variable.getNumWrittenRecords();
                if (l6 > 0L) {
                    out.print(" numRecordsAllocate=\"" + l6 + '\"');
                }
            } else {
                out.print(" sparseRecords=\"" + string2 + '\"');
            }
            if (variable.checkPadValueExistence()) {
                if (l == 31L) {
                    object = Epoch.encode((double)((Double)object));
                } else if (l == 32L) {
                    object = Epoch16.encode((Object)((double[])object));
                }
                out.print(" padValue=\"" + object + '\"');
            }
            if (l4 > 0L) {
                out.print(" blockingFactor=\"" + l4 + '\"');
            }
            out.println("/>");
        }
        catch (Exception exception) {
            System.out.println("** Error occurred in printVariables");
            System.out.println(exception);
            System.exit(1);
        }
    }

    private static final void printVarAttributes(Variable variable) {
        try {
            Attribute attribute = null;
            String string = null;
            Vector vector = variable.getAttributes();
            if (vector.size() == 0) {
                return;
            }
            CDF2CDFML.outputIndentation(indent);
            out.println("<cdfVAttributes>");
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                attribute = (Attribute)enumeration.nextElement();
                string = attribute.getName();
                try {
                    Entry entry = attribute.getEntry(variable);
                    if (entry == null) continue;
                    CDF2CDFML.outputIndentation(++indent);
                    String[] stringArray = CDF2CDFML.getAttributeAndEntryTagNames();
                    out.println("<" + stringArray[0] + " name=\"" + string + "\">");
                    ++indent;
                    if (mode.equalsIgnoreCase("cdfxdf")) {
                        CDF2CDFML.outputIndentation(indent);
                        out.println("<units><unitless/></units>");
                    }
                    long l = entry.getDataType();
                    CDF2CDFML.outputIndentation(indent);
                    out.print("<" + stringArray[1] + " cdfDatatype=\"" + CDFUtils.getStringDataType((long)l) + "\">");
                    Object object = entry.getData();
                    int n = 0;
                    if (l == 31L) {
                        n = 1;
                    }
                    if (l == 32L) {
                        n = 2;
                    }
                    if (l == 51L || l == 52L) {
                        out.print(CDATA_BEGIN);
                    }
                    CDFUtils.printData((Object)object, (PrintWriter)out, (int)n);
                    if (l == 51L || l == 52L) {
                        out.print(CDATA_END);
                    }
                    out.println("</" + stringArray[1] + '>');
                    CDF2CDFML.outputIndentation(--indent);
                    out.println("</" + stringArray[0] + '>');
                    --indent;
                }
                catch (CDFException cDFException) {}
            }
            CDF2CDFML.outputIndentation(indent);
            out.println("</cdfVAttributes>");
        }
        catch (Exception exception) {
            System.out.println("** Error occurred in printVarAttrInfo");
            System.out.println(exception);
            System.exit(1);
        }
    }

    private static final void printVarData(Variable variable) {
        try {
            long l;
            long[] lArray = new long[]{1L};
            long[] lArray2 = new long[1];
            long[] lArray3 = new long[]{1L};
            String string = " ";
            CDFData cDFData = null;
            long l2 = variable.getMaxWrittenRecord();
            if (varData.equalsIgnoreCase("no") || l2 < 0L) {
                CDF2CDFML.outputIndentation(--indent);
                out.println("</variable>");
                return;
            }
            long l3 = variable.getNumDims();
            lArray = variable.getDimSizes();
            long l4 = variable.getNumElements();
            long l5 = variable.getDataType();
            long l6 = 1L;
            if (l3 > 0L) {
                lArray3 = new long[lArray.length];
                lArray2 = new long[lArray.length];
                int n = 0;
                while (n < lArray.length) {
                    lArray3[n] = 1L;
                    lArray2[n] = 0L;
                    l6 *= lArray[n];
                    ++n;
                }
            }
            string = " ";
            CDF2CDFML.outputIndentation(indent);
            out.println("<cdfVarData>");
            if (mode.equalsIgnoreCase("cdfxdf")) {
                CDF2CDFML.printXDFtags(variable, l2, l6);
            }
            long l7 = (l = variable.getSparseRecords()) == 0L ? (long)(l3 == 0L ? 1000 : 200) : 1L;
            int n = 0;
            while ((long)n <= l2) {
                long l8 = (long)n + l7 > l2 ? l2 - (long)n + 1L : l7;
                cDFData = l3 > 0L ? variable.getHyperDataObject((long)n, l8, 1L, lArray2, lArray, lArray3) : variable.getRecordsObject((long)n, l8);
                long l9 = cdf.getStatus();
                Object object = cDFData.getData();
                int n2 = 0;
                while ((long)n2 < l8) {
                    Object object2 = l8 > 1L ? Array.get(object, n2) : object;
                    GetMyCDFData getMyCDFData = GetMyCDFData.create(object2, l5, l3, lArray, l4);
                    boolean bl = false;
                    if (!mode.equalsIgnoreCase("cdfxdf")) {
                        StringBuffer stringBuffer = new StringBuffer("<record ");
                        long l10 = n + n2;
                        String string2 = "recNum=\"" + l10 + "\">";
                        if (l9 != 1001L) {
                            String string3;
                            if (l5 == 51L || l5 == 52L) {
                                if (strDelimiter == null) {
                                    string = defaultStrDelimiter;
                                } else {
                                    string = strDelimiter;
                                    if (string.equals("\"")) {
                                        string = "&quot;";
                                    }
                                }
                                if (string.equals("<element>")) {
                                    bl = true;
                                    stringBuffer.append(string2);
                                } else if (l3 >= 1L) {
                                    stringBuffer.append("elementDelimiter=\"");
                                    stringBuffer.append(string);
                                    stringBuffer.append("\" ");
                                    stringBuffer.append(string2);
                                } else {
                                    stringBuffer.append(string2);
                                }
                                string3 = stringBuffer.toString();
                            } else {
                                string = " ";
                                string3 = "<record recNum=\"" + l10 + "\">";
                            }
                            getMyCDFData.dumpData(out, string3, "</record>", string, bl, indent, indentation);
                        }
                    } else {
                        getMyCDFData.dumpData(out, "", "", " ", bl, indent, indentation);
                    }
                    ++n2;
                }
                n = (int)((long)n + l7);
            }
            if (mode.equalsIgnoreCase("cdfxdf")) {
                CDF2CDFML.outputIndentation(indent);
                out.println("</data>");
                CDF2CDFML.outputIndentation(--indent);
                out.println("</array>");
                --indent;
            }
            CDF2CDFML.outputIndentation(indent);
            out.println("</cdfVarData>");
            CDF2CDFML.outputIndentation(--indent);
            out.println("</variable>");
        }
        catch (Exception exception) {
            System.out.println("** Error occurred in printVarData");
            System.out.println(exception);
            System.exit(1);
        }
    }

    private static final String[] getAttributeAndEntryTagNames() {
        String[] stringArray = new String[2];
        if (mode.equalsIgnoreCase("cdfxdf")) {
            stringArray[0] = "parameter";
            stringArray[1] = "value";
        } else {
            stringArray[0] = "attribute";
            stringArray[1] = "entry";
        }
        return stringArray;
    }

    private static final void printXDFtags(Variable variable, long l, long l2) {
        long l3 = variable.getID();
        long l4 = variable.getDataType();
        CDF2CDFML.outputIndentation(++indent);
        out.println("<array>");
        CDF2CDFML.outputIndentation(++indent);
        out.println("<units><unitless/></units>");
        CDF2CDFML.outputIndentation(indent);
        out.println("<dataFormat>");
        CDF2CDFML.outputIndentation(++indent);
        switch ((int)l4) {
            case 31: 
            case 32: 
            case 51: 
            case 52: {
                out.println("<string length=\"" + MAX_STR + "\"/>");
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 11: 
            case 12: 
            case 14: 
            case 41: {
                out.println("<integer width=\"10\"/>");
                break;
            }
            case 21: 
            case 22: 
            case 44: 
            case 45: {
                out.println("<float width=\"18\" precision=\"9\"/>");
                break;
            }
        }
        CDF2CDFML.outputIndentation(--indent);
        out.println("</dataFormat>");
        CDF2CDFML.outputIndentation(indent);
        out.println("<axis axisId=\"recNoforVarnum" + l3 + "\">");
        CDF2CDFML.outputIndentation(++indent);
        out.println("<axisUnits><unitless/></axisUnits>");
        CDF2CDFML.outputIndentation(indent);
        out.println("<valueList size=\"" + (l + 1L) + "\"/>");
        CDF2CDFML.outputIndentation(--indent);
        out.println("</axis>");
        CDF2CDFML.outputIndentation(indent);
        out.println("<axis axisId=\"record" + l3 + "\">");
        CDF2CDFML.outputIndentation(++indent);
        out.println("<axisUnits><unitless/></axisUnits>");
        CDF2CDFML.outputIndentation(indent);
        out.println("<valueList size=\"" + l2 + "\"/>");
        CDF2CDFML.outputIndentation(--indent);
        out.println("</axis>");
        CDF2CDFML.outputIndentation(indent);
        out.println("<read>");
        CDF2CDFML.outputIndentation(++indent);
        out.println("<for axisIdRef=\"recNoforVarnum" + l3 + "\">");
        CDF2CDFML.outputIndentation(++indent);
        out.println("<for axisIdRef=\"record" + l3 + "\">");
        CDF2CDFML.outputIndentation(++indent);
        out.println("<textDelimiter repeatable=\"yes\" recordTerminator=\"" + recordTerminator + "\"/>");
        CDF2CDFML.outputIndentation(--indent);
        out.println("</for>");
        CDF2CDFML.outputIndentation(--indent);
        out.println("</for>");
        CDF2CDFML.outputIndentation(--indent);
        out.println("</read>");
        CDF2CDFML.outputIndentation(indent);
        out.println("<data>");
    }

    private static final void printOrphanAttributes() {
        Vector vector = cdf.getOrphanAttributes();
        if (vector.size() > 0) {
            CDF2CDFML.outputIndentation(indent);
            out.println("<orphanAttributes>");
            ++indent;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Attribute attribute = (Attribute)enumeration.nextElement();
                String string = attribute.getName();
                CDF2CDFML.outputIndentation(indent);
                if (mode.equalsIgnoreCase("cdfxdf")) {
                    out.println("<parameter name=\"" + string + "\">");
                    CDF2CDFML.outputIndentation(++indent);
                    out.println("<units><unitless/></units>");
                    CDF2CDFML.outputIndentation(indent);
                    out.println("<value>></value>");
                    CDF2CDFML.outputIndentation(--indent);
                    out.println("</parameter> ");
                    continue;
                }
                out.println("<attribute name=\"" + string + "\"/>");
            }
            CDF2CDFML.outputIndentation(--indent);
            out.println("</orphanAttributes>");
        }
    }

    private static final String getDefaultOutputFileName() {
        String string;
        boolean bl;
        int n = inFile.lastIndexOf(".cdf");
        int n2 = inFile.lastIndexOf(".CDF");
        boolean bl2 = false;
        if (inFile.endsWith(".cdf") || inFile.endsWith(".CDF")) {
            bl2 = true;
        }
        if (!(bl = bl2)) {
            string = inFile + ".xml";
        } else if (n != -1) {
            string = inFile.substring(0, n);
            string = string + ".xml";
        } else {
            string = inFile.substring(0, n2);
            string = string + ".XML";
        }
        return string;
    }

    private static final String removeFilePath(String string) {
        String string2 = System.getProperty("file.separator");
        int n = string.lastIndexOf(string2);
        string = string.substring(n + 1);
        return string;
    }

    private static final void exit(String string) {
        if (!string.equals("")) {
            System.out.println(string);
        }
        CDF2CDFML.usage();
        System.exit(1);
    }

    private static final void usage() {
        System.out.println("\nDescription:");
        System.out.println("    This program exports the contents of a CDF file into an XML file");
        System.out.println("    that conforms to cdf.dtd (default mode), cdf.xsd, or cdfxdf.dtd.");
        System.out.println("    The file conforms to the CDF Document Type Definition (cdf.dtd or");
        System.out.println("    cdfxdf.dtd) or the CDF XML Schema (cdf.xsd) is called a CDF markup");
        System.out.println("    language (CDFML) file.");
        System.out.println("");
        System.out.println("      - cdf.dtd is a pure version of CDFML described in DTD.");
        System.out.println("      - cdf.xsd is a pure version of CDFML described in schema.");
        System.out.println("      - cdfxdf.dtd is a CDFML that employs some of the eXtensible Data ");
        System.out.println("        Format (XDF) tags within CDF tags.");
        System.out.println(" ");
        System.out.println("    The name of the input CDF file is used as the default output file name.");
        System.out.println(" ");
        System.out.println("Usage: java CDF2CDFML [Options] cdfFileName ");
        System.out.println(" ");
        System.out.println("Options: ");
        System.out.println("   -mode:[dtd | xsd | cdfxdf].  -mode:dtd is the default.");
        System.out.println("       -mode:dtd creates a CDFML file that conforms to cdf.dtd (DTD)");
        System.out.println("       -mode:xsd creates a CDFML file that conforms to cdf.xsd (schema)");
        System.out.println("       -mode:cdfxdf creates a CDFML file that conforms to cdfxdf.dtd");
        System.out.println(" ");
        System.out.println("   -varData:[yes | no].  -varData:yes is the default.");
        System.out.println("       -varData:yes extracts the variable data");
        System.out.println("       -varData:no doesn't extract the variable data");
        System.out.println(" ");
        System.out.println("   -output:outputFileName ");
        System.out.println("       The name of the input CDF file is used as the default output file");
        System.out.println("       name.  Use this option to specify a different output file name.");
        System.out.println(" ");
        System.out.println("   -indentation:n (n is the number of spaces to skip between levels)");
        System.out.println(" ");
        System.out.println("   -showProgress");
        System.out.println("       This option displays the progress report on the screen.");
        System.out.println("       It shows how many CDF variables are there to process and which");
        System.out.println("       variable is being processed.");
        System.out.println(" ");
        System.out.println("   -strDelimiter:[\"userDefinedDelimiter\" | \"<element>\"]");
        System.out.println("       The string delimiter to be used for an array of string data.");
        System.out.println("");
        System.out.println("       -strDelimiter:\"<element>\" option describes data between the");
        System.out.println("           <element index=\"indexNum\"> and </element> tags.");
        System.out.println("");
        System.out.println("Examples: ");
        System.out.println("   1) java CDF2CDFML test.cdf (same as java CDF2CDFML -mode:dtd test.cdf)");
        System.out.println("   2) java CDF2CDFML -mode:cdfxdf test.cdf");
        System.out.println("   3) java CDF2CDFML -output:mytest.xml test.cdf");
        System.out.println("   4) java CDF2CDFML -indentation:2 test.cdf (use 2 spaces for indentation)");
        System.out.println("          The default indentation is 3 spaces between levels");
        System.out.println("   5) java CDF2CDFML -strDelimiter:\"'\" output:test.xml test.cdf ");
        System.out.println("   6) java CDF2CDFML -strDelimiter:\\\"\"\" output:test.xml test.cdf ");
        System.out.println("   7) java CDF2CDFML -strDelimiter:\"<element>\" output:test.xml test.cdf ");
        System.out.println(" ");
    }
}

