/*
 * Decompiled with CFR 0.152.
 */
package gsfc.nssdc.cdf;

import gsfc.nssdc.cdf.Attribute;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.CDFObject;
import gsfc.nssdc.cdf.util.CDFUtils;
import java.io.Serializable;
import java.util.Vector;

public class Entry
implements CDFObject,
CDFConstants {
    private long id;
    private long scope;
    private long dataType;
    private long xdataType;
    private long numElements;
    private long xnumElements;
    private Object data = null;
    private Object xdata = null;
    private String dataSignature;
    private String xdataSignature;
    private Attribute myAttribute;

    protected static Entry retrieve(Attribute attribute, long l) throws CDFException {
        Entry entry = new Entry(attribute, l);
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        switch ((int)entry.scope) {
            case 1: {
                vector.addElement(new Long(1007L));
                vector.addElement(new Long(98L));
                vector2.addElement("dataType");
                vector2.addElement("J");
                vector.addElement(vector2);
                vector.addElement(new Long(99L));
                vector3.addElement("numElements");
                vector3.addElement("J");
                vector.addElement(vector3);
                vector.addElement(new Long(1000L));
                break;
            }
            case 2: {
                vector.addElement(new Long(1007L));
                vector.addElement(new Long(112L));
                vector2.addElement("dataType");
                vector2.addElement("J");
                vector.addElement(vector2);
                vector.addElement(new Long(113L));
                vector3.addElement("numElements");
                vector3.addElement("J");
                vector.addElement(vector3);
                vector.addElement(new Long(1000L));
                break;
            }
            default: {
                throw new CDFException(-2010L);
            }
        }
        entry.myAttribute.getMyCDF().executeCommand(entry, vector);
        entry.buildDataObject();
        vector.removeAllElements();
        vector2.removeAllElements();
        vector.addElement(new Long(1007L));
        vector.addElement(entry.scope == 1L ? new Long(101L) : new Long(115L));
        vector2.addElement("data");
        vector2.addElement("Ljava/lang/Object;");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        entry.myAttribute.getMyCDF().executeCommand(entry, vector);
        attribute.addEntry(entry, (int)l);
        return entry;
    }

    public static Entry create(Attribute attribute, long l, long l2, Object object) throws CDFException {
        if (l < 0L) {
            throw new CDFException(-2043L);
        }
        if (attribute.getMaxEntryNumber() < l && attribute.getScope() == 2L) {
            throw new CDFException(-2019L);
        }
        Entry entry = new Entry(attribute, l);
        entry.dataType = l2;
        entry.data = object;
        entry.dataSignature = CDFUtils.getSignature(object);
        entry.numElements = CDFUtils.getNumElements(l2, object);
        attribute.select();
        if (attribute.getMaxEntryNumber() > l) {
            try {
                attribute.getEntry(l).delete();
            }
            catch (CDFException cDFException) {
                // empty catch block
            }
        }
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        vector.addElement(new Long(1008L));
        vector.addElement(entry.scope == 1L ? new Long(101L) : new Long(115L));
        vector2.addElement("dataType");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector3.addElement("numElements");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector4.addElement("data");
        vector4.addElement("Ljava/lang/Object;");
        vector.addElement(vector4);
        vector.addElement(new Long(1000L));
        entry.myAttribute.getMyCDF().executeCommand(entry, vector);
        attribute.addEntry(entry, (int)l);
        return entry;
    }

    private void buildDataObject() {
        if (this.dataType == 51L || this.dataType == 52L) {
            this.data = new String();
            this.dataSignature = "Ljava/lang/String;";
        } else {
            switch ((int)this.dataType) {
                case 1: 
                case 41: {
                    if (this.numElements > 1L) {
                        this.dataSignature = "[B";
                        this.data = new byte[(int)this.numElements];
                        break;
                    }
                    this.dataSignature = "Ljava/lang/Byte;";
                    this.data = new Byte(0);
                    break;
                }
                case 2: 
                case 11: {
                    if (this.numElements > 1L) {
                        this.dataSignature = "[S";
                        this.data = new short[(int)this.numElements];
                        break;
                    }
                    this.dataSignature = "Ljava/lang/Short;";
                    this.data = new Short(0);
                    break;
                }
                case 4: 
                case 12: {
                    if (this.numElements > 1L) {
                        this.dataSignature = "[I";
                        this.data = new int[(int)this.numElements];
                        break;
                    }
                    this.dataSignature = "Ljava/lang/Integer;";
                    this.data = new Integer(0);
                    break;
                }
                case 14: {
                    if (this.numElements > 1L) {
                        this.data = new long[(int)this.numElements];
                        this.dataSignature = "[J";
                        break;
                    }
                    this.dataSignature = "Ljava/lang/Long;";
                    this.data = new Long(0L);
                    break;
                }
                case 21: 
                case 44: {
                    if (this.numElements > 1L) {
                        this.dataSignature = "[F";
                        this.data = new float[(int)this.numElements];
                        break;
                    }
                    this.dataSignature = "Ljava/lang/Float;";
                    this.data = new Float(0.0f);
                    break;
                }
                case 22: 
                case 31: 
                case 45: {
                    if (this.numElements > 1L) {
                        this.dataSignature = "[D";
                        this.data = new double[(int)this.numElements];
                        break;
                    }
                    this.dataSignature = "Ljava/lang/Double;";
                    this.data = new Double(0.0);
                    break;
                }
            }
        }
    }

    public void delete() throws CDFException {
        Vector<Long> vector = new Vector<Long>();
        this.id = this.getID();
        this.myAttribute.select();
        vector.addElement(new Long(1003L));
        vector.addElement(this.scope == 1L ? new Long(96L) : new Long(109L));
        vector.addElement(new Long(1000L));
        this.myAttribute.getMyCDF().executeCommand(this, vector);
        this.myAttribute.removeEntry(this);
    }

    public long getDataType() {
        return this.dataType;
    }

    public long getNumElements() {
        return this.numElements;
    }

    public Object getData() {
        return this.data;
    }

    public long getID() {
        return this.myAttribute.getEntryID(this);
    }

    public String getName() {
        return Long.toString(this.id);
    }

    public void rename(String string) throws CDFException {
    }

    public void updateDataSpec(long l, long l2) throws CDFException {
        this.xdataType = l;
        this.xnumElements = l2;
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        this.id = this.getID();
        this.myAttribute.select();
        vector.addElement(new Long(1008L));
        vector.addElement(this.scope == 1L ? new Long(100L) : new Long(114L));
        vector2.addElement("xdataType");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector3.addElement("xnumElements");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(1000L));
        this.myAttribute.getMyCDF().executeCommand(this, vector);
        this.dataType = this.xdataType;
        this.numElements = this.xnumElements;
        vector.removeAllElements();
        vector2.removeAllElements();
        this.data = null;
        this.buildDataObject();
        vector.addElement(new Long(1007L));
        vector.addElement(this.scope == 1L ? new Long(101L) : new Long(115L));
        vector2.addElement("data");
        vector2.addElement("Ljava/lang/Object;");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.myAttribute.getMyCDF().executeCommand(this, vector);
    }

    public void putData(long l, Object object) throws CDFException {
        this.xdataType = this.dataType;
        this.xnumElements = this.numElements;
        this.xdataSignature = this.dataSignature;
        this.xdata = this.data;
        this.dataType = l;
        this.numElements = CDFUtils.getNumElements(l, object);
        this.dataSignature = CDFUtils.getSignature(object);
        this.data = object;
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        this.myAttribute.select();
        this.id = this.getID();
        try {
            vector.addElement(new Long(1008L));
            vector.addElement(this.scope == 1L ? new Long(101L) : new Long(115L));
            vector2.addElement("dataType");
            vector2.addElement("J");
            vector.addElement(vector2);
            vector3.addElement("numElements");
            vector3.addElement("J");
            vector.addElement(vector3);
            vector4.addElement("data");
            vector4.addElement("Ljava/lang/Object;");
            vector.addElement(vector4);
            vector.addElement(new Long(1000L));
            this.myAttribute.getMyCDF().executeCommand(this, vector);
        }
        catch (CDFException cDFException) {
            this.dataType = this.xdataType;
            this.numElements = this.xnumElements;
            this.data = this.xdata;
            this.dataSignature = this.xdataSignature;
            throw new CDFException(cDFException.getCurrentStatus());
        }
    }

    protected final void select() throws CDFException {
        Vector<Long> vector = new Vector<Long>();
        this.id = this.getID();
        vector.addElement(new Long(1000L));
        this.myAttribute.getMyCDF().executeCommand(this, vector);
    }

    private Entry(Attribute attribute, long l) {
        this.myAttribute = attribute;
        this.id = l;
        this.scope = attribute.getScope();
    }
}

