/*
 * Decompiled with CFR 0.152.
 */
package gsfc.nssdc.cdf;

import gsfc.nssdc.cdf.Attribute;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFDelegate;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.CDFNativeLibrary;
import gsfc.nssdc.cdf.CDFObject;
import gsfc.nssdc.cdf.Entry;
import gsfc.nssdc.cdf.Variable;
import gsfc.nssdc.cdf.util.CDFUtils;
import java.io.File;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class CDF
implements CDFObject,
CDFConstants {
    private CDFDelegate delegate;
    private String path;
    private long id;
    private File theFile;
    private long cdfStatus;
    private long cType;
    private long cTypeX;
    private long cPct;
    private long[] cParms = new long[1];
    private long[] cParmsX = new long[1];
    private long cSize;
    private long uSize;
    private String copyright = null;
    private String version = null;
    private long vers;
    private long libVersion;
    private long rel;
    private long libRelease;
    private long inc;
    private long libIncrement;
    private String libsubIncrement;
    private String libCopyright;
    private long encoding;
    private long encodingX;
    private long decoding;
    private long cacheSize;
    private long compressCacheSize;
    private long stageCacheSize;
    private long negtoPosfp0;
    private long format;
    private long formatX;
    private long majority;
    private long majorityX;
    private long numAttrs;
    private long numGattrs;
    private long numVattrs;
    private long numRvars;
    private long numZvars;
    private long readOnly;
    private long zmode;
    private long numDims;
    private long[] dimSizes;
    private boolean closed;
    private long infoWarning;
    private Vector attributes;
    private Vector variables;

    public static CDF create(String string) throws CDFException {
        CDF cDF = new CDF(string, new CDFNativeLibrary());
        cDF.theFile = new File(string);
        cDF.numDims = 0L;
        cDF.dimSizes = new long[]{2L};
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        Vector<String> vector5 = new Vector<String>();
        vector.addElement(new Long(1001L));
        vector.addElement(new Long(1L));
        vector2.addElement("path");
        vector2.addElement("Ljava/lang/String;");
        vector.addElement(vector2);
        vector3.addElement("numDims");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector4.addElement("dimSizes");
        vector4.addElement("[J");
        vector.addElement(vector4);
        vector5.addElement("id");
        vector5.addElement("J");
        vector.addElement(vector5);
        vector.addElement(new Long(1000L));
        cDF.executeCommand(cDF, vector);
        cDF.selectzMode(2L);
        cDF.selectReadOnlyMode(0L);
        cDF.getCDFInfo();
        return cDF;
    }

    public static CDF open(String string, long l) throws CDFException {
        CDF cDF = new CDF(string, new CDFNativeLibrary());
        cDF.theFile = new File(string);
        cDF.infoWarning = 0L;
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        vector.addElement(new Long(1002L));
        vector.addElement(new Long(1L));
        vector2.addElement("path");
        vector2.addElement("Ljava/lang/String;");
        vector.addElement(vector2);
        vector3.addElement("id");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(1000L));
        cDF.executeCommand(cDF, vector);
        cDF.selectReadOnlyMode(l);
        cDF.selectzMode(2L);
        cDF.getCDFInfo();
        long l2 = cDF.numAttrs;
        long l3 = 0L;
        while (l3 < l2) {
            Attribute attribute = Attribute.retrieve(cDF, l3);
            ++l3;
        }
        l2 = cDF.numZvars;
        Variable variable = null;
        long l4 = 0L;
        while (l4 < l2) {
            variable = Variable.retrieve(cDF, l4);
            ++l4;
        }
        return cDF;
    }

    public static String getLibraryVersion() throws CDFException {
        CDF cDF = new CDF(new CDFNativeLibrary());
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        Vector<String> vector5 = new Vector<String>();
        vector.addElement(new Long(1007L));
        vector.addElement(new Long(21L));
        vector2.addElement("libVersion");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(22L));
        vector3.addElement("libRelease");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(23L));
        vector4.addElement("libIncrement");
        vector4.addElement("J");
        vector.addElement(vector4);
        vector.addElement(new Long(24L));
        vector5.addElement("libsubIncrement");
        vector5.addElement("Ljava/lang/String;");
        vector.addElement(vector5);
        vector.addElement(new Long(1000L));
        cDF.executeCommand(cDF, vector);
        return cDF.libVersion + "." + cDF.libRelease + "." + cDF.libIncrement + cDF.libsubIncrement;
    }

    public static String getLibraryCopyRight() throws CDFException {
        CDF cDF = new CDF(new CDFNativeLibrary());
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        vector.addElement(new Long(1007L));
        vector.addElement(new Long(20L));
        vector2.addElement("libCopyright");
        vector2.addElement("Ljava/lang/String;");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        cDF.executeCommand(cDF, vector);
        return cDF.libCopyright;
    }

    private void getCDFInfo() throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        Vector<String> vector5 = new Vector<String>();
        Vector<String> vector6 = new Vector<String>();
        Vector<String> vector7 = new Vector<String>();
        Vector<String> vector8 = new Vector<String>();
        Vector<String> vector9 = new Vector<String>();
        Vector<String> vector10 = new Vector<String>();
        Vector<String> vector11 = new Vector<String>();
        Vector<String> vector12 = new Vector<String>();
        Vector<String> vector13 = new Vector<String>();
        Vector<String> vector14 = new Vector<String>();
        Vector<String> vector15 = new Vector<String>();
        Vector<String> vector16 = new Vector<String>();
        vector.addElement(new Long(1007L));
        vector.addElement(new Long(3L));
        vector2.addElement("encoding");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(6L));
        vector3.addElement("format");
        vector3.addElement("J");
        vector.addElement(vector3);
        vector.addElement(new Long(13L));
        vector4.addElement("vers");
        vector4.addElement("J");
        vector.addElement(vector4);
        vector.addElement(new Long(14L));
        vector5.addElement("rel");
        vector5.addElement("J");
        vector.addElement(vector5);
        vector.addElement(new Long(15L));
        vector6.addElement("inc");
        vector6.addElement("J");
        vector.addElement(vector6);
        vector.addElement(new Long(5L));
        vector7.addElement("majority");
        vector7.addElement("J");
        vector.addElement(vector7);
        vector.addElement(new Long(10L));
        vector8.addElement("numAttrs");
        vector8.addElement("J");
        vector.addElement(vector8);
        vector.addElement(new Long(11L));
        vector9.addElement("numGattrs");
        vector9.addElement("J");
        vector.addElement(vector9);
        vector.addElement(new Long(12L));
        vector10.addElement("numVattrs");
        vector10.addElement("J");
        vector.addElement(vector10);
        vector.addElement(new Long(8L));
        vector11.addElement("numRvars");
        vector11.addElement("J");
        vector.addElement(vector11);
        vector.addElement(new Long(9L));
        vector12.addElement("numZvars");
        vector12.addElement("J");
        vector.addElement(vector12);
        vector.addElement(new Long(7L));
        vector13.addElement("copyright");
        vector13.addElement("Ljava/lang/String;");
        vector.addElement(vector13);
        vector.addElement(new Long(130L));
        vector14.addElement("cType");
        vector14.addElement("J");
        vector.addElement(vector14);
        vector15.addElement("cParms");
        vector15.addElement("[J");
        vector.addElement(vector15);
        vector16.addElement("cPct");
        vector16.addElement("J");
        vector.addElement(vector16);
        vector.addElement(new Long(1000L));
        this.executeCommand(this, vector);
        this.version = this.vers + "." + this.rel + "." + this.inc;
        this.closed = false;
    }

    public void close() throws CDFException {
        if (!this.closed) {
            Vector<Long> vector = new Vector<Long>();
            Vector vector2 = new Vector();
            vector.addElement(new Long(1004L));
            vector.addElement(new Long(1L));
            vector.addElement(new Long(1000L));
            this.executeCommand(this, vector);
            this.closed = true;
        }
    }

    public long getID() {
        return this.id;
    }

    public long getEncoding() {
        return this.encoding;
    }

    public void setEncoding(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        this.encodingX = l;
        this.select();
        vector.addElement(new Long(1008L));
        vector.addElement(new Long(3L));
        vector2.addElement("encodingX");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.executeCommand(this, vector);
        this.encoding = l;
    }

    public void selectDecoding(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        this.decoding = l;
        this.select();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(4L));
        vector2.addElement("decoding");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.executeCommand(this, vector);
    }

    public long confirmDecoding() throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        this.decoding = this.decoding;
        this.select();
        vector.addElement(new Long(1006L));
        vector.addElement(new Long(4L));
        vector2.addElement("decoding");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.executeCommand(this, vector);
        return this.decoding;
    }

    public void selectCDFCacheSize(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        this.cacheSize = l;
        this.select();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(117L));
        vector2.addElement("cacheSize");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.executeCommand(this, vector);
    }

    public long confirmCDFCacheSize() throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        this.select();
        vector.addElement(new Long(1006L));
        vector.addElement(new Long(117L));
        vector2.addElement("cacheSize");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.executeCommand(this, vector);
        return this.cacheSize;
    }

    public void selectNegtoPosfp0(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        this.negtoPosfp0 = l;
        this.select();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(19L));
        vector2.addElement("negtoPosfp0");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.executeCommand(this, vector);
    }

    public long confirmNegtoPosfp0() throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        this.select();
        vector.addElement(new Long(1006L));
        vector.addElement(new Long(19L));
        vector2.addElement("negtoPosfp0");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.executeCommand(this, vector);
        return this.negtoPosfp0;
    }

    public long getFormat() {
        return this.format;
    }

    public void setFormat(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        this.formatX = l;
        this.select();
        vector.addElement(new Long(1008L));
        vector.addElement(new Long(6L));
        vector2.addElement("formatX");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.executeCommand(this, vector);
        this.format = l;
    }

    public String getVersion() {
        return this.version;
    }

    public long getMajority() {
        return this.majority;
    }

    public void setMajority(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        this.majorityX = l;
        this.select();
        vector.addElement(new Long(1008L));
        vector.addElement(new Long(5L));
        vector2.addElement("majorityX");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.executeCommand(this, vector);
        this.majority = l;
    }

    public long getNumAttrs() {
        return this.attributes.size();
    }

    public long getNumGattrs() {
        long l = 0L;
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (attribute.getScope() != 1L) continue;
            ++l;
        }
        return l;
    }

    public long getNumVattrs() {
        long l = 0L;
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (attribute.getScope() != 2L) continue;
            ++l;
        }
        return l;
    }

    public long getNumRvars() {
        return this.numRvars;
    }

    public long getNumZvars() {
        return this.variables.size();
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void selectReadOnlyMode(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        this.readOnly = l;
        this.select();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(17L));
        vector2.addElement("readOnly");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.executeCommand(this, vector);
    }

    public long confirmReadOnlyMode() throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        this.select();
        vector.addElement(new Long(1006L));
        vector.addElement(new Long(17L));
        vector2.addElement("readOnly");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.executeCommand(this, vector);
        return this.readOnly;
    }

    public long getCompressionType() {
        return this.cType;
    }

    public long getCompressionPct() {
        return this.cPct;
    }

    public long[] getCompressionParms() {
        return this.cParms;
    }

    public void setCompression(long l, long[] lArray) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        this.cTypeX = l;
        this.cParmsX = lArray;
        this.select();
        vector.addElement(new Long(1008L));
        vector.addElement(new Long(130L));
        vector2.addElement("cTypeX");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector3.addElement("cParmsX");
        vector3.addElement("[J");
        vector.addElement(vector3);
        vector.addElement(new Long(1000L));
        this.executeCommand(this, vector);
        this.cType = l;
        this.cParms = lArray;
    }

    public String getCompression() throws CDFException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.cType == 0L) {
            stringBuffer.append("No compression");
        } else {
            stringBuffer.append(CDFUtils.getStringCompressionType(this.cType)).append(".").append(this.cParms[0]);
        }
        return stringBuffer.toString();
    }

    private void selectzMode(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        this.zmode = l;
        this.select();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(18L));
        vector2.addElement("zmode");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.executeCommand(this, vector);
    }

    public long confirmzMode() throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        this.select();
        vector.addElement(new Long(1006L));
        vector.addElement(new Long(18L));
        vector2.addElement("zmode");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.executeCommand(this, vector);
        return this.zmode;
    }

    public void selectCompressCacheSize(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        this.compressCacheSize = l;
        this.select();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(155L));
        vector2.addElement("compressCacheSize");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.executeCommand(this, vector);
    }

    public long confirmCompressCacheSize() throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        this.select();
        vector.addElement(new Long(1006L));
        vector.addElement(new Long(155L));
        vector2.addElement("compressCacheSize");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.executeCommand(this, vector);
        return this.compressCacheSize;
    }

    public void selectStageCacheSize(long l) throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        this.stageCacheSize = l;
        this.select();
        vector.addElement(new Long(1005L));
        vector.addElement(new Long(154L));
        vector2.addElement("stageCacheSize");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.executeCommand(this, vector);
    }

    public long confirmStageCacheSize() throws CDFException {
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<String> vector2 = new Vector<String>();
        this.select();
        vector.addElement(new Long(1006L));
        vector.addElement(new Long(154L));
        vector2.addElement("stageCacheSize");
        vector2.addElement("J");
        vector.addElement(vector2);
        vector.addElement(new Long(1000L));
        this.executeCommand(this, vector);
        return this.stageCacheSize;
    }

    public String getName() {
        return this.path;
    }

    public void rename(String string) {
        this.path = string;
    }

    public void delete() throws CDFException {
        Vector<Long> vector = new Vector<Long>();
        this.select();
        vector.addElement(new Long(1003L));
        vector.addElement(new Long(1L));
        vector.addElement(new Long(1000L));
        this.executeCommand(this, vector);
    }

    public void save() throws CDFException {
        Vector<Long> vector = new Vector<Long>();
        vector.addElement(new Long(1009L));
        this.executeCommand(this, vector);
    }

    public long getStatus() {
        return this.cdfStatus;
    }

    public static String getStatusText(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        if (l > 0L) {
            stringBuffer.append("INFO: ");
        } else if (l < 0L && l > -2000L) {
            stringBuffer.append("WARNING: ");
        }
        return stringBuffer.append(CDFException.getStatusMsg(l)).toString();
    }

    public void setInfoWarningOff() {
        this.infoWarning = 0L;
    }

    public void setInfoWarningOn() {
        this.infoWarning = 1L;
    }

    private final void select() throws CDFException {
        Vector<Long> vector = new Vector<Long>();
        this.id = this.getID();
        vector.addElement(new Long(1000L));
        this.executeCommand(this, vector);
    }

    public String toString() {
        return this.path;
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    public CDFDelegate getDelegate() {
        return this.delegate;
    }

    public void setDelegate(CDFDelegate cDFDelegate) {
        this.delegate = cDFDelegate;
    }

    protected synchronized void executeCommand(CDFObject cDFObject, Vector vector) throws CDFException {
        this.delegate.cdflib(this, cDFObject, vector);
    }

    /*
     * Unable to fully structure code
     */
    public long getAttributeID(String var1_1) {
        var2_2 = 0;
        if (this.attributes.size() != 0) ** GOTO lbl-1000
        return -1L;
        while (++var2_2 < this.attributes.size()) lbl-1000:
        // 2 sources

        {
            if (!this.attributes.elementAt(var2_2).toString().equals(var1_1)) continue;
        }
        if (var2_2 == this.attributes.size()) {
            return -1L;
        }
        return var2_2;
    }

    protected final void addAttribute(Attribute attribute) {
        this.attributes.addElement(attribute);
    }

    protected final void removeAttribute(Attribute attribute) {
        this.attributes.removeElement(attribute);
    }

    public Attribute getAttribute(long l) throws CDFException {
        if (l > (long)this.attributes.size()) {
            throw new CDFException(-2017L);
        }
        return (Attribute)this.attributes.elementAt((int)l);
    }

    public Attribute getAttribute(String string) throws CDFException {
        long l = this.getAttributeID(string);
        if (l == -1L) {
            throw new CDFException(-2017L);
        }
        return (Attribute)this.attributes.elementAt((int)l);
    }

    public Vector getAttributes() {
        return this.attributes;
    }

    public Vector getGlobalAttributes() {
        Vector<Attribute> vector = new Vector<Attribute>();
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (attribute.getScope() != 1L) continue;
            vector.addElement(attribute);
        }
        return vector;
    }

    public Vector getVariableAttributes() {
        Vector<Attribute> vector = new Vector<Attribute>();
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (attribute.getScope() != 2L) continue;
            vector.addElement(attribute);
        }
        return vector;
    }

    public Vector getOrphanAttributes() {
        boolean bl = true;
        Vector<Attribute> vector = new Vector<Attribute>();
        if (this.getNumVars() <= 0L) {
            return vector;
        }
        Vector vector2 = this.getVariableAttributes();
        Vector vector3 = this.getVariables();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            bl = true;
            Enumeration enumeration2 = vector3.elements();
            while (enumeration2.hasMoreElements()) {
                Variable variable = (Variable)enumeration2.nextElement();
                try {
                    Entry entry = attribute.getEntry(variable);
                    if (entry == null) continue;
                    bl = false;
                    break;
                }
                catch (CDFException cDFException) {
                    if (cDFException.getCurrentStatus() == -2018L) continue;
                    System.out.println("** Error occurred in getOrphanAttributes");
                    System.out.println(cDFException);
                    System.exit(0);
                }
            }
            if (!bl) continue;
            vector.addElement(attribute);
        }
        return vector;
    }

    /*
     * Unable to fully structure code
     */
    public long getVariableID(String var1_1) {
        var2_2 = 0L;
        if (this.variables.size() != 0) ** GOTO lbl-1000
        return -1L;
        while (++var2_2 < (long)this.variables.size()) lbl-1000:
        // 2 sources

        {
            if (!this.variables.elementAt((int)var2_2).toString().equals(var1_1)) continue;
        }
        if (var2_2 == (long)this.variables.size()) {
            return -1L;
        }
        return var2_2;
    }

    protected final void addVariable(Variable variable) {
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (attribute.getScope() != 2L) continue;
            attribute.addNullEntry();
        }
        this.variables.addElement(variable);
    }

    protected final void removeVariable(Variable variable) {
        int n = this.variables.indexOf(variable);
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (attribute.getScope() != 2L) continue;
            attribute.removeEntry(n);
        }
        this.variables.removeElement(variable);
    }

    public Variable getVariable(long l) throws CDFException {
        if (l > (long)this.variables.size()) {
            throw new CDFException(-2019L);
        }
        return (Variable)this.variables.elementAt((int)l);
    }

    public Variable getVariable(String string) throws CDFException {
        long l = this.getVariableID(string);
        if (l == -1L) {
            throw new CDFException(-2019L);
        }
        return (Variable)this.variables.elementAt((int)l);
    }

    public Vector getVariables() {
        return this.variables;
    }

    public long getNumVars() {
        return this.variables.size();
    }

    public Vector getRecord(long l, String[] stringArray) throws CDFException {
        return this.getRecord(l, stringArray, null);
    }

    public Vector getRecord(long l, String[] stringArray, long[] lArray) throws CDFException {
        if (l < 0L || stringArray == null || stringArray.length == 0) {
            return null;
        }
        int n = stringArray.length;
        long[] lArray2 = new long[n];
        int n2 = 0;
        while (n2 < n) {
            lArray2[n2] = this.getVariableID(stringArray[n2]);
            if (lArray2[n2] == -1L) {
                System.err.println("Error: Variable: " + stringArray[n2] + " not exists!!!");
                throw new CDFException(-2019L);
            }
            ++n2;
        }
        return this.getRecord(l, lArray2, lArray);
    }

    public Vector getRecord(long l, long[] lArray) throws CDFException {
        return this.getRecord(l, lArray, null);
    }

    public Vector getRecord(long l, long[] lArray, long[] lArray2) throws CDFException {
        if (l < 0L || lArray == null || lArray.length == 0) {
            return null;
        }
        int n = lArray.length;
        Vector<Object> vector = new Vector<Object>();
        int n2 = 0;
        while (n2 < n) {
            Variable variable;
            try {
                variable = this.getVariable(lArray[n2]);
            }
            catch (CDFException cDFException) {
                System.err.println("Error: Variable: " + lArray[n2] + " not exists!!!");
                throw new CDFException(-2019L);
            }
            vector.add(variable.getRecord(l));
            if (lArray2 != null) {
                lArray2[n2] = this.getStatus();
            }
            ++n2;
        }
        return vector;
    }

    public void putRecord(long l, String[] stringArray, Vector vector) throws CDFException {
        this.putRecord(l, stringArray, vector, null);
    }

    public void putRecord(long l, String[] stringArray, Vector vector, long[] lArray) throws CDFException {
        if (l < 0L || stringArray == null || stringArray.length == 0 || vector == null || vector.isEmpty()) {
            return;
        }
        int n = stringArray.length;
        long[] lArray2 = new long[n];
        int n2 = 0;
        while (n2 < n) {
            lArray2[n2] = this.getVariableID(stringArray[n2]);
            if (lArray2[n2] == -1L) {
                System.err.println("Error: Variable: " + stringArray[n2] + " not exists!!!");
                throw new CDFException(-2019L);
            }
            ++n2;
        }
        this.putRecord(l, lArray2, vector, lArray);
    }

    public void putRecord(long l, long[] lArray, Vector vector) throws CDFException {
        this.putRecord(l, lArray, vector, null);
    }

    public void putRecord(long l, long[] lArray, Vector vector, long[] lArray2) throws CDFException {
        if (l < 0L || lArray == null || lArray.length == 0 || vector == null || vector.isEmpty()) {
            return;
        }
        if (lArray.length != vector.size()) {
            System.err.println("Error: the variables' count: " + lArray.length + " does not match the record objects' count: " + vector.size());
            return;
        }
        if (lArray2 != null && lArray2.length < lArray.length) {
            System.err.println("Error: the variables' count: " + lArray.length + " does not match the status' count: " + lArray2.length);
            return;
        }
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            Variable variable;
            try {
                variable = this.getVariable(lArray[n2]);
            }
            catch (CDFException cDFException) {
                System.err.println("Error: Variable: " + lArray[n2] + " not exists!!!");
                throw new CDFException(-2019L);
            }
            variable.putRecord(l, vector.elementAt(n2));
            if (lArray2 != null) {
                lArray2[n2] = this.getStatus();
            }
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    private CDF(String var1_1, CDFDelegate var2_2) throws CDFException {
        super();
        if (var1_1 == null || var1_1.length() == 0) {
            throw new CDFException(-2049L);
        }
        var3_3 = null;
        var3_3 = var1_1.trim();
        if (var3_3 != null && var3_3.length() != 0) ** GOTO lbl13
        throw new CDFException(-2049L);
lbl-1000:
        // 1 sources

        {
            var3_3 = var3_3.substring(1);
lbl13:
            // 2 sources

            ** while (var3_3.startsWith((String)" "))
        }
lbl14:
        // 1 sources

        this.path = var3_3;
        this.delegate = var2_2;
        this.zmode = 2L;
        this.attributes = new Vector<E>();
        this.variables = new Vector<E>();
        this.closed = false;
    }

    private CDF(CDFDelegate cDFDelegate) throws CDFException {
        this.delegate = cDFDelegate;
    }
}

