/*
 * Decompiled with CFR 0.152.
 */
package gsfc.nssdc.cdf.util;

import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.Entry;
import gsfc.nssdc.cdf.Variable;
import gsfc.nssdc.cdf.util.Epoch;
import gsfc.nssdc.cdf.util.Epoch16;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.StringTokenizer;

public class CDFUtils
implements CDFConstants {
    public static String getSignature(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = object.getClass().getName();
        if (string.indexOf(91) == 0) {
            stringBuffer.append(string);
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            stringBuffer.append("L");
            do {
                stringBuffer.append(stringTokenizer.nextToken());
                if (!stringTokenizer.hasMoreTokens()) continue;
                stringBuffer.append("/");
            } while (stringTokenizer.hasMoreTokens());
            stringBuffer.append(";");
        }
        return stringBuffer.toString();
    }

    public static long getNumElements(long l, Object object) throws CDFException {
        if (l == 51L || l == 52L) {
            return ((String)object).length();
        }
        int n = 0;
        if (l == 32L) {
            n = 1;
        }
        int n2 = n + 1;
        String string = CDFUtils.getSignature(object);
        if (string.charAt(0) == '[') {
            switch (string.charAt(1)) {
                case 'B': {
                    return ((byte[])object).length / n2;
                }
                case 'S': {
                    return ((short[])object).length / n2;
                }
                case 'I': {
                    return ((int[])object).length / n2;
                }
                case 'J': {
                    return ((long[])object).length / n2;
                }
                case 'F': {
                    return ((float[])object).length / n2;
                }
                case 'D': {
                    return ((double[])object).length / n2;
                }
            }
            throw new CDFException(-2022L);
        }
        return 1L;
    }

    public static void printData(Object object) {
        CDFUtils.printData(object, 0);
    }

    public static void printData(Object object, int n) {
        int n2 = 1;
        String string = CDFUtils.getSignature(object);
        if (n == 2) {
            n2 = 2;
        }
        if (string.charAt(0) == '[') {
            int n3 = Array.getLength(object);
            int n4 = 0;
            while (n4 < n3) {
                if (string.charAt(1) == 'B') {
                    System.out.print("" + Array.getByte(object, n4) + ' ');
                } else if (string.charAt(1) == 'S') {
                    System.out.print("" + Array.getShort(object, n4) + ' ');
                } else if (string.charAt(1) == 'I') {
                    System.out.print("" + Array.getInt(object, n4) + ' ');
                } else if (string.charAt(1) == 'J') {
                    System.out.print("" + Array.getLong(object, n4) + ' ');
                } else if (string.charAt(1) == 'F') {
                    System.out.print("" + Array.getFloat(object, n4) + ' ');
                } else if (string.charAt(1) == 'D') {
                    if (n == 1) {
                        System.out.print(Epoch.encode(Array.getDouble(object, n4)) + ' ');
                    } else if (n == 2) {
                        double[] dArray = new double[]{Array.getDouble(object, n4), Array.getDouble(object, n4 + 1)};
                        System.out.print(Epoch16.encode(dArray) + ' ');
                    } else {
                        System.out.print("" + Array.getDouble(object, n4) + ' ');
                    }
                }
                n4 += n2;
            }
        } else if (n == 1) {
            System.out.print(Epoch.encode((Double)object) + ' ');
        } else {
            System.out.print(object);
        }
    }

    public static void printData(Object object, PrintWriter printWriter) {
        CDFUtils.printData(object, printWriter, 0);
    }

    public static void printData(Object object, PrintWriter printWriter, int n) {
        int n2 = 1;
        String string = CDFUtils.getSignature(object);
        if (n == 2) {
            n2 = 2;
        }
        if (string.charAt(0) == '[') {
            int n3 = Array.getLength(object);
            int n4 = 0;
            while (n4 < n3) {
                if (string.charAt(1) == 'B') {
                    printWriter.print("" + Array.getByte(object, n4) + ' ');
                } else if (string.charAt(1) == 'S') {
                    printWriter.print("" + Array.getShort(object, n4) + ' ');
                } else if (string.charAt(1) == 'I') {
                    printWriter.print("" + Array.getInt(object, n4) + ' ');
                } else if (string.charAt(1) == 'J') {
                    printWriter.print("" + Array.getLong(object, n4) + ' ');
                } else if (string.charAt(1) == 'F') {
                    printWriter.print("" + Array.getFloat(object, n4) + ' ');
                } else if (string.charAt(1) == 'D') {
                    if (n == 1) {
                        printWriter.print(Epoch.encode(Array.getDouble(object, n4)) + ' ');
                    } else if (n == 2) {
                        double[] dArray = new double[]{Array.getDouble(object, n4), Array.getDouble(object, n4 + 1)};
                        printWriter.print(Epoch16.encode(dArray) + ' ');
                    } else {
                        printWriter.print("" + Array.getDouble(object, n4) + ' ');
                    }
                }
                n4 += n2;
            }
        } else if (n == 1) {
            printWriter.print(Epoch.encode((Double)object));
        } else {
            printWriter.print(object);
        }
    }

    public static String getStringData(Object object) {
        return CDFUtils.getStringData(object, " ", 0);
    }

    public static String getStringData(Object object, int n) {
        return CDFUtils.getStringData(object, " ", n);
    }

    public static String getStringData(Object object, String string) {
        return CDFUtils.getStringData(object, string, 0);
    }

    public static String getStringData(Object object, String string, int n) {
        String string2 = CDFUtils.getSignature(object);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n == 2 ? 2 : 1;
        if (string2.charAt(0) == '[') {
            int n3 = Array.getLength(object);
            int n4 = 0;
            while (n4 < n3) {
                if (string2.charAt(1) == 'B') {
                    stringBuffer.append(Array.getByte(object, n4)).append(string);
                } else if (string2.charAt(1) == 'S') {
                    stringBuffer.append(Array.getShort(object, n4)).append(string);
                } else if (string2.charAt(1) == 'I') {
                    stringBuffer.append(Array.getInt(object, n4)).append(string);
                } else if (string2.charAt(1) == 'J') {
                    stringBuffer.append(Array.getLong(object, n4)).append(string);
                } else if (string2.charAt(1) == 'F') {
                    stringBuffer.append(Array.getFloat(object, n4)).append(string);
                } else if (string2.charAt(1) == 'D') {
                    Object object2;
                    if (n == 1) {
                        object2 = Epoch.encode(Array.getDouble(object, n4));
                        stringBuffer.append((String)object2).append(string);
                    } else if (n == 2) {
                        object2 = new double[2];
                        object2[0] = Array.getDouble(object, n4);
                        object2[1] = Array.getDouble(object, n4 + 1);
                        String string3 = Epoch16.encode(object2);
                        stringBuffer.append(string3).append(string);
                    } else {
                        stringBuffer.append(Array.getDouble(object, n4)).append(string);
                    }
                } else if (string2.charAt(1) == 'C') {
                    stringBuffer.append(Array.getChar(object, n4)).append(string);
                } else if (string2.indexOf("String") != -1) {
                    stringBuffer.append(((String[])object)[n4]).append(string);
                }
                n4 += n2;
            }
            stringBuffer.setLength(stringBuffer.length() - string.length());
        } else if (string2.indexOf("Byte") != -1) {
            stringBuffer.append(((Byte)object).toString());
        } else if (string2.indexOf("Short") != -1) {
            stringBuffer.append(((Short)object).toString());
        } else if (string2.indexOf("Integer") != -1) {
            stringBuffer.append(((Integer)object).toString());
        } else if (string2.indexOf("Long") != -1) {
            stringBuffer.append(((Long)object).toString());
        } else if (string2.indexOf("Float") != -1) {
            stringBuffer.append(((Float)object).toString());
        } else if (string2.indexOf("Double") != -1) {
            if (n == 1) {
                String string4 = Epoch.encode((Double)object);
                stringBuffer.append(string4).append(string);
            } else {
                stringBuffer.append(((Double)object).toString());
            }
        } else if (string2.indexOf("Character") != -1) {
            stringBuffer.append(((Character)object).toString());
        } else if (string2.indexOf("String") != -1) {
            stringBuffer.append((String)object);
        }
        return stringBuffer.toString();
    }

    public static String getStringDataType(Variable variable) {
        return CDFUtils.getStringDataType(variable.getDataType());
    }

    public static String getStringDataType(Entry entry) {
        return CDFUtils.getStringDataType(entry.getDataType());
    }

    public static String getStringDataType(long l) {
        String string = l == 41L ? "CDF_BYTE" : (l == 51L ? "CDF_CHAR" : (l == 52L ? "CDF_UCHAR" : (l == 1L ? "CDF_INT1" : (l == 11L ? "CDF_UINT1" : (l == (long)2 ? "CDF_INT2" : (l == 12L ? "CDF_UINT2" : (l == (long)4 ? "CDF_INT4" : (l == 14L ? "CDF_UINT4" : (l == 21L ? "CDF_REAL4" : (l == 44L ? "CDF_FLOAT" : (l == 22L ? "CDF_REAL8" : (l == 45L ? "CDF_DOUBLE" : (l == 31L ? "CDF_EPOCH" : (l == 32L ? "CDF_EPOCH16" : "UNKNOWN"))))))))))))));
        return string;
    }

    public static long getDataTypeValue(String string) {
        long l = string.equals("CDF_BYTE") ? 41L : (string.equals("CDF_CHAR") ? 51L : (string.equals("CDF_UCHAR") ? 52L : (string.equals("CDF_INT1") ? 1L : (string.equals("CDF_UINT1") ? 11L : (string.equals("CDF_INT2") ? (long)2 : (string.equals("CDF_UINT2") ? 12L : (string.equals("CDF_INT4") ? (long)4 : (string.equals("CDF_UINT4") ? 14L : (string.equals("CDF_REAL4") ? 21L : (string.equals("CDF_FLOAT") ? 44L : (string.equals("CDF_REAL8") ? 22L : (string.equals("CDF_DOUBLE") ? 45L : (string.equals("CDF_EPOCH") ? 31L : (long)-1)))))))))))));
        return l;
    }

    public static String getStringCompressionType(long l) {
        String[] stringArray = new String[]{"NONE", "RLE", "Huffman", "Adaptive Huffman", " ", "GZIP"};
        if (l > (long)5 || l == (long)4) {
            return "UNKNOWN";
        }
        return stringArray[(int)l];
    }

    public static long getLongCompressionType(String string) {
        String[] stringArray = new String[]{"NONE", "RLE", "Huffman", "Adaptive Huffman", " ", "GZIP"};
        int n = 0;
        while (n < stringArray.length) {
            if (string.equalsIgnoreCase(stringArray[n])) {
                return n;
            }
            ++n;
        }
        if (string.equalsIgnoreCase("NONE")) {
            return 0L;
        }
        return -1;
    }

    public static String getStringCompressionType(Variable variable) {
        return CDFUtils.getStringCompressionType(variable.getCompressionType());
    }

    public static String getStringCompressionType(CDF cDF) {
        return CDFUtils.getStringCompressionType(cDF.getCompressionType());
    }

    public static String getStringEncoding(long l) {
        String[] stringArray = new String[]{" ", "NETWORK", "SUN", "VAX", "DECSTATION", "SGi", "IBMPC", "IBMRS", "HOST", "MAC", "HP", " ", "NeXT", "ALPHAOSF1", "ALPHAVMSd", "ALPHAVMSg", "ALPHAVMSi"};
        if (l == 0L || l == 11L || l > 16L) {
            return "UNKNOWN";
        }
        return stringArray[(int)l];
    }

    public static long getLongEncoding(String string) {
        String[] stringArray = new String[]{" ", "NETWORK", "SUN", "VAX", "DECSTATION", "SGi", "IBMPC", "IBMRS", "HOST", "MAC", "HP", " ", "NeXT", "ALPHAOSF1", "ALPHAVMSd", "ALPHAVMSg", "ALPHAVMSi"};
        if ("".equals(string) || string.equals(" ")) {
            return -1;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (n != 0 && n != 11 && string.equalsIgnoreCase(stringArray[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static String getStringEncoding(CDF cDF) {
        return CDFUtils.getStringEncoding(cDF.getEncoding());
    }

    public static String getStringDecoding(long l) throws CDFException {
        return CDFUtils.getStringEncoding(l);
    }

    public static String getStringDecoding(CDF cDF) throws CDFException {
        return CDFUtils.getStringEncoding(cDF.confirmDecoding());
    }

    public static String getStringMajority(long l) {
        String string = null;
        string = l == 1L ? "ROW" : (l == (long)2 ? "COLUMN" : "UNKNOWN");
        return string;
    }

    public static long getLongMajority(String string) {
        long l = string.equalsIgnoreCase("ROW") ? 1L : (string.equalsIgnoreCase("COLUMN") ? (long)2 : (long)-1);
        return l;
    }

    public static String getStringMajority(CDF cDF) {
        return CDFUtils.getStringMajority(cDF.getMajority());
    }

    public static String getStringFormat(long l) {
        String string = null;
        string = l == 1L ? "SINGLE" : (l == (long)2 ? "MULTI" : "UNKNOWN");
        return string;
    }

    public static long getLongFormat(String string) {
        long l = string.equalsIgnoreCase("SINGLE") ? 1L : (string.equalsIgnoreCase("MULTI") ? (long)2 : (long)-1);
        return l;
    }

    public static String getStringFormat(CDF cDF) {
        return CDFUtils.getStringFormat(cDF.getFormat());
    }

    public static String getStringSparseRecord(long l) {
        String string = null;
        string = l == 0L ? "None" : (l == 1L ? "PAD" : (l == (long)2 ? "PREV" : "UNKNOWN"));
        return string;
    }

    public static long getLongSparseRecord(String string) {
        long l = string.equalsIgnoreCase("None") ? 0L : (string.equalsIgnoreCase("sRecords.PAD") || string.equalsIgnoreCase("PAD") ? 1L : (string.equalsIgnoreCase("sRecords.PREV") || string.equalsIgnoreCase("PREV") ? (long)2 : (long)-1));
        return l;
    }

    public static String getStringSparseRecord(Variable variable) {
        return CDFUtils.getStringSparseRecord(variable.getSparseRecords());
    }

    public static boolean cdfFileExists(String string) {
        if (string == null) {
            return false;
        }
        String string2 = null;
        String string3 = null;
        if (string.indexOf(".cdf") == -1 && string.indexOf(".CDF") == -1) {
            string2 = string + ".cdf";
            string3 = string + ".CDF";
        } else {
            string2 = string;
        }
        File file = new File(string2);
        if (file.exists()) {
            return true;
        }
        return string3 != null && (file = new File(string3)).exists();
    }
}

