/******************************************************************************
*
*  NSSDC/CDF						CDFlist.  Part 3 of 4.
*
*  Version 1.2, 18-Jun-96, Hughes STX.
*
*  Modification history:
*
*   V1.0  20-Dec-93, H Leckner	Original version.
*   V1.0a  9-Feb-94, H Leckner	Fix for creating CDFs while in ZMODE.
*   V1.1   4-Apr-94, H Leckner  Use CDF Hyper calls in CDF output.
*   V1.1a 12-Dec-94, J Love	CDF V2.5.
*   V1.2  18-Jun-96, J Love	CDF V2.6.
*
******************************************************************************/

#include "cdflist.h"

void list_data_horizontal(screen, CDF, select, num_select, data_values, fptr)
struct	GLOBAL_struct	*screen;
struct	CDF_struct	*CDF;
struct  VAR_struct		*select;
long int		num_select;
union mixed		*data_values;
FILE			*fptr;
{
struct	CDF_struct	new_CDF;
int			line_cnt;
int			num_lines_page;
int			cont;
int			done;
long int		cnt;
int			col,end_col;
int			var_num;
int			valid;
int			first_valid;
int			data_found_in_record;
long int		record_num, out_record_num;
int			copy_complete;
long int		rcode;
int			exit_code;
struct VAR_struct		*VN;
int			data_found = FALSE;
int			change_output = FALSE;
long			first_record,last_record;
cont = CONTINUEkey_LIST;
line_cnt = 0;
rcode = CDFLIST_list_startup(screen, CDF, select, num_select,
	&num_lines_page, data_values, fptr, &new_CDF, &first_record,
			     &last_record);
if(rcode != CDF_OK)
   {
   if(rcode != NODATA) {
      exit_code = print_error(screen, rcode);
      if(rcode == BAD_MALLOC)ExitBAD;
    }
   else
     exit_code = NOCONTINUE;

   if(exit_code == NOCONTINUE)
      {
      rcode = CDFLIST_list_endup(screen, CDF, select, num_select,
	data_found, cont, change_output, line_cnt, data_values, &new_CDF);
      return;
      }
   }
out_record_num = -1;
first_valid = TRUE;
col = 1;
/* standby for liftoff */
/*max_record_num = C.zmode_group->max_record_num;*/
for(record_num=first_record; record_num <= last_record && 
			     cont==CONTINUEkey_LIST;++record_num)
    {
    init_indices(select);
    data_found_in_record = FALSE;
    copy_complete = FALSE;
    clear_scalars(select);
    if(scalar_check(CDF, select, record_num, data_values))
       {
       if(C.output == CDFOUT)init_array(select);
/*
The record passed proceed and get the rest of data for this record
*/
       data_found = TRUE;
       var_num = 0;
       VN=select;
       cnt=0;
       if((first_valid) && (C.output == TERMIN || C.output == TERMFILE))
	   paste_virtual_display(S.SCREEN_vid, SCREEN_ROW_PASTE, SCREEN_COL_PASTE);
/*
Print a HEADER to the listing
*/
       if(first_valid && C.output != CDFOUT)
	  {
	  if(C.output != FILEOUT)erase_display(S.SCREEN_vid, 0, 0, SCREEN_ROWS-1,
				  SCREEN_COLUMNS-1);
	  CDFLIST_print_header(S.SCREEN_vid, &line_cnt, select, num_select,
					C.output, fptr, first_valid);
	  }
       first_valid = FALSE;
       done = FALSE;
       while (!done && cont == CONTINUEkey_LIST)
	      {
/*
Get the data for the variables
*/
	      if(VN->scalar)
		 {
		 data_found = TRUE;
		 get_data(CDF, VN, record_num, VN->x, &data_values[var_num]);
		 if(C.output == CDFOUT)
		    {
		    if(VN->var_num != RECORD_VAR_NUM) {
			    if(!data_found_in_record)out_record_num++;
			    data_found_in_record = TRUE;
/*
Put the data into a new CDF
*/
			    rcode = put_CDF(&new_CDF, VN->cnt, out_record_num, 
					VN->x, VN, &data_values[var_num]);
		   	    if(rcode < CDF_WARN) {
	              	       exit_code = print_error(screen, rcode);
   		      	       if(exit_code == NOCONTINUE) {
		         	  rcode = CDFLIST_list_endup(screen, CDF, 
				   select, num_select, data_found, cont, 
				   change_output, line_cnt, data_values, 
				   &new_CDF);
		                   return;
		      		   }
		   	       }

		  	    }
		    }
		 else
		    {
/*
Print the data to the Terminal and/or a file
*/
		    if(VN->display == DISPLAY)
		       {
		       CDFLIST_print_string(VN, NORMAL_PRINT, &data_values[var_num]);
		       end_col = col + strlen(print_string);
		       if((end_col > 80) && (C.output == TERMIN || C.output == TERMFILE))
			   {
			   line_cnt++;
			   col = 1;
			   if(line_cnt == num_lines_page-1)cont = end_of_page(screen, CDF,
			      select, num_select, &line_cnt, fptr, &change_output);
			   }
		      if(cont == CONTINUEkey_LIST)CDFLIST_print_data(S.SCREEN_vid, line_cnt, &col,
					    C.output, fptr);
		      }
		    }/* not CDF output */
		    next_var(&VN, select, &var_num, &cnt, &line_cnt, &col);
		    if((VN == select) && (C.output == FILEOUT || C.output == TERMFILE)) 
			write_eol(fptr);
		    if((line_cnt == num_lines_page-1 && cont == CONTINUEkey_LIST) &&
		       (C.output == TERMIN || C.output == TERMFILE))
			cont = end_of_page(screen, CDF, select, num_select, &line_cnt,
					fptr, &change_output);

		 } /* scalar */
	      else
		 {
/*
Variable is multi-dimensional
*/
		 copy_complete = FALSE;
		 while(!copy_complete && cont == CONTINUEkey_LIST)
		      {
		      get_data(CDF, VN, record_num, VN->x,
		      &data_values[var_num]);
		      valid = filter1(VN, &data_values[var_num]);
		      if(valid)data_found = TRUE; 
		      if(C.output == CDFOUT)
			 {
		         if(valid)
			    {
			    if(!data_found_in_record)out_record_num++;
			    data_found_in_record = TRUE;
			    rcode = put_CDF(&new_CDF, VN->cnt, out_record_num,
				 VN->x, VN, &data_values[var_num]);
		   	    if(rcode < CDF_WARN) {
	              	       exit_code = print_error(screen, rcode);
   		      	       if(exit_code == NOCONTINUE) {
		         	  rcode = CDFLIST_list_endup(screen, CDF, 
				   select, num_select, data_found, cont, 
				   change_output, line_cnt, data_values, 
				   &new_CDF);
		                   return;
		      		   }
		   	       }
			    }
			 }
		      else
			 {
			 if(VN->display == DISPLAY)
			    {
			    if(valid)
			       CDFLIST_print_string(VN, NORMAL_PRINT, &data_values[var_num]);
			    else
			       CDFLIST_print_string(VN, OUT_OF_RANGE, &data_values[var_num]);
		            end_col = col + strlen(print_string);
			    if((end_col > 80) && (C.output == TERMIN || C.output == TERMFILE))
			       {
			       line_cnt++;
			       col = 1;
			       if(line_cnt == num_lines_page-1)cont = end_of_page(screen, CDF,
				  select, num_select, &line_cnt, fptr, &change_output);
		               }
			   if(cont == CONTINUEkey_LIST)CDFLIST_print_data(S.SCREEN_vid, line_cnt, &col,
					    C.output, fptr);
			   }
		       }/* not CDF output */
/*
Generate next set indices
*/
                       OffsetIndices(VN->cnt++, 
			VN->discrete ? VN->num_values : VN->total_values ,
		        C.majority == ROW_MAJOR ? (Logical)TRUE : (Logical)FALSE, 
		        VN->var_num_dims, VN->PhyDimValues, VN->x, &copy_complete);
		       if(copy_complete && cont == CONTINUEkey_LIST)
			  {
			  if(C.output == CDFOUT && VN->multidim && SO.hyper_out)
			     rcode = write_multidim_to_CDF(&new_CDF, VN, 
								out_record_num);
		   	     if(rcode < CDF_WARN) {
	              	        exit_code = print_error(screen, rcode);
   		      	        if(exit_code == NOCONTINUE) {
		          	   rcode = CDFLIST_list_endup(screen, CDF, 
				     select, num_select, data_found, cont, 
				     change_output, line_cnt, data_values, 
				     &new_CDF);
		                   return;
		      		   }
		   	       }
			  next_var(&VN, select, &var_num, &cnt, &line_cnt, &col);
		          if((VN == select) && (C.output == FILEOUT || C.output == TERMFILE)) 
			      write_eol(fptr);
			  if((line_cnt == num_lines_page-1) &&
			     (C.output == TERMIN || C.output == TERMFILE))
			     cont = end_of_page(screen, CDF, select, num_select, &line_cnt,
					fptr, &change_output);
			  if(VN != select)copy_complete = FALSE;
			  }
		      }/*end loop copy_complete for a variable */
		    }/* variable is multi-dimensional*/
		    if(var_num == 0)done = TRUE;
	     } /* end-loop */
/*
Look for user trying to break the search - aw3
*/
#if defined(dos)
	    if(dos_cont() == NOCONTINUE)
	       {
	       copy_complete = TRUE;
	       cont = NOCONTINUE;
	       }
#endif

	}/*record_passes*/
    }/*record_num*/

rcode = CDFLIST_list_endup(screen, CDF, select, num_select,
	data_found, cont, change_output, line_cnt, data_values, &new_CDF);
if(rcode != CDF_OK)
   {
   exit_code = print_error(screen, rcode);
   if(exit_code == NOCONTINUE)ExitBAD;
   }
}


void list_data_vertical(screen, CDF, select, num_select, data_values, fptr)
struct	GLOBAL_struct	*screen;
struct	CDF_struct	*CDF;
struct VAR_struct		*select;
long int		num_select;
union mixed		*data_values;
FILE			*fptr;
{
struct	CDF_struct	new_CDF;
int			line_cnt;
int			num_lines_page;
int			cont;
long int		cnt;
int			var_num;
int			valid;
int			first_valid;
long int		record_num;
int			copy_complete;
long int		rcode;
int			exit_code;
long int		max_values;
int			col,end_col;
struct VAR_struct		*VN;
int			data_found = FALSE;
int			change_output = FALSE;
long			first_record,last_record;
cont = CONTINUEkey_LIST;
line_cnt = 0;
rcode = CDFLIST_list_startup(screen, CDF, select, num_select,
	&num_lines_page, data_values, fptr, &new_CDF, &first_record,
			     &last_record);
if(rcode != CDF_OK)
   {
   if(rcode != NODATA) {
     exit_code = print_error(screen, rcode);
     if(rcode == BAD_MALLOC)ExitBAD;
   }
   else
     exit_code = NOCONTINUE;

   if(exit_code == NOCONTINUE)
      {
      rcode = CDFLIST_list_endup(screen, CDF, select, num_select,
	data_found, cont, change_output, line_cnt, data_values, &new_CDF);
      return;
      }
   }

max_values = get_max_vals(select, num_select);
first_valid = TRUE;
/* standby for liftoff */
/*max_record_num = C.zmode_group->max_record_num;*/
for(record_num=first_record; record_num <= last_record && cont==CONTINUEkey_LIST;
    ++record_num)
    {
    init_indices(select);
    copy_complete = FALSE;
/*
Get the data for the scalars to see if the record passes
*/
    cnt = 0;
    col = 1;
    clear_scalars(select);
    if(scalar_check(CDF, select, record_num, data_values))
       {
       data_found = TRUE;
       var_num = 0;
       VN=select;
       cnt=1;
       if((first_valid) && (C.output == TERMIN || C.output == TERMFILE))
           paste_virtual_display(S.SCREEN_vid, SCREEN_ROW_PASTE, SCREEN_COL_PASTE);
/*
Print a HEADER to the listing
*/
       if(first_valid && C.output != CDFOUT)
	  {
          if(C.output != FILEOUT)erase_display(S.SCREEN_vid, 0, 0, SCREEN_ROWS-1,
				  SCREEN_COLUMNS-1);
	  CDFLIST_print_header(S.SCREEN_vid, &line_cnt, select, num_select,
					C.output, fptr, first_valid);
	  }
       while (cnt <=  max_values && cont == CONTINUEkey_LIST)
	      {
	      if(cnt > VN->max_values)
		 {
		 if(VN->display == DISPLAY)
		   {
		   CDFLIST_print_string(VN, FILL, &data_values[var_num]);
		   end_col = col + strlen(print_string);
		   if((end_col > 80) && (C.output == TERMIN || C.output == TERMFILE))
		     {
		     line_cnt++;
		     col = 1;
		     if(line_cnt == num_lines_page-1)cont = end_of_page(screen, CDF,
			      select, num_select, &line_cnt, fptr, &change_output);
		     }
		   if(cont == CONTINUEkey_LIST)CDFLIST_print_data(S.SCREEN_vid, line_cnt, &col,
					    C.output, fptr);
		   }
		 next_var(&VN, select, &var_num, &cnt, &line_cnt, &col);
		 if((VN == select) && (C.output == FILEOUT || C.output == TERMFILE)) 
		     write_eol(fptr);
		 if((line_cnt == num_lines_page-1 && cont == CONTINUEkey_LIST) &&
		    (C.output == TERMIN || C.output == TERMFILE))
		     cont = end_of_page(screen, CDF, select, num_select, &line_cnt,
					fptr, &change_output);

		 }
	      else
		 {
/*
Get the data for the variables
*/
		 get_data(CDF, VN, record_num, VN->x, &data_values[var_num]);
		 if(VN->scalar)
		    {
		    if(VN->display == DISPLAY)
		       {
		       CDFLIST_print_string(VN, NORMAL_PRINT, &data_values[var_num]);
		       end_col = col + strlen(print_string);
		       if((end_col > 80) && (C.output == TERMIN || C.output == TERMFILE))
		        {
			line_cnt++;
		        col = 1;
			if(line_cnt == num_lines_page-1)cont = end_of_page(screen, CDF,
			      select, num_select, &line_cnt, fptr, &change_output);
		        }
		       if(cont == CONTINUEkey_LIST)CDFLIST_print_data(S.SCREEN_vid, line_cnt, &col,
					    C.output, fptr);
		       first_valid = FALSE;
		       }
		    next_var(&VN, select, &var_num, &cnt, &line_cnt, &col);
		    if((VN == select) && (C.output == FILEOUT || C.output == TERMFILE)) 
		         write_eol(fptr);
		    if((line_cnt == num_lines_page-1 && cont == CONTINUEkey_LIST) &&
		       (C.output == TERMIN || C.output == TERMFILE))
			cont = end_of_page(screen, CDF, select, num_select, &line_cnt,
					fptr, &change_output);
		    }
		 else
		    {
		    if(VN->display == DISPLAY)
		      {
		      valid = filter1(VN, &data_values[var_num]);
		      if(valid)
		         CDFLIST_print_string(VN, NORMAL_PRINT, &data_values[var_num]);
		      else
		         CDFLIST_print_string(VN, OUT_OF_RANGE, &data_values[var_num]);
		      end_col = col + strlen(print_string);
		      if((end_col > 80) && (C.output == TERMIN || C.output == TERMFILE))
		        {
			line_cnt++;
			col = 1;
			if(line_cnt == num_lines_page-1)cont = end_of_page(screen, CDF,
			      select, num_select, &line_cnt, fptr, &change_output);
			}
		      if(cont == CONTINUEkey_LIST)CDFLIST_print_data(S.SCREEN_vid, line_cnt, &col,
					    C.output, fptr);
		      first_valid = FALSE;
		      }
/*
Generate next set indices
*/
		    OffsetIndices(VN->cnt++,
		      VN->discrete ? VN->num_values : VN->total_values ,
		      C.majority == ROW_MAJOR ? (Logical)TRUE : (Logical)FALSE, 
		      VN->var_num_dims, VN->PhyDimValues, VN->x, &copy_complete);
		    copy_complete = FALSE;
		    next_var(&VN, select, &var_num, &cnt, &line_cnt, &col);
		    if((VN == select) && (C.output == FILEOUT || C.output == TERMFILE))
			 write_eol(fptr);
		    if((line_cnt == num_lines_page-1 && cont == CONTINUEkey_LIST) &&
		       (C.output == TERMIN || C.output == TERMFILE))
			cont = end_of_page(screen, CDF, select, num_select, &line_cnt,
					fptr, &change_output);
		    }
		 }
	     } /* end-loop */
/*
Look for user trying to break the search - aw3
*/
#if defined(dos)
	    if(dos_cont() == NOCONTINUE)
	       {
	       copy_complete = TRUE;
	       cont = NOCONTINUE;
	       }
#endif

	}/*record_passes*/
    }/*record_num*/

rcode = CDFLIST_list_endup(screen, CDF, select, num_select,
	data_found, cont, change_output, line_cnt, data_values, &new_CDF);
if(rcode != CDF_OK)
   {
   exit_code = print_error(screen, rcode);
   if(exit_code == NOCONTINUE)ExitBAD;
   }
}
void next_var(VN, select, var_num, cnt, line_cnt, col)
struct VAR_struct	**VN;
struct VAR_struct	*select;
int		*var_num;
long int	*cnt;
int		*line_cnt;
int	        *col;
{
*VN=(*VN)->next_var;
(*var_num)++;
if(*VN == NULL)
   {
   *var_num = 0;
   *VN=select;
   (*cnt)++;
   (*line_cnt)++;
   *col = 1;
   }
}
void get_init_data(CDF, select)
struct CDF_struct  	*CDF;
struct VAR_struct		*select;
{
struct VAR_struct		*VN;
long record_num = 0;
long recInterval = 1;
long recCount = 1;
long indices[CDF_MAX_DIMS];
long intervals[CDF_MAX_DIMS];
long dim_sizes[CDF_MAX_DIMS];
int i;

for(i=0; i<CDF_MAX_DIMS; i++)
    {
    indices[i] = 0;
    intervals[i] = dim_sizes[i] = 1;
    }
VN = select;
while(VN != NULL)
  {
  if(VN->discrete)
      {
      indices[VN->dim_num-1] =  C.first_indice[VN->dim_num-1];
      dim_sizes[VN->dim_num-1] = VN->num_values;
      VN->rcode = CDFlib (SELECT_, CDF_, C.CDF_id,
		 BOO(VN->Z, zVAR_, rVAR_),  VN->var_num,
		 BOO(VN->Z, zVAR_RECNUMBER_,rVARs_RECNUMBER_),record_num,
		 BOO(VN->Z, zVAR_RECCOUNT_, rVARs_RECCOUNT_), recCount,
		 BOO(VN->Z, zVAR_RECINTERVAL_, rVARs_RECINTERVAL_),  recInterval,
		 BOO(VN->Z, zVAR_DIMINDICES_, rVARs_DIMINDICES_), indices,
		 BOO(VN->Z, zVAR_DIMCOUNTS_, rVARs_DIMCOUNTS_), dim_sizes,
		 BOO(VN->Z, zVAR_DIMINTERVALS_, rVARs_DIMINTERVALS_), intervals,
	GET_,    BOO(VN->Z, zVAR_HYPERDATA_, rVAR_HYPERDATA_), VN->data_array,
		    NULL_);
/*
Set Back
*/
      indices[VN->dim_num-1] = 0;
      dim_sizes[VN->dim_num-1] = 1; 
      }
  VN=VN->next_var;
  }
}
void get_data(CDF, VN, record_num, indices, data_values)
struct CDF_struct  	*CDF;
struct VAR_struct		*VN;
long int		record_num;
long int		*indices;
union  mixed		*data_values;
{
if(SO.hyper && !VN->scalar/* && VN->max_values > 1*/)
   {
   if(VN->discrete)
      {
      VN->offset = (int) (indices[VN->dim_num-1]*VN->bytes_value);
      memmove(data_values, (Byte *) VN->data_array+VN->offset, VN->bytes_value);
      }
   else
      {
      if(new_record(indices, VN->var_num_dims))
	 {
	 long recInterval = 1;
	 long recCount = 1;
	 static long intervals[] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 };
	 VN->rcode = CDFlib (SELECT_, CDF_, C.CDF_id,
		 BOO(VN->Z, zVAR_, rVAR_),  VN->var_num,
		 BOO(VN->Z, zVAR_RECNUMBER_,rVARs_RECNUMBER_),record_num,
		 BOO(VN->Z, zVAR_RECCOUNT_, rVARs_RECCOUNT_), recCount,
		 BOO(VN->Z, zVAR_RECINTERVAL_, rVARs_RECINTERVAL_),  recInterval,
		 BOO(VN->Z, zVAR_DIMINDICES_, rVARs_DIMINDICES_), C.first_indice,
		 BOO(VN->Z, zVAR_DIMCOUNTS_, rVARs_DIMCOUNTS_), VN->act_dim_sizes,
		 BOO(VN->Z, zVAR_DIMINTERVALS_, rVARs_DIMINTERVALS_), intervals,
	       GET_,   
                 BOO(VN->Z, zVAR_HYPERDATA_, rVAR_HYPERDATA_), VN->data_array,
		    NULL_);
	 VN->offset = 0;
	 }
      memmove(data_values, (Byte *) VN->data_array+VN->offset, VN->bytes_value);
      VN->offset +=VN->bytes_value;
      }
    }
else
    {
    if(!SO.hyper || !VN->scalar_entered)
       {
       if(VN->data_type == CDF_CHAR || VN->data_type == CDF_UCHAR)
	  {
	  VN->rcode = CDFlib (SELECT_, CDF_, C.CDF_id,
			  BOO(VN->Z,zVAR_,rVAR_), VN->var_num,
			  BOO(VN->Z,zVAR_RECNUMBER_,rVARs_RECNUMBER_),
				record_num,
			  BOO(VN->Z,zVAR_DIMINDICES_,rVARs_DIMINDICES_),
				indices,
		 GET_, 	  BOO(VN->Z,zVAR_DATA_,rVAR_DATA_),
				  data_values->string,
		 NULL_);
	  data_values->string[(int) VN->num_bytes] = '\0';
	  }
       else
	  {
	  if(VN->var_num == RECORD_VAR_NUM)
	     {
	     data_values->i4 = record_num+1;
	     VN->rcode = CDF_OK;
	     }
	  else
  	     VN->rcode = CDFlib (SELECT_, CDF_, C.CDF_id,
			  BOO(VN->Z,zVAR_,rVAR_), VN->var_num,
			  BOO(VN->Z,zVAR_RECNUMBER_,rVARs_RECNUMBER_),
				record_num,
			  BOO(VN->Z,zVAR_DIMINDICES_,rVARs_DIMINDICES_),
				indices,
		 GET_, 	  BOO(VN->Z,zVAR_DATA_,rVAR_DATA_),
				  data_values,
		 NULL_);
 	  }
       }
    }
}
double convert_value(data_type, data_values)
long		data_type;
union mixed	*data_values;
{
switch(data_type)
       {
       case CDF_REAL4:
       case CDF_FLOAT:
	    return((double) data_values->r4);
       case CDF_REAL8:
       case CDF_DOUBLE:
       case CDF_EPOCH:
	    return(data_values->r8);
       case CDF_INT4:
	    return((double) data_values->i4);
       case CDF_UINT4:
	    return((double) data_values->ui4);
       case CDF_INT2:
	    return((double) data_values->i2);
       case CDF_UINT2:
	    return((double) data_values->ui2);
       case CDF_BYTE:
       case CDF_INT1:
	    return((double) data_values->byte);
       case CDF_UINT1:
	    return((double) data_values->ubyte);
       }
return((double) 0.);
}
int filter1(VN, data_values)
struct VAR_struct		*VN;
union mixed		*data_values;
{
int			valid;
double			value;
valid = TRUE;
if(SO.filters == NOFILTER && VN->var_num == RECORD_VAR_NUM)return(valid);
value = convert_value(VN->data_type, data_values);
/*
Now filter depending on what was entered by the USER
*/
switch (VN->filter)
       {
       case MIN_MAX:
	    {
	    if(value < VN->filter_min ||
	       value > VN->filter_max)valid = FALSE;
	    break;
	    }
       case MIN_ONLY:
	    {
	    if(value < VN->filter_min) valid = FALSE;
	    break;
	    }
       case MAX_ONLY:
	    {
	    if(value > VN->filter_max) valid = FALSE;
	    break;
	    }
       }
  /*
  Are we checking for the fill value
  */
       if(SO.fill_values == CHECK_FILL)
	  {
 /*
 Yes, but make sure the value was out of range to begin with
 */
	  if(valid == FALSE)
	     {
 /*
 Was there a entry for value and was the current value a fill value
 */
	     if((VN->fillval) &&
		(value >= VN->fill_value_min &&
		 value <= VN->fill_value_max))
/*
The value was a fill value, keep this value is still valid
*/
		valid = TRUE;
	     }
	  }
return(valid);
}
void load_fill(flag, len)
int			flag;
int			len;
{
char			print_char;
int			i;
if(flag == OUT_OF_RANGE)
   print_char = '-';
else
   print_char = ' ';
for(i=0; i<len; i++)
    print_string[i] = print_char;
print_string[len] = '\0';
}
void init_indices(select)
struct	VAR_struct	*select;
{
struct 	VAR_struct	*VN;
int	dim_num;
VN=select;
while(VN != NULL)
      {
      for(dim_num=0; dim_num<CDF_MAX_DIMS; dim_num++)
	  VN->x[dim_num] = 0;
      VN->cnt = 1;
      VN=VN->next_var;
      }
}
void get_header(select, num_select, squeeze)
struct VAR_struct	*select;
long int	num_select;
int		squeeze;
{
struct 	VAR_struct	*VN;
int		i;
VN = select;

for(i=0; i<num_select; i++)
    {
    if(VN->display == DISPLAY)header(VN, squeeze);
    VN=VN->next_var;
    }
}
void fudge_it(select, num_select)
struct VAR_struct	*select;
long int	num_select;
{
struct 	VAR_struct	*VN;
double		fudge_up;
double		fudge_down;
int		i;
/*
Fudge factor to insure filtering reliability
*/
fudge_down = .999999; fudge_up = 1.000001;
VN = select;
for (i=0; i<num_select; i++)
  {
  if(VN->filter)
     {
     if(VN->data_type != CDF_REAL8 && VN->data_type != CDF_DOUBLE &&
	VN->data_type != CDF_EPOCH)
			/* V1.6 */
	{
	if(VN->min > 0)
	   VN->filter_min = fudge_down*VN->min;
	else
	   VN->filter_min = fudge_up*VN->min;

	if(VN->max > 0)
	   VN->filter_max = fudge_up*VN->max;
	else
	   VN->filter_max = fudge_down*VN->max;
	}
     else
	{
	   VN->filter_min = VN->min;
	   VN->filter_max = VN->max;
	}

     }
     if(VN->fillval)
	{
	if(VN->fill_value > 0)
	   {
	   VN->fill_value_min = fudge_down*VN->fill_value;
	   VN->fill_value_max = fudge_up*VN->fill_value;
	   }
	else
	   {
	   VN->fill_value_min = fudge_up*VN->fill_value;
	   VN->fill_value_max = fudge_down*VN->fill_value;
	   }
	}
    VN=VN->next_var;
  }
}
long get_max_vals(select, num_select)
struct VAR_struct	*select;
long int	num_select;
{
struct 	VAR_struct	*VN;
long int	max_values;
int		i;
VN = select;
max_values = 0;
for(i=0; i<num_select; i++)
    {

    if(VN->display == DISPLAY && VN->max_values > max_values)
       max_values = VN->max_values;
    VN=VN->next_var;
    }
return(max_values);
}
long get_max_bytes(select, num_select)
struct VAR_struct	*select;
long int	num_select;
{
struct 	VAR_struct	*VN;
long int	max_bytes = 0;
int		i;
VN = select;
for(i=0; i < num_select; i++)
    {
    if(VN->data_type == CDF_EPOCH)
	   {
	   if(SO.EPOCH_output_len[SO.EPOCH_format-1] > max_bytes)
	     max_bytes = SO.EPOCH_output_len[SO.EPOCH_format-1];
	   }
   else if(SO.variable_format == FORMAT && VN->format)
	   {
	   if( VN->field_width > max_bytes)
	       max_bytes = VN->field_width;
	   }
   else if(VN->data_type == CDF_CHAR || VN->data_type == CDF_UCHAR)
	   {
	   if( VN->num_bytes+2 > max_bytes)
	       max_bytes = VN->num_bytes+2;
	   }
   else if(max_bytes < 15) max_bytes = 15;
	   VN=VN->next_var;
   }
return(max_bytes);
}
int	new_record(indices, num_dims)
long int	*indices;
long int	num_dims;
{
int		i;
for(i=0; i<num_dims; i++)
    if(indices[i] != 0)return(FALSE);
return(TRUE);
}
