/******************************************************************************
*
*  NSSDC/CDF			CDF C interface for non-macro'ed functions
*				of the Standard Interface.
*
*  Version 2.4a, 8-Mar-97, Hughes STX.
*
*  Modification history:
*
*   V1.0   1-Jun-91, J Love	Original version (for CDF V2.1).  This is a
*				combination of cdf.c, cdfattr.c and cdfvar.c.
*				Most of these functions can be replaced by
*				the macros in 'cdf.h'.
*   V1.1  30-Jul-91, J Love	Use 'CDFlib'.
*   V2.0  10-Feb-92, J Love	IBM PC port.
*   V2.1  21-Aug-92, J Love	CDF V2.3 (shareable/NeXT/zVar).
*   V2.2  18-Oct-93, J Love	CDF V2.4.
*   V2.3   9-Nov-94, J Love	CDF V2.5.
*   V2.4  14-Feb-96, J Love	CDF V2.6 (renamed - previously `cdf_c_if.c').
*   V2.4a  8-Mar-97, J Love	Windows NT for Visual C++ 4 on an IBM PC.
*   V3.0  28-Aug-01, M Liu      Add CDFgetrVarsRecordData, CDFgetzVarsRecordData,
*                               CDFputrVarsRecordData, CDFputzVarsRecordData.
*
******************************************************************************/

#include "cdflib.h"

/******************************************************************************
* CDFattrInquire.
* Can't implement with macro because the attribute's scope determines which
* item(s) to use.
******************************************************************************/

VISIBLE_PREFIX CDFstatus CDFattrInquire (id, attrNum, attrName, attrScope,
					 maxEntry)
CDFid	id;		/* In -- CDF id. */
long	attrNum;	/* In -- Attribute number. */
char	*attrName;	/* Out -- Attribute name. */
long	*attrScope;	/* Out -- Attribute scope. */
long	*maxEntry;	/* Out -- Maximum gEntry/rEntry number used. */
{
  CDFstatus pStatus = CDF_OK;
  if (!sX(CDFlib(SELECT_, CDF_, id,
			  ATTR_, attrNum,
		 GET_, ATTR_SCOPE_, attrScope,
		 NULL_), &pStatus)) return pStatus;
  if (!sX(CDFlib(SELECT_, CDF_, id,
		 GET_, ATTR_NAME_, attrName,
		       BOO(GLOBALscope(*attrScope),ATTR_MAXgENTRY_,
						   ATTR_MAXrENTRY_), maxEntry,
		 NULL_), &pStatus)) return pStatus;
  return pStatus;
}

/******************************************************************************
* CDFattrEntryInquire.
* Can't implement with macro because the attribute's scope determines which
* item(s) to use.
******************************************************************************/

VISIBLE_PREFIX CDFstatus CDFattrEntryInquire (id, attrNum, entryNum, dataType,
					      numElems)
CDFid	id;		/* In -- CDF id. */
long	attrNum;	/* In -- Attribute number. */
long	entryNum;	/* In -- gEntry/rEntry number. */
long	*dataType;	/* Out -- gEntry/rEntry data type. */
long	*numElems;	/* Out -- gEntry/rEntry number of elements. */
{
  long scope;
  CDFstatus pStatus = CDF_OK;
  if (!sX(CDFlib(SELECT_, CDF_, id,
			  ATTR_, attrNum,
		 GET_, ATTR_SCOPE_, &scope,
		 NULL_), &pStatus)) return pStatus;
  if (!sX(CDFlib(SELECT_, CDF_, id,
			  BOO(GLOBALscope(scope),gENTRY_,rENTRY_), entryNum,
		 GET_, BOO(GLOBALscope(scope),gENTRY_DATATYPE_,
					      rENTRY_DATATYPE_), dataType,
		       BOO(GLOBALscope(scope),gENTRY_NUMELEMS_,
					      rENTRY_NUMELEMS_), numElems,
		 NULL_), &pStatus)) return pStatus;
  return pStatus;
}

/******************************************************************************
* CDFattrPut.
* Can't implement with macro because the attribute's scope determines which
* item(s) to use.
******************************************************************************/

VISIBLE_PREFIX CDFstatus CDFattrPut (id, attrNum, entryNum, dataType,
				     numElems, value)
CDFid	id;		/* In -- CDF id. */
long	attrNum;	/* In -- Attribute number. */
long	entryNum;	/* In -- gEntry/rEntry number. */
long	dataType;	/* In -- gEntry/rEntry data type. */
long	numElems;	/* In -- gEntry/rEntry number of elements. */
void	*value;		/* In -- Value. */
{
  long scope;
  CDFstatus pStatus = CDF_OK;
  if (!sX(CDFlib(SELECT_, CDF_, id,
			  ATTR_, attrNum,
		 GET_, ATTR_SCOPE_, &scope,
		 NULL_), &pStatus)) return pStatus;
  if (!sX(CDFlib(SELECT_, CDF_, id,
			  BOO(GLOBALscope(scope),gENTRY_,rENTRY_), entryNum,
		 PUT_, BOO(GLOBALscope(scope),gENTRY_DATA_,rENTRY_DATA_),
						  dataType, numElems, value,
		 NULL_), &pStatus)) return pStatus;
  return pStatus;
}

/******************************************************************************
* CDFattrGet.
* Can't implement with macro because the attribute's scope determines which
* item(s) to use.
******************************************************************************/

VISIBLE_PREFIX CDFstatus CDFattrGet (id, attrNum, entryNum, value)
CDFid	id;		/* In -- CDF id. */
long	attrNum;	/* In -- Attribute number. */
long	entryNum;	/* In -- gEntry/rEntry number. */
void	*value;		/* In -- Value. */
{
  long scope;
  CDFstatus pStatus = CDF_OK;
  if (!sX(CDFlib(SELECT_, CDF_, id,
			  ATTR_, attrNum,
		 GET_, ATTR_SCOPE_, &scope,
		 NULL_), &pStatus)) return pStatus;
  if (!sX(CDFlib(SELECT_, CDF_, id,
			  BOO(GLOBALscope(scope),gENTRY_,rENTRY_), entryNum,
		 GET_, BOO(GLOBALscope(scope),gENTRY_DATA_,
					      rENTRY_DATA_), value,
		 NULL_), &pStatus)) return pStatus;
  return pStatus;
}

/******************************************************************************
* CDFattrNum.
* Can't implement with macro since it is the attribute number which is to be
* returned (unless an error).
******************************************************************************/

VISIBLE_PREFIX long CDFattrNum (id,attrName)
CDFid	id;		/* In -- CDF id. */
char	*attrName;	/* In -- attribute name. */
{
  CDFstatus status;
  long attrNum;
  status = CDFlib (SELECT_, CDF_, id,
		   GET_, ATTR_NUMBER_, attrName, &attrNum,
		   NULL_);
  if (StatusOK(status))
    return attrNum;
  else
    return status;
}

/******************************************************************************
* CDFvarNum.
* Can't implement with macro since it is the variable number which is to be
* returned (unless an error).
******************************************************************************/

VISIBLE_PREFIX long CDFvarNum (id,varName)
CDFid	id;		/* In -- CDF id. */
char	*varName;	/* In -- variable name. */
{
  CDFstatus status;
  long varNum;
  status = CDFlib (SELECT_, CDF_, id,
		   GET_, rVAR_NUMBER_, varName, &varNum,
		   NULL_);
  if (StatusOK(status))
    return varNum;
  else
    return status;
}

/******************************************************************************
* CDFgetrVarsRecordData.
* Acquire a full record data for a given record for a set of the selected 
* rVariables. Retrieved data are filled into the buffers that are pointed to
* by the passed array of pointers.
******************************************************************************/

VISIBLE_PREFIX CDFstatus CDFgetrVarsRecordData (id,numVars,varNames,varRecNum,
                                                buffptr)
CDFid   id;             /* In -- CDF id. */
long    numVars;        /* In -- number of rVariables. */
char    *varNames[];    /* In -- array of rVariable names. */
long    varRecNum;      /* In -- record number to read. */
void    *buffptr[];     /* Out -- array of buffer pointers for holding data. */

{
  CDFstatus pStatus = CDF_OK;
  long dataType, numElems, numDims; 
  long dimSizes[CDF_MAX_DIMS], dimVarys[CDF_MAX_DIMS];
  long dataTypeSize, recNumValues, phyRecSize[CDF_MAX_DIMS];
  long totalSize, offset, varNums[CDF_MAX_DIMS];
  int i, j;
  void *buffer;

  if (numVars <= 0) return pStatus;

  if (!sX(CDFlib(SELECT_, CDF_, id,
                 NULL_), &pStatus)) return pStatus;

  totalSize = 0;
  for (i = 0; i < numVars; i++) {
    if (!sX(CDFlib(GET_, rVAR_NUMBER_, varNames[i], &varNums[i],
                   NULL_), &pStatus)) return pStatus;
    if (!sX(CDFlib(SELECT_, rVAR_, varNums[i],
                   GET_, rVAR_DATATYPE_, &dataType,
                         rVAR_NUMELEMS_, &numElems,
                         rVARs_NUMDIMS_, &numDims,
                         rVARs_DIMSIZES_, dimSizes,
                         rVAR_DIMVARYS_, dimVarys,
                   NULL_), &pStatus)) return pStatus;
    if (!sX(CDFlib(GET_, DATATYPE_SIZE_, dataType, &dataTypeSize,
                   NULL_), &pStatus)) return pStatus;

    if (numDims == 0) {
      numDims = 1;
      dimSizes[0] = 1;
      dimVarys[0] = 0;
    }

    recNumValues = 1;
    for (j = 0; j < numDims; j++) 
      if (dimVarys[j]) recNumValues *= dimSizes[j]; 
    phyRecSize[i] = recNumValues * dataTypeSize * numElems;
    totalSize += phyRecSize[i];
  }

  buffer = cdf_AllocateMemory (totalSize, NULL);
  if (buffer == NULL) return BAD_MALLOC;

  if (!sX(CDFlib(SELECT_, rVARs_RECNUMBER_, varRecNum,
                 GET_, rVARs_RECDATA_, numVars, varNums, 
                       buffer,
                 NULL_), &pStatus)) return pStatus;

  offset = 0;
  for (i = 0; i < numVars; i++) {
    memcpy((char *) buffptr[i], (char *) buffer+offset, phyRecSize[i]);
    offset += phyRecSize[i];
  }
  cdf_FreeMemory (buffer, NULL);
  return CDF_OK;

}

/******************************************************************************
* CDFgetzVarsRecordData.
* Acquire a full record data for a given record for a set of the selected
* zVariables. Retrieved data is filled into the buffers that are ponited
* to by the passed array of pointers.
******************************************************************************/

VISIBLE_PREFIX CDFstatus CDFgetzVarsRecordData (id,numVars,varNames,varRecNum,
                                                buffptr)
CDFid   id;             /* In -- CDF id. */
long    numVars;        /* In -- number of zVariables. */
char    *varNames[];    /* In -- array of zVariable names. */
long    varRecNum;      /* In -- record number to read. */
void    *buffptr[];     /* Out -- array of buffer pointers for holding data. */

{
  CDFstatus pStatus = CDF_OK;
  long dataType, numElems, numDims; 
  long dimSizes[CDF_MAX_DIMS], dimVarys[CDF_MAX_DIMS];
  long dataTypeSize, recNumValues, phyRecSize[CDF_MAX_DIMS];
  long totalSize = 0, offset, varNums[CDF_MAX_DIMS];
  int i, j;
  void *buffer;

  if (numVars <= 0) return pStatus;

  if (!sX(CDFlib(SELECT_, CDF_, id,
                 NULL_), &pStatus)) return pStatus;

  totalSize = 0;
  for (i = 0; i < numVars; i++) {
    if (!sX(CDFlib(GET_, zVAR_NUMBER_, varNames[i], &varNums[i],
		   NULL_), &pStatus)) return pStatus;
    if (!sX(CDFlib(SELECT_, zVAR_, varNums[i],
                   GET_, zVAR_DATATYPE_, &dataType,
                         zVAR_NUMELEMS_, &numElems,
                         zVAR_NUMDIMS_, &numDims,
                         zVAR_DIMSIZES_, dimSizes,
                         zVAR_DIMVARYS_, dimVarys,
                   NULL_), &pStatus)) return pStatus;
    if (!sX(CDFlib(GET_, DATATYPE_SIZE_, dataType, &dataTypeSize,
                   NULL_), &pStatus)) return pStatus;

    if (numDims == 0) {
      numDims = 1;
      dimSizes[0] = 1;
    }

    recNumValues = 1;
    for (j = 0; j < numDims; j++)
      if (dimVarys[j]) recNumValues *= dimSizes[j];
    phyRecSize[i] = recNumValues * dataTypeSize * numElems;
    totalSize += phyRecSize[i];
  }

  buffer = cdf_AllocateMemory (totalSize, NULL);
  if (buffer == NULL) return BAD_MALLOC;

  if (!sX(CDFlib(SELECT_, zVARs_RECNUMBER_, varRecNum,
                 GET_, zVARs_RECDATA_, numVars, varNums, 
                       buffer,
                 NULL_), &pStatus)) return pStatus;
  offset = 0;
  for (i = 0; i < numVars; i++) {
    memcpy((char *) buffptr[i], (char *) buffer+offset, phyRecSize[i]);
    offset += phyRecSize[i];
  }
  cdf_FreeMemory (buffer, NULL);
  return CDF_OK;

}


/******************************************************************************
* CDFputrVarsRecordData.
* Write a full record data for a set of the selected rVariables. 
* Record data are passed from the buffers that are pointed to by the 
* passed array of pointers.
******************************************************************************/

VISIBLE_PREFIX CDFstatus CDFputrVarsRecordData (id,numVars,varNames,varRecNum,
                                                buffptr)
CDFid   id;             /* In -- CDF id. */
long    numVars;        /* In -- number of rVariables. */
char    *varNames[];    /* In -- array of rVariable names. */
long    varRecNum;      /* In -- record number to read. */
void    *buffptr[];     /* In -- array of buffer pointers for holding data. */

{
  CDFstatus pStatus = CDF_OK;
  long dataType, numElems, numDims; 
  long dimSizes[CDF_MAX_DIMS], dimVarys[CDF_MAX_DIMS];
  long dataTypeSize, recNumValues, phyRecSize[CDF_MAX_DIMS];
  long totalSize, offset, varNums[CDF_MAX_DIMS];
  int i, j;
  void *buffer;

  if (numVars <= 0) return pStatus;

  if (!sX(CDFlib(SELECT_, CDF_, id,
                 NULL_), &pStatus)) return pStatus;

  totalSize = 0;
  for (i = 0; i < numVars; i++) {
    if (!sX(CDFlib(GET_, rVAR_NUMBER_, varNames[i], &varNums[i],
                   NULL_), &pStatus)) return pStatus;
    if (!sX(CDFlib(SELECT_, rVAR_, varNums[i],
                   GET_, rVAR_DATATYPE_, &dataType,
                         rVAR_NUMELEMS_, &numElems,
                         rVARs_NUMDIMS_, &numDims,
                         rVARs_DIMSIZES_, dimSizes,
                         rVAR_DIMVARYS_, dimVarys,
                   NULL_), &pStatus)) return pStatus;
    if (!sX(CDFlib(GET_, DATATYPE_SIZE_, dataType, &dataTypeSize,
                   NULL_), &pStatus)) return pStatus;

    if (numDims == 0) {
      numDims = 1;
      dimSizes[0] = 1;
    }

    recNumValues = 1;
    for (j = 0; j < numDims; j++) 
      if (dimVarys[j]) recNumValues *= dimSizes[j];
    phyRecSize[i] = recNumValues * dataTypeSize * numElems;
    totalSize += phyRecSize[i];
  }

  buffer = cdf_AllocateMemory (totalSize, NULL);
  if (buffer == NULL) return BAD_MALLOC;

  offset = 0;
  for (i = 0; i < numVars; i++) {
    memcpy((char *) buffer+offset, (char *) buffptr[i], phyRecSize[i]);
    offset += phyRecSize[i];
  }

  if (!sX(CDFlib(SELECT_, rVARs_RECNUMBER_, varRecNum,
                 PUT_, rVARs_RECDATA_, numVars, varNums, 
                       buffer,
                 NULL_), &pStatus)) return pStatus;
  cdf_FreeMemory (buffer, NULL);
  return CDF_OK;

}

/******************************************************************************
* CDFputzVarsRecordData.
* Write a full record data for a set of the selected zVariables. 
* Record data are passed from the buffers that are pointed to by the
* passed array of pointers.
******************************************************************************/

VISIBLE_PREFIX CDFstatus CDFputzVarsRecordData (id,numVars,varNames,varRecNum,
                                                buffptr)
CDFid   id;             /* In -- CDF id. */
long    numVars;        /* In -- number of zVariables. */
char    *varNames[];    /* In -- array of zVariable names. */
long    varRecNum;      /* In -- record number to read. */
void    *buffptr[];     /* In -- array of buffer pointers for holding data. */

{
  CDFstatus pStatus = CDF_OK;
  long dataType, numElems, numDims; 
  long dimSizes[CDF_MAX_DIMS], dimVarys[CDF_MAX_DIMS];
  long dataTypeSize, recNumValues, phyRecSize[CDF_MAX_DIMS];
  long totalSize = 0, offset, varNums[CDF_MAX_DIMS];
  int i, j;
  void *buffer;

  if (numVars <= 0) return pStatus;

  if (!sX(CDFlib(SELECT_, CDF_, id,
                 NULL_), &pStatus)) return pStatus;
  totalSize = 0;
  for (i = 0; i < numVars; i++) {
    if (!sX(CDFlib(GET_, zVAR_NUMBER_, varNames[i], &varNums[i],
                   NULL_), &pStatus)) return pStatus;
    if (!sX(CDFlib(SELECT_, zVAR_, varNums[i],
                   GET_, zVAR_DATATYPE_, &dataType,
                         zVAR_NUMELEMS_, &numElems,
                         zVAR_NUMDIMS_, &numDims,
                         zVAR_DIMSIZES_, dimSizes,
                         zVAR_DIMVARYS_, dimVarys,
                   NULL_), &pStatus)) return pStatus;
    if (!sX(CDFlib(GET_, DATATYPE_SIZE_, dataType, &dataTypeSize,
                   NULL_), &pStatus)) return pStatus;

    if (numDims == 0) {
      numDims = 1;
      dimSizes[0] = 1;
    }
    recNumValues = 1;
    for (j = 0; j < numDims; j++)
      if (dimVarys[j]) recNumValues *= dimSizes[j];
    phyRecSize[i] = recNumValues * dataTypeSize * numElems;
    totalSize += phyRecSize[i];
  }

  buffer = cdf_AllocateMemory (totalSize, NULL);
  if (buffer == NULL) return BAD_MALLOC;

  offset = 0;
  for (i = 0; i < numVars; i++) {
    memcpy((char *) buffer+offset, (char *) buffptr[i], phyRecSize[i]);
    offset += phyRecSize[i];
  }

  if (!sX(CDFlib(SELECT_, zVARs_RECNUMBER_, varRecNum,
                 PUT_, zVARs_RECDATA_, numVars, varNums, 
                       buffer,
                 NULL_), &pStatus)) return pStatus;
  cdf_FreeMemory (buffer, NULL);
  return CDF_OK;

}


