;------------------------------------------------------------------------------
;
;  NSSDC/CDF					IDL/CDF Interface, CDFattrGet.
;
;  Version 1.4, 21-Aug-96, Hughes STX.
;
;  Modification history:
;
;   V1.0  21-Sep-92, H Leckner	Original version.
;   V1.1  10-Dec-92, H Leckner	Removed print/help debug statements.
;   V1.2  13-May-93, J Love	CDF V2.4 (`idl_cdf.pro' split into separate
;                               files as required for online help in IDL).
;   V1.3   1-Nov-94, J Love	CDF V2.5.
;   V1.3a 26-Jun-95, J Love	IDL 4.0.
;   V1.4  21-Aug-96, J Love	CDF V2.6.
;
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
; CDFattrGet.
;------------------------------------------------------------------------------

;+
; NAME:
;       CDFattrGet
;
; PURPOSE:
;       `CDFattrGet' is used to read an entry value from an attribute.
;
;       This function is part of the CDF interface provided with the CDF
;       distribution.  IDL also provides its own built-in interface to CDFs.
;
; CALLING SEQUENCE:
;       status = CDFattrGet (id, attrNum, entryNum, value)
;
; INPUTS:
;       id:             LONG.  Identifier of the CDF being accessed.  This
;                       identifier must have been returned from a successful
;                       call to `CDFcreate' or `CDFopen'.
;       attrNum:        LONG.  The number of the attribute
;       entryNum:       LONG.  The number of the entry.
;
;       All input variables must have been created/initialized before calling
;       `CDFattrGet'.
;
; OUTPUTS:
;       value:          DATA TYPE DEPENDENT.  The value which was read.  The
;                       entry's CDF data type will determine which IDL data
;                       type is used for this IDL variable.
;
;       status:         LONG.  A completion status code.  CDF_OK indicates
;                       success.  The possible status codes are defined by
;                       `cdf1.pro'.
;
;       All output variables are (re)created/assigned by `CDFattrGet'.
;
; EXAMPLE:
;       IDL> @cdf0x.pro
;       IDL> status = CDFattrGet (id, CDFattrNum('TITLE'), 0L, value)
;       IDL> if (status lt CDFx.CDF_WARN) print, 'CDFattrGet failed.'
;
; RESTRICTIONS:
;       None.
;
; REVISION HISTORY:
;       13-May-93       Original version.
;        1-Nov-94       CDF V2.5.
;       26-Jun-95       IDL 4.0.
;       21-Aug-96       CDF V2.6.
;-

function CDFattrGet, CDF_id,attr_num,entry_num,value
common cdfcurrent_, cdfid_, cdfstatus_
on_error, 1
idl_cdfattrget, cdfid_, cdfstatus_, status, $
		CDF_id, attr_num, entry_num, value
return, status
end
