;------------------------------------------------------------------------------
;
;  NSSDC/CDF					IDL/CDF Interface, CDFattrPut.
;
;  Version 1.4, 21-Aug-96, Hughes STX.
;
;  Modification history:
;
;   V1.0  21-Sep-92, H Leckner	Original version.
;   V1.1  10-Dec-92, H Leckner	Removed print/help debug statements.
;   V1.2  13-May-93, J Love	CDF V2.4 (`idl_cdf.pro' split into separate
;                               files as required for online help in IDL).
;   V1.3   1-Nov-94, J Love	CDF V2.5.
;   V1.3a 26-Jun-95, J Love	IDL 4.0.
;   V1.4  21-Aug-96, J Love	CDF V2.6.
;
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
; CDFattrPut.
;------------------------------------------------------------------------------

;+
; NAME:
;       CDFattrPut
;
; PURPOSE:
;       `CDFattrPut' is used to write an entry value to an attribute.
;
;       This function is part of the CDF interface provided with the CDF
;       distribution.  IDL also provides its own built-in interface to CDFs.
;
; CALLING SEQUENCE:
;       status = CDFattrPut (id, attrNum, entryNum, dataType, numElems, value)
;
; INPUTS:
;       id:             LONG.  Identifier of the CDF being accessed.  This
;                       identifier must have been returned from a successful
;                       call to `CDFcreate' or `CDFopen'.
;       attrNum:        LONG.  The number of the attribute
;       entryNum:       LONG.  The number of the entry.
;       dataType:       LONG.  The entry's data type.  Use one of the data
;                       types defined by `cdf0x.pro'.
;       numElems:       LONG.  The number of elements of the data type.
;       value:          DATA TYPE DEPENDENT.  The value to be written.  The
;                       IDL data type of this IDL variable should correspond
;                       to the CDF data type of the entry.
;
;       All input variables must have been created/initialized before calling
;       `CDFattrPut'.
;
; OUTPUTS:
;       status:         LONG.  A completion status code.  CDF_OK indicates
;                       success.  The possible status codes are defined bu
;                       `cdf0x.pro'.
;
;       All output variables are (re)created/assigned by `CDFattrPut'.
;
; EXAMPLE:
;       IDL> @cdf0x.pro
;       IDL> value = 'This is an example entry for the TITLE attribute. '
;       IDL> status = CDFattrPut (id, CDFattrNum(id,'TITLE'), 0L, $
;                                 CDFdt.CDF_CHAR, 50L, value)
;       IDL> if (status lt CDFx.CDF_WARN) print, 'CDFattrPut failed.'
;
; RESTRICTIONS:
;       None.
;
; REVISION HISTORY:
;       13-May-93       Original version.
;        1-Nov-94       CDF V2.5.
;       26-Jun-95       IDL 4.0.
;       21-Aug-96       CDF V2.6.
;-

function CDFattrPut, CDF_id,attr_num,entry_num,data_type,num_elements,value
common cdfcurrent_, cdfid_, cdfstatus_
on_error, 1
idl_cdfattrput, cdfid_, cdfstatus_, status, $
		CDF_id, attr_num, entry_num, data_type, num_elements, value
return, status
end
