;******************************************************************************
;
;  NSSDC/CDF			   CDF constant procedures for IDL interface.
;
;  Version 1.1b, 16-Dec-97, Hughes STX.
;
;  Modification history:
;
;   V1.0  23-Feb-95, J Love	Original version.
;   V1.0a 12-Jun-95, J Love	EPOCH custom format.
;   V1.1   9-Sep-96, J Love	CDF V2.6.
;   V1.1a 21-Feb-97, J Love	Removed RICE.
;   V1.1b 16-Dec-97, J Love	Added ALPHAVMSi encoding.
;
;******************************************************************************
; DANGER, DANGER:
;   There is an apparently undocumented limit of 127 tags (elements) per
; structure.  Exceeding that limit may not produce an immediate error but
; may cause IDL to crash at some point.
;******************************************************************************

pro CDFconstantCodes, CDFconst
CDFconst = { $
  CDF_MIN_DIMS			: 0L, $		;1
  CDF_MAX_DIMS			: 10L, $	;2
  CDF_VAR_NAME_LEN  		: 64L, $	;3
  CDF_ATTR_NAME_LEN 		: 64L, $	;4
  CDF_COPYRIGHT_LEN 		: 256L, $	;5
  CDF_STATUSTEXT_LEN 		: 80L, $	;6
  CDF_PATHNAME_LEN		: 128L, $	;7
  EPOCH_STRING_LEN		: 24L, $	;8
  EPOCH1_STRING_LEN		: 16L, $	;9
  EPOCH2_STRING_LEN		: 14L, $	;10
  EPOCH3_STRING_LEN		: 24L, $	;11
  EPOCHx_STRING_MAX		: 30L, $	;12
  EPOCHx_FORMAT_MAX		: 60L, $	;13
  VARY				: -1L, $	;14
  NOVARY			: 0L, $		;15
  ROW_MAJOR			: 1L, $		;16
  COLUMN_MAJOR			: 2L, $		;17
  COL_MAJOR			: 2L, $		;18 (synonym)
  SINGLE_FILE			: 1L, $		;19
  MULTI_FILE			: 2L, $		;20
  GLOBAL_SCOPE			: 1L, $		;21
  VARIABLE_SCOPE		: 2L, $		;22
  READONLYon			: -1L, $	;23
  READONLYoff			: 0L, $		;24
  zMODEoff			: 0L, $		;25
  zMODEon1			: 1L, $		;26
  zMODEon2			: 2L, $		;27
  NEGtoPOSfp0on			: -1L, $	;28
  NEGtoPOSfp0off		: 0L, $		;29
  CDF_OK			: 0L, $		;30
  CDF_WARN			: -2000L, $	;31
  CDF_MAX_PARMS			: 5, $		;32
  NO_COMPRESSION		: 0L, $		;33
  RLE_COMPRESSION		: 1L, $		;34
  HUFF_COMPRESSION		: 2L, $		;35
  AHUFF_COMPRESSION		: 3L, $		;36
  GZIP_COMPRESSION		: 5L, $		;37
  RLE_OF_ZEROs			: 0L, $		;38
  OPTIMAL_ENCODING_TREES	: 0L, $		;39
  NO_SPARSEARRAYS		: 0L, $		;40
  NO_SPARSERECORDS		: 0L, $		;41
  PAD_SPARSERECORDS		: 1L, $		;42
  PREV_SPARSERECORDS		: 2L $		;43
}
end

pro CDFdataTypeCodes, CDFdataType
CDFdataType = { $
  CDF_INT1			: 1L, $		;1
  CDF_INT2			: 2L, $		;2
  CDF_INT4			: 4L, $		;3
  CDF_UINT1			: 11L, $	;4
  CDF_UINT2			: 12L, $	;5
  CDF_UINT4			: 14L, $	;6
  CDF_REAL4			: 21L, $	;7
  CDF_REAL8			: 22L, $	;8
  CDF_EPOCH			: 31L, $	;9
  CDF_BYTE			: 41L, $	;10
  CDF_FLOAT			: 44L, $	;11
  CDF_DOUBLE			: 45L, $	;12
  CDF_CHAR			: 51L, $	;13
  CDF_UCHAR			: 52L $ 	;14
}
end

pro CDFencodingCodes, CDFencoding
CDFencoding = { $
  NETWORK_ENCODING		: 1L, $		;1
  SUN_ENCODING			: 2L, $		;2
  VAX_ENCODING			: 3L, $		;3
  DECSTATION_ENCODING		: 4L, $		;4
  SGi_ENCODING			: 5L, $		;5
  IBMPC_ENCODING		: 6L, $		;6
  IBMRS_ENCODING		: 7L, $		;7
  HOST_ENCODING			: 8L, $		;8
  MAC_ENCODING			: 9L, $		;9
  HP_ENCODING			: 11L, $	;10
  NeXT_ENCODING			: 12L, $	;11
  ALPHAOSF1_ENCODING		: 13L, $	;12
  ALPHAVMSd_ENCODING		: 14L, $	;13
  ALPHAVMSg_ENCODING		: 15L, $	;14
  ALPHAVMSi_ENCODING		: 16L $		;15
}
end

pro CDFdecodingCodes, CDFdecoding
CDFdecoding = { $
  NETWORK_DECODING		: 1L, $		;1
  SUN_DECODING			: 2L, $		;2
  VAX_DECODING			: 3L, $		;3
  DECSTATION_DECODING		: 4L, $		;4
  SGi_DECODING			: 5L, $		;5
  IBMPC_DECODING		: 6L, $		;6
  IBMRS_DECODING		: 7L, $		;7
  HOST_DECODING			: 8L, $		;8
  MAC_DECODING			: 9L, $		;9
  HP_DECODING			: 11L, $	;10
  NeXT_DECODING			: 12L, $	;11
  ALPHAOSF1_DECODING		: 13L, $	;12
  ALPHAVMSd_DECODING		: 14L, $	;13
  ALPHAVMSg_DECODING		: 15L, $	;14
  ALPHAVMSi_DECODING		: 16L $		;15
}
end

pro CDFinfoCodes, CDFiCode
CDFiCode = { $
  CDF_OK			: 0L, $		;1
  VIRTUAL_RECORD_DATA		: 1001L, $	;2
  DID_NOT_COMPRESS		: 1002L, $	;3
  VAR_ALREADY_CLOSED		: 1003L, $	;4
  SINGLE_FILE_FORMAT		: 1004L, $	;5
  NO_PADVALUE_SPECIFIED		: 1005L, $	;6
  NO_VARS_IN_CDF		: 1006L, $	;7
  MULTI_FILE_FORMAT		: 1007L, $	;8
  SOME_ALREADY_ALLOCATED	: 1008L, $	;9
  PRECEEDING_RECORDS_ALLOCATED	: 1009L $	;10
}
end

pro CDFwarnCodes, CDFwCode
CDFwCode = { $
  ATTR_NAME_TRUNC		: -1001L, $	;1
  CDF_NAME_TRUNC		: -1002L, $	;2
  VAR_NAME_TRUNC		: -1003L, $	;3
  NEGATIVE_FP_ZERO		: -1004L, $	;4
  FORCED_PARAMETER		: -1006L, $	;5
  NA_FOR_VARIABLE		: -1007L $	;6
}
end

pro CDFerrorCodes, CDFeCode
CDFeCode = { $
  ATTR_EXISTS			: -2001L, $	;1
  BAD_CDF_ID			: -2002L, $	;2
  BAD_DATA_TYPE			: -2003L, $	;3
  BAD_DIM_SIZE			: -2004L, $	;4
  BAD_DIM_INDEX			: -2005L, $	;5
  BAD_ENCODING			: -2006L, $	;6
  BAD_MAJORITY			: -2007L, $	;7
  BAD_NUM_DIMS			: -2008L, $	;8
  BAD_REC_NUM			: -2009L, $	;9
  BAD_SCOPE			: -2010L, $	;10
  BAD_NUM_ELEMS			: -2011L, $	;11
  CDF_OPEN_ERROR		: -2012L, $	;12
  CDF_EXISTS			: -2013L, $	;13
  BAD_FORMAT			: -2014L, $	;14
  BAD_ALLOCATE_RECS		: -2015L, $	;15
  BAD_CDF_EXTENSION		: -2016L, $	;16
  NO_SUCH_ATTR			: -2017L, $	;17
  NO_SUCH_ENTRY			: -2018L, $	;18
  NO_SUCH_VAR			: -2019L, $	;19
  VAR_READ_ERROR		: -2020L, $	;20
  VAR_WRITE_ERROR		: -2021L, $	;21
  BAD_ARGUMENT			: -2022L, $	;22
  IBM_PC_OVERFLOW		: -2023L, $	;23
  TOO_MANY_VARS			: -2024L, $	;24
  VAR_EXISTS			: -2025L, $	;25
  BAD_MALLOC			: -2026L, $	;26
  NOT_A_CDF			: -2027L, $	;27
  CORRUPTED_V2_CDF		: -2028L, $	;28
  VAR_OPEN_ERROR		: -2029L, $	;29
  BAD_INITIAL_RECS		: -2030L, $	;30
  BAD_BLOCKING_FACTOR		: -2031L, $	;31
  BAD_EXTEND_RECS		: -2031L, $	;32 (synonym)
  END_OF_VAR			: -2032L, $	;33
  BAD_CDFSTATUS			: -2034L, $	;34
  CDF_INTERNAL_ERROR		: -2035L, $	;35
  BAD_NUM_VARS			: -2036L, $	;36
  BAD_REC_COUNT			: -2037L, $	;37
  BAD_REC_INTERVAL		: -2038L, $	;38
  BAD_DIM_COUNT			: -2039L, $	;39
  BAD_DIM_INTERVAL		: -2040L, $	;40
  BAD_VAR_NUM			: -2041L, $	;41
  BAD_ATTR_NUM			: -2042L, $	;42
  BAD_ENTRY_NUM			: -2043L, $	;43
  BAD_ATTR_NAME			: -2044L, $	;44
  BAD_VAR_NAME			: -2045L, $	;45
  NO_ATTR_SELECTED		: -2046L, $	;46
  NO_ENTRY_SELECTED		: -2047L, $	;47
  NO_VAR_SELECTED		: -2048L, $	;48
  BAD_CDF_NAME			: -2049L, $	;49
  CANNOT_CHANGE			: -2051L, $	;50
  NO_STATUS_SELECTED		: -2052L, $	;51
  NO_CDF_SELECTED		: -2053L, $	;52
  READ_ONLY_DISTRIBUTION	: -2054L, $	;53
  CDF_CLOSE_ERROR		: -2055L, $	;54
  VAR_CLOSE_ERROR		: -2056L, $	;55
  BAD_FNC_OR_ITEM		: -2058L, $	;56
  ILLEGAL_ON_V1_CDF		: -2060L, $	;57
  BAD_CACHE_SIZE		: -2063L, $	;58
  CDF_CREATE_ERROR		: -2066L, $	;59
  NO_SUCH_CDF			: -2067L, $	;60
  VAR_CREATE_ERROR		: -2068L, $	;61
  READ_ONLY_MODE		: -2070L, $	;62
  ILLEGAL_IN_zMODE		: -2071L, $	;63
  BAD_zMODE			: -2072L, $	;64
  BAD_READONLY_MODE		: -2073L, $	;65
  CDF_READ_ERROR		: -2074L, $	;66
  CDF_WRITE_ERROR		: -2075L, $	;67
  ILLEGAL_FOR_SCOPE		: -2076L, $	;68
  NO_MORE_ACCESS		: -2077L, $	;69
  BAD_DECODING			: -2079L, $	;70
  BAD_NEGtoPOSfp0_MODE		: -2081L, $	;71
  UNSUPPORTED_OPERATION		: -2082L, $	;72
  NO_WRITE_ACCESS		: -2086L, $	;73
  NO_DELETE_ACCESS		: -2087L, $	;74
  CDF_DELETE_ERROR		: -2088L, $	;75
  VAR_DELETE_ERROR		: -2089L, $	;76
  UNKNOWN_COMPRESSION		: -2090L, $	;77
  CANNOT_COMPRESS		: -2091L, $	;78
  DECOMPRESSION_ERROR		: -2092L, $	;79
  COMPRESSION_ERROR		: -2093L, $	;80
  EMPTY_COMPRESSED_CDF		: -2096L, $	;81
  BAD_COMPRESSION_PARM		: -2097L, $	;82
  UNKNOWN_SPARSENESS		: -2098L, $	;83
  CANNOT_SPARSERECORDS		: -2099L, $	;84
  CANNOT_SPARSEARRAYS		: -2100L, $	;85
  TOO_MANY_PARMS		: -2101L, $	;86
  NO_SUCH_RECORD		: -2102L, $	;87
  CANNOT_ALLOCATE_RECORDS	: -2103L, $	;88
  SCRATCH_DELETE_ERROR		: -2106L, $	;89
  SCRATCH_CREATE_ERROR		: -2107L, $	;90
  SCRATCH_READ_ERROR		: -2108L, $	;91
  SCRATCH_WRITE_ERROR		: -2109L, $	;92
  BAD_SPARSEARRAYS_PARM		: -2110L, $	;93
  BAD_SCRATCH_DIR		: -2111L $	;94
}
end

pro CDFiiFunctionCodes, CDFiiFnc
CDFiiFnc = { $
  CREATE_			: 1001L, $	;1
  OPEN_				: 1002L, $	;2
  DELETE_			: 1003L, $	;3
  CLOSE_			: 1004L, $	;4
  SELECT_			: 1005L, $	;5
  CONFIRM_			: 1006L, $	;6
  GET_				: 1007L, $	;7
  PUT_				: 1008L, $	;8
  NULL_				: 1000L $	;9
}
end

pro CDFiiItemCodes, CDFiiItem
CDFiiItem = { $
  CDF_				: 1L, $		;1
  CDF_NAME_			: 2L, $		;2
  CDF_ENCODING_			: 3L, $		;3
  CDF_DECODING_			: 4L, $		;4
  CDF_MAJORITY_			: 5L, $		;5
  CDF_FORMAT_			: 6L, $		;6
  CDF_COPYRIGHT_		: 7L, $		;7
  CDF_NUMrVARS_			: 8L, $		;8
  CDF_NUMzVARS_			: 9L, $		;9
  CDF_NUMATTRS_			: 10L, $	;10
  CDF_NUMgATTRS_		: 11L, $	;11
  CDF_NUMvATTRS_		: 12L, $	;12
  CDF_VERSION_			: 13L, $	;13
  CDF_RELEASE_			: 14L, $	;14
  CDF_INCREMENT_		: 15L, $	;15
  CDF_STATUS_			: 16L, $	;16
  CDF_READONLY_MODE_		: 17L, $	;17
  CDF_zMODE_			: 18L, $	;18
  CDF_NEGtoPOSfp0_MODE_		: 19L, $	;19
  LIB_COPYRIGHT_		: 20L, $	;20
  LIB_VERSION_			: 21L, $	;21
  LIB_RELEASE_			: 22L, $	;22
  LIB_INCREMENT_		: 23L, $	;23
  LIB_subINCREMENT_		: 24L, $	;24
  STATUS_TEXT_			: 116L, $	;25
  CDF_CACHESIZE_		: 117L, $	;26
  DATATYPE_SIZE_		: 125L, $	;27
  CDF_INFO_			: 129L, $	;28
  CDF_COMPRESSION_		: 130L, $	;29
  CDF_SCRATCHDIR_		: 149L, $	;30
  STAGE_CACHESIZE_		: 154L, $	;31
  COMPRESS_CACHESIZE_		: 155L $	;32
}
end

pro CDFii_attrItemCodes, CDFiiItemA
CDFiiItemA = { $
  ATTR_				: 85L, $	;1
  ATTR_SCOPE_			: 86L, $	;2
  ATTR_NAME_			: 87L, $	;3
  ATTR_NUMBER_			: 88L, $	;4
  ATTR_MAXgENTRY_		: 89L, $	;5
  ATTR_NUMgENTRIES_		: 90L, $	;6
  ATTR_MAXrENTRY_		: 91L, $	;7
  ATTR_NUMrENTRIES_		: 92L, $	;8
  ATTR_MAXzENTRY_		: 93L, $	;9
  ATTR_NUMzENTRIES_		: 94L, $	;10
  ATTR_EXISTENCE_		: 95L $		;11
}
end

pro CDFii_entryItemCodes, CDFiiItemE
CDFiiItemE = { $
  gENTRY_			: 96L, $	;1
  gENTRY_EXISTENCE_		: 97L, $	;2
  gENTRY_DATATYPE_		: 98L, $	;3
  gENTRY_NUMELEMS_		: 99L, $	;4
  gENTRY_DATASPEC_		: 100L, $	;5
  gENTRY_DATA_			: 101L, $	;6
  rENTRY_			: 102L, $	;7
  rENTRY_NAME_			: 103L, $	;8
  rENTRY_EXISTENCE_		: 104L, $	;9
  rENTRY_DATATYPE_		: 105L, $	;10
  rENTRY_NUMELEMS_		: 106L, $	;11
  rENTRY_DATASPEC_		: 107L, $	;12
  rENTRY_DATA_			: 108L, $	;13
  zENTRY_			: 109L, $	;14
  zENTRY_NAME_			: 110L, $	;15
  zENTRY_EXISTENCE_		: 111L, $	;16
  zENTRY_DATATYPE_		: 112L, $	;17
  zENTRY_NUMELEMS_		: 113L, $	;18
  zENTRY_DATASPEC_		: 114L, $	;19
  zENTRY_DATA_			: 115L, $	;20
  CURgENTRY_EXISTENCE_		: 126L, $	;21
  CURrENTRY_EXISTENCE_		: 127L, $	;22
  CURzENTRY_EXISTENCE_		: 128L $	;23
}
end

pro CDFii_rVarItemCodes, CDFiiItemR
CDFiiItemR = { $
  rVARs_NUMDIMS_		: 25L, $	;1
  rVARs_DIMSIZES_		: 26L, $	;2
  rVARs_MAXREC_			: 27L, $	;3
  rVARs_RECDATA_		: 28L, $	;4
  rVARs_RECNUMBER_		: 29L, $	;5
  rVARs_RECCOUNT_		: 30L, $	;6
  rVARs_RECINTERVAL_		: 31L, $	;7
  rVARs_DIMINDICES_		: 32L, $	;8
  rVARs_DIMCOUNTS_		: 33L, $	;9
  rVARs_DIMINTERVALS_		: 34L, $	;10
  rVAR_				: 35L, $	;11
  rVAR_NAME_			: 36L, $	;12
  rVAR_DATATYPE_		: 37L, $	;13
  rVAR_NUMELEMS_		: 38L, $	;14
  rVAR_RECVARY_			: 39L, $	;15
  rVAR_DIMVARYS_		: 40L, $	;16
  rVAR_NUMBER_			: 41L, $	;17
  rVAR_DATA_			: 42L, $	;18
  rVAR_HYPERDATA_		: 43L, $	;19
  rVAR_SEQDATA_			: 44L, $	;20
  rVAR_SEQPOS_			: 45L, $	;21
  rVAR_MAXREC_			: 46L, $	;22
  rVAR_MAXallocREC_		: 47L, $	;23
  rVAR_DATASPEC_		: 48L, $	;24
  rVAR_PADVALUE_		: 49L, $	;25
  rVAR_INITIALRECS_		: 50L, $	;26
  rVAR_BLOCKINGFACTOR_		: 51L, $	;27
  rVAR_EXTENDRECS_		: 51L, $	;28 (synonym)
  rVAR_nINDEXRECORDS_		: 52L, $	;29
  rVAR_nINDEXENTRIES_		: 53L, $	;30
  rVAR_EXISTENCE_		: 54L, $	;31
  rVARs_CACHESIZE_		: 118L, $	;32
  rVAR_CACHESIZE_		: 120L, $	;33
  rVAR_ALLOCATERECS_		: 123L, $	;34
  rVAR_COMPRESSION_		: 137L, $	;35
  rVAR_SPARSERECORDS_		: 138L, $	;36
  rVAR_SPARSEARRAYS_		: 139L, $	;37
  rVAR_ALLOCATEBLOCK_		: 140L, $	;38
  rVAR_NUMRECS_			: 141L, $	;39
  rVAR_NUMallocRECS_		: 142L, $	;40
  rVAR_ALLOCATEDFROM_		: 143L, $	;41
  rVAR_ALLOCATEDTO_		: 144L, $	;42
  rVAR_nINDEXLEVELS_		: 148L, $	;43
  rVAR_RESERVEPERCENT_		: 150L, $	;44
  rVAR_RECORDS_			: 152L $	;45
}
end

pro CDFii_zVarItemCodes, CDFiiItemZ
CDFiiItemZ = { $
  zVARs_MAXREC_			: 55L, $	;1
  zVARs_RECDATA_		: 56L, $	;2
  zVAR_				: 57L, $	;3
  zVAR_NAME_			: 58L, $	;4
  zVAR_DATATYPE_		: 59L, $	;5
  zVAR_NUMELEMS_		: 60L, $	;6
  zVAR_NUMDIMS_			: 61L, $	;7
  zVAR_DIMSIZES_		: 62L, $	;8
  zVAR_RECVARY_			: 63L, $	;9
  zVAR_DIMVARYS_		: 64L, $	;10
  zVAR_NUMBER_			: 65L, $	;11
  zVAR_DATA_			: 66L, $	;12
  zVAR_HYPERDATA_		: 67L, $	;13
  zVAR_SEQDATA_			: 68L, $	;14
  zVAR_SEQPOS_			: 69L, $	;15
  zVAR_MAXREC_			: 70L, $	;16
  zVAR_MAXallocREC_		: 71L, $	;17
  zVAR_DATASPEC_		: 72L, $	;18
  zVAR_PADVALUE_		: 73L, $	;19
  zVAR_INITIALRECS_		: 74L, $	;20
  zVAR_BLOCKINGFACTOR_		: 75L, $	;21
  zVAR_EXTENDRECS_		: 75L, $	;22 (synonym)
  zVAR_nINDEXRECORDS_		: 76L, $	;23
  zVAR_nINDEXENTRIES_		: 77L, $	;24
  zVAR_EXISTENCE_		: 78L, $	;25
  zVAR_RECNUMBER_		: 79L, $	;26
  zVAR_RECCOUNT_		: 80L, $	;27
  zVAR_RECINTERVAL_		: 81L, $	;28
  zVAR_DIMINDICES_		: 82L, $	;29
  zVAR_DIMCOUNTS_		: 83L, $	;30
  zVAR_DIMINTERVALS_		: 84L, $	;31
  zVARs_CACHESIZE_		: 119L, $	;32
  zVAR_CACHESIZE_		: 121L, $	;33
  zVARs_RECNUMBER_		: 122L, $	;34
  zVAR_ALLOCATERECS_		: 124L, $	;35
  zVAR_COMPRESSION_		: 131L, $	;36
  zVAR_SPARSERECORDS_		: 132L, $	;37
  zVAR_SPARSEARRAYS_		: 133L, $	;38
  zVAR_ALLOCATEBLOCK_		: 134L, $	;39
  zVAR_NUMRECS_			: 135L, $	;40
  zVAR_NUMallocRECS_		: 136L, $	;41
  zVAR_ALLOCATEDFROM_		: 145L, $	;42
  zVAR_ALLOCATEDTO_		: 146L, $	;43
  zVAR_nINDEXLEVELS_		: 147L, $	;44
  zVAR_RESERVEPERCENT_		: 151L, $	;45
  zVAR_RECORDS_			: 153L $	;46
}
end
