;------------------------------------------------------------------------------
;
;  NSSDC/CDF				     IDL/CDF Interface, CDFvarInquire.
;
;  Version 1.4, 21-Aug-96, Hughes STX.
;
;  Modification history:
;
;   V1.0  21-Sep-92, H Leckner	Original version.
;   V1.1  10-Dec-92, H Leckner	Removed print/help debug statements.
;   V1.2  13-May-93, J Love	CDF V2.4 (`idl_cdf.pro' split into separate
;                               files as required for online help in IDL).
;   V1.3   1-Nov-94, J Love	CDF V2.5.
;   V1.3a 26-Jun-95, J Love	IDL 4.0.
;   V1.4  21-Aug-96, J Love	CDF V2.6.
;
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
; CDFvarInquire.
;------------------------------------------------------------------------------

;+
; NAME:
;       CDFvarInquire
;
; PURPOSE:
;       `CDFvarInquire' is used to inquire about an rVariable in a CDF.
;
;       This function is part of the CDF interface provided with the CDF
;       distribution.  IDL also provides its own built-in interface to CDFs.
;
; CALLING SEQUENCE:
;       status = CDFvarInquire (id, varNum, varName, dataType, numElems, $
;                               recVary, dimVarys)
;
; INPUTS:
;       id:             LONG.  Identifier of the CDF being accessed.  This
;                       identifier must have been returned from a successful
;                       call to `CDFcreate' or `CDFopen'.
;       varNum:         LONG.  The number of the rVariable.
;
;       All input variables must have been created/initialized before calling
;       `CDFvarInquire'.
;
; OUTPUTS:
;       varName:        STRING.  The rVariable name.
;       dataType:       LONG.  The rVariable data type.  This will be one of
;                       data types defined by `cdf0x.pro'.
;       numElems:       LONG.  The number of elements of the data type.
;       recVary:        LONG.  The rVariable record variance.  This will be
;                       one of the variances defined by `cdf0x.pro'.
;       dimVarys:       LONG array.  The rVariable dimension variances.  These
;                       will consist of the variances defined by `cdf0x.pro'.
;
;       status:         LONG.  A completion status code.  CDF_OK indicates
;                       success.  The possible status codes are defined by
;                       `cdf0x.pro'.
;
;       All output variables are (re)created/assigned by `CDFvarInquire'.
;
; EXAMPLE:
;       IDL> @cdf0x.pro
;       IDL> status = CDFvarInquire (id, CDFvarNum(id,'EPOCH'), varName, $
;       IDL>                         dataType, numElems, recVary, dimVarys)
;       IDL> if (status lt CDFx.CDF_WARN) print, 'CDFvarInquire failed.'
;
; RESTRICTIONS:
;       None.
;
; REVISION HISTORY:
;       13-May-93       Original version.
;        1-Nov-94       CDF V2.5.
;       26-Jun-95       IDL 4.0.
;       21-Aug-96       CDF V2.6.
;-

function CDFvarInquire, CDF_id,var_num,var_mnemonic,data_type, $
			num_bytes,record_variance,dim_variances
common cdfcurrent_, cdfid_, cdfstatus_
on_error, 1
idl_cdfvarinq, cdfid_, cdfstatus_, status, $
	       CDF_id, var_num, var_mnemonic, data_type, $
	       num_bytes, record_variance, dim_variances
return, status
end
