;------------------------------------------------------------------------------
;
;  NSSDC/CDF				       IDL/CDF Interface, CDFvarClose.
;
;  Version 1.4, 21-Aug-96, Hughes STX.
;
;  Modification history:
;
;   V1.0  21-Sep-92, H Leckner	Original version.
;   V1.1  10-Dec-92, H Leckner	Removed print/help debug statements.
;   V1.2  13-May-93, J Love	CDF V2.4 (`idl_cdf.pro' split into separate
;                               files as required for online help in IDL).
;   V1.3   1-Nov-94, J Love	CDF V2.5.
;   V1.3a 26-Jun-95, J Love	IDL 4.0.
;   V1.4  21-Aug-96, J Love	CDF V2.6.
;
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
; CDFvarClose.
;------------------------------------------------------------------------------

;+
; NAME:
;       CDFvarClose
;
; PURPOSE:
;       `CDFvarClose' is used to close a variable file in a multi-file CDF.
;       This may become necessary if the limit on open files imposed by the
;       operating system is reached.
;
;       This function is part of the CDF interface provided with the CDF
;       distribution.  IDL also provides its own built-in interface to CDFs.
;
; CALLING SEQUENCE:
;       status = CDFvarClose (id, varNum)
;
; INPUTS:
;       id:             LONG.  Identifier of the CDF being accessed.  This
;                       identifier must have been returned from a successful
;                       call to `CDFcreate' or `CDFopen'.
;       varNum:         LONG.  Number of the variable being closed.
;
;       All input variables must have been created/initialized before calling
;       `CDFvarClose'.
;
; OUTPUTS:
;       status:         LONG.  A completion status code.  CDF_OK indicates
;                       success.  The possible status codes are defined by
;                       `cdf0x.pro'.
;
;       All output variables are (re)created/assigned by `CDFvarClose'.
;
; EXAMPLE:
;       IDL> @cdf0x.pro
;       IDL> status = CDFvarClose (id, CDFvarNum(id,'PollenCount'))
;       IDL> if (status lt CDFx.CDF_WARN) print, 'CDFvarClose failed.'
;
; RESTRICTIONS:
;       `CDFvarClose' should only be used on multi-file CDFs.
;
; REVISION HISTORY:
;       13-May-93       Original version.
;        1-Nov-94       CDF V2.5.
;       26-Jun-95       IDL 4.0.
;       21-Aug-96       CDF V2.6.
;-

function CDFvarClose, CDF_id,var_num
common cdfcurrent_, cdfid_, cdfstatus_
on_error, 1
idl_cdfvarclose, cdfid_, cdfstatus_, status, CDF_id, var_num
return, status
end
