;------------------------------------------------------------------------------
;
;  NSSDC/CDF					IDL/CDF Interface, CDFinquire.
;
;  Version 1.4, 21-Aug-96, Hughes STX.
;
;  Modification history:
;
;   V1.0  21-Sep-92, H Leckner	Original version.
;   V1.1  10-Dec-92, H Leckner	Removed print/help debug statements.
;   V1.2  13-May-93, J Love	CDF V2.4 (`idl_cdf.pro' split into separate
;                               files as required for online help in IDL).
;   V1.3   1-Nov-94, J Love	CDF V2.5.
;   V1.3a 26-Jun-95, J Love	IDL 4.0.
;   V1.4  21-Aug-96, J Love	CDF V2.6.
;
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
; CDFinquire.
;------------------------------------------------------------------------------

;+
; NAME:
;       CDFinquire
;
; PURPOSE:
;       `CDFinquire' is used to inquire general information about an opened
;       CDF.
;
;       This function is part of the CDF interface provided with the CDF
;       distribution.  IDL also provides its own built-in interface to CDFs.
;
; CALLING SEQUENCE:
;       status = CDFinquire (id, numDims, dimSizes, encoding, majority, $
;                            maxRec, numVars, numAttrs)
;
; INPUTS:
;       id:             LONG.  Identifier of the CDF being accessed.  This
;                       identifier must have been returned from a successful
;                       call to `CDFcreate' or `CDFopen'.
;
;       All input variables must have been created/initialized before calling
;       `CDFinquire'.
;
; OUTPUTS:
;       numDims:        LONG.  The number of rVariable dimensions.
;       dimSizes:       LONG array.  The rVariable dimension sizes.
;       encoding:       LONG.  The variable/attribute entry encoding.  This
;                       will be one of the encodings defined in `cdf.pro'.
;       majority:       LONG.  The variable majority.  This will be one of
;                       the majorities defined by `cdf0x.pro'.
;       maxRec:         LONG.  The maximum record number written for the
;                       rVariables.
;       numVars:        LONG.  The number of rVariables.
;       numAttrs:       LONG.  The number of attributes.
;
;       status:         LONG.  A completion status code.  CDF_OK indicates
;                       success.  The possible status codes are defined by
;                       `cdf0x.pro'.
;
;       All output variables are (re)created/assigned by `CDFinquire'.
;
; EXAMPLE:
;       IDL> @cdf0x.pro
;       IDL> status = CDFinquire (id, numDims, dimSizes, encoding, majority, $
;       IDL>                      maxRec, numVars, numAttrs)
;       IDL> if (status lt CDFx.CDF_WARN) print, 'CDFinquire failed.'
;
; RESTRICTIONS:
;       None.
;
; REVISION HISTORY:
;       13-May-93       Original version.
;        1-Nov-94       CDF V2.5.
;       26-Jun-95       IDL 4.0.
;       21-Aug-96       CDF V2.6.
;-

function CDFinquire,CDF_id,num_dims,dim_sizes,encoding, $
		    majority,max_record_num,num_vars,num_attrs
common cdfcurrent_, cdfid_, cdfstatus_
on_error, 1
idl_cdfinquire, cdfid_, cdfstatus_, status, $
		CDF_id, num_dims, dim_sizes, encoding, $
		majority, max_record_num, num_vars, num_attrs
return, status
end
