;------------------------------------------------------------------------------
;
;  NSSDC/CDF					 IDL/CDF Interface, CDFdelete.
;
;  Version 1.4, 21-Aug-96, Hughes STX.
;
;  Modification history:
;
;   V1.0  21-Sep-92, H Leckner	Original version.
;   V1.1  10-Dec-92, H Leckner	Removed print/help debug statements.
;   V1.2  13-May-93, J Love	CDF V2.4 (`idl_cdf.pro' split into separate
;                               files as required for online help in IDL).
;   V1.3   1-Nov-94, J Love	CDF V2.5.
;   V1.3a 26-Jun-95, J Love	IDL 4.0.
;   V1.4  21-Aug-96, J Love	CDF V2.6.
;
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
; CDFdelete.
;------------------------------------------------------------------------------

;+
; NAME:
;       CDFdelete
;
; PURPOSE:
;       `CDFdelete' is used to delete an open CDF.
;
;       This function is part of the CDF interface provided with the CDF
;       distribution.  IDL also provides its own built-in interface to CDFs.
;
; CALLING SEQUENCE:
;       status = CDFdelete (id)
;
; INPUTS:
;       id:             LONG.  Identifier of the CDF being deleted.  This
;                       identifier must have been returned from a successful
;                       call to `CDFcreate' or `CDFopen'.
;
;       All input variables must have been created/initialized before calling
;       `CDFdelete'.
;
; OUTPUTS:
;       status:         LONG.  A completion status code.  CDF_OK indicates
;                       success.  The possible status codes are defined by
;                       `cdf0x.pro'.
;
;       All output variables are (re)created/assigned by `CDFdelete'.
;
; EXAMPLE:
;       IDL> @cdf0x.pro
;       IDL> status = CDFopen ('rain3', id)
;       IDL> if (status lt CDFx.CDF_WARN) print, 'CDFopen failed.'
;       IDL> status = CDFdelete (id)
;       IDL> if (status lt CDFx.CDF_WARN) print, 'CDFdelete failed.'
;
; RESTRICTIONS:
;       You must be able to open a CDF in order to delete it with `CDFdelete'.
;       Corrupted CDFs must be deleted at the operating system command line.
;
; REVISION HISTORY:
;       13-May-93       Original version.
;        1-Nov-94       CDF V2.5.
;       26-Jun-95       IDL 4.0.
;       21-Aug-96       CDF V2.6.
;-

function CDFdelete, CDF_id
common cdfcurrent_, cdfid_, cdfstatus_
on_error, 1
idl_cdfdelete, cdfid_, cdfstatus_,status, CDF_id
return, status
end
