;------------------------------------------------------------------------------
;
;  NSSDC/CDF				      IDL/CDF Interface, CDFvarCreate.
;
;  Version 1.4, 21-Aug-96, Hughes STX.
;
;  Modification history:
;
;   V1.0  21-Sep-92, H Leckner	Original version.
;   V1.1  10-Dec-92, H Leckner	Removed print/help debug statements.
;   V1.2  13-May-93, J Love	CDF V2.4 (`idl_cdf.pro' split into separate
;                               files as required for online help in IDL).
;   V1.3   1-Nov-94, J Love	CDF V2.5.
;   V1.3a 26-Jun-95, J Love	IDL 4.0.
;   V1.4  21-Aug-96, J Love	CDF V2.6.
;
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
; CDFvarCreate.
;------------------------------------------------------------------------------

;+
; NAME:
;       CDFvarCreate
;
; PURPOSE:
;       `CDFvarCreate' is used to create a new rVariable in a CDF.
;
;       This function is part of the CDF interface provided with the CDF
;       distribution.  IDL also provides its own built-in interface to CDFs.
;
; CALLING SEQUENCE:
;       status = CDFvarCreate (id, varName, dataType, numElems, recVary, $
;                              dimVarys, varNum)
;
; INPUTS:
;       id:             LONG.  Identifier of the CDF being accessed.  This
;                       identifier must have been returned from a successful
;                       call to `CDFcreate' or `CDFopen'.
;       varName:        STRING.  The new rVariable's name.
;       dataType:       LONG.  The rVariable data type.  Use one of the data
;                       types defined by `cdf0x.pro'.
;       numElems:       LONG.  The number of elements of the data type.
;       recVary:        LONG.  The rVariable record variance.  Use one of the
;                       variances defined by `cdf0x.pro'.
;       dimVarys:       LONG array.  The rVariable dimension variances.  Use
;                       the variances defined by `cdf0x.pro'.
;
;       All input variables must have been created/initialized before calling
;       `CDFvarCreate'.
;
; OUTPUTS:
;       varNum:         LONG.  The number of the new rVariable.
;
;       status:         LONG.  A completion status code.  CDF_OK indicates
;                       success.  The possible status codes are defined by
;                       `cdf0x.pro'.
;
;       All output variables are (re)created/assigned by `CDFvarCreate'.
;
; EXAMPLE:
;       IDL> @cdf0x.pro
;       IDL> dimVarys = lonarr(2)
;       IDL> dimVarys(0) = CDFx.NOVARY
;       IDL> dimVarys(1) = CDFx.NOVARY
;       IDL> status = CDFvarCreate (id, 'EPOCH', CDFdt.CDF_EPOCH, 1L, $
;       IDL>                        CDFx.VARY, dimVarys, varNum)
;       IDL> if (status lt CDFx.CDF_WARN) print, 'CDFvarCreate failed.'
;
; RESTRICTIONS:
;       The rVariable name must not already be in use in the CDF.
;
; REVISION HISTORY:
;       13-May-93       Original version.
;        1-Nov-94       CDF V2.5.
;       26-Jun-95       IDL 4.0.
;       21-Aug-96       CDF V2.6.
;-

function CDFvarCreate, CDF_id,var_mnemonic,data_type,num_bytes, $
		       record_variance,dim_variances,out_var_num
common cdfcurrent_, cdfid_, cdfstatus_
on_error, 1
idl_cdfvarcre, cdfid_, cdfstatus_, status, $
	       CDF_id, var_mnemonic, data_type, num_bytes, $
	       record_variance, dim_variances, out_var_num
return, status
end
