;------------------------------------------------------------------------------
;
;  NSSDC/CDF					 IDL/CDF Interface, CDFerror.
;
;  Version 1.4, 21-Aug-96, Hughes STX.
;
;  Modification history:
;
;   V1.0  21-Sep-92, H Leckner	Original version.
;   V1.1  10-Dec-92, H Leckner	Removed print/help debug statements.
;   V1.2  13-May-93, J Love	CDF V2.4 (`idl_cdf.pro' split into separate
;                               files as required for online help in IDL).
;   V1.3   1-Nov-94, J Love	CDF V2.5.
;   V1.3a 26-Jun-95, J Love	IDL 4.0.
;   V1.4  21-Aug-96, J Love	CDF V2.6.
;
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
; CDFerror.
;------------------------------------------------------------------------------

;+
; NAME:
;       CDFerror
;
; PURPOSE:
;       `CDFerror' is used to retrieve a text string descibing a CDF status
;       code.
;
;       This function is part of the CDF interface provided with the CDF
;       distribution.  IDL also provides its own built-in interface to CDFs.
;
; CALLING SEQUENCE:
;       status = CDFerror (iStatus, text)
;
; INPUTS:
;       iStatus:        LONG.  CDF status code for which an explanation
;                       string is desired.
;
;       All input variables must have been created/initialized before calling
;       `CDFerror'.
;
; OUTPUTS:
;       text:           STRING.  The explanation string.
;
;       status:         LONG.  A completion status code.  CDF_OK indicates
;                       success.  The possible status codes are defined by
;                       `cdf0x.pro'.
;
;       All output variables are (re)created/assigned by `CDFerror'.
;
; EXAMPLE:
;       IDL> @cdf0x.pro
;       IDL> iStatus = CDFopen ('rain2', id)
;       IDL> tStatus = CDFerror (iStatus, text)
;       IDL> print, text
;
; RESTRICTIONS:
;       None.
;
; REVISION HISTORY:
;       13-May-93       Original version.
;        1-Nov-94       CDF V2.5.
;       26-Jun-95       IDL 4.0.
;       21-Aug-96       CDF V2.6.
;-

function CDFerror, status_code,status_msg
common cdfcurrent_, cdfid_, cdfstatus_
on_error, 1
idl_cdferror, cdfid_, cdfstatus_, status, status_code, status_msg
return, status
end
