/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ExportGeneralOptions
extends JDialog {
    private static ExportGeneralOptions dialog;
    static boolean defaultModal;
    private static final String ENTER = "Continue";
    private static final String RESET = "Reset";
    private static final String CANCEL = "Cancel";
    private CDFExport cdfexport;
    private ButtonGroup orientationgp;
    private JRadioButton orientation1;
    private JRadioButton orientation2;
    private JTextField tfRow;
    private JTextField tfCol;
    Font boldFont;
    private JCheckBox t0c;
    private JCheckBox rnc;
    private JCheckBox ric;
    private JCheckBox vhc;
    private ButtonGroup epochgp;
    private JRadioButton epoch0;
    private JRadioButton epoch1;
    private JRadioButton epoch2;
    private JRadioButton epoch3;
    private JRadioButton epochx;
    private ButtonGroup columngp;
    private JRadioButton columnAll;
    private JRadioButton columnSome;
    private int oldCol;

    public static ExportGeneralOptions createGeneralOptions(JFrame jFrame, CDFExport cDFExport, boolean bl) {
        if (dialog == null) {
            dialog = new ExportGeneralOptions(jFrame, bl);
            dialog.getContentPane().setLayout(new BorderLayout());
        }
        ExportGeneralOptions.dialog.cdfexport = cDFExport;
        ExportGeneralOptions.dialog.oldCol = cDFExport.COLUMNS;
        dialog.packUIs();
        dialog.setLocation(0, 0);
        return dialog;
    }

    public void displayGeneralOptions() {
        dialog.setVisible(true);
    }

    private final void packUIs() {
        dialog.setTitle("Output to Screen/Text File Options");
        dialog.setDefaultCloseOperation(0);
        dialog.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent windowEvent) {
            }
        });
        dialog.setSize(400, 500);
        JPanel jPanel = (JPanel)dialog.getContentPane();
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.buildUIs();
        JPanel jPanel2 = new JPanel(true);
        JPanel jPanel3 = new JPanel(true);
        JLabeledPanel jLabeledPanel = new JLabeledPanel("Display Control", new GridLayout(2, 1));
        JLabeledPanel jLabeledPanel2 = new JLabeledPanel("Rows per Display", new GridLayout(1, 3));
        JLabeledPanel jLabeledPanel3 = new JLabeledPanel("Columns per Display", new GridLayout(1, 2));
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel(new GridLayout(2, 1));
        JPanel jPanel6 = new JPanel(new GridLayout(2, 3));
        this.tfRow.setHorizontalAlignment(0);
        this.tfRow.setText("" + this.cdfexport.ROWS);
        this.tfCol.setHorizontalAlignment(0);
        this.tfCol.setText("" + this.cdfexport.COLUMNS);
        jPanel4.add(new JLabel("Rows: "));
        jPanel4.add(this.tfRow);
        jLabeledPanel2.add(jPanel4);
        jLabeledPanel2.add(Box.createRigidArea(new Dimension(5, 1)));
        jLabeledPanel2.add(Box.createRigidArea(new Dimension(5, 1)));
        this.columnSome.setFont(this.boldFont);
        this.columnAll.setFont(this.boldFont);
        jPanel5.add(this.columnSome);
        jPanel5.add(this.columnAll);
        jPanel6.add(this.tfCol);
        jPanel6.add(Box.createRigidArea(new Dimension(5, 1)));
        jPanel6.add(Box.createRigidArea(new Dimension(5, 1)));
        jPanel6.add(Box.createRigidArea(new Dimension(5, 1)));
        jPanel6.add(Box.createRigidArea(new Dimension(5, 1)));
        jPanel6.add(Box.createRigidArea(new Dimension(5, 1)));
        jLabeledPanel.add(jLabeledPanel2);
        jLabeledPanel3.add(jPanel5);
        jLabeledPanel3.add(jPanel6);
        jLabeledPanel.add(jLabeledPanel3);
        this.tfRow.addActionListener(new XYListener());
        this.tfRow.setToolTipText("Number of rows per display. Avoid setting it too big!!!");
        this.tfCol.addActionListener(new XYListener());
        this.tfCol.setToolTipText("Number of columns per display.");
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Component component = Box.createRigidArea(new Dimension(20, 1));
        jPanel2.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.t0c, gridBagConstraints);
        jPanel2.add(this.t0c);
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(this.rnc, gridBagConstraints);
        jPanel2.add(this.rnc);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.ric, gridBagConstraints);
        jPanel2.add(this.ric);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.vhc, gridBagConstraints);
        jPanel2.add(this.vhc);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        jPanel2.add(component);
        JLabeledPanel jLabeledPanel4 = new JLabeledPanel("Orientation");
        jLabeledPanel4.setLayout(new BoxLayout(jLabeledPanel4, 1));
        jLabeledPanel4.setAlignmentY(0.0f);
        jLabeledPanel4.add(this.orientation1);
        jLabeledPanel4.add(this.orientation2);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabeledPanel4, gridBagConstraints);
        jPanel2.add(jLabeledPanel4);
        JLabeledPanel jLabeledPanel5 = new JLabeledPanel("Epoch");
        jLabeledPanel5.setLayout(new BoxLayout(jLabeledPanel5, 1));
        jLabeledPanel5.setAlignmentY(0.0f);
        jLabeledPanel5.add(this.epoch0);
        jLabeledPanel5.add(this.epoch1);
        jLabeledPanel5.add(this.epoch2);
        jLabeledPanel5.add(this.epoch3);
        jLabeledPanel5.add(this.epochx);
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(jLabeledPanel5, gridBagConstraints);
        jPanel2.add(jLabeledPanel5);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jLabeledPanel, gridBagConstraints);
        jPanel2.add(jLabeledPanel);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(Box.createVerticalStrut(20), gridBagConstraints);
        jPanel2.add(Box.createVerticalStrut(20));
        jPanel.add((Component)jPanel2, "Center");
        this.createButtonPanel(jPanel);
    }

    private final void buildUIs() {
        this.t0c = new JCheckBox("Translate -0.0 to 0.0", false);
        this.rnc = new JCheckBox("Show Record Number", true);
        this.ric = new JCheckBox("Show Indices", true);
        this.vhc = new JCheckBox("Show Variable Headings", true);
        OptionsListener optionsListener = new OptionsListener();
        this.t0c.addItemListener(optionsListener);
        this.t0c.setToolTipText("Translate -0.0 to 0.0 that VAXes or DEC Alpha/Open VMS can access");
        this.rnc.addItemListener(optionsListener);
        this.rnc.setToolTipText("Show the data value's record number in the output");
        this.ric.addItemListener(optionsListener);
        this.ric.setToolTipText("Show indices for data value (applicable only for vertical output)");
        this.vhc.addItemListener(optionsListener);
        this.vhc.setToolTipText("Show the headings for each variable in the output");
        this.orientationgp = new ButtonGroup();
        this.orientation1 = new JRadioButton("Vertical");
        this.orientation2 = new JRadioButton("Horizontal");
        OrientationListener orientationListener = new OrientationListener();
        this.orientation1.setActionCommand("0");
        this.orientation2.setActionCommand("1");
        this.orientation1.addActionListener(orientationListener);
        this.orientation2.addActionListener(orientationListener);
        this.orientation1.setSelected(true);
        this.orientationgp.add(this.orientation1);
        this.orientationgp.add(this.orientation2);
        this.orientation1.setToolTipText("Use vertical output orientation");
        this.orientation2.setToolTipText("Use horizontal output orientation... no record indices");
        this.columngp = new ButtonGroup();
        this.columnSome = new JRadioButton("Show Columns:");
        this.columnAll = new JRadioButton("Show All");
        this.columnSome.addActionListener(new ColumnListener());
        this.columnAll.addActionListener(new ColumnListener());
        this.columngp.add(this.columnSome);
        this.columngp.add(this.columnAll);
        this.columnSome.setSelected(true);
        this.columnSome.setToolTipText("Number of columns per display.");
        this.columnAll.setToolTipText("Show all columns in each scrollable display.");
        this.epochgp = new ButtonGroup();
        this.epoch0 = new JRadioButton("Standard");
        this.epoch1 = new JRadioButton("Epoch1");
        this.epoch2 = new JRadioButton("Epoch2");
        this.epoch3 = new JRadioButton("Epoch3");
        this.epochx = new JRadioButton("Epochx");
        EpochListener epochListener = new EpochListener();
        this.epoch0.setActionCommand("0");
        this.epoch1.setActionCommand("1");
        this.epoch2.setActionCommand("2");
        this.epoch3.setActionCommand("3");
        this.epochx.setActionCommand("5");
        this.epoch0.addActionListener(epochListener);
        this.epoch1.addActionListener(epochListener);
        this.epoch2.addActionListener(epochListener);
        this.epoch3.addActionListener(epochListener);
        this.epochx.addActionListener(epochListener);
        this.epoch0.setSelected(true);
        this.epochgp.add(this.epoch0);
        this.epochgp.add(this.epoch1);
        this.epochgp.add(this.epoch2);
        this.epochgp.add(this.epoch3);
        this.epochgp.add(this.epochx);
        this.epoch0.setToolTipText("Format: dd-mmm-yyyy hh:mm:ss.ccc");
        this.epoch1.setToolTipText("Format: yyyymmdd.ttttttt");
        this.epoch2.setToolTipText("Format: yyyymoddhhmmss");
        this.epoch3.setToolTipText("Format: yyyy-mo-ddThh:mm:ss.cccZ");
        this.epochx.setToolTipText("Use a user-defined string with tokens as format");
    }

    private final void createButtonPanel(JPanel jPanel) {
        JButton jButton = new JButton(ENTER);
        JButton jButton2 = new JButton(RESET);
        JButton jButton3 = new JButton(CANCEL);
        JPanel jPanel2 = new JPanel(true);
        jPanel2.add(jButton);
        jPanel2.add(Box.createRigidArea(new Dimension(20, 1)));
        jPanel2.add(jButton2);
        jPanel2.add(Box.createRigidArea(new Dimension(20, 1)));
        jPanel2.add(jButton3);
        SelectionListener selectionListener = new SelectionListener();
        jButton.addActionListener(selectionListener);
        jButton2.addActionListener(selectionListener);
        jButton3.addActionListener(selectionListener);
        jButton.setToolTipText("Continue to the next step ...");
        jButton2.setToolTipText("Reset the selections to their defaults...");
        jButton3.setToolTipText("Stop but keep the selections and retrun to the previous step...");
        jPanel.add((Component)jPanel2, "South");
    }

    public void reset() {
        this.t0c.setSelected(false);
        this.rnc.setSelected(true);
        this.ric.setSelected(true);
        this.vhc.setSelected(true);
        this.orientation1.setSelected(true);
        this.epoch0.setSelected(true);
        this.tfRow.setText("" + this.cdfexport.ROWS);
        this.tfCol.setText("" + this.cdfexport.COLUMNS);
        this.cdfexport.epoch = 0;
        this.cdfexport.trans0 = 0;
        this.cdfexport.recordNum = 1;
        this.cdfexport.indiceNum = 1;
        this.cdfexport.headings = 1;
        this.cdfexport.orientation = 0;
        this.cdfexport.ROWS = 26;
        this.cdfexport.COLUMNS = 9;
    }

    static /* synthetic */ String access$11() {
        return CANCEL;
    }

    static /* synthetic */ String access$13() {
        return ENTER;
    }

    static /* synthetic */ String access$14() {
        return RESET;
    }

    private final /* synthetic */ void this() {
        this.tfRow = new JTextField(3);
        this.tfCol = new JTextField(3);
        this.boldFont = new Font("Dialog", 1, 12);
    }

    private ExportGeneralOptions(JFrame jFrame, boolean bl) {
        super((Frame)jFrame, bl);
        this.this();
    }

    static {
        defaultModal = true;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class XYListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            block9: {
                Object object = actionEvent.getSource();
                if (object == ExportGeneralOptions.this.tfRow) {
                    try {
                        int n = Integer.parseInt(ExportGeneralOptions.this.tfRow.getText());
                        if (n < 0) {
                            Toolkit.getDefaultToolkit().beep();
                            ExportGeneralOptions.this.tfRow.setText("" + ((ExportGeneralOptions)ExportGeneralOptions.this).cdfexport.ROWS);
                            break block9;
                        }
                        ((ExportGeneralOptions)ExportGeneralOptions.this).cdfexport.ROWS = n;
                    }
                    catch (Exception exception) {
                        Toolkit.getDefaultToolkit().beep();
                        ExportGeneralOptions.this.tfRow.setText("" + ((ExportGeneralOptions)ExportGeneralOptions.this).cdfexport.ROWS);
                    }
                } else {
                    try {
                        int n = Integer.parseInt(ExportGeneralOptions.this.tfCol.getText());
                        if (n < 0) {
                            Toolkit.getDefaultToolkit().beep();
                            ExportGeneralOptions.this.tfCol.setText("" + ((ExportGeneralOptions)ExportGeneralOptions.this).cdfexport.COLUMNS);
                        } else {
                            ((ExportGeneralOptions)ExportGeneralOptions.this).cdfexport.COLUMNS = n;
                            ExportGeneralOptions.this.columnSome.setSelected(true);
                        }
                    }
                    catch (Exception exception) {
                        Toolkit.getDefaultToolkit().beep();
                        ExportGeneralOptions.this.tfCol.setText("" + ((ExportGeneralOptions)ExportGeneralOptions.this).cdfexport.COLUMNS);
                    }
                }
            }
        }

        private XYListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class OptionsListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (object == ExportGeneralOptions.this.t0c) {
                ((ExportGeneralOptions)ExportGeneralOptions.this).cdfexport.trans0 = ExportGeneralOptions.this.t0c.isSelected() ? -1 : 0;
            } else if (object == ExportGeneralOptions.this.rnc) {
                if (ExportGeneralOptions.this.rnc.isSelected()) {
                    ((ExportGeneralOptions)ExportGeneralOptions.this).cdfexport.recordNum = 1;
                    ((ExportGeneralOptions)ExportGeneralOptions.this).cdfexport.changedCDF = true;
                } else {
                    ((ExportGeneralOptions)ExportGeneralOptions.this).cdfexport.recordNum = 0;
                    ((ExportGeneralOptions)ExportGeneralOptions.this).cdfexport.changedCDF = true;
                }
            } else if (object == ExportGeneralOptions.this.ric) {
                if (ExportGeneralOptions.this.ric.isSelected()) {
                    if (ExportGeneralOptions.this.orientation2.isSelected()) {
                        Toolkit.getDefaultToolkit().beep();
                        ExportGeneralOptions.this.ric.setSelected(false);
                        return;
                    }
                    ((ExportGeneralOptions)ExportGeneralOptions.this).cdfexport.indiceNum = 1;
                    ((ExportGeneralOptions)ExportGeneralOptions.this).cdfexport.changedCDF = true;
                } else {
                    ((ExportGeneralOptions)ExportGeneralOptions.this).cdfexport.indiceNum = 0;
                    ((ExportGeneralOptions)ExportGeneralOptions.this).cdfexport.changedCDF = true;
                }
            } else if (object == ExportGeneralOptions.this.vhc) {
                ((ExportGeneralOptions)ExportGeneralOptions.this).cdfexport.headings = ExportGeneralOptions.this.vhc.isSelected() ? 1 : 0;
            }
        }

        private OptionsListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class OrientationListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ((ExportGeneralOptions)ExportGeneralOptions.this).cdfexport.orientation = Integer.parseInt(actionEvent.getActionCommand());
            if (((ExportGeneralOptions)ExportGeneralOptions.this).cdfexport.orientation == 1) {
                ExportGeneralOptions.this.ric.setSelected(false);
                ((ExportGeneralOptions)ExportGeneralOptions.this).cdfexport.indiceNum = 0;
            } else {
                ExportGeneralOptions.this.ric.setSelected(true);
                ((ExportGeneralOptions)ExportGeneralOptions.this).cdfexport.indiceNum = 1;
            }
        }

        private OrientationListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ColumnListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
            if (jRadioButton == ExportGeneralOptions.this.columnSome) {
                ((ExportGeneralOptions)ExportGeneralOptions.this).cdfexport.COLUMNS = ExportGeneralOptions.this.oldCol;
                ExportGeneralOptions.this.tfCol.setText("" + ((ExportGeneralOptions)ExportGeneralOptions.this).cdfexport.COLUMNS);
            } else {
                ExportGeneralOptions.this.oldCol = ((ExportGeneralOptions)ExportGeneralOptions.this).cdfexport.COLUMNS;
                ((ExportGeneralOptions)ExportGeneralOptions.this).cdfexport.COLUMNS = 0;
                ExportGeneralOptions.this.tfCol.setText(" ");
            }
        }

        private ColumnListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class EpochListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ((ExportGeneralOptions)ExportGeneralOptions.this).cdfexport.epoch = Integer.parseInt(actionEvent.getActionCommand());
        }

        private EpochListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class SelectionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            block13: {
                Object object = actionEvent.getSource();
                if (object instanceof JButton) {
                    String string = actionEvent.getActionCommand();
                    if (string.equals(ExportGeneralOptions.CANCEL)) {
                        dialog.setVisible(false);
                        ExportGeneralOptions.this.cdfexport.repaint();
                    } else if (string.equals(ExportGeneralOptions.ENTER)) {
                        try {
                            int n = Integer.parseInt(ExportGeneralOptions.this.tfRow.getText());
                            int n2 = ExportGeneralOptions.this.columnSome.isSelected() ? Integer.parseInt(ExportGeneralOptions.this.tfCol.getText()) : 0;
                            if (n < 0 || n2 < 0) {
                                Toolkit.getDefaultToolkit().beep();
                                if (n < 0) {
                                    ExportGeneralOptions.this.tfRow.setText("" + ((ExportGeneralOptions)ExportGeneralOptions.this).cdfexport.ROWS);
                                }
                                if (n2 < 0) {
                                    ExportGeneralOptions.this.tfCol.setText("" + ((ExportGeneralOptions)ExportGeneralOptions.this).cdfexport.COLUMNS);
                                }
                                break block13;
                            }
                            if (n != ((ExportGeneralOptions)ExportGeneralOptions.this).cdfexport.ROWS) {
                                ((ExportGeneralOptions)ExportGeneralOptions.this).cdfexport.ROWS = n;
                            }
                            if (n2 != ((ExportGeneralOptions)ExportGeneralOptions.this).cdfexport.COLUMNS) {
                                ((ExportGeneralOptions)ExportGeneralOptions.this).cdfexport.COLUMNS = n2;
                            }
                            dialog.setVisible(false);
                            ExportGeneralOptions.this.cdfexport.repaint();
                        }
                        catch (Exception exception) {
                            Toolkit.getDefaultToolkit().beep();
                            ExportGeneralOptions.this.tfRow.setText("" + ((ExportGeneralOptions)ExportGeneralOptions.this).cdfexport.ROWS);
                            ExportGeneralOptions.this.tfCol.setText("" + ((ExportGeneralOptions)ExportGeneralOptions.this).cdfexport.COLUMNS);
                        }
                    } else if (string.equals(ExportGeneralOptions.RESET)) {
                        ExportGeneralOptions.this.reset();
                    }
                }
            }
        }

        private SelectionListener() {
        }
    }
}

