#!/usr/bin/perl -w

use strict;
use Math::BigInt;
use Data::Dumper;

BEGIN { unshift @INC,$ENV{"HOME"}.'/PerlCDF39_1/blib/arch',
                     $ENV{"HOME"}.'/PerlCDF39_1/blib/lib'; }
use CDF;

my $id;
my $status;
my %tatal;
$status = CDF::CDFlib (&OPEN_, &CDF_, $ARGV[0], \$id,
		       &NULL_);
QuitCDF ("1.0", $status) if ($status < &CDF_OK);
my %cdf;
my @vars = ();
if (scalar(@ARGV) > 1) {
          my $haveVars = $ARGV[1];
          if (ref($haveVars) eq "ARRAY") {
            @vars = $ARGV[1];
          } else {
            if ($haveVars ne "ALL") {
              @vars = split(',', $haveVars);
            }
          }
}
if ($#vars > -1) {
  print "var=$vars[0] \n";
}
if (scalar(@ARGV) > 4) {
  ($status, %cdf) = CDF::CDFreadCDF($id, $ARGV[1], $ARGV[2], $ARGV[3], $ARGV[4]);
#  ($status, %cdf) = CDF::CDFreadCDF($id, \@vars, $ARGV[2], $ARGV[3], $ARGV[4]);
} elsif (scalar(@ARGV) > 3) {
#  ($status, %cdf) = CDF::CDFreadCDF($ARGV[0], $ARGV[1], $ARGV[2], $ARGV[3]);
   ($status, %cdf) = CDF::CDFreadCDF($id, \@vars, $ARGV[2], $ARGV[3]);
} elsif (scalar(@ARGV) > 2) {
#  ($status, %cdf) = CDF::CDFreadCDF($ARGV[0], $ARGV[1], $ARGV[2]);
   ($status, %cdf) = CDF::CDFreadCDF($id, \@vars, $ARGV[2]);
} elsif (scalar(@ARGV) > 1) {
#  ($status, %cdf) = CDF::CDFreadCDF($ARGV[0], $ARGV[1]);
   ($status, %cdf) = CDF::CDFreadCDF($id, \@vars);
} else {
#  ($status, %cdf) = CDF::CDFreadCDF($ARGV[0]);
   ($status, %cdf) = CDF::CDFreadCDF($id);
}

if ($status == &CDF_OK) {
#  print Dumper(\%cdf);
  my ($key, $value);
  while ( ($key, $value) = each %cdf) {
    print $key . "\n";
    if ($key eq "Variables") {
      my ($key2, $value2);
      while ( ($key2, $value2) = each %$value) {
        print "**** Var:" . $key2 . "\n";
        my ($key3, $value3);
        while ( ($key3, $value3) = each %$value2) {
          print $key3 . "\n";
          print Dumper(\$value3);
        }
      }
    } else {
      print Dumper(\$value);
    }
  }
} else {
  QuitCDF ("2.0", $status);
}

#$status = CDF::CDFlib (&CLOSE_, &CDF_,
#		       &NULL_);
#QuitCDF ("3.0", $status) if ($status < &CDF_OK) ;

exit;

#############################################################################
# QuitCDF.
#############################################################################
sub QuitCDF {
	my ($where, $status)=@_;

  print "Aborting at $where ...\n";
  if ($status < &CDF_OK) {
    my $text;
    CDF::CDFlib (&SELECT_, &CDF_STATUS_, $status,
		   &GET_, &STATUS_TEXT_, \$text,
		   &NULL_);
    print $text;
  }
  CDF::CDFlib (&CLOSE_, &CDF_,
	  &NULL_);
  print "...test aborted.\n";
  exit;
	
}#endsub QuitCDF

