#!/usr/bin/perl -w

use strict;
use Math::BigInt;
use Data::Dumper;

BEGIN { unshift @INC,$ENV{"HOME"}.'/PerlCDF39_1/blib/arch',
                     $ENV{"HOME"}.'/PerlCDF39_1/blib/lib'; }
use CDF;

my $id;
my $status;
$status = CDF::CDFlib (&OPEN_, &CDF_, $ARGV[0], \$id,
		       &NULL_);
QuitCDF ("1.0", $status) if ($status < &CDF_OK) ;

my $md5;
$status = CDF::CDFgetChecksum ($id, \$md5);

print "status=$status checksum = $md5\n";
my %meta;

print "global 1....\n";
($status, %meta) = CDF::CDFgetGlobalMetaData($id, 0);

if ($status == &CDF_OK && %meta ) {
  print Dumper(\%meta);
} else {
  if ($status != 0) {
    QuitCDF ("2.0", $status);
  }
}
print "global 2....\n";
($status, %meta) = CDF::CDFgetGlobalMetaData($ARGV[0], 0);

if ($status == &CDF_OK && %meta ) {
  print Dumper(\%meta);
} else {
  if ($status != 0) {
    QuitCDF ("3.0", $status);
  }
}
if ($#ARGV > 0) {
  print "variable 1....\n";

  ($status, %meta) = CDF::CDFgetVarMetaData($id, $ARGV[1], 0);

  if ($status == &CDF_OK && %meta) {
    print Dumper(\%meta);
  } else {
    if ($status != 0) {
      QuitCDF ("4.0", $status);
    }
  }
}
if ($#ARGV > 1) {
  print "variable 2....\n";
  ($status, %meta) = CDF::CDFgetVarMetaData($id, $ARGV[2], 0);

  if ($status == &CDF_OK && %meta) {
    print Dumper(\%meta);
  } else {
    if ($status != 0) {
      QuitCDF ("5.0", $status);
    }
  }
}
$status = CDF::CDFlib (&CLOSE_, &CDF_,
		       &NULL_);
QuitCDF ("6.0", $status) if ($status < &CDF_OK) ;

exit;

#############################################################################
# QuitCDF.
#############################################################################
sub QuitCDF {
	my ($where, $status)=@_;

  if ($status < &CDF_OK) {
    my $text;
    CDF::CDFlib (&SELECT_, &CDF_STATUS_, $status,
		   &GET_, &STATUS_TEXT_, \$text,
		   &NULL_);
    print $text;
  }
  CDF::CDFlib (&CLOSE_, &CDF_,
	  &NULL_);
  print "...test aborted.\n";
  exit;
	
}#endsub QuitCDF

