# NOTE: Derived from blib/lib/CDF.pm.
# Changes made here will be lost when autosplit is run again.
# See AutoSplit.pm.
package CDF;

#line 2493 "blib/lib/CDF.pm (autosplit into blib/lib/auto/CDF/CDFgetVarInfo.al)"
sub CDFgetVarInfo {
        use strict;
        my @args = @_;
        my $cdf = $args[0];
        my $var = $args[1];
        my $id;
        my ($toClose, $varNum, $status, $dataType, $numElems, $sparse);
        my ($numDims, $recVary, $maxRec, $varName, $zMode, $numRecs);
        my (@dimSizes, @dimVarys);
        my %varInfo;
        $toClose = 0;
        if ($cdf =~ /^\d+$/) {
          $status = CDFlib(&SELECT_, &CDF_, $cdf,
                           &NULL_);
          if ($status != &CDF_OK) {
            $status = CDFlib(&OPEN_, &CDF_, $cdf, \$id,
                             &NULL_);
            $toClose = 1;
          }
        } else {
          $status = CDFlib(&OPEN_, &CDF_, $cdf, \$id,
                           &NULL_);
          $toClose = 1;
        }
        if ($status != &CDF_OK) {
          return ($status, ());
        }
        $status = CDFlib(&CONFIRM_, &CDF_zMODE_, \$zMode,
                         &SELECT_, &CDF_zMODE_, &zMODEon2,
                         &NULL_);
        if ($status != &CDF_OK) {
          if ($toClose == 1) {
            $status = CDFlib(&CLOSE_, &CDF_, &NULL_);
          }
          return ($status, ());
        }
        my $check = 0;
        if ($var =~ /^\d+$/) {
          $varNum = $var;
          $status = CDFlib(&SELECT_, &zVAR_, $varNum,
                           &GET_, &zVAR_NAME_, \$varName,
                           &NULL_);
          if ($status == &CDF_OK) {
            $check++;
          }
        }
        if ($check == 0) {
          $varName = $var;
          $status = CDFlib(&GET_, &zVAR_NUMBER_, $varName, \$varNum,
                           &NULL_);
          if ($status != &CDF_OK) {
            if ($toClose == 1) {
              $status = CDFlib(&CLOSE_, &CDF_, &NULL_);
            }
            return (&BAD_VAR_NAME, ());
          }
        }
        $status = CDFlib (&SELECT_, &zVAR_, $varNum,
                          &GET_, &zVAR_DATATYPE_, \$dataType,
                                 &zVAR_NUMELEMS_, \$numElems,
                                 &zVAR_NUMDIMS_, \$numDims,
                                 &zVAR_DIMSIZES_, \@dimSizes,
                                 &zVAR_DIMVARYS_, \@dimVarys,
                                 &zVAR_RECVARY_, \$recVary,
                                 &zVAR_MAXREC_, \$maxRec,
                                 &zVAR_NUMRECS_, \$numRecs,
                                 &zVAR_SPARSERECORDS_, \$sparse,
                          &NULL_);
        if ($status != &CDF_OK) {
          if ($toClose == 1) {
            $status = CDFlib(&CLOSE_, &CDF_, &NULL_);
          }
          return ($status, ());
        }
#       $varInfo{"DataType"} = getStringDataType($dataType);
        $varInfo{"DataType"} = $dataType;
        $varInfo{"NumElems"} = $numElems;
        $varInfo{"NumDims"} = $numDims;
        if ($numDims > 0) {
          my $i;
          for ($i = 0; $i < $numDims; $i++) {
            $varInfo{"DimSizes"}{$i} = $dimSizes[$i];
          }
          for ($i = 0; $i < $numDims; $i++) {
            $varInfo{"DimVarys"}{$i} = $dimVarys[$i]==0?"False":"True";
          }
        }
        $varInfo{"RecVary"} = $recVary==0?"False":"True";
        $varInfo{"VarName"} = $varName;
        $varInfo{"NumWrittenRecs"} = $numRecs;
        if ($numRecs > 0 && $sparse != &NO_SPARSERECORDS) {
          $varInfo{"MaxRec"} = $maxRec;
#         $varInfo{"SparseRecords"} = getSparseness($sparse);
          $varInfo{"SparseRecords"} = $sparse;
        }
        if ($toClose == 1) {
          $status = CDFlib(&CLOSE_, &CDF_, &NULL_);
        } else {
          $status = CDFlib (&SELECT_, &CDF_zMODE_, $zMode,
                            &NULL_);
        }
        return (&CDF_OK, %varInfo);
}#end sub CDFgetVarInfo

# end of CDF::CDFgetVarInfo
1;
