/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.Entry;
import gsfc.nssdc.cdf.util.CDFUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Array;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class EditAttrEntryDialog
extends JDialog
implements CDFConstants,
ActionListener {
    static final long serialVersionUID = 1L;
    private EditAttrEntryPanel myPanel;
    private JLabeledTF tfen;
    private JLabeledTF tfne;
    private JLabeledTF tfva;
    private JLabeledCB cbdt;
    private JTextField jtfen;
    private JTextField jtfne;
    private JTextField jtfva;
    private JFrame myFrame;
    private JButton enter;
    private JButton cancel;
    private JButton reset;
    private static final String ENTER = "Modify";
    private static final String RESET = "Reset";
    private static final String CANCEL = "End";
    private static EditAttrEntryDialog cache;
    private long scope;
    private long dataType;
    private long numElements;
    private Entry entry = null;
    private String outData;
    private Dimension ss;
    private Dimension ps;

    private EditAttrEntryDialog() {
    }

    private EditAttrEntryDialog(EditAttrEntryPanel editAttrEntryPanel) {
        super((Frame)editAttrEntryPanel.getMyEditor().getFrame(), true);
        this.myFrame = editAttrEntryPanel.getMyEditor().getFrame();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.getContentPane().add(jPanel);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
            }
        });
        this.ss = Toolkit.getDefaultToolkit().getScreenSize();
        this.ps = this.getPreferredSize();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(gridBagLayout);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jtfen = new JTextField(20);
        this.tfen = new JLabeledTF("Variable Name", this.jtfen, false);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.tfen, gridBagConstraints);
        jPanel2.add(this.tfen);
        Vector<String> vector = new Vector<String>(17);
        vector.addElement("CDF_BYTE");
        vector.addElement("CDF_INT1");
        vector.addElement("CDF_UINT1");
        vector.addElement("CDF_INT2");
        vector.addElement("CDF_UINT2");
        vector.addElement("CDF_INT4");
        vector.addElement("CDF_UINT4");
        vector.addElement("CDF_INT8");
        vector.addElement("CDF_REAL4");
        vector.addElement("CDF_FLOAT");
        vector.addElement("CDF_REAL8");
        vector.addElement("CDF_DOUBLE");
        vector.addElement("CDF_EPOCH");
        vector.addElement("CDF_EPOCH16");
        vector.addElement("CDF_TIME_TT2000");
        vector.addElement("CDF_CHAR");
        vector.addElement("CDF_UCHAR");
        this.cbdt = new JLabeledCB("Data Type", vector, false, true);
        this.cbdt.comboBox.setToolTipText("Select the data type");
        this.cbdt.comboBox.addActionListener(this);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.cbdt, gridBagConstraints);
        jPanel2.add(this.cbdt);
        this.jtfne = new JTextField(3);
        this.tfne = new JLabeledTF("NumElements", this.jtfne, true);
        this.tfne.textField.setToolTipText("Enter the number of elements.");
        this.tfne.setEnabled(true);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.tfne, gridBagConstraints);
        jPanel2.add(this.tfne);
        this.jtfva = new JTextField(40);
        this.tfva = new JLabeledTF("Data", this.jtfva, true);
        this.tfva.textField.setToolTipText("Modify the entry data. Use \",\" to separate multiple values");
        this.jtfva.addActionListener(new ActionValue());
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.tfva, gridBagConstraints);
        jPanel2.add(this.tfva);
        jPanel.add((Component)jPanel2, "Center");
        this.createButtonPanel(jPanel);
        this.setResizable(false);
        this.setSize(430, 300);
        this.pack();
        this.setLocation(10, 20);
    }

    private void createButtonPanel(JPanel jPanel) {
        JPanel jPanel2 = new JPanel();
        this.enter = new JButton(ENTER);
        this.enter.addActionListener(this);
        this.enter.setToolTipText("Apply the change");
        jPanel2.add(this.enter);
        this.reset = new JButton(RESET);
        this.reset.addActionListener(this);
        this.reset.setToolTipText("Rest the fields to their original values");
        jPanel2.add(this.reset);
        this.cancel = new JButton(CANCEL);
        this.cancel.setToolTipText("End the change");
        this.cancel.addActionListener(this);
        jPanel2.add(this.cancel);
        jPanel.add((Component)jPanel2, "South");
    }

    public static void editEntry(EditAttrEntryPanel editAttrEntryPanel, String string) {
        if (cache == null) {
            cache = new EditAttrEntryDialog(editAttrEntryPanel);
        }
        try {
            EditAttrEntryDialog.cache.myPanel = editAttrEntryPanel;
            EditAttrEntryDialog.cache.scope = editAttrEntryPanel.getScope();
            EditAttrEntryDialog.cache.entry = editAttrEntryPanel.getSelectedEntry();
            EditAttrEntryDialog.cache.dataType = EditAttrEntryDialog.cache.entry.getDataType();
            EditAttrEntryDialog.cache.numElements = EditAttrEntryDialog.cache.entry.getNumElements();
            if (EditAttrEntryDialog.cache.scope == 1L) {
                EditAttrEntryDialog.cache.tfen.setMaxLength(3);
                EditAttrEntryDialog.cache.tfen.setLabel("Entry Number");
            } else {
                EditAttrEntryDialog.cache.tfen.setMaxLength(30);
                EditAttrEntryDialog.cache.tfen.setLabel("Variable Name");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        cache.reset();
        cache.setTitle(string);
        cache.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JComboBox) {
            long l;
            String string = (String)((JComboBox)object).getSelectedItem();
            switch (this.cbdt.comboBox.getSelectedIndex()) {
                case 0: {
                    l = 41L;
                    break;
                }
                case 1: {
                    l = 1L;
                    break;
                }
                case 2: {
                    l = 11L;
                    break;
                }
                case 3: {
                    l = 2L;
                    break;
                }
                case 4: {
                    l = 12L;
                    break;
                }
                case 5: {
                    l = 4L;
                    break;
                }
                case 6: {
                    l = 14L;
                    break;
                }
                case 7: {
                    l = 8L;
                    break;
                }
                case 8: {
                    l = 21L;
                    break;
                }
                case 9: {
                    l = 44L;
                    break;
                }
                case 10: {
                    l = 22L;
                    break;
                }
                case 11: {
                    l = 45L;
                    break;
                }
                case 12: {
                    l = 31L;
                    break;
                }
                case 13: {
                    l = 32L;
                    break;
                }
                case 14: {
                    l = 33L;
                    break;
                }
                case 15: {
                    l = 51L;
                    break;
                }
                case 16: {
                    l = 52L;
                    break;
                }
                default: {
                    l = 41L;
                }
            }
            if (l != this.dataType) {
                if (!(this.dataType != 51L && this.dataType != 51L || l != 41L && l != 1L && l != 11L)) {
                    byte[] byArray;
                    String string2 = (String)this.tfva.get();
                    string2 = string2.substring(1, string2.length() - 1);
                    StringBuffer stringBuffer = new StringBuffer();
                    try {
                        byArray = string2.getBytes("UTF-8");
                    }
                    catch (Exception exception) {
                        byArray = string2.getBytes();
                    }
                    for (int i = 0; i < Array.getLength(byArray); ++i) {
                        if (i > 0) {
                            stringBuffer.append(",");
                        }
                        int n = byArray[i];
                        if (l == 11L && n < 0) {
                            n += 256;
                        }
                        stringBuffer.append(n);
                    }
                    stringBuffer.setLength(stringBuffer.length() - 1);
                    this.tfva.set(stringBuffer.toString());
                    this.outData = (String)this.tfva.get();
                } else if (!(this.dataType != 41L && this.dataType != 1L && this.dataType != 11L || l != 51L && l != 51L)) {
                    String string3 = ((String)this.tfva.get()).trim();
                    StringBuffer stringBuffer = new StringBuffer();
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                    if (stringTokenizer.countTokens() == -1) {
                        int n = Integer.parseInt(string3);
                        if (this.dataType == 11L) {
                            n = n < 0 ? n - -256 : n;
                        }
                        stringBuffer.append(n);
                    } else {
                        while (stringTokenizer.hasMoreTokens()) {
                            String string4 = stringTokenizer.nextToken().trim();
                            int n = Integer.parseInt(string4);
                            if (this.dataType == 11L) {
                                n = n < 0 ? n - -256 : n;
                            }
                            stringBuffer.append(n);
                        }
                    }
                    this.tfva.set("\"" + stringBuffer.toString() + "\"");
                    this.outData = (String)this.tfva.get();
                }
            }
        } else if (object instanceof JButton) {
            String string = actionEvent.getActionCommand();
            if (string.equals(CANCEL)) {
                this.entry = null;
                this.setVisible(false);
                this.dispose();
                System.gc();
            } else if (string.equals(RESET)) {
                cache.reset();
            } else if (string.equals(ENTER)) {
                long l;
                String string5;
                long l2;
                ((JButton)object).setEnabled(false);
                Object var6_9 = null;
                switch (this.cbdt.comboBox.getSelectedIndex()) {
                    case 0: {
                        l2 = 41L;
                        break;
                    }
                    case 1: {
                        l2 = 1L;
                        break;
                    }
                    case 2: {
                        l2 = 11L;
                        break;
                    }
                    case 3: {
                        l2 = 2L;
                        break;
                    }
                    case 4: {
                        l2 = 12L;
                        break;
                    }
                    case 5: {
                        l2 = 4L;
                        break;
                    }
                    case 6: {
                        l2 = 14L;
                        break;
                    }
                    case 7: {
                        l2 = 8L;
                        break;
                    }
                    case 8: {
                        l2 = 21L;
                        break;
                    }
                    case 9: {
                        l2 = 44L;
                        break;
                    }
                    case 10: {
                        l2 = 22L;
                        break;
                    }
                    case 11: {
                        l2 = 45L;
                        break;
                    }
                    case 12: {
                        l2 = 31L;
                        break;
                    }
                    case 13: {
                        l2 = 32L;
                        break;
                    }
                    case 14: {
                        l2 = 33L;
                        break;
                    }
                    case 15: {
                        l2 = 51L;
                        break;
                    }
                    case 16: {
                        l2 = 52L;
                        break;
                    }
                    default: {
                        l2 = 41L;
                    }
                }
                String string6 = string5 = ((String)this.tfva.get()).trim();
                if (l2 == 51L || l2 == 52L) {
                    if (string6.charAt(0) == '\"') {
                        string6 = string6.substring(1, string6.length() - 1);
                    }
                    l = string6.length();
                } else {
                    StringTokenizer stringTokenizer = new StringTokenizer(string6, ",");
                    l = stringTokenizer.countTokens();
                }
                if (l2 != this.dataType && string5.equals(this.outData)) {
                    boolean bl = CDFToolUtils.equivalentDataTypes(this.dataType, l2);
                    if (!bl) {
                        Toolkit.getDefaultToolkit().beep();
                        JOptionPane.showMessageDialog(this.myFrame, "Data Type Error:\nExisting and New Data Type not Equivalent", "MYEditor: CDFException", 0);
                        this.reset();
                    } else {
                        try {
                            this.entry.updateDataSpec(l2, l);
                            this.dataType = l2;
                        }
                        catch (CDFException cDFException) {
                            Toolkit.getDefaultToolkit().beep();
                            JOptionPane.showMessageDialog(this.myFrame, CDFException.getStatusMsg((long)cDFException.getCurrentStatus()), "MYEditor: Error", 0);
                            this.cbdt.set(CDFUtils.getStringDataType((long)this.dataType));
                        }
                    }
                } else {
                    try {
                        this.entry.putData(l2, CDFToolUtils.parseContents(string6, l2));
                        this.dataType = l2;
                        this.tfne.set("" + l);
                    }
                    catch (CDFException cDFException) {
                        Toolkit.getDefaultToolkit().beep();
                        JOptionPane.showMessageDialog(this.myFrame, CDFException.getStatusMsg((long)cDFException.getCurrentStatus()), "MYEditor: Error", 0);
                    }
                    catch (NumberFormatException numberFormatException) {
                        Toolkit.getDefaultToolkit().beep();
                        JOptionPane.showMessageDialog(this.myFrame, numberFormatException.toString(), "MYEditor: CDFException", 0);
                    }
                }
                ((JButton)object).setEnabled(true);
            }
        }
    }

    private void reset() {
        if (this.scope == 1L) {
            this.tfen.set("" + (this.entry.getID() + 1L));
        } else if (this.entry != null) {
            try {
                this.tfen.set(this.myPanel.getMyEditor().theCDF.getVariable(this.entry.getID()).getName());
            }
            catch (CDFException cDFException) {
                System.err.println("Error: entry" + this.entry);
            }
        } else {
            JList jList = (JList)this.myPanel.controls.get("listOfEntries");
            this.tfen.set((String)jList.getSelectedValue());
        }
        this.cbdt.set(CDFUtils.getStringDataType((Entry)this.entry));
        this.tfne.set("" + this.numElements);
        try {
            if (this.dataType == 51L || this.dataType == 52L) {
                this.tfva.set("\"" + CDFUtils.getStringData((Object)this.entry.getData(), (String)", ") + "\"");
            } else {
                int n = this.dataType == 31L ? 1 : (this.dataType == 32L ? 2 : 0);
                this.tfva.set(CDFUtils.getStringData((Object)this.entry.getData(), (String)", ", (int)n));
            }
        }
        catch (CDFException cDFException) {
            // empty catch block
        }
        this.outData = (String)this.tfva.get();
        this.tfva.requestFocus();
        this.tfen.setEnabled(true);
        this.tfen.setEditable(false);
        this.tfne.setEditable(false);
    }

    class ActionValue
    implements ActionListener {
        ActionValue() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EditAttrEntryDialog.this.jtfva = (JTextField)actionEvent.getSource();
            if (EditAttrEntryDialog.this.dataType == 51L || EditAttrEntryDialog.this.dataType == 52L) {
                if (((String)EditAttrEntryDialog.this.tfva.get()).charAt(0) == '\"') {
                    EditAttrEntryDialog.this.tfne.set("" + (((String)EditAttrEntryDialog.this.tfva.get()).length() - 2));
                } else {
                    EditAttrEntryDialog.this.tfne.set("" + ((String)EditAttrEntryDialog.this.tfva.get()).length());
                }
            } else {
                String string = (String)EditAttrEntryDialog.this.tfva.get();
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                EditAttrEntryDialog.this.tfne.set("" + stringTokenizer.countTokens());
            }
        }
    }
}

