/******************************************************************************
* Copyright 1996-2014 United States Government as represented by the
* Administrator of the National Aeronautics and Space Administration.
* All Rights Reserved.
******************************************************************************/

import javax.swing.*;
/**
 * Runnable object to update the progress bar.
 */

public class GoodWorker implements Runnable {
     private Object which;
     private int currentProgressValue;

     GoodWorker(Object obj, int currentProgressValue) {
        which = obj;
	this.currentProgressValue = currentProgressValue;
     }

     public void run() {
	if (which != null) {
          if (which instanceof ExportToText) {
	     BuildProgressPanel bpp = ((ExportToText)which).getProgressPanel(); 
	     if (bpp != null) {
		JProgressBar pb = bpp.getProgressBar();
		if (pb != null) pb.setValue(currentProgressValue);
	     }
//             ((ExportToText)which).getProgressPanel().getProgressBar().setValue(
//					currentProgressValue);
	  } else if (which instanceof ExportCreateCDF) {
             BuildProgressPanel bpp = ((ExportCreateCDF)which).getProgressPanel(); 
             if (bpp != null) {
                JProgressBar pb = bpp.getProgressBar();
                if (pb != null) pb.setValue(currentProgressValue);
             }
//	     ((ExportCreateCDF)which).getProgressPanel().getProgressBar().setValue(
//					currentProgressValue);
	  }
	}
     }
};


