//$Id: EditAttrEntriesAction.java,v 1.1.1.1 2023/08/01 12:28:28 mhliu Exp $
/******************************************************************************
* Copyright 1996-2014 United States Government as represented by the
* Administrator of the National Aeronautics and Space Administration.
* All Rights Reserved.
******************************************************************************/

import javax.swing.*;

import java.awt.Cursor;
import java.awt.event.*;
import java.lang.*;
import java.util.Vector;
import java.util.Enumeration;

import gsfc.nssdc.cdf.*;

/**
 * For future use.
 *
 * @author Phil Williams
 * @version $Revision: 1.1.1.1 $
 */

public class EditAttrEntriesAction extends AbstractAction {
    
    private static final String DEFAULT_NAME = "Edit Attribute";

    private MYEditor myEditor;
    private AttributePanel myAttrPanel;

    static final long serialVersionUID = 1L;

    public EditAttrEntriesAction(AttributePanel myAttrPanel, char gORv) {
	this(myAttrPanel, "Edit "+gORv+"Attribute");
    }

    public EditAttrEntriesAction(AttributePanel myAttrPanel, String name) {
	super(name);
	this.myAttrPanel = myAttrPanel;
	myEditor = myAttrPanel.getMyEditor();
    }

    public void putValue(String key, Object value) {
	if (value != null)
	    super.putValue(key, value);
    }

    public void actionPerformed(ActionEvent event) {
	myEditor.setWaitCursor();
	EditAttrEntryPanel entryPanel = new EditAttrEntryPanel(myAttrPanel);
	myEditor.setDefaultCursor();
    }
    
} // EditAttrEntriesAction
