/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.Attribute;
import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.Entry;
import gsfc.nssdc.cdf.Variable;
import gsfc.nssdc.cdf.util.CDFTT2000;
import gsfc.nssdc.cdf.util.CDFUtils;
import gsfc.nssdc.cdf.util.Epoch;
import gsfc.nssdc.cdf.util.Epoch16;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonValue;

public class Json2CDF
implements CDFConstants {
    private static boolean progress = false;
    private static boolean delete = false;
    private static boolean showfile = false;
    private static boolean toCompress = true;
    private static boolean checksum = false;
    private static String inFile = null;
    private static String assignedFile = null;
    private static String outDir = null;
    private static int numFiles = 0;
    private static long dataType;
    private static long numElements;
    private static boolean varData;
    private static long varDataType;
    private static long varNumElems;
    private static long varNumDims;
    private static long varSparseRec;
    private static long varNumWritten;
    private static long varMaxWritten;
    private static long[] varDimSizes;
    private static long[] varDimVariances;
    private static String varName;
    private static Object varPadValue;
    private static Object varFillVal;
    private static long varRecVary;
    private static String separator;
    private static String item1;
    private static String item2;
    private static String item3;
    private static String item4;
    private static String item5;
    private static String item6;
    private static String item7;
    private static String vAttrName;
    private static long dataTypeY;

    public static void main(String[] stringArray) throws IOException {
        try {
            Json2CDF.parseCmdLine(stringArray);
            if (showfile) {
                System.out.println(inFile);
            }
            FileInputStream fileInputStream = new FileInputStream(inFile);
            JsonReader jsonReader = Json.createReader((InputStream)fileInputStream);
            JsonObject jsonObject = jsonReader.readObject();
            jsonReader.close();
            ((InputStream)fileInputStream).close();
            numFiles = jsonObject.keySet().size();
            for (String string : jsonObject.keySet()) {
                Json2CDF.outPutJsonObject(string, jsonObject.getJsonObject(string));
            }
        }
        catch (Exception exception) {
            System.out.println("Exception... " + exception);
        }
    }

    private static void outPutJsonObject(String object, JsonObject jsonObject) {
        long l = -1L;
        long l2 = -1L;
        long l3 = -1L;
        long l4 = 0L;
        CDF cDF = null;
        Variable variable = null;
        Object object2 = null;
        try {
            JsonArray jsonArray;
            JsonArray jsonArray2;
            Object object3;
            JsonArray jsonArray3 = jsonObject.getJsonArray(item1);
            if (jsonArray3 != null) {
                int n;
                if (progress) {
                    System.out.println(item1 + ":");
                }
                for (Object object4 : jsonArray3) {
                    for (Object object5 : ((JsonObject)object4).keySet()) {
                        Object object6 = ((JsonObject)object4).getString((String)object5);
                        if (progress) {
                            System.out.println("  " + (String)object5 + ":" + (String)object6);
                        }
                        if (((String)object5).equalsIgnoreCase("filename")) {
                            object = object6;
                            continue;
                        }
                        if (((String)object5).equalsIgnoreCase("format")) {
                            l = CDFUtils.getLongFormat((String)object6);
                            continue;
                        }
                        if (((String)object5).equalsIgnoreCase("majority")) {
                            l2 = CDFUtils.getLongMajority((String)object6);
                            continue;
                        }
                        if (((String)object5).equalsIgnoreCase("encoding")) {
                            l3 = CDFUtils.getLongEncoding((String)object6);
                            continue;
                        }
                        if (!((String)object5).equalsIgnoreCase("checksum")) continue;
                        l4 = CDFUtils.getLongChecksum((String)object6);
                    }
                }
                object3 = null;
                if (delete) {
                    int n2;
                    Object object4;
                    object3 = outDir == null ? (numFiles == 1 && assignedFile != null ? assignedFile : object) : (numFiles == 1 && assignedFile != null ? outDir + separator + assignedFile : ((n2 = ((String)object).lastIndexOf(separator)) != -1 ? outDir + separator + ((String)object).substring(n2 + 1) : outDir + separator + (String)object));
                    object4 = new File((String)object3);
                    if (((File)object4).exists()) {
                        ((File)object4).delete();
                    }
                }
                object2 = outDir == null ? (numFiles == 1 && assignedFile != null ? assignedFile : object) : (numFiles == 1 && assignedFile != null ? outDir + separator + assignedFile : ((n = ((String)object).lastIndexOf(separator)) != -1 ? outDir + separator + ((String)object).substring(n + 1) : outDir + separator + (String)object));
                cDF = CDF.create((String)object2);
                cDF.setFormat(l);
                cDF.setMajority(l2);
                cDF.setEncoding(l3);
                if (checksum || l4 == 1L) {
                    cDF.setChecksum(1L);
                }
            }
            if ((object3 = jsonObject.getJsonArray(item2)) != null) {
                if (progress) {
                    System.out.println(item2 + ":");
                }
                Json2CDF.processGlobalAttributes(cDF, (JsonArray)object3);
            }
            if ((jsonArray2 = jsonObject.getJsonArray(item3)) != null) {
                if (progress) {
                    System.out.println(item3 + ":");
                }
                for (Object object5 : jsonArray2) {
                    for (Object object7 : ((JsonObject)object5).keySet()) {
                        if (progress) {
                            System.out.println("  " + (String)object7 + ":");
                        }
                        String string = ((JsonObject)object5).getJsonArray((String)object7);
                        for (int i = 0; i < string.size(); ++i) {
                            JsonObject jsonObject2 = string.getJsonObject(i);
                            for (String string2 : jsonObject2.keySet()) {
                                Object object8;
                                if (string2.equalsIgnoreCase(item4)) {
                                    object8 = jsonObject2.get((Object)string2);
                                    if (progress) {
                                        System.out.println("    " + string2 + ":");
                                    }
                                    variable = Json2CDF.processVariableSpec(cDF, (String)object7, object8);
                                    continue;
                                }
                                if (string2.equalsIgnoreCase(item5)) {
                                    if (variable == null) continue;
                                    object8 = jsonObject2.get((Object)string2);
                                    if (progress) {
                                        System.out.println("    " + string2 + ":");
                                    }
                                    Json2CDF.processVariableAttributes(cDF, variable, object8);
                                    continue;
                                }
                                if (string2.equalsIgnoreCase(item6)) {
                                    if (!varData && varRecVary != 0L || variable == null) continue;
                                    if (progress) {
                                        System.out.println("   Doing VarData....");
                                    }
                                    object8 = jsonObject2.get((Object)string2);
                                    Json2CDF.processVariableData(variable, object8);
                                    continue;
                                }
                                System.out.println("***** Unknown item...: " + string2);
                            }
                        }
                    }
                }
            }
            if ((jsonArray = jsonObject.getJsonArray(item7)) != null) {
                if (progress) {
                    System.out.println(item7 + ":");
                }
                for (Object object6 : jsonArray) {
                    for (String string : ((JsonObject)object6).keySet()) {
                        Object object9;
                        int n;
                        JsonArray jsonArray4 = ((JsonObject)object6).getJsonArray(string);
                        if (progress) {
                            System.out.println("  " + string + ":" + jsonArray4);
                        }
                        if (string.equals("GlobalAttributes")) {
                            for (n = 0; n < jsonArray4.size(); ++n) {
                                object9 = jsonArray4.getString(n);
                                Attribute.create((CDF)cDF, (String)object9, (long)1L);
                            }
                            continue;
                        }
                        for (n = 0; n < jsonArray4.size(); ++n) {
                            object9 = jsonArray4.getString(n);
                            Attribute.create((CDF)cDF, (String)object9, (long)2L);
                        }
                    }
                }
            }
            cDF.close();
        }
        catch (Exception exception) {
            System.out.println("***** Error: " + exception + " for file: " + object2);
        }
    }

    private static void parseCmdLine(String[] stringArray) {
        Object var1_1 = null;
        if (stringArray.length == 0) {
            Json2CDF.exit("");
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                if (i == stringArray.length - 1) {
                    inFile = stringArray[i];
                    continue;
                }
                int n = stringArray[i].indexOf(":");
                if (stringArray[i].toLowerCase().startsWith("-output:")) {
                    assignedFile = stringArray[i].substring(n + 1);
                    if (assignedFile.toLowerCase().endsWith(".cdf")) continue;
                    assignedFile = assignedFile + ".cdf";
                    continue;
                }
                if (stringArray[i].toLowerCase().startsWith("-vardata:")) {
                    String string = stringArray[i].substring(n + 1);
                    if (string.equalsIgnoreCase("yes")) {
                        varData = true;
                        continue;
                    }
                    if (string.equalsIgnoreCase("no")) {
                        varData = false;
                        continue;
                    }
                    Json2CDF.exit("** Error: Invalid -vardata option entered **");
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-showprogress") || stringArray[i].equalsIgnoreCase("-progress")) {
                    progress = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-delete")) {
                    delete = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-showfile")) {
                    showfile = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-checksum")) {
                    checksum = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-nocompress")) {
                    toCompress = false;
                    continue;
                }
                if (stringArray[i].toLowerCase().startsWith("-outdir:")) {
                    outDir = stringArray[i].substring(n + 1);
                    continue;
                }
                Json2CDF.exit("** Error: Invalid option entered **");
            }
        }
    }

    private static boolean equivalentDataTypes(long l, long l2) {
        long[] lArray = new long[]{0L, 1L, 2L, 0L, 3L, 0L, 0L, 0L, 4L, 0L, 0L, 5L, 6L, 0L, 7L, 0L, 0L, 0L, 0L, 0L, 0L, 8L, 9L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 9L, 0L, 4L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 0L, 0L, 8L, 9L, 0L, 0L, 0L, 0L, 0L, 10L, 10L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
        return lArray[(int)l] == lArray[(int)l2];
    }

    private static Object handleSpecial(long l, String string) {
        if (string.equals("-nan")) {
            if (l == 45L || l == 22L) {
                return new Double(Double.NaN);
            }
            if (l == 44L || l == 21L) {
                return new Float(Float.NaN);
            }
            return new Double(Double.NaN);
        }
        if (string.equals("nan")) {
            if (l == 45L || l == 22L) {
                return new Double(Double.NaN);
            }
            if (l == 44L || l == 21L) {
                return new Float(Float.NaN);
            }
            return new Double(Double.NaN);
        }
        if (string.equals("-inf")) {
            if (l == 45L || l == 22L) {
                return new Double(Double.NEGATIVE_INFINITY);
            }
            if (l == 44L || l == 21L) {
                return new Float(Float.NEGATIVE_INFINITY);
            }
            return new Double(Double.NEGATIVE_INFINITY);
        }
        if (string.equals("inf")) {
            if (l == 45L || l == 22L) {
                return new Double(Double.POSITIVE_INFINITY);
            }
            if (l == 44L || l == 21L) {
                return new Float(Float.POSITIVE_INFINITY);
            }
            return new Double(Double.POSITIVE_INFINITY);
        }
        return string;
    }

    private static Object changeData(long l, long l2, Object object) {
        String string = CDFUtils.getSignature((Object)object);
        if (string.indexOf("String") != -1) {
            if (string.charAt(0) != '[') {
                String string2 = (String)object;
                String string3 = Json2CDF.specialString(string2);
                if (string3 != null) {
                    return Json2CDF.handleSpecial(l2, string3);
                }
                return object;
            }
            int n = ((String[])object).length;
            String string4 = null;
            String string5 = null;
            if (l2 == 21L || l2 == 44L) {
                float[] fArray = new float[n];
                for (int i = 0; i < n; ++i) {
                    string4 = ((String[])object)[i];
                    string5 = Json2CDF.specialString(string4);
                    fArray[i] = string5 != null ? ((Float)Json2CDF.handleSpecial(l2, string5)).floatValue() : new Float(string4).floatValue();
                }
                return fArray;
            }
            if (l2 == 22L || l2 == 45L) {
                double[] dArray = new double[n];
                for (int i = 0; i < n; ++i) {
                    string4 = ((String[])object)[i];
                    string5 = Json2CDF.specialString(string4);
                    dArray[i] = string5 != null ? ((Double)Json2CDF.handleSpecial(l2, string5)).doubleValue() : new Double(string4).doubleValue();
                }
                return dArray;
            }
            return object;
        }
        if (Json2CDF.equivalentDataTypes(l, l2)) {
            return object;
        }
        if (object instanceof Double) {
            return new Float(((Double)object).floatValue());
        }
        if (object instanceof Integer) {
            if (l == 1L || l == 41L) {
                return new Byte(((Integer)object).byteValue());
            }
            if (l == 2L || l == 11L) {
                return new Short(((Integer)object).shortValue());
            }
        } else if (string.charAt(0) == '[') {
            if (string.charAt(1) == 'D') {
                int n = ((double[])object).length;
                float[] fArray = new float[n];
                for (int i = 0; i < n; ++i) {
                    fArray[i] = (float)((double[])object)[i];
                }
                return fArray;
            }
            if (l == 1L || l == 41L) {
                int n = ((int[])object).length;
                byte[] byArray = new byte[n];
                for (int i = 0; i < n; ++i) {
                    byArray[i] = (byte)((int[])object)[i];
                }
                return byArray;
            }
            if (l == 2L || l == 11L) {
                int n = ((int[])object).length;
                short[] sArray = new short[n];
                for (int i = 0; i < n; ++i) {
                    sArray[i] = (short)((int[])object)[i];
                }
                return sArray;
            }
            return object;
        }
        return object;
    }

    private static Object handleMixed(int n, Object object) {
        Object object2;
        Object object3;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            object3 = ((JsonArray)object).get(n2);
            if (!(object3 instanceof JsonString) || Json2CDF.specialString((String)(object2 = ((JsonString)object3).getString())) != null) continue;
            ++n3;
        }
        if (n3 != 0) {
            System.out.println("????                 mixed number & string ?????");
            return null;
        }
        object3 = dataType == 21L || dataType == 44L ? (Object)new double[n] : (Object)new double[n];
        for (n2 = 0; n2 < n; ++n2) {
            object2 = ((JsonArray)object).get(n2);
            if (object2 instanceof JsonString) {
                String string = ((JsonString)object2).getString();
                String string2 = Json2CDF.specialString(string);
                Object object4 = Json2CDF.handleSpecial(dataType, string2);
                if (dataType == 21L || dataType == 44L) {
                    ((float[])object3)[n2] = ((Float)object4).floatValue();
                    continue;
                }
                ((double[])object3)[n2] = (Double)object4;
                continue;
            }
            if (dataType == 21L || dataType == 44L) {
                ((float[])object3)[n2] = Float.parseFloat(((JsonNumber)object2).toString());
                continue;
            }
            ((double[])object3)[n2] = Double.parseDouble(((JsonNumber)object2).toString());
        }
        return object3;
    }

    private static Object getData(Object object, long l) {
        String string = null;
        if (object instanceof JsonString) {
            string = ((JsonString)object).toString();
            int n = string.length();
            if (string.charAt(0) == '\"') {
                string = string.substring(1, string.length() - 1);
            }
            if (l != 0L) {
                dataType = l;
                return Json2CDF.parseContents(string, dataType);
            }
            try {
                if (n < 14 || string.charAt(4) != '-' || string.charAt(7) != '-' || string.charAt(10) != 'T' || string.charAt(13) != ':') {
                    dataType = 51L;
                    return Json2CDF.parseContents(string, dataType);
                }
                numElements = 1L;
                if (string.length() == 23 || string.length() == 24) {
                    dataType = 31L;
                    return new Double(Epoch.toParse((String)string));
                }
                if (string.length() == 29 || string.length() == 30) {
                    dataType = 33L;
                    return new Long(CDFTT2000.toParse((String)string));
                }
                dataType = 32L;
                double[] dArray = Epoch16.toParse((String)string);
                return dArray;
            }
            catch (Exception exception) {
                numElements = n;
                dataType = 51L;
                return string;
            }
        }
        if (object instanceof JsonNumber) {
            numElements = 1L;
            try {
                string = ((JsonNumber)object).toString();
                if (l == 0L) {
                    if (((JsonNumber)object).isIntegral()) {
                        if (!Json2CDF.useVarDataType(vAttrName)) {
                            dataType = 4L;
                        }
                        try {
                            return Json2CDF.parseContents(string, dataType);
                        }
                        catch (Exception exception) {
                            try {
                                dataType = 8L;
                                return Json2CDF.parseContents(string, dataType);
                            }
                            catch (Exception exception2) {
                                System.out.println("Error.... Json integer... value:" + string + " dt:" + dataType + " " + exception2);
                                return null;
                            }
                        }
                    }
                    if (!Json2CDF.useVarDataType(vAttrName)) {
                        dataType = 45L;
                    }
                } else {
                    dataType = l;
                }
                return Json2CDF.parseContents(string, dataType);
            }
            catch (Exception exception) {
                System.out.println("Error.... Json integer... value:" + string + " dt:" + dataType + " " + exception);
                return null;
            }
        }
        if (object instanceof JsonArray) {
            Object object2 = ((JsonArray)object).get(0);
            numElements = ((JsonArray)object).size();
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while ((long)n < numElements) {
                stringBuffer.append(((JsonNumber)((JsonArray)object).get(n)).toString());
                if ((long)n < numElements - 1L) {
                    stringBuffer.append(",");
                }
                ++n;
            }
            string = stringBuffer.toString();
            if (object2 instanceof JsonNumber) {
                if (l == 0L) {
                    if (((JsonNumber)object2).isIntegral()) {
                        if (!Json2CDF.useVarDataType(vAttrName)) {
                            dataType = 4L;
                        }
                        try {
                            return Json2CDF.parseContents(string, dataType);
                        }
                        catch (Exception exception) {
                            try {
                                dataType = 8L;
                                return Json2CDF.parseContents(string, dataType);
                            }
                            catch (Exception exception3) {
                                System.out.println("Error.... Json integer... value:" + string + " dt:" + dataType + " " + exception3);
                                return null;
                            }
                        }
                    }
                    if (!Json2CDF.useVarDataType(vAttrName)) {
                        dataType = 45L;
                    }
                } else {
                    dataType = l;
                }
                try {
                    return Json2CDF.parseContents(string, dataType);
                }
                catch (Exception exception) {
                    System.out.println("Error.... Json array... value:" + string + " dt:" + dataType + " " + exception);
                    return null;
                }
            }
        }
        return null;
    }

    private static String specialString(String string) {
        String string2 = string.toLowerCase();
        if (string2.startsWith("\"")) {
            string2 = string2.substring(1, string2.length() - 1);
        }
        if (string2.equals("nan") || string2.equals("-nan") || string2.equals("inf") || string2.equals("-inf")) {
            return string2;
        }
        return null;
    }

    private static Object setData(Object object, Object object2, int n, int n2) throws CDFException {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            Object object3;
            Object object4 = ((JsonArray)object).get(i);
            String string = CDFUtils.getSignature((Object)object4);
            Object object5 = null;
            if (object4 instanceof JsonString) {
                int n4;
                String string2 = ((JsonString)object4).getString();
                object3 = Json2CDF.specialString(string2);
                if (object3 != null) {
                    object5 = Json2CDF.handleSpecial(varDataType, (String)object3);
                    if (varDataType == 21L || varDataType == 44L) {
                        if (n == 1) {
                            return object5;
                        }
                        ((float[])object2)[i] = ((Float)object5).floatValue();
                    }
                    if (varDataType != 22L && varDataType != 45L) continue;
                    if (n == 1) {
                        return object5;
                    }
                    ((double[])object2)[i] = (Double)object5;
                    continue;
                }
                object5 = Json2CDF.setData1(object4);
                if (n == 1) {
                    return object5;
                }
                if (varDataType == 31L) {
                    ((double[])object2)[i] = (Double)object5;
                    continue;
                }
                if (varDataType == 33L) {
                    ((long[])object2)[i] = (Long)object5;
                    continue;
                }
                if (varDataType == 32L) {
                    ((double[])object2)[2 * i] = ((double[])object5)[0];
                    ((double[])object2)[2 * i + 1] = ((double[])object5)[1];
                    continue;
                }
                byte[] byArray = ((String)object5).getBytes();
                int n5 = ((String)object5).length();
                for (n4 = 0; n4 < n5; ++n4) {
                    ((byte[])object2)[n3 + n4] = byArray[n4];
                }
                n4 = n5;
                while ((long)n4 < varNumElems) {
                    ((byte[])object2)[n3 + n4] = 0;
                    ++n4;
                }
                n3 = (int)((long)n3 + varNumElems);
                continue;
            }
            if (object4 instanceof JsonNumber) {
                object5 = Json2CDF.setData1(object4);
                if (n == 1) {
                    return object5;
                }
                switch ((int)varDataType) {
                    case 1: 
                    case 41: {
                        ((byte[])object2)[i] = (Byte)object5;
                        break;
                    }
                    case 2: 
                    case 11: {
                        ((short[])object2)[i] = (short)((JsonNumber)object4).intValue();
                        break;
                    }
                    case 4: 
                    case 12: {
                        ((int[])object2)[i] = ((JsonNumber)object4).intValue();
                        break;
                    }
                    case 8: 
                    case 14: {
                        ((long[])object2)[i] = ((JsonNumber)object4).longValue();
                        break;
                    }
                    case 21: 
                    case 44: {
                        ((float[])object2)[i] = (float)((JsonNumber)object4).doubleValue();
                        break;
                    }
                    case 22: 
                    case 45: {
                        ((double[])object2)[i] = ((JsonNumber)object4).doubleValue();
                        break;
                    }
                }
                continue;
            }
            if (object4 instanceof JsonArray) {
                int n6 = ((JsonArray)object4).size();
                object3 = ((JsonArray)object4).get(0);
                if (object3 instanceof JsonString) {
                    for (int j = 0; j < n6; ++j) {
                        String string3 = ((JsonString)((JsonArray)object4).get(j)).toString();
                        Object object6 = Json2CDF.setData1(string3);
                        if (varDataType == 51L || varDataType == 52L) {
                            int n7;
                            int n8 = ((String)object6).length();
                            byte[] byArray = ((String)object6).getBytes();
                            for (n7 = 0; n7 < n8; ++n7) {
                                ((byte[])object2)[n3 + n7] = byArray[n7];
                            }
                            n7 = n8;
                            while ((long)n7 < varNumElems) {
                                ((byte[])object2)[n3 + n7] = 0;
                                ++n7;
                            }
                            n3 = (int)((long)n3 + varNumElems);
                            continue;
                        }
                        if (varDataType == 31L) {
                            ((double[])object2)[n3++] = (Double)object6;
                            continue;
                        }
                        if (varDataType == 33L) {
                            ((long[])object2)[n3++] = (Long)object6;
                            continue;
                        }
                        if (varDataType != 32L) continue;
                        ((double[])object2)[n3] = ((double[])object6)[0];
                        ((double[])object2)[n3 + 1] = ((double[])object6)[1];
                        n3 += 2;
                    }
                    continue;
                }
                if (!(object3 instanceof JsonNumber)) continue;
                block22: for (int j = 0; j < n6; ++j) {
                    Object object7 = ((JsonArray)object4).get(j);
                    Object object8 = Json2CDF.setData1(object7);
                    switch ((int)varDataType) {
                        case 1: 
                        case 41: {
                            ((byte[])object2)[n3++] = (Byte)object8;
                            continue block22;
                        }
                        case 2: 
                        case 11: {
                            ((short[])object2)[n3++] = (Short)object8;
                            continue block22;
                        }
                        case 4: 
                        case 12: {
                            ((int[])object2)[n3++] = (Integer)object8;
                            continue block22;
                        }
                        case 8: 
                        case 14: {
                            ((long[])object2)[n3++] = (Long)object8;
                            continue block22;
                        }
                        case 21: 
                        case 44: {
                            ((float[])object2)[n3++] = ((Float)object8).floatValue();
                            continue block22;
                        }
                        case 22: 
                        case 45: {
                            ((double[])object2)[n3++] = (Double)object8;
                            continue block22;
                        }
                    }
                }
                continue;
            }
            System.out.println("                     ?????");
            return null;
        }
        return object2;
    }

    private static Object setData1(Object object) throws CDFException {
        if (object instanceof JsonString || object instanceof String) {
            String string = object instanceof JsonString ? ((JsonString)object).toString() : (String)object;
            if (string.charAt(0) == '\"') {
                string = string.substring(1, string.length() - 1);
            }
            if (varDataType == 31L) {
                return new Double(Epoch.toParse((String)string));
            }
            if (varDataType == 33L) {
                return new Long(CDFTT2000.toParse((String)string));
            }
            if (varDataType == 32L) {
                double[] dArray = Epoch16.toParse((String)string);
                return dArray;
            }
            return string;
        }
        if (object instanceof JsonNumber) {
            switch ((int)varDataType) {
                case 1: 
                case 41: {
                    return new Byte((byte)((JsonNumber)object).intValue());
                }
                case 2: 
                case 11: {
                    return new Short((short)((JsonNumber)object).intValue());
                }
                case 4: 
                case 12: {
                    return new Integer(((JsonNumber)object).intValue());
                }
                case 8: 
                case 14: {
                    return new Long(((JsonNumber)object).longValue());
                }
                case 21: 
                case 44: {
                    return new Float(((JsonNumber)object).doubleValue());
                }
                case 22: 
                case 45: {
                    return new Double(((JsonNumber)object).doubleValue());
                }
            }
            return null;
        }
        return null;
    }

    private static void exit(String string) {
        if (!string.equals("")) {
            System.out.println(string);
        }
        Json2CDF.usage();
        System.exit(1);
    }

    private static void usage() {
        System.out.println("\nDescription:");
        System.out.println("    This program exports the contents of a Json file into a CDF file(s).");
        System.out.println("");
        System.out.println("Usage: java Json2CDF [Options] JsonFileName ");
        System.out.println("    JsonFileName: The name of the Json file used to create a CDF(s).");
        System.out.println(" ");
        System.out.println("Options: ");
        System.out.println(" ");
        System.out.println("   -output:outputFileName");
        System.out.println("      Use this option to specify a different output file name for the CDF.");
        System.out.println("      It is only applicable to a single CDF file output.");
        System.out.println(" ");
        System.out.println("   -outdir:outputDir");
        System.out.println("      Specifies a directory to hold the output CDF file(s). Make sure the");
        System.out.println("      directory exists and is writeable.");
        System.out.println(" ");
        System.out.println("   -vardata:[yes | no].   -vardata:yes is the default.");
        System.out.println("      Whether to extract var data in the Json file if it is there. If \"no\"");
        System.out.println("      is specified, non-record varying variables' data will not be extracted.");
        System.out.println(" ");
        System.out.println("   -[showProgress | Progress]");
        System.out.println("      This option displays the processing progress on the screen.");
        System.out.println("      It shows how many CDF variables are there to process and which");
        System.out.println("      variable is being processed.");
        System.out.println(" ");
        System.out.println("   -checksum");
        System.out.println("      This option adds checksum to the file.");
        System.out.println(" ");
        System.out.println("   -nocompress");
        System.out.println("      This option forces no compression for variable data. By default, a");
        System.out.println("      variable with large enough size (>1K) will be compressed, no matter if");
        System.out.println("      defined by its specification or not.");
        System.out.println(" ");
        System.out.println("   -delete");
        System.out.println("      Over-ride the CDF file(s) if it alreadyexists.");
        System.out.println("");
        System.out.println("   -showfile");
        System.out.println("      Display the Json file being processed.");
        System.out.println("");
        System.out.println("NOTE:");
        System.out.println("  1. If an attribute value's data type is not specified, then its");
        System.out.println("     integral value is converted into 4-byte integer, if it can fill. ");
        System.out.println("     Otherwise, 8-byte long is used. All floating-values are converted into ");
        System.out.println("     8-byte doubles.");
        System.out.println("  2. A varying dimension with size of 1 is considered as non-varying.");
        System.out.println("     Its dimension is removed and NOT shown.");
        System.out.println("  3. Values for variable attributes: VALIDMIN/VALIDMAX/SCALEMIN/SCALEMAX/FILLVAL");
        System.out.println("     will have the same data type as the variable's.");
        System.out.println("  4. All variables are zVariables.");
        System.out.println("  5. All \"NaN\"|\"-NaN\" and \"INF\"|\"-INF\" strings are converted into");
        System.out.println("     floating-point values. ");
        System.out.println("");
        System.out.println("Examples: ");
        System.out.println("   java Json2CDF test.json (same as java Json2CDF -json:test.cdf test.json)");
        System.out.println("");
        System.out.println("The Json file should have the following form: (made from CDF2Json):\nCDFname1: \n CDFFileInfo: \n   FileVersion:..... \n   Format:..... \n   Majority:... \n   Encoding:..... \n   Checksum:..... \n CDFglobalAttributes: \n   Gattr_name1: \n    entry#:value \n      ... \n   Gattr_name2: \n    entry#:value \n      ... \n   ... \n   ... \n CDFVariables: \n   VarName1: \n    VarDescription: \n      DataType:.... \n      ... \n      ... \n    VarAttributes: \n      VALIDMIN:.... or VALIDMIN:... DataType:... Value:...\n      VALIDMAX:.... or VALIDMAX:... DataType:... Value:...\n      ... \n      ... \n    VarData: \n      ... \n   VarName2: \n    VarDescription: \n      DataType:.... \n      ... \n      ... \n    VarAttributes: \n      ... \n      ... \n    VarData: \n      ... \n EmptyAttributes:   <== If attribute(s) defined but not assign value(s) \n    GlobalAttributes:    <== If global attribute(s) is not assigned value \n    VariableAttributes:  <== If variable attribute(s) is not assigned value \n  \nCDFname2: \n CDFFileInfo: \n  ..... \n  ..... \n CDFglobalAttributes: \n   Gattr_name1: \n      ... \n   Gattr_name2: \n      ... \n   ... \n   ... \n CDFVariables: \n   VarName1: \n    VarDescription: \n      .... \n ....");
        System.out.println(" ");
    }

    private static void processGlobalAttributes(CDF cDF, JsonArray jsonArray) throws CDFException {
        long l = 0L;
        boolean bl = false;
        Object object = null;
        for (JsonValue jsonValue : jsonArray) {
            for (String string : ((JsonObject)jsonValue).keySet()) {
                if (progress) {
                    System.out.println("  " + string);
                }
                Attribute attribute = Attribute.create((CDF)cDF, (String)string, (long)1L);
                JsonArray jsonArray2 = ((JsonObject)jsonValue).getJsonArray(string);
                for (int i = 0; i < jsonArray2.size(); ++i) {
                    JsonObject jsonObject = jsonArray2.getJsonObject(i);
                    for (String string2 : jsonObject.keySet()) {
                        Object object2 = jsonObject.get((Object)string2);
                        if (progress) {
                            System.out.println("      " + string2 + ":" + object2);
                        }
                        if (object2 instanceof JsonArray) {
                            block12: {
                                int n = ((JsonArray)object2).size();
                                Object object3 = ((JsonArray)object2).get(0);
                                if (object3 instanceof JsonObject) {
                                    try {
                                        JsonObject jsonObject2 = null;
                                        JsonObject jsonObject3 = null;
                                        jsonObject2 = (JsonObject)((JsonArray)object2).get(0);
                                        jsonObject3 = (JsonObject)((JsonArray)object2).get(1);
                                        if (jsonObject2 instanceof JsonObject) {
                                            String string3 = jsonObject2.getString("DataType");
                                            l = CDFUtils.getDataTypeValue((String)string3);
                                            Object object4 = jsonObject3.get((Object)"Value");
                                            bl = true;
                                            object = Json2CDF.getData(object4, l);
                                            break block12;
                                        }
                                        object = Json2CDF.getData(object2, 0L);
                                    }
                                    catch (Exception exception) {
                                        l = 0L;
                                        object = Json2CDF.getData(object2, l);
                                    }
                                } else {
                                    object = Json2CDF.getData(object2, 0L);
                                }
                            }
                            Entry.create((Attribute)attribute, (long)new Integer(string2).intValue(), (long)dataType, (Object)object);
                            continue;
                        }
                        object = Json2CDF.getData(object2, 0L);
                        Entry.create((Attribute)attribute, (long)new Integer(string2).intValue(), (long)dataType, (Object)object);
                    }
                }
            }
        }
    }

    private static Variable processVariableSpec(CDF cDF, String string, Object object) throws CDFException {
        int n;
        Object object2 = null;
        varPadValue = null;
        varSparseRec = 0L;
        long l = -1L;
        long l2 = 0L;
        long l3 = -1L;
        int n2 = ((JsonArray)object).size();
        varMaxWritten = -1L;
        varNumDims = -1L;
        varNumElems = -1L;
        varDataType = -1L;
        for (n = 0; n < n2; ++n) {
            Object object3 = ((JsonArray)object).get(n);
            if (!(object3 instanceof JsonObject)) continue;
            for (String string2 : ((JsonObject)object3).keySet()) {
                String string3;
                String string4;
                Object object4 = ((JsonObject)object3).get((Object)string2);
                if (progress) {
                    System.out.println("      " + string2 + ":" + object4);
                }
                if (string2.equalsIgnoreCase("varname")) continue;
                if (string2.equalsIgnoreCase("datatype")) {
                    string4 = ((JsonObject)object3).getString(string2);
                    varDataType = CDFUtils.getDataTypeValue((String)string4);
                    continue;
                }
                if (string2.equalsIgnoreCase("numelements")) {
                    varNumElems = ((JsonObject)object3).getInt(string2);
                    continue;
                }
                if (string2.equalsIgnoreCase("numdims")) {
                    varNumDims = ((JsonObject)object3).getInt(string2);
                    continue;
                }
                if (string2.equalsIgnoreCase("dimsizes")) {
                    string4 = ((JsonObject)object3).getJsonArray(string2);
                    for (int i = 0; i < (int)varNumDims; ++i) {
                        Json2CDF.varDimSizes[i] = string4.getInt(i);
                    }
                    continue;
                }
                if (string2.equalsIgnoreCase("recvariance")) {
                    string4 = ((JsonObject)object3).getString(string2);
                    if (string4.equalsIgnoreCase("vary")) {
                        varRecVary = -1L;
                        continue;
                    }
                    varRecVary = 0L;
                    continue;
                }
                if (string2.equalsIgnoreCase("dimvariances")) {
                    string4 = ((JsonObject)object3).getJsonArray(string2);
                    for (int i = 0; i < (int)varNumDims; ++i) {
                        string3 = string4.getString(i);
                        Json2CDF.varDimVariances[i] = string3.equalsIgnoreCase("vary") ? -1L : 0L;
                    }
                    continue;
                }
                if (string2.equalsIgnoreCase("compression")) {
                    string4 = ((JsonObject)object3).getString(string2);
                    String string5 = string4.substring(0, string4.indexOf(46));
                    string3 = string4.substring(string4.indexOf(46) + 1);
                    l = CDFUtils.getLongCompressionType((String)string5);
                    l2 = new Long(string3);
                    continue;
                }
                if (string2.equalsIgnoreCase("blockingfactor")) {
                    l3 = ((JsonObject)object3).getInt(string2);
                    continue;
                }
                if (string2.equalsIgnoreCase("sparserecords")) {
                    string4 = ((JsonObject)object3).getString(string2);
                    varSparseRec = CDFUtils.getLongSparseRecord((String)string4);
                    continue;
                }
                if (string2.equalsIgnoreCase("numwrittenrecords")) {
                    varNumWritten = ((JsonObject)object3).getInt(string2);
                    continue;
                }
                if (string2.equalsIgnoreCase("maxwrittenrec")) {
                    varMaxWritten = ((JsonObject)object3).getInt(string2);
                    continue;
                }
                if (string2.equalsIgnoreCase("padvalue")) {
                    object2 = ((JsonObject)object3).get((Object)string2);
                    continue;
                }
                System.out.println("NOT handling... " + string2);
            }
        }
        if (progress) {
            System.out.print("***** Creating... var:" + string + "  type:" + CDFUtils.getStringDataType((long)varDataType) + " numElms=" + varNumElems + " numDims=" + varNumDims + " ");
            if (varNumDims > 0L) {
                System.out.print("dimSize=[");
                for (n = 0; n < (int)varNumDims; ++n) {
                    System.out.print(varDimSizes[n]);
                    if ((long)n < varNumDims - 1L) {
                        System.out.print(",");
                    }
                    if ((long)n != varNumDims - 1L) continue;
                    System.out.print("] ");
                }
            }
            System.out.println("RecVary=" + (varRecVary == -1L ? "T" : "F"));
        }
        if (varDataType == -1L || varNumElems == -1L || varNumDims == -1L) {
            return null;
        }
        Variable variable = Variable.create((CDF)cDF, (String)string, (long)varDataType, (long)varNumElems, (long)varNumDims, (long[])varDimSizes, (long)varRecVary, (long[])varDimVariances);
        varFillVal = null;
        if (object2 != null) {
            varPadValue = Json2CDF.setData1(object2);
            variable.setPadValue(varPadValue);
        }
        if (toCompress && varSparseRec == 0L) {
            if (l != -1L) {
                variable.setCompression(l, new long[]{l2});
            } else {
                long l4 = (varMaxWritten == -1L ? 0L : varMaxWritten) + 1L;
                for (int i = 0; i < (int)varNumDims; ++i) {
                    l4 *= varDimSizes[i];
                }
                l4 *= varNumElems;
                if ((l4 *= (long)Json2CDF.getDataTypeSize(varDataType)) > 1000L) {
                    l = 5L;
                    l2 = 6L;
                    variable.setCompression(l, new long[]{l2});
                }
            }
        }
        if (l3 != -1L) {
            variable.setBlockingFactor(l3);
        }
        if (varSparseRec != 0L) {
            variable.setSparseRecords(varSparseRec);
        }
        return variable;
    }

    private static void processVariableAttributes(CDF cDF, Variable variable, Object object) throws CDFException {
        int n = ((JsonArray)object).size();
        Object object2 = null;
        boolean bl = false;
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            Attribute attribute = null;
            JsonObject jsonObject = ((JsonArray)object).getJsonObject(i);
            for (String string : jsonObject.keySet()) {
                Object object3;
                Object object4;
                bl = false;
                Object object5 = jsonObject.get((Object)string);
                l = 0L;
                if (progress) {
                    System.out.println("      " + string + ":" + object5);
                }
                try {
                    attribute = Attribute.create((CDF)cDF, (String)string, (long)2L);
                }
                catch (CDFException cDFException) {
                    attribute = cDF.getAttribute(string);
                }
                if (object5 instanceof JsonArray) {
                    object4 = ((JsonArray)object5).get(0);
                    if (object4 instanceof JsonObject) {
                        try {
                            object3 = null;
                            JsonObject jsonObject2 = null;
                            object3 = (JsonObject)((JsonArray)object5).get(0);
                            jsonObject2 = (JsonObject)((JsonArray)object5).get(1);
                            if (object3 instanceof JsonObject) {
                                String string2 = object3.getString("DataType");
                                l = CDFUtils.getDataTypeValue((String)string2);
                                object5 = jsonObject2.get((Object)"Value");
                                bl = true;
                            }
                        }
                        catch (Exception exception) {
                            l = 0L;
                        }
                        dataType = variable.getDataType();
                        vAttrName = string;
                        object2 = Json2CDF.getData(object5, l);
                        if (!bl && Json2CDF.useVarDataType(string)) {
                            object2 = Json2CDF.changeData(dataType, varDataType, object2);
                            dataType = varDataType;
                            if (string.equalsIgnoreCase("fillval")) {
                                varFillVal = object2;
                            }
                        }
                        variable.putEntry(attribute, dataType, object2);
                        continue;
                    }
                    dataTypeY = Json2CDF.useVarDataType(string) ? variable.getDataType() : -1L;
                    object3 = Json2CDF.buildDataObject(dataTypeY, object5);
                    variable.putEntry(attribute, dataTypeY, object3);
                    continue;
                }
                if (object5 instanceof JsonString) {
                    object4 = (String)Json2CDF.getData(object5, 51L);
                    if (Json2CDF.useVarDataType(string)) {
                        object3 = Json2CDF.parseContents((String)object4, varDataType);
                        variable.putEntry(attribute, varDataType, object3);
                        continue;
                    }
                    variable.putEntry(attribute, 51L, object4);
                    continue;
                }
                dataType = variable.getDataType();
                vAttrName = string;
                object2 = Json2CDF.getData(object5, 0L);
                if (bl) continue;
                if (Json2CDF.useVarDataType(string)) {
                    object2 = Json2CDF.changeData(dataType, varDataType, object2);
                    dataType = varDataType;
                    if (string.equalsIgnoreCase("fillval")) {
                        varFillVal = object2;
                    }
                }
                variable.putEntry(attribute, dataType, object2);
            }
        }
    }

    private static void processVariableData(Variable variable, Object object) throws CDFException {
        int n = 1;
        int n2 = 1;
        int n3 = 1;
        int n4 = 0;
        while ((long)n4 < varNumDims) {
            n3 = (int)((long)n3 * varDimSizes[n4]);
            ++n4;
        }
        if (object instanceof JsonArray) {
            n = ((JsonArray)object).size();
        }
        if (varRecVary == -1L) {
            n2 = ((JsonArray)object).get(0) instanceof JsonArray ? n : n / n3;
        }
        String string = CDFUtils.getSignature((Object)object);
        int n5 = 1;
        Object object2 = null;
        Object[] objectArray = null;
        if (varDataType == 51L || varDataType == 52L) {
            n5 = n3 * (int)varNumElems * n2;
        }
        if (varSparseRec == 0L) {
            n3 *= n2;
        }
        if (n3 > 1) {
            if (varDataType == 1L || varDataType == 41L) {
                objectArray = new byte[n3];
            } else if (varDataType == 2L || varDataType == 11L) {
                objectArray = new short[n3];
            } else if (varDataType == 4L || varDataType == 12L) {
                objectArray = new int[n3];
            } else if (varDataType == 8L || varDataType == 14L || varDataType == 33L) {
                objectArray = new long[n3];
            } else if (varDataType == 21L || varDataType == 44L) {
                objectArray = new float[n3];
            } else if (varDataType == 22L || varDataType == 45L || varDataType == 31L) {
                objectArray = new double[n3];
            } else if (varDataType == 32L) {
                objectArray = new double[n3 * 2];
            } else if (varDataType == 51L || varDataType == 52L) {
                objectArray = new byte[n5];
            }
        }
        if (varSparseRec == 0L) {
            object2 = object instanceof JsonArray ? Json2CDF.setData(object, n3 == 1 ? null : objectArray, n3, n2 == 1 ? n3 : n2) : Json2CDF.setData1(object);
            variable.putRecords(0L, (long)n2, object2);
        } else {
            Object object3 = null;
            if (varSparseRec == 1L) {
                object3 = varFillVal != null ? varFillVal : varPadValue;
            }
            for (int i = 0; i < n2; ++i) {
                Object object4 = ((JsonArray)object).get(i);
                object2 = object4 instanceof JsonArray ? Json2CDF.setData(object4, n3 == 1 ? null : objectArray, n3, n3) : Json2CDF.setData1(object4);
                boolean bl = Json2CDF.checkForVirtual(object2, object3);
                if (bl) continue;
                variable.putRecord((long)i, object2);
                if (varSparseRec != 2L) continue;
                object3 = object2;
            }
        }
    }

    private static boolean checkForVirtual(Object object, Object object2) {
        if (object2 == null) {
            return false;
        }
        String string = CDFUtils.getSignature((Object)object);
        String string2 = CDFUtils.getSignature((Object)object2);
        if (string.charAt(0) == '[') {
            if (varDataType == 1L || varDataType == 41L) {
                int n = ((byte[])object).length;
                for (int i = 0; i < n; ++i) {
                    if (!(string2.charAt(0) == '[' ? ((byte[])object)[i] != ((byte[])object2)[i] : ((byte[])object)[i] != (Byte)object2)) continue;
                    return false;
                }
                return true;
            }
            if (varDataType == 2L || varDataType == 11L) {
                int n = ((short[])object).length;
                for (int i = 0; i < n; ++i) {
                    if (!(string2.charAt(0) == '[' ? ((short[])object)[i] != ((short[])object2)[i] : ((short[])object)[i] != (Short)object2)) continue;
                    return false;
                }
                return true;
            }
            if (varDataType == 4L || varDataType == 12L) {
                int n = ((int[])object).length;
                for (int i = 0; i < n; ++i) {
                    if (!(string2.charAt(0) == '[' ? ((int[])object)[i] != ((int[])object2)[i] : ((int[])object)[i] != (Integer)object2)) continue;
                    return false;
                }
                return true;
            }
            if (varDataType == 8L || varDataType == 14L || varDataType == 33L) {
                int n = ((long[])object).length;
                for (int i = 0; i < n; ++i) {
                    if (!(string2.charAt(0) == '[' ? ((long[])object)[i] != ((long[])object2)[i] : ((long[])object)[i] != (Long)object2)) continue;
                    return false;
                }
                return true;
            }
            if (varDataType == 21L || varDataType == 44L) {
                int n = ((float[])object).length;
                for (int i = 0; i < n; ++i) {
                    if (!(string2.charAt(0) == '[' ? ((float[])object)[i] != ((float[])object2)[i] : ((float[])object)[i] != ((Float)object2).floatValue())) continue;
                    return false;
                }
                return true;
            }
            if (varDataType == 22L || varDataType == 45L || varDataType == 31L) {
                int n = ((double[])object).length;
                for (int i = 0; i < n; ++i) {
                    if (!(string2.charAt(0) == '[' ? ((double[])object)[i] != ((double[])object2)[i] : ((double[])object)[i] != (Double)object2)) continue;
                    return false;
                }
                return true;
            }
        } else {
            if (varDataType == 1L || varDataType == 41L) {
                return ((Byte)object).byteValue() == ((Byte)object2).byteValue();
            }
            if (varDataType == 2L || varDataType == 11L) {
                return ((Short)object).shortValue() == ((Short)object2).shortValue();
            }
            if (varDataType == 4L || varDataType == 12L) {
                return ((Integer)object).intValue() == ((Integer)object2).intValue();
            }
            if (varDataType != 8L && varDataType != 14L && varDataType != 33L) {
                if (varDataType == 21L || varDataType == 44L) {
                    return ((Float)object).floatValue() == ((Float)object2).floatValue();
                }
                if (varDataType == 22L || varDataType == 45L || varDataType == 31L) {
                    return ((Double)object).doubleValue() == ((Double)object2).doubleValue();
                }
                return false;
            }
        }
        return false;
    }

    private static int getDimSize(Object object) {
        String string = CDFUtils.getSignature((Object)object);
        String string2 = string.substring(0, 2);
        if (string2.equals("[I")) {
            return ((int[])object).length;
        }
        if (string2.equals("[B")) {
            return ((byte[])object).length;
        }
        if (string2.equals("[J")) {
            return ((long[])object).length;
        }
        if (string2.equals("[S")) {
            return ((short[])object).length;
        }
        if (string2.equals("[F")) {
            return ((float[])object).length;
        }
        if (string2.equals("[D")) {
            return ((double[])object).length;
        }
        return 1;
    }

    private static int getDataTypeSize(long l) {
        int n;
        switch ((int)l) {
            case 1: 
            case 11: 
            case 41: 
            case 51: 
            case 52: {
                n = 1;
                break;
            }
            case 2: 
            case 12: {
                n = 2;
                break;
            }
            case 4: 
            case 14: 
            case 21: 
            case 44: {
                n = 4;
                break;
            }
            case 8: 
            case 22: 
            case 31: 
            case 33: 
            case 45: {
                n = 8;
                break;
            }
            case 32: {
                n = 16;
                break;
            }
            default: {
                n = 1;
            }
        }
        return n;
    }

    public static Object parseContents(String string, long l) throws NumberFormatException {
        if (string.charAt(0) == '\"') {
            string = string.substring(1, string.length() - 1);
        }
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.countTokens() == -1) {
            return null;
        }
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        int n = vector.size();
        if (l == 51L || l == 52L) {
            String string2 = string;
            return string2;
        }
        if (l == 41L || l == 1L) {
            if (n == 1) {
                byte[] byArray = new byte[]{Byte.parseByte(string)};
                return byArray;
            }
            byte[] byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray[i] = Byte.parseByte(((String)vector.elementAt(i)).trim());
            }
            return byArray;
        }
        if (l == 11L || l == 2L) {
            if (n == 1) {
                short[] sArray = new short[]{Short.parseShort(string)};
                if (l == 11L && (sArray[0] < 0 || sArray[0] > 255)) {
                    sArray = null;
                    throw new NumberFormatException(string);
                }
                return sArray;
            }
            short[] sArray = new short[n];
            for (int i = 0; i < n; ++i) {
                sArray[i] = Short.parseShort(((String)vector.elementAt(i)).trim());
                if (l != 11L || sArray[i] >= 0 && sArray[i] <= 255) continue;
                sArray = null;
                throw new NumberFormatException(((String)vector.elementAt(i)).trim());
            }
            return sArray;
        }
        if (l == 12L || l == 4L) {
            if (n == 1) {
                int[] nArray = new int[]{Integer.parseInt(string)};
                if (l == 12L && (nArray[0] < 0 || nArray[0] > 65535)) {
                    nArray = null;
                    throw new NumberFormatException(string);
                }
                return nArray;
            }
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = Integer.parseInt(((String)vector.elementAt(i)).trim());
                if (l != 12L || nArray[i] >= 0 && nArray[i] <= 65535) continue;
                nArray = null;
                throw new NumberFormatException(((String)vector.elementAt(i)).trim());
            }
            return nArray;
        }
        if (l == 14L || l == 8L) {
            if (n == 1) {
                long[] lArray = new long[]{Long.parseLong(string)};
                if (l == 14L && (lArray[0] < 0L || lArray[0] > 0xFFFFFFFFL)) {
                    lArray = null;
                    throw new NumberFormatException(string);
                }
                return lArray;
            }
            long[] lArray = new long[n];
            for (int i = 0; i < n; ++i) {
                lArray[i] = Long.parseLong(((String)vector.elementAt(i)).trim());
                if (l != 14L || lArray[i] >= 0L && lArray[i] <= 0xFFFFFFFFL) continue;
                lArray = null;
                throw new NumberFormatException(((String)vector.elementAt(i)).trim());
            }
            return lArray;
        }
        if (l == 44L || l == 21L) {
            if (n == 1) {
                float[] fArray = new float[]{Float.valueOf(string).floatValue()};
                return fArray;
            }
            float[] fArray = new float[n];
            for (int i = 0; i < n; ++i) {
                fArray[i] = Float.valueOf(((String)vector.elementAt(i)).trim()).floatValue();
            }
            return fArray;
        }
        if (l == 22L || l == 45L) {
            if (n == 1) {
                double[] dArray = new double[]{Double.valueOf(string)};
                return dArray;
            }
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = Double.valueOf(((String)vector.elementAt(i)).trim());
            }
            return dArray;
        }
        if (l == 31L) {
            try {
                if (n == 1) {
                    double[] dArray = new double[]{string.indexOf(":") == -1 ? Double.valueOf(string) : Epoch.toParse((String)string)};
                    return dArray;
                }
                double[] dArray = new double[n];
                for (int i = 0; i < n; ++i) {
                    String string3 = ((String)vector.elementAt(i)).trim();
                    dArray[i] = string3.indexOf(":") == -1 ? Double.valueOf(string3) : Epoch.toParse((String)string3);
                }
                return dArray;
            }
            catch (CDFException cDFException) {
                System.err.println("***** error parsing Epoch ");
                return null;
            }
        }
        if (l == 32L) {
            try {
                if (n == 1) {
                    double[] dArray = new double[2];
                    if (string.indexOf(":") == -1) {
                        dArray[0] = Double.valueOf(string);
                        dArray[1] = 0.0;
                    } else {
                        dArray = Epoch16.toParse((String)string);
                    }
                    return dArray;
                }
                double[][] dArray = new double[n][2];
                double[] dArray2 = new double[2];
                for (int i = 0; i < n; ++i) {
                    String string4 = ((String)vector.elementAt(i)).trim();
                    if (string4.indexOf(":") == -1) {
                        dArray[i][0] = Double.valueOf(string4);
                        dArray[i][1] = 0.0;
                        continue;
                    }
                    dArray2 = Epoch16.toParse((String)string4);
                    dArray[i][0] = dArray2[0];
                    dArray[i][1] = dArray2[1];
                }
                return dArray;
            }
            catch (CDFException cDFException) {
                System.err.println("***** error parsing Epoch ");
                return null;
            }
        }
        if (l == 33L) {
            try {
                if (n == 1) {
                    long[] lArray = new long[]{CDFTT2000.toParse((String)string)};
                    return lArray;
                }
                long[] lArray = new long[n];
                for (int i = 0; i < n; ++i) {
                    String string5 = ((String)vector.elementAt(i)).trim();
                    lArray[i] = CDFTT2000.toParse((String)string5);
                }
                return lArray;
            }
            catch (CDFException cDFException) {
                System.err.println("***** error parsing TT2000 string ");
                return null;
            }
        }
        return null;
    }

    public static boolean useVarDataType(String string) {
        return string.equalsIgnoreCase("validmin") || string.equalsIgnoreCase("validmax") || string.equalsIgnoreCase("scalemin") || string.equalsIgnoreCase("scalemax") || string.equalsIgnoreCase("fillval");
    }

    private static Object buildDataObject(long l, Object object) {
        Object object2 = null;
        int n = ((JsonArray)object).size();
        Object object3 = null;
        switch ((int)l) {
            case 1: 
            case 41: {
                if (n > 1) {
                    object2 = new byte[n];
                    for (int i = 0; i < n; ++i) {
                        String string = ((JsonNumber)((JsonArray)object).get(i)).toString();
                        object2[i] = new Byte(string);
                    }
                    break;
                }
                object2 = new byte[1];
                String string = ((JsonNumber)object).toString();
                object2[0] = new Byte(string);
                break;
            }
            case 2: 
            case 11: {
                if (n > 1) {
                    object2 = new short[n];
                    for (int i = 0; i < n; ++i) {
                        String string = ((JsonNumber)((JsonArray)object).get(i)).toString();
                        ((short[])object2)[i] = new Short(string);
                    }
                    break;
                }
                object2 = new short[1];
                String string = ((JsonNumber)object).toString();
                ((short[])object2)[0] = new Short(string);
                break;
            }
            case 4: 
            case 12: {
                if (n > 1) {
                    object2 = new int[n];
                    for (int i = 0; i < n; ++i) {
                        String string = ((JsonNumber)((JsonArray)object).get(i)).toString();
                        ((int[])object2)[i] = new Integer(string);
                    }
                    break;
                }
                object2 = new int[1];
                String string = ((JsonNumber)object).toString();
                ((int[])object2)[0] = new Integer(string);
                break;
            }
            case 8: 
            case 14: {
                if (n > 1) {
                    object2 = new long[n];
                    for (int i = 0; i < n; ++i) {
                        String string = ((JsonNumber)((JsonArray)object).get(i)).toString();
                        ((long[])object2)[i] = new Long(string);
                    }
                    break;
                }
                object2 = new long[1];
                String string = ((JsonNumber)object).toString();
                ((long[])object2)[0] = new Long(string);
                break;
            }
            case 33: {
                if (n > 1) {
                    object2 = new long[n];
                    for (int i = 0; i < n; ++i) {
                        String string;
                        object3 = ((JsonArray)object).get(i);
                        if (object3 instanceof JsonNumber) {
                            string = ((JsonNumber)object3).toString();
                            ((long[])object2)[i] = new Long(string);
                        }
                        if (!(object3 instanceof JsonString)) continue;
                        string = ((JsonString)object3).toString();
                        try {
                            ((long[])object2)[i] = CDFTT2000.toParse((String)string);
                            continue;
                        }
                        catch (Exception exception) {
                            ((long[])object2)[i] = -9223372036854775805L;
                        }
                    }
                    break;
                }
                object2 = new long[1];
                if (object instanceof JsonNumber) {
                    String string = ((JsonNumber)object).toString();
                    ((long[])object2)[0] = new Long(string);
                    break;
                }
                if (!(object instanceof JsonString)) break;
                String string = ((JsonString)object).toString();
                try {
                    ((long[])object2)[0] = new Long(CDFTT2000.toParse((String)string));
                }
                catch (Exception exception) {
                    ((long[])object2)[0] = -9223372036854775805L;
                }
            }
            case 21: 
            case 44: {
                if (n > 1) {
                    object2 = new float[n];
                    for (int i = 0; i < n; ++i) {
                        String string = ((JsonNumber)((JsonArray)object).get(i)).toString();
                        ((float[])object2)[i] = new Float(string).floatValue();
                    }
                    break;
                }
                object2 = new float[1];
                String string = ((JsonNumber)object).toString();
                ((float[])object2)[0] = new Float(string).floatValue();
                break;
            }
            case 22: 
            case 45: {
                if (n > 1) {
                    object2 = new double[n];
                    for (int i = 0; i < n; ++i) {
                        String string = ((JsonNumber)((JsonArray)object).get(i)).toString();
                        ((double[])object2)[i] = new Double(string);
                    }
                    break;
                }
                object2 = new double[1];
                String string = ((JsonNumber)object).toString();
                ((double[])object2)[0] = new Double(string);
                break;
            }
            case 31: {
                if (n > 1) {
                    object2 = new double[n];
                    for (int i = 0; i < n; ++i) {
                        String string;
                        object3 = ((JsonArray)object).get(i);
                        if (object3 instanceof JsonNumber) {
                            string = ((JsonNumber)object3).toString();
                            ((double[])object2)[i] = new Double(string);
                            continue;
                        }
                        if (!(object3 instanceof JsonString)) continue;
                        string = ((JsonString)object3).toString();
                        try {
                            ((double[])object2)[i] = Epoch.toParse((String)string);
                            continue;
                        }
                        catch (Exception exception) {
                            ((double[])object2)[i] = -1.0;
                        }
                    }
                    break;
                }
                object2 = new double[1];
                if (object instanceof JsonNumber) {
                    String string = ((JsonNumber)object).toString();
                    ((double[])object2)[0] = new Double(string);
                    break;
                }
                if (!(object instanceof JsonString)) break;
                String string = ((JsonString)object).toString();
                try {
                    ((double[])object2)[0] = new Double(Epoch.toParse((String)string));
                }
                catch (Exception exception) {
                    ((double[])object2)[0] = -1.0;
                }
            }
            case 32: {
                double[] dArray = new double[2];
                object3 = ((JsonArray)object).get(0);
                if (object3 instanceof JsonNumber) {
                    object2 = new double[n];
                    for (int i = 0; i < n / 2; ++i) {
                        String string = ((JsonNumber)((JsonArray)object).get(2 * i)).toString();
                        String string2 = ((JsonNumber)((JsonArray)object).get(2 * i + 1)).toString();
                        ((double[])object2)[2 * i] = new Double(string);
                        ((double[])object2)[2 * i + 1] = new Double(string2);
                    }
                    break;
                }
                if (!(object3 instanceof JsonString)) break;
                object2 = new double[2 * n];
                for (int i = 0; i < n; ++i) {
                    String string = ((JsonString)((JsonArray)object).get(i)).toString();
                    try {
                        dArray = Epoch16.toParse((String)string);
                    }
                    catch (Exception exception) {
                        dArray[0] = -1.0;
                        dArray[1] = -1.0;
                    }
                    ((double[])object2)[2 * i] = dArray[0];
                    ((double[])object2)[2 * i + 1] = dArray[1];
                }
                break;
            }
            default: {
                if (n > 1) {
                    Object object4 = ((JsonArray)object).get(0);
                    if (object4 instanceof JsonNumber) {
                        if (((JsonNumber)object4).isIntegral()) {
                            try {
                                object2 = new int[n];
                                for (int i = 0; i < n; ++i) {
                                    object3 = ((JsonArray)object).get(i);
                                    String string = ((JsonNumber)object3).toString();
                                    ((int[])object2)[i] = new Integer(string);
                                }
                                dataTypeY = 4L;
                                break;
                            }
                            catch (Exception exception) {
                                try {
                                    object2 = new long[n];
                                    for (int i = 0; i < n; ++i) {
                                        object3 = ((JsonArray)object).get(i);
                                        String string = ((JsonNumber)object3).toString();
                                        ((long[])object2)[i] = new Long(string);
                                    }
                                    dataTypeY = 8L;
                                    break;
                                }
                                catch (Exception exception2) {
                                    System.out.println("Error.... Json integer... value:" + object + " dt:" + dataTypeY + " " + exception2);
                                    return null;
                                }
                            }
                        }
                        object2 = new double[n];
                        for (int i = 0; i < n; ++i) {
                            object3 = ((JsonArray)object).get(i);
                            String string = ((JsonNumber)object3).toString();
                            ((double[])object2)[i] = new Double(string);
                        }
                        dataTypeY = 45L;
                        break;
                    }
                    if (!(object4 instanceof JsonString)) break;
                    object2 = new String();
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < n; ++i) {
                        object3 = ((JsonArray)object).get(i);
                        String string = ((JsonString)object3).toString();
                        if (string.startsWith("\"") && string.endsWith("\"")) {
                            string = string.substring(1, string.length() - 1);
                        }
                        stringBuffer = stringBuffer.append(string);
                        if (i == n - 1) continue;
                        stringBuffer = stringBuffer.append(" ");
                    }
                    object2 = new String(stringBuffer.toString());
                    dataTypeY = 51L;
                    break;
                }
                if (object instanceof JsonNumber) {
                    String string = ((JsonNumber)object).toString();
                    if (((JsonNumber)object).isIntegral()) {
                        try {
                            object2 = new int[1];
                            dataTypeY = 4L;
                            object2 = Json2CDF.parseContents(string, dataTypeY);
                            break;
                        }
                        catch (Exception exception) {
                            try {
                                object2 = new long[1];
                                dataTypeY = 8L;
                                object2 = Json2CDF.parseContents(string, dataTypeY);
                                break;
                            }
                            catch (Exception exception3) {
                                System.out.println("Error.... Json integer... value:" + string + " dt:" + dataTypeY + " " + exception3);
                                return null;
                            }
                        }
                    }
                    object2 = new double[1];
                    dataTypeY = 45L;
                    object2 = Json2CDF.parseContents(string, dataTypeY);
                    break;
                }
                if (!(object instanceof JsonString)) break;
                object2 = new String();
                String string = ((JsonString)object).toString();
                if (string.startsWith("\"") && string.endsWith("\"")) {
                    string = string.substring(1, string.length() - 1);
                }
                object2 = new String(string);
                dataTypeY = 51L;
            }
        }
        return object2;
    }

    static {
        varData = true;
        varSparseRec = 0L;
        varNumWritten = 0L;
        varMaxWritten = -1L;
        varDimSizes = new long[10];
        varDimVariances = new long[10];
        varName = null;
        varPadValue = null;
        varFillVal = null;
        varRecVary = -1L;
        separator = System.getProperty("file.separator");
        item1 = "CDFFileInfo";
        item2 = "CDFglobalAttributes";
        item3 = "CDFVariables";
        item4 = "VarDescription";
        item5 = "VarAttributes";
        item6 = "VarData";
        item7 = "EmptyAttributes";
        vAttrName = null;
        dataTypeY = -1L;
    }
}

