/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.Attribute;
import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JViewport;

public class AttributePanel
extends JSplitPane
implements CDFConstants {
    private MYEditor myEditor;
    private Attribute selectedAttr = null;
    private long scope;
    private AttrListListener all;
    private Hashtable controls = new Hashtable();
    private Hashtable currentAttributes = new Hashtable();
    private JLabeledPanel rightPanel;
    private EditgAttributeTableScrollPane gDisplay;
    private EditvAttributeTableScrollPane vDisplay;
    private CDFSpecPanel cdfspec;
    private int maxWritten;
    static final long serialVersionUID = 1L;

    public AttributePanel(MYEditor mYEditor, long l) {
        super(1);
        this.scope = l;
        this.setOneTouchExpandable(true);
        this.myEditor = mYEditor;
        this.all = new AttrListListener(this);
        if (l == 1L) {
            this.gDisplay = new EditgAttributeTableScrollPane(this);
        } else {
            this.vDisplay = new EditvAttributeTableScrollPane(this);
        }
        Vector vector = new Vector();
        JList jList = new JList(vector);
        jList.setSelectionMode(0);
        jList.addListSelectionListener(this.all);
        JScrollPane jScrollPane = new JScrollPane(jList);
        this.controls.put("listOfAttributes", jList);
        this.controls.put("attributeScrollPane", jScrollPane);
        this.controls.put("attributeVector", vector);
        JViewport jViewport = new JViewport();
        if (l == 1L) {
            jViewport.setView(new JLabel("gAttribute"));
        } else {
            jViewport.setView(new JLabel("vAttribute"));
        }
        jScrollPane.setColumnHeader(jViewport);
        this.rightPanel = new JLabeledPanel("CDF: " + mYEditor.theCDF.toString(), new BorderLayout());
        this.cdfspec = new CDFSpecPanel();
        CDF cDF = mYEditor.theCDF;
        this.maxWritten = CDFToolUtils.getMaxRecNum(cDF);
        this.cdfspec.set(cDF);
        this.rightPanel.add((Component)this.cdfspec, "North");
        this.updateListOfAttributes();
        if (l == 1L) {
            this.rightPanel.add((Component)this.gDisplay, "Center");
        } else {
            this.rightPanel.add((Component)this.vDisplay, "Center");
        }
        this.setLeftComponent(jScrollPane);
        this.setRightComponent(this.rightPanel);
        jScrollPane.setPreferredSize(new Dimension(100, 620));
        this.rightPanel.setPreferredSize(new Dimension(670, 620));
        this.setDividerLocation(100);
        this.setDividerSize(5);
        this.setPreferredSize(new Dimension(mYEditor.getEditWidth(), mYEditor.getEditHeight()));
    }

    public void updateAttrPanel(Attribute attribute, boolean bl) {
        this.selectedAttr = attribute;
        if (attribute != null) {
            if (this.scope == 2L) {
                this.myEditor.enablevAttrMenu();
                this.vDisplay.buildTable(this.selectedAttr);
            } else {
                this.myEditor.enablegAttrMenu();
                if (bl) {
                    this.gDisplay.buildTable();
                } else {
                    this.gDisplay.reset();
                }
            }
        } else if (this.scope == 2L) {
            this.vDisplay.reset();
        } else {
            this.gDisplay.reset();
        }
        this.rightPanel.revalidate();
        this.rightPanel.repaint();
        System.gc();
    }

    public void reselectCurrentAttribute() {
        JList jList = (JList)this.controls.get("listOfAttributes");
        JScrollPane jScrollPane = (JScrollPane)this.controls.get("attributeScrollPane");
        jList.removeListSelectionListener(this.all);
        jList.setSelectedValue(this.selectedAttr.toString(), true);
        jList.addListSelectionListener(this.all);
        this.rightPanel.revalidate();
        this.rightPanel.repaint();
        jScrollPane.revalidate();
        jScrollPane.repaint();
        System.gc();
        if (this.scope == 2L) {
            this.myEditor.enablevAttrMenu();
        } else {
            this.myEditor.enablegAttrMenu();
        }
    }

    public void resetPanel(boolean bl) {
        if (this.scope == 1L) {
            this.gDisplay.reset();
        } else {
            this.vDisplay.reset();
        }
        if (bl) {
            this.updateListOfAttributes();
            this.selectedAttr = null;
        }
    }

    public void updateListOfAttributes() {
        Vector<String> vector = new Vector<String>();
        JList jList = (JList)this.controls.get("listOfAttributes");
        JScrollPane jScrollPane = (JScrollPane)this.controls.get("attributeScrollPane");
        Attribute attribute = null;
        if (this.myEditor.theCDF != null) {
            Enumeration enumeration = this.myEditor.theCDF.getAttributes().elements();
            while (enumeration.hasMoreElements()) {
                attribute = (Attribute)enumeration.nextElement();
                if (attribute.getScope() != this.scope) continue;
                vector.addElement(attribute.toString());
            }
        }
        this.controls.put("attributeVector", vector);
        jList.setListData(vector);
        jScrollPane.revalidate();
        jScrollPane.repaint();
        System.gc();
    }

    public void addToListOfAttributes(Object object) {
        if (((Attribute)object).getScope() == this.scope) {
            Vector vector = (Vector)this.controls.get("attributeVector");
            JList jList = (JList)this.controls.get("listOfAttributes");
            JScrollPane jScrollPane = (JScrollPane)this.controls.get("attributeScrollPane");
            if (!vector.contains(object.toString())) {
                vector.addElement(object.toString());
                this.controls.put("attributeVector", vector);
                jList.setListData(vector);
                jScrollPane.revalidate();
                jScrollPane.repaint();
                System.gc();
            }
        }
    }

    public void removeFromListOfAttributes(Object object) {
        if (((Attribute)object).getScope() == this.scope) {
            Vector vector = (Vector)this.controls.get("attributeVector");
            JList jList = (JList)this.controls.get("listOfAttributes");
            JScrollPane jScrollPane = (JScrollPane)this.controls.get("attributeScrollPane");
            vector.removeElement(object.toString());
            this.controls.put("attributeVector", vector);
            jList.setListData(vector);
            jScrollPane.revalidate();
            jScrollPane.repaint();
            System.gc();
        }
    }

    public void saveAttributeChanges() {
    }

    public void renameSelectedAttr(String string) throws CDFException {
        String string2 = this.selectedAttr.toString();
        this.selectedAttr.rename(string);
        Vector vector = (Vector)this.controls.get("attributeVector");
        JList jList = (JList)this.controls.get("listOfAttributes");
        JScrollPane jScrollPane = (JScrollPane)this.controls.get("attributeScrollPane");
        jList.removeListSelectionListener(this.all);
        int n = vector.indexOf(string2);
        vector.removeElementAt(n);
        vector.insertElementAt(this.selectedAttr.toString(), n);
        this.controls.put("attributeVector", vector);
        jList.setListData(vector);
        jList.setSelectedValue(string, true);
        jScrollPane.revalidate();
        jScrollPane.repaint();
        System.gc();
        jList.addListSelectionListener(this.all);
    }

    public void deleteSelectedAttr() throws CDFException {
        try {
            Vector vector = (Vector)this.controls.get("attributeVector");
            JList jList = (JList)this.controls.get("listOfAttributes");
            jList.removeListSelectionListener(this.all);
            JScrollPane jScrollPane = (JScrollPane)this.controls.get("attributeScrollPane");
            vector.removeElementAt(vector.indexOf(this.selectedAttr.toString()));
            this.controls.put("attributeVector", vector);
            jList.setListData(vector);
            jList.setSelectedIndex(-1);
            jList.addListSelectionListener(this.all);
            jScrollPane.revalidate();
            jScrollPane.repaint();
            this.resetPanel(false);
            System.gc();
            this.selectedAttr.delete();
            if (this.selectedAttr.getScope() == 1L) {
                this.myEditor.disablegAttrMenu();
            } else {
                this.myEditor.disablevAttrMenu();
            }
            this.selectedAttr = null;
        }
        catch (CDFException cDFException) {
            System.err.println("AttributePanel.deleteSelectedAttr: " + cDFException);
        }
    }

    public Attribute getSelectedAttr() {
        return this.selectedAttr;
    }

    public Hashtable getControls() {
        return this.controls;
    }

    public Object getControl(String string) {
        return this.controls.get(string);
    }

    public Object getAttribute(String string) {
        return this.currentAttributes.get(string);
    }

    private void putAttribute(String string, Object object) {
        this.currentAttributes.put(string, object);
    }

    public int getMaxWritten() {
        return this.maxWritten;
    }

    public void setMaxWritten(int n) {
        this.maxWritten = n;
    }

    public long getScope() {
        return this.scope;
    }

    public MYEditor getMyEditor() {
        return this.myEditor;
    }

    public EditgAttributeTableScrollPane getgDisplay() {
        return this.gDisplay;
    }

    public EditvAttributeTableScrollPane getvDisplay() {
        return this.vDisplay;
    }

    public CDFSpecPanel getCDFSpecPanel() {
        return this.cdfspec;
    }

    public JLabeledPanel getRightPanel() {
        return this.rightPanel;
    }
}

