'
'
'  SPDF/CDF                   Quick VB Start Test Program(C# interface).
'
'  Version 1.0,15-Oct-09,Mike Liu
'
'  Modification history:
'
'   V1.0   12-Jun-13,M Liu     Original version(for CDF V3.5).
'
'


Imports System
Imports System.Runtime.InteropServices
Imports CDF

Public Class Qst2vb2
	Inherits CDFAPIs

	Public Shared Sub Main()
		Dim id As Long = 0
		Dim status As Integer

		Dim N_DIMS As Integer = 2
		Dim DIM_0_SIZE As Integer = 2
		Dim DIM_1_SIZE As Integer = 3

		Dim zN_DIMSa As Integer = 1
		Dim zDIM_0_SIZEa As Integer = 5
		Dim zNUM_ELEMSa As Integer = 8

		Dim dim_n As Integer
		Dim encoding As Integer = NETWORK_ENCODING
		Dim actual_encoding As Integer = NETWORK_ENCODING
		Dim majority As Integer = ROW_MAJOR
		Dim numDims As Integer = N_DIMS
		Dim dimSizes As Integer() = New Integer(1) {2, 3}
		Dim zNumDimsA As Integer = zN_DIMSa
		Dim zDimSizesA As Integer() = New Integer(0) {5}
		Dim var1DataType As Integer = CDF_INT2
		Dim var1DataTypeNew As Integer = CDF_UINT2
		Dim var2DataType As Integer = CDF_REAL4
		Dim var3DataType As Integer = CDF_CHAR
		Dim var3DataTypeNew As Integer = CDF_UCHAR
		Dim var1NumElements As Integer = 1
		Dim var2NumElements As Integer = 1
		Dim var3NumElements As Integer = zNUM_ELEMSa
		Dim var3NumElementsNew As Integer = zNUM_ELEMSa
		Dim var1Values As Short(,) = New Short(1, 2) {{1, 2, 3}, _
							      {4, 5, 6}}
		Dim var2Values As Single(,) = New Single(1, 2) {{1F, 2F, 3F}, _
								{4F, 5F, 6F}}
		Dim var3Values As String() = New String(4) {"11111111", _
			"22222222", "33333333", "44444444", "55555555"}
		Dim recNum As Integer = 0
		Dim recStart As Integer = 2
		Dim recCount As Integer = 1
		Dim recInterval As Integer = 1
		Dim indices As Integer() = New Integer(1) {}
		Dim counts As Integer() = New Integer(1) {2, 3}
		Dim intervals As Integer() = New Integer(1) {1, 1}
		Dim zIndicesA As Integer() = New Integer(0) {}
		Dim zCounts As Integer() = New Integer(0) {5}
		Dim zIntervals As Integer() = New Integer(0) {1}
		Dim entryNum As Integer = 2
		Dim attrScope As Integer = GLOBAL_SCOPE
		Dim attrScope2 As Integer = VARIABLE_SCOPE
		Dim attrScope3 As Integer = VARIABLE_SCOPE
		Dim entryDataType As Integer = CDF_INT2
		Dim entryDataTypeNew As Integer = CDF_UINT2
		Dim entryNumElems As Integer = 1
		Dim entryValue As Short = 1
		Dim x0 As Integer, x1 As Integer
		Dim var1Num_out As Integer, var2Num_out As Integer, _
		    var3Num_out As Integer, attrNum_out As Integer
		Dim var1RecVariance As Integer = VARY
		Dim var1RecVarianceNew As Integer = NOVARY
		Dim var2RecVariance As Integer = VARY
		Dim var3RecVariance As Integer = VARY
		Dim var3RecVarianceNew As Integer = NOVARY
		Dim var1DimVariances As Integer() = New Integer(1) {VARY, VARY}
		Dim var1DimVariancesNew As Integer() = New Integer(1) _
							{NOVARY, NOVARY}
		Dim var2DimVariances As Integer() = New Integer(1) {VARY, VARY}
		Dim var3DimVariances As Integer() = New Integer(0) {VARY}
		Dim var3DimVariancesNew As Integer() = New Integer(0) {NOVARY}
		Dim var1Name As String = "VAR1a"
		Dim var2Name As String = "VAR2a"
		Dim var3Name As String = "zVARa1"
		Dim new_var1Name As String = "VAR1b"
		Dim new_var2Name As String = "VAR2b"
		Dim new_var3Name As String = "zVARa2"
		Dim attrName As String = "ATTR1"
		Dim attrName2 As String = "ATTR2"
		Dim attrName3 As String = "ATTR3"
		Dim new_attrName As String = "ATTR1a"
		Dim CopyrightText As String
		Dim errorText As String
		Dim zEntryValue1 As SByte = 4
		Dim zEntryValue2 As Double = 5.0
		Dim pad1 As Short = -999
		Dim pad2 As Single = -8F
		Dim pad3 As String = "********"
		Dim blockingfactor1 As Integer = 3
		Dim blockingfactor2 As Integer = 4
		Dim blockingfactor3 As Integer = 5
		Dim allocRecs1 As Integer = 10
		Dim allocRecs2 As Integer = 15
		Dim allocRecs3 As Integer = 8
		Dim comType As Integer = GZIP_COMPRESSION
		Dim comParms As Integer() = New Integer() {9}
		Dim varNs1 As Integer() = New Integer(0) {0}, _
		    varNs2 As Integer() = New Integer(0) {2}
		Dim varsRecBuffer2 As String() = New String(4) {"%%%%%%%%", _
                    "%%%%%%%%", "%%%%%%%%", "%%%%%%%%", "%%%%%%%%"}

		' ***********************************************************
                ' Display title.
                ' ***********************************************************

		Console.WriteLine("Testing VB-CDF Interface... using generic Objects for reading variable data and attribute entry")

		' ***********************************************************
		' Create CDF.
		' ***********************************************************

		Try
			status = CDFcreate("TEST", numDims, dimSizes, _
					   encoding, majority, id)
		Catch ex As CDFException
			Dim stat As Integer = ex.CDFgetCurrentStatus()
			If stat < CDF_OK Then
'				id = 0
				If stat = CDF_EXISTS Then
					status = CDFopen("TEST", id)

					status = CDFdeleteCDF(id)

					status = CDFcreate("TEST", numDims, _
							   dimSizes, encoding, _
							   majority, id)
					status = CDFsetFormat(id, MULTI_FILE)
				Else
					QuitCDF("1.4", stat, id)
				End If
			End If
		End Try

		Try
			status = CDFsetFormat(id, MULTI_FILE)

			' *****************************************************
			' Create variables and set/confirm cache sizes,etc.
			' *****************************************************

			status = CDFcreatezVar(id, var1Name, var1DataType, _
					       var1NumElements, numDims, _
					       dimSizes, var1RecVariance, _
					       var1DimVariances, var1Num_out)

			status = CDFputzVarPadValue(id, var1Num_out, pad1)

			status = CDFcreatezVar(id, var2Name, var2DataType, _
					       var2NumElements, numDims, _
					       dimSizes, var2RecVariance, _
					       var2DimVariances, var2Num_out)

			status = CDFputzVarPadValue(id, var2Num_out, pad2)

			status = CDFcreatezVar(id, var3Name, var3DataType, _
					       var3NumElements, zNumDimsA, _
					       zDimSizesA, var3RecVariance, _
					       var3DimVariances, var3Num_out)

			status = CDFputzVarPadValue(id, var3Num_out, pad3)

			status = CDFsetzVarsCacheSize(id, 5)

			Dim cacheOut1o As Integer, cacheOut2o As Integer, _
			    cacheOut3o As Integer
			Dim pad1outo As Object
			Dim pad2outo As Object
			Dim pad3outo As Object

			status = CDFgetzVarCacheSize(id, 0, cacheOut1o)

			status = CDFgetzVarPadValue(id, 0, pad1outo)
			Dim pad1outoo As Short = CShort(pad1outo)

			status = CDFgetzVarCacheSize(id, 1, cacheOut2o)

			status = CDFgetzVarPadValue(id, 1, pad2outo)
			Dim pad2outoo As Single = CSng(pad2outo)

			status = CDFgetzVarCacheSize(id, 2, cacheOut3o)

			status = CDFgetzVarPadValue(id, 2, pad3outo)
			Dim pad3outoo As String = DirectCast(pad3outo, String)

			If cacheOut1o <> 5 Then
				QuitCDF("2.14", status, id)
			End If
			If cacheOut2o <> 5 Then
				QuitCDF("2.15", status, id)
			End If
			If cacheOut3o <> 5 Then
				QuitCDF("2.16", status, id)
			End If
			If pad1outoo <> pad1 Then
				QuitCDF("2.17", status, id)
			End If
			If pad2outoo <> pad2 Then
				QuitCDF("2.18", status, id)
			End If
			If [String].Compare(pad3outoo, pad3) <> 0 Then
				QuitCDF("2.19", status, id)
			End If

			status = CDFsetzVarCacheSize(id, 0, 4)

			status = CDFsetzVarCacheSize(id, 2, 8)

			status = CDFgetzVarCacheSize(id, 0, cacheOut1o)

			status = CDFgetzVarCacheSize(id, 1, cacheOut2o)

			status = CDFgetzVarCacheSize(id, 2, cacheOut3o)

			If CInt(cacheOut1o) <> 4 Then
				QuitCDF("2.25", status, id)
			End If
			If CInt(cacheOut2o) <> 5 Then
				QuitCDF("2.26", status, id)
			End If
			If CInt(cacheOut3o) <> 8 Then
				QuitCDF("2.27", status, id)
			End If

			' *****************************************************
			' Modify variables.
			' *****************************************************

			status = CDFsetzVarDataSpec(id, 0, var1DataTypeNew)

			status = CDFsetzVarRecVariance(id, 0, var1RecVarianceNew)

			status = CDFsetzVarDimVariances(id, 0, var1DimVariancesNew)

			status = CDFsetzVarInitialRecs(id, 0, 1)

			status = CDFsetzVarDataSpec(id, 2, var3DataTypeNew)

			status = CDFsetzVarRecVariance(id, 2, var3RecVarianceNew)

			status = CDFsetzVarDimVariances(id, 2, var3DimVariancesNew)

			status = CDFsetzVarInitialRecs(id, 2, 1)

			' *****************************************************
			' Close CDF.
			' *****************************************************

			status = CDFcloseCDF(id)

			' *****************************************************
			' Reopen CDF.
			' *****************************************************


			status = CDFopen("TEST", id)

			status = CDFsetDecoding(id, HOST_DECODING)

			'
			' Delete CDF.
			'

			status = CDFdeleteCDF(id)

			'
			' Create CDF again(previous delete will allow this).
			'

			status = CDFcreateCDF("TEST", id)

			status = CDFsetEncoding(id, NETWORK_ENCODING)

			status = CDFsetMajority(id, ROW_MAJOR)

			status = CDFsetFormat(id, SINGLE_FILE)

			status = CDFsetDecoding(id, HOST_DECODING)

			status = CDFsetCompression(id, comType, comParms)

			' *****************************************************
			' Create variables.
			' *****************************************************


			status = CDFcreatezVar(id, var1Name, var1DataType, _
					       var1NumElements, numDims, _
					       dimSizes, var1RecVariance, _
					       var1DimVariances, var1Num_out)

			status = CDFsetzVarAllocRecords(id, var1Num_out, _
							allocRecs1)

			status = CDFsetzVarBlockingFactor(id, var1Num_out, _
							   blockingfactor1)

			status = CDFcreatezVar(id, var2Name, var2DataType, _
					       var2NumElements, numDims, _
					       dimSizes, var2RecVariance, _
					       var2DimVariances, var2Num_out)

			status = CDFsetzVarAllocRecords(id, var2Num_out, _
							allocRecs2)

			status = CDFsetzVarBlockingFactor(id, var2Num_out, _
							  blockingfactor2)

			status = CDFcreatezVar(id, var3Name, var3DataType, _
					       var3NumElements, zNumDimsA, _
					       zDimSizesA, var3RecVariance, _
					       var3DimVariances, var3Num_out)

			status = CDFsetzVarAllocRecords(id, var3Num_out, _
							allocRecs3)

			status = CDFsetzVarBlockingFactor(id, var3Num_out, _
							  blockingfactor3)

			' *****************************************************
			' PUT to variables.
			' *****************************************************

			For x0 = 0 To DIM_0_SIZE - 1
				For x1 = 0 To DIM_1_SIZE - 1
				   indices(0) = x0
				   indices(1) = x1
				   status = CDFputzVarData(id, var1Num_out, _
							   recNum, indices, _
							   var1Values(x0, x1))

				   status = CDFputzVarData(id, var2Num_out, _
							   recNum, indices, _
							   var2Values(x0, x1))
				Next
			Next
			For x0 = 0 To zDIM_0_SIZEa - 1
				zIndicesA(0) = x0
				status = CDFputzVarData(id, var3Num_out, _
							recNum, zIndicesA, _
							var3Values(x0))
			Next
			'
			' GET from the variables.
			'

			Dim pvalue1o As Object, pvalue2o As Object, _
			    pvalue3o As Object
			Dim pvalue1oo As Short
			Dim pvalue2oo As Single
			Dim pvalue3oo As String

			For x0 = 0 To DIM_0_SIZE - 1
				For x1 = 0 To DIM_1_SIZE - 1
				   indices(0) = x0
				   indices(1) = x1

				   status = CDFgetzVarData(id, var1Num_out, _
							   recNum, indices, _
							   pvalue1o)
				   ' Console.WriteLine("object={0}", pvalue1o)
				   pvalue1oo = CShort(pvalue1o)
				   status = CDFgetzVarData(id, var2Num_out, _
							   recNum, indices, _
							   pvalue2o)
				   pvalue2oo = CSng(pvalue2o)

				   If pvalue1oo <> var1Values(x0, x1) Then
						QuitCDF("10.2", status, id)
				   End If
				   If pvalue2oo <> var2Values(x0, x1) Then
						QuitCDF("10.3", status, id)
				   End If
				Next
			Next
			status = CDFgetzVarRecordData(id, var1Num_out, _
						      recNum, pvalue1o)
			Dim pvalue1ooo As Short(,) = DirectCast(pvalue1o, _
								Short(,))

			status = CDFgetzVarRecordData(id, var2Num_out, _
						      recNum, pvalue2o)
			Dim pvalue2ooo As Single(,) = DirectCast(pvalue2o, _
								 Single(,))

			For x0 = 0 To DIM_0_SIZE - 1
				For x1 = 0 To DIM_1_SIZE - 1
				   If pvalue1ooo(x0, x1) <> var1Values(x0, x1) _
									Then
						QuitCDF("10.2a", status, id)
				   End If
				   If pvalue2ooo(x0, x1) <> var2Values(x0, x1) _
									Then
						QuitCDF("10.3a", status, id)
				   End If
				Next
			Next
			For x0 = 0 To zDIM_0_SIZEa - 1
				zIndicesA(0) = x0
				status = CDFgetzVarData(id, var3Num_out, _
							recNum, zIndicesA, _
							pvalue3o)
				pvalue3oo = DirectCast(pvalue3o, String)

				If [String].Compare(pvalue3oo, var3Values(x0)) <> 0 Then
					QuitCDF("10.5", status, id)
				End If
			Next

			' *****************************************************
			' HyperPUT to the variables.
			' *****************************************************

			For x0 = 0 To DIM_0_SIZE - 1
				For x1 = 0 To DIM_1_SIZE - 1
				   var1Values(x0, x1) = CShort(-var1Values(x0, x1))
				   var2Values(x0, x1) = -var2Values(x0, x1)
				Next
			Next

			indices(0) = 0
			indices(1) = 0
			status = CDFhyperPutzVarData(id, var1Num_out, _
						     recStart, recCount, _
						     recInterval, indices, _
						     counts, intervals, _
						     var1Values)

			status = CDFhyperPutzVarData(id, var2Num_out, _
						     recStart, recCount, _
						     recInterval, indices, _
						     counts, intervals, _
						     var2Values)
			Dim mychar() as Char = {"2"C,"3"C,"4"C,"5"C,"6"C,"7"C,"8"C} 
			For x0 = 0 To zDIM_0_SIZEa - 1
				var3Values(x0) = New String(mychar(x0), zNUM_ELEMSa)
			Next

			zIndicesA(0) = 0
			status = CDFhyperPutzVarData(id, var3Num_out, _
						     recStart, recCount, _
						     recInterval, zIndicesA, _
						     zCounts, zIntervals, _
						     var3Values)

			' *****************************************************
			' HyperGET from variables.
			' *****************************************************


			Dim pvalues1o As Object, pvalues2o As Object
			Dim pvalues3o As Object
			'short[] pvalues1o;
			'float[] pvalues2o;
			'string[] pvalues3o;

			status = CDFhyperGetzVarData(id, var1Num_out, _
						     recStart, recCount, _
						     recInterval, indices, _
						     counts, intervals, _
						     pvalues1o)
			Dim pvalues1oo As Short(,) = DirectCast(pvalues1o, Short(,))

			status = CDFhyperGetzVarData(id, var2Num_out, _
						     recStart, recCount, _
						     recInterval, indices, _
						     counts, intervals, _
						     pvalues2o)
			Dim pvalues2oo As Single(,) = DirectCast(pvalues2o, Single(,))

			For x0 = 0 To DIM_0_SIZE - 1
				For x1 = 0 To DIM_1_SIZE - 1
				   If DirectCast(pvalues1o, Short(,))(x0, x1) _
				      <> var1Values(x0, x1) Then
						QuitCDF("12.2", status, id)
				   End If
				   If DirectCast(pvalues2o, Single(,))(x0, x1) _
				      <> var2Values(x0, x1) Then
						QuitCDF("12.3", status, id)
				   End If
				Next
			Next

			status = CDFhyperGetzVarData(id, var3Num_out, _
						     recStart, recCount, _
						     recInterval, zIndicesA, _
				zCounts, zIntervals, pvalues3o)
			Dim pvalues3oo As String() = DirectCast(pvalues3o, String())

			For x0 = 0 To zDIM_0_SIZEa - 1
				If [String].Compare(pvalues3oo(x0), var3Values(x0)) <> 0 Then
					QuitCDF("12.5", status, id)
				End If
			Next

			' *****************************************************
			' Set/confirm sequential access position for a 
			' zVariable (and read/write a value).
			' *****************************************************

			status = CDFsetzVarSeqPos(id, var3Num_out, _
						  recStart, zIndicesA)

			Dim var3Valueo As String
			Dim recNumOuto As Integer
			Dim ptro As Integer()

			status = CDFgetzVarSeqData(id, var3Num_out, _
						   var3Valueo)
			Dim var3Valueoo As String = var3Valueo

			status = CDFputzVarSeqData(id, var3Num_out, _
						   var3Valueo)

			Dim v3Indices As Integer() = New Integer(0) _
							{zIndicesA(0) + 1}
			Dim var3Valuea As Object
			status = CDFgetzVarData(id, var3Num_out, recStart, _
						v3Indices, var3Valuea)
			Dim var3Valueaa As String = DirectCast(var3Valuea, String)

			status = CDFgetzVarSeqPos(id, var3Num_out, _
						  recNumOuto, ptro)

			If recNumOuto <> recStart Then
				QuitCDF("14.4", status, id)
			End If
			If ptro(0) <> zIndicesA(0) + 2 Then
				QuitCDF("14.5", status, id)
			End If
			If [String].Compare(var3Valueoo, var3Valueaa) <> 0 Then
				QuitCDF("14.6", status, id)
			End If

			' *****************************************************
			' Create attributes.
			' *****************************************************

			status = CDFcreateAttr(id, attrName, attrScope, _
					       attrNum_out)

			status = CDFcreateAttr(id, attrName2, attrScope2, _
					       attrNum_out)

			status = CDFcreateAttr(id, attrName3, attrScope3, _
					       attrNum_out)

			' *****************************************************
			' PUT to attributes.
			' *****************************************************

			status = CDFputAttrgEntry(id, 0, entryNum, _
						  entryDataType, entryNumElems, _
						  entryValue)


			status = CDFputAttrzEntry(id, 1, _
						  CDFgetVarNum(id, var1Name), _
						  CDF_BYTE, 1, zEntryValue1)

			status = CDFputAttrzEntry(id, 2, _
						  CDFgetVarNum(id, var2Name), _
						  CDF_REAL8, 1, zEntryValue2)

			' *****************************************************
			' GET from attributes.
			' *****************************************************


			Dim entryValueo As Object, zEntryValue1o As Object, _
			    zEntryValue2o As Object

			status = CDFgetAttrgEntry(id, 0, entryNum, entryValueo)
			Dim entryValueoo As Short = CShort(entryValueo)

			status = CDFgetAttrzEntry(id, 1, _
						  CDFgetVarNum(id, var1Name), _
						  zEntryValue1o)
			Dim zEntryValue1oo As SByte = CSByte(zEntryValue1o)

			status = CDFgetAttrzEntry(id, 2, _
						  CDFgetVarNum(id, var2Name), _
						  zEntryValue2o)
			Dim zEntryValue2oo As Double = CDbl(zEntryValue2o)

			If entryValueoo <> entryValue Then
				QuitCDF("19.6", status, id)
			End If
			If zEntryValue1oo <> zEntryValue1 Then
				QuitCDF("19.7", status, id)
			End If
			If zEntryValue2oo <> zEntryValue2 Then
				QuitCDF("19.8", status, id)
			End If

			' *****************************************************
			' Confirm existence of variables/attributes/entries.
			' *****************************************************

			status = CDFconfirmzVarExistence(id, var3Name)
			If status < CDF_OK Then
				QuitCDF("20.1", status, id)
			End If

			status = CDFconfirmzVarExistence(id, var1Name)
			If status < CDF_OK Then
				QuitCDF("20.2", status, id)
			End If

			status = CDFconfirmAttrExistence(id, attrName3)
			If status < CDF_OK Then
				QuitCDF("20.3", status, id)
			End If

			status = CDFconfirmgEntryExistence(id, 0, entryNum)
			If status < CDF_OK Then
				QuitCDF("20.4", status, id)
			End If

			status = CDFconfirmzEntryExistence(id, 1, _
						CDFgetVarNum(id, var1Name))
			If status < CDF_OK Then
				QuitCDF("20.5", status, id)
			End If

			' *****************************************************
			' Get CDF documentation.
			' *****************************************************

			Dim versiono As Integer, releaseo As Integer, _
			    incremento As Integer
			Dim subincremento As String

			status = CDFgetLibraryVersion(versiono, releaseo, _
						      incremento, _
						      subincremento)

			status = CDFgetLibraryCopyright(CopyrightText)

			' *****************************************************
			' Inquire CDF.
			' *****************************************************


			Dim formato As Integer, encodingo As Integer, _
			    majorityo As Integer, maxReco As Integer, _
			    numZvarso As Integer, numAttrso As Integer

			status = CDFgetFormat(id, formato)

			status = CDFgetEncoding(id, encodingo)

			status = CDFgetMajority(id, majorityo)

			status = CDFgetzVarsMaxWrittenRecNum(id, maxReco)

			status = CDFgetNumzVars(id, numZvarso)

			status = CDFgetNumAttributes(id, numAttrso)

			If formato <> SINGLE_FILE Then
				QuitCDF("22.9", status, id)
			End If
			If encodingo <> actual_encoding Then
				QuitCDF("22.12", status, id)
			End If
			If majorityo <> majority Then
				QuitCDF("22.13", status, id)
			End If
			If maxReco <> 2 Then
				QuitCDF("22.14", status, id)
			End If
			If numZvarso <> 3 Then
				QuitCDF("22.16", status, id)
			End If
			If numAttrso <> 3 Then
				QuitCDF("22.17", status, id)
			End If

			' *****************************************************
			' Inquire numbers.
			' *****************************************************

			attrNum_out = CDFgetAttrNum(id, attrName3)

			Dim varNum_out1 As Integer = CDFgetVarNum(id, var2Name)

			Dim varNum_out2 As Integer = CDFgetVarNum(id, var3Name)

			If attrNum_out <> 2 Then
				QuitCDF("23.3", status, id)
			End If
			If varNum_out1 <> 1 Then
				QuitCDF("23.4", status, id)
			End If
			If varNum_out2 <> 2 Then
				QuitCDF("23.5", status, id)
			End If

			' *****************************************************
			' Rename variables.
			' *****************************************************

			status = CDFrenamezVar(id, CDFgetVarNum(id, var1Name), _
					       new_var1Name)

			status = CDFrenamezVar(id, CDFgetVarNum(id, var2Name), _
					       new_var2Name)

			status = CDFrenamezVar(id, CDFgetVarNum(id, var3Name), _
					       new_var3Name)

			' *****************************************************
			' Inquire variables.
			' *****************************************************

			Dim var1Nameo As String
			Dim var1DataTypeo As Integer, _
			    var1NumElementso As Integer, _
			    var1RecVarianceo As Integer
			Dim var1DimVarianceso As Integer()
			Dim blockingfactor1o As Integer, max1Alloco As Integer
			Dim max1Reco As Integer

			status = CDFgetzVarName(id, var1Num_out, var1Nameo)

			status = CDFgetzVarDataType(id, var1Num_out, _
						    var1DataTypeo)

			status = CDFgetzVarNumElements(id, var1Num_out, _
						       var1NumElementso)

			status = CDFgetzVarRecVariance(id, var1Num_out, _
						       var1RecVarianceo)

			status = CDFgetzVarDimVariances(id, var1Num_out, _
							var1DimVarianceso)

			status = CDFgetzVarBlockingFactor(id, var1Num_out, _
							  blockingfactor1o)

			status = CDFgetzVarMaxAllocRecNum(id, var1Num_out, _
							  max1Alloco)

			status = CDFgetzVarMaxWrittenRecNum(id, var1Num_out, _
							    max1Reco)

			If [String].Compare(var1Nameo, new_var1Name) <> 0 Then
				QuitCDF("26.11", status, id)
			End If
			If var1DataTypeo <> var1DataType Then
				QuitCDF("26.12", status, id)
			End If
			If var1NumElementso <> var1NumElements Then
				QuitCDF("26.13", status, id)
			End If
			If var1RecVarianceo <> var1RecVariance Then
				QuitCDF("26.14", status, id)
			End If
			If var1Num_out <> 0 Then
				QuitCDF("26.15", status, id)
			End If
			If blockingfactor1o <> blockingfactor1 Then
				QuitCDF("26.16", status, id)
			End If
			If max1Alloco + 1 <> allocRecs1 Then
				QuitCDF("26.17", status, id)
			End If
			If max1Reco <> 2 Then
				QuitCDF("26.18", status, id)
			End If

			For dim_n = 0 To numDims - 1
				If var1DimVariances(dim_n) <> _
				   var1DimVariances(dim_n) Then
					QuitCDF("26.19", status, id)
				End If
			Next

			Dim var2Nameo As String
			Dim var2DataTypeo As Integer, _
			    var2NumElementso As Integer, _
			    var2RecVarianceo As Integer
			Dim blockingfactor2o As Integer, _
			    max2Alloco As Integer, max2Reco As Integer
			Dim var2DimVarianceso As Integer()

			status = CDFgetzVarName(id, var2Num_out, var2Nameo)

			status = CDFgetzVarDataType(id, var2Num_out, _
						var2DataTypeo)

			status = CDFgetzVarNumElements(id, var2Num_out, _
						       var2NumElementso)

			status = CDFgetzVarRecVariance(id, var2Num_out, _
						       var2RecVarianceo)

			status = CDFgetzVarDimVariances(id, var2Num_out, _
							var2DimVarianceso)

			status = CDFgetzVarBlockingFactor(id, var2Num_out, _
							  blockingfactor2o)

			status = CDFgetzVarMaxAllocRecNum(id, var2Num_out, _
							  max2Alloco)

			status = CDFgetzVarMaxWrittenRecNum(id, var2Num_out, _
							    max2Reco)

			If [String].Compare(var2Nameo, new_var2Name) <> 0 Then
				QuitCDF("26.31", status, id)
			End If
			If var2DataTypeo <> var2DataType Then
				QuitCDF("26.32", status, id)
			End If
			If var2NumElementso <> var2NumElements Then
				QuitCDF("26.33", status, id)
			End If
			If var2RecVarianceo <> var2RecVariance Then
				QuitCDF("26.34", status, id)
			End If
			If var2Num_out <> 1 Then
				QuitCDF("26.35", status, id)
			End If
			If blockingfactor2o <> blockingfactor2 Then
				QuitCDF("26.36", status, id)
			End If
			If max2Alloco + 1 <> allocRecs2 Then
				QuitCDF("26.37", status, id)
			End If
			If max2Reco <> 2 Then
				QuitCDF("26.38", status, id)
			End If


			For dim_n = 0 To numDims - 1
				If var2DimVarianceso(dim_n) <> _
				   var2DimVariances(dim_n) Then
					QuitCDF("26.39", status, id)
				End If
			Next

			Dim var3Nameo As String
			Dim var3DataTypeo As Integer, _
			    var3NumElementso As Integer, _
			    var3RecVarianceo As Integer
			Dim blockingfactor3o As Integer, _
			    max3Alloco As Integer, max3Reco As Integer
			Dim var3DimVarianceso As Integer()
			Dim zNumDimsAo As Integer
			Dim zDimSizesAo As Integer()

			status = CDFgetzVarName(id, var3Num_out, var3Nameo)

			status = CDFgetzVarDataType(id, var3Num_out, _
						    var3DataTypeo)

			status = CDFgetzVarNumElements(id, var3Num_out, _
						       var3NumElementso)

			status = CDFgetzVarRecVariance(id, var3Num_out, _
						       var3RecVarianceo)

			status = CDFgetzVarDimVariances(id, var3Num_out, _
						        var3DimVarianceso)

			status = CDFgetzVarNumDims(id, var3Num_out, _
						   zNumDimsAo)

			status = CDFgetzVarDimSizes(id, var3Num_out, _
						    zDimSizesAo)

			status = CDFgetzVarBlockingFactor(id, var3Num_out, _
							  blockingfactor3o)

			status = CDFgetzVarMaxAllocRecNum(id, var3Num_out, _
							  max3Alloco)

			status = CDFgetzVarMaxWrittenRecNum(id, var3Num_out, _
							    max3Reco)

			If [String].Compare(var3Nameo, new_var3Name) <> 0 Then
				QuitCDF("26.53", status, id)
			End If
			If var3DataTypeo <> var3DataType Then
				QuitCDF("26.54", status, id)
			End If
			If var3NumElementso <> var3NumElements Then
				QuitCDF("26.55", status, id)
			End If
			If var3RecVarianceo <> var3RecVariance Then
				QuitCDF("26.56", status, id)
			End If
			If zNumDimsAo <> zNumDimsA Then
				QuitCDF("26.57", status, id)
			End If
			If var3Num_out <> 2 Then
				QuitCDF("26.58", status, id)
			End If
			If blockingfactor3o <> blockingfactor3 Then
				QuitCDF("26.59", status, id)
			End If
			If max3Alloco + 1 <> allocRecs3 Then
				QuitCDF("26.60", status, id)
			End If
			If max3Reco <> 2 Then
				QuitCDF("26.61", status, id)
			End If

			For dim_n = 0 To zNumDimsA - 1
				If zDimSizesAo(dim_n) <> zDimSizesA(dim_n) Then
					QuitCDF("26.62", status, id)
				End If
				If var3DimVarianceso(dim_n) <> _
				   var3DimVariances(dim_n) Then
					QuitCDF("26.63", status, id)
				End If
			Next

			' *****************************************************
			' Rename attribute.
			' *****************************************************

			status = CDFrenameAttr(id, CDFgetAttrNum(id, attrName), _
					       new_attrName)

			' *****************************************************
			' Inquire attribute.
			' *****************************************************

			Dim attrNameo As String
			Dim attrScopeo As Integer, maxEntryo As Integer

			status = CDFgetAttrName(id, 
						CDFgetAttrNum(id, new_attrName), _
						attrNameo)

			status = CDFgetAttrScope(id, _
						CDFgetAttrNum(id, new_attrName), _
						attrScopeo)

			status = CDFgetAttrMaxgEntry(id, _
						CDFgetAttrNum(id, new_attrName), _
						maxEntryo)

			If [String].Compare(attrNameo, new_attrName) <> 0 Then
				QuitCDF("28.4", status, id)
			End If
			If attrScopeo <> attrScope Then
				QuitCDF("28.5", status, id)
			End If
			If maxEntryo <> entryNum Then
				QuitCDF("28.6", status, id)
			End If

			' *****************************************************
			' Inquire attribute entries.
			' *****************************************************

			Dim entryDataTypeo As Integer, _
			    entryNumElemso As Integer

			status = CDFgetAttrgEntryDataType(id, 0, entryNum, _
							  entryDataTypeo)

			status = CDFgetAttrgEntryNumElements(id, 0, entryNum, _
							     entryNumElemso)

			If entryDataTypeo <> entryDataType Then
				QuitCDF("29.2", status, id)
			End If
			If entryNumElemso <> entryNumElems Then
				QuitCDF("29.3", status, id)
			End If

			status = CDFgetAttrzEntryDataType(id, 1, 0, _
							  entryDataTypeo)

			status = CDFgetAttrzEntryNumElements(id, 1, 0, _
							     entryNumElemso)

			If entryDataTypeo <> CDF_BYTE Then
				QuitCDF("29.6", status, id)
			End If
			If entryNumElemso <> 1 Then
				QuitCDF("29.7", status, id)
			End If

			status = CDFgetAttrzEntryDataType(id, 2, 1, _
							  entryDataTypeo)

			status = CDFgetAttrzEntryNumElements(id, 2, 1, _
							     entryNumElemso)

			If entryDataTypeo <> CDF_REAL8 Then
				QuitCDF("29.10", status, id)
			End If
			If entryNumElemso <> 1 Then
				QuitCDF("29.11", status, id)
			End If

			' *****************************************************
			' Get error text.
			' *****************************************************


			status = CDFgetStatusText(CDF_OK, errorText)

			' *****************************************************
			' Select zMode and inquire CDF.
			' *****************************************************

			status = CDFsetzMode(id, zMODEon2)

			Dim numGattrso As Integer, numVattrso As Integer, _
			    maxGentryo As Integer, numGentrieso As Integer, _
			    maxZentryo As Integer, numZentrieso As Integer
			Dim numDimsXo As Integer, encodingXo As Integer, _
			    majorityXo As Integer, maxrRecXo As Integer, _
			    nrVarsXo As Integer, nAttrsXo As Integer
			Dim dimSizesXo As Integer()
			Dim numDimsYo As Integer, encodingYo As Integer, _
			    majorityYo As Integer, maxrRecYo As Integer, _
			    nrVarsYo As Integer, nAttrsYo As Integer
			Dim dimSizesYo As Integer()
			Dim maxzRecYo As Integer, nzVarsYo As Integer

			status = CDFgetNumgAttributes(id, numGattrso)

			status = CDFgetNumvAttributes(id, numVattrso)

			status = CDFgetNumzVars(id, numZvarso)

			status = CDFgetAttrMaxgEntry(id, 0, maxGentryo)

			status = CDFgetNumAttrgEntries(id, 0, numGentrieso)

			status = CDFgetzVarsMaxWrittenRecNum(id, maxReco)

			status = CDFgetAttrMaxzEntry(id, 1, maxZentryo)

			status = CDFgetNumAttrzEntries(id, 1, numZentrieso)

			status = CDFsetzMode(id, zMODEoff)

			status = CDFinquire(id, numDimsXo, dimSizesXo, _
					    encodingXo, majorityXo, _
					    maxrRecXo, nrVarsXo, nAttrsXo)

			status = CDFinquireCDF(id, numDimsYo, dimSizesYo, _
					       encodingYo, majorityYo, _
					       maxrRecYo, nrVarsYo, _
					       maxzRecYo, nzVarsYo, nAttrsYo)

			If numGattrso <> 1 Then
				QuitCDF("31.13", status, id)
			End If
			If numVattrso <> 2 Then
				QuitCDF("31.14", status, id)
			End If
			If numZvarso <> 3 Then
				QuitCDF("31.16", status, id)
			End If
			If maxGentryo <> entryNum Then
				QuitCDF("31.17", status, id)
			End If
			If numGentrieso <> 1 Then
				QuitCDF("31.18", status, id)
			End If
			If maxZentryo <> 0 Then
				QuitCDF("31.21", status, id)
			End If
			If numZentrieso <> 1 Then
				QuitCDF("31.22", status, id)
			End If
			If maxReco <> 2 Then
				QuitCDF("31.23", status, id)
			End If
			If numDimsXo <> numDimsYo OrElse CInt(numDimsXo) <> 0 Then
				QuitCDF("31.24", status, id)
			End If
			If encodingXo <> encodingYo OrElse _
			   CInt(encodingXo) <> NETWORK_ENCODING Then
				QuitCDF("31.25", status, id)
			End If
			If majorityXo <> majorityYo OrElse _
			   CInt(majorityXo) <> ROW_MAJOR Then
				QuitCDF("31.26", status, id)
			End If

			If nrVarsXo <> nrVarsYo OrElse nrVarsXo <> 0 Then
				QuitCDF("31.28", status, id)
			End If
			If nAttrsXo <> nAttrsYo OrElse nAttrsXo <> 3 Then
				QuitCDF("31.29", status, id)
			End If
			If nzVarsYo <> 3 Then
				QuitCDF("31.30", status, id)
			End If
			If maxzRecYo <> 2 Then
				QuitCDF("31.31", status, id)
			End If

			' *****************************************************
			' Attempt to close variables.
			' *****************************************************


			status = CDFclosezVar(id, 0)
			If status <> SINGLE_FILE_FORMAT Then
				QuitCDF("32.0", status, id)
			End If

			status = CDFclosezVar(id, 2)
			If status <> SINGLE_FILE_FORMAT Then
				QuitCDF("32.1", status, id)
			End If

			' *****************************************************
			' Modify entries/attribute.
			' *****************************************************


			status = CDFsetAttrgEntryDataSpec(id, 0, entryNum, _
							  entryDataTypeNew)

			status = CDFsetAttrzEntryDataSpec(id, 1, _
					CDFgetVarNum(id, new_var1Name), _
					CDF_UINT1)


			status = CDFsetAttrzEntryDataSpec(id, 2, _
					CDFgetVarNum(id, new_var2Name), _
					CDF_EPOCH)


			status = CDFsetAttrScope(id, 0, VARIABLE_SCOPE)

			status = CDFsetAttrScope(id, 0, GLOBAL_SCOPE)

			' *****************************************************
			' Delete entries/attribute/variables.
			' *****************************************************


			status = CDFdeleteAttrgEntry(id, 0, entryNum)

			status = CDFdeleteAttrzEntry(id, 1, 0)

			status = CDFdeleteAttrzEntry(id, 2, 1)

			status = CDFdeleteAttr(id, _
					       CDFgetAttrNum(id, new_attrName))

			status = CDFdeletezVar(id, _
					       CDFgetVarNum(id, new_var1Name))

			status = CDFdeletezVar(id, _
					       CDFgetVarNum(id, new_var3Name))

			' *****************************************************
			' Close CDF.
			' *****************************************************


			status = CDFcloseCDF(id)

			Dim cTypeo As Integer
			Dim cParmso As Integer()
			Dim cSizeo As Long, uSizeo As Long
			status = CDFgetCompressionInfo("TEST", cTypeo, _
						       cParmso, cSizeo, _
						       uSizeo)

			' *****************************************************
			' Successful completion.
			' *****************************************************

			Console.WriteLine(" Compression: {0}.{1} size: Compressed: {2} Uncompressed: {3}", CDFUtils.CDFgetStringCompressionType(comType), DirectCast(comParms, Integer())(0), CLng(cSizeo), CLng(uSizeo))
		Catch ex As CDFException
			Console.WriteLine("Error... {0}", ex)
		Finally
			Try
				status = CDFselect(id)
				status = CDFcloseCDF(id)
			Catch ex As CDFException
			End Try
		End Try

	End Sub


	' *********************************************************************
	' QuitCDF.
	' *********************************************************************


	Private Shared Sub QuitCDF(where As String, status As Integer, id As Long)
		Dim text As String
		Console.WriteLine("Aborting at " + where)
		If status < 0 Then
			status = CDFgetStatusText(status, text)
			Console.WriteLine(" " + text)
		End If
		If id <> 0 Then
			status = CDFcloseCDF(id)
		End If
		Console.WriteLine("...test aborted.")
	End Sub

End Class

