/*****************************************************************************e
*
*  NSSDC/CDF                      Quick Start Test Program(C# interface).
*
*  Version 1.0,15-Oct-09,Mike Liu
*
*  Modification history:
*
*   V1.0   15-Oct-09,M Liu     Original version(for CDF V3.3).
*                              Using pointers (&) to pass arguments for 
*                              retrieving data fields and values to C# APIs.
*
******************************************************************************/

using System;
using System.Runtime.InteropServices;
using CDF;

public class rQst2 : CDFAPIs {

unsafe public static void Main(string[] args) {
  void* id;
  int status;

  int[]  indices = new int[1] {0};
  int[]  counts = new int[1] { 2 };
  int[]  intervals = new int[1] { 1 };
  object astr,pad;
  string[] strings;
  object strings2;
  string entry1, entry2;

id = (void *) 0;
try {
status = CDFopen(args[0],&id);

status = CDFgetzVarPadValue(id,0,out pad);
Console.WriteLine("pad:\""+pad+"\"");

status = CDFgetzVarPadValue(id,1,out pad);
Console.WriteLine("2= pad:\""+pad+"\"");

status = CDFgetzVarData(id,0,0,indices,out astr);
Console.WriteLine("length="+((string)astr).Length);
Console.WriteLine("str:\""+astr+"\"");

status = CDFgetzVarRecordData(id,0,0,out astr);
Console.WriteLine("length="+((string)astr).Length);
Console.WriteLine("str:\""+astr+"\"");

status = CDFhyperGetzVarData(id,0,1,2,1,
                             indices,intervals,intervals,out strings);
Console.WriteLine("length="+strings.Length+" rank="+strings.Rank);
int x0;
for(x0 = 0; x0 < 2; x0++)
Console.WriteLine(""+x0+": \""+((string[])strings)[x0]+"\"");

status = CDFgetzVarData(id,1,0,indices,out astr);
Console.WriteLine("2= length="+((string)astr).Length);
Console.WriteLine("2= str:\""+astr+"\"");

status = CDFgetzVarRecordData(id,1,0,out astr);
Console.WriteLine("2= length="+((string[])astr).Length+" rank="+((string[])astr).Rank);
Console.WriteLine("2= str:\""+((string[])astr)[0]+"\" \""+((string[])astr)[1]+"\"");

status = CDFhyperGetzVarData(id,1,0,3,1,
                             indices,counts,intervals,out strings2);
Console.WriteLine("2= length="+((string[,])strings2).Length+" rank="+((string[,])strings2).Rank);
for(x0 = 0; x0 < 3; x0++)
Console.WriteLine(""+x0+": \""+((string[,])strings2)[x0,0]+"\" \""+((string[,])strings2)[x0,1]+"\"");

status = CDFgetAttrzEntry(id,0,0, out entry1);
Console.WriteLine(" 0 0: \""+entry1+"\"");

status = CDFgetAttrzEntry(id,0,1, out entry2);
Console.WriteLine("2= 0 1: \""+entry2+"\"");

status = CDFcloseCDF(id);  


/******************************************************************************
* Successful completion.
******************************************************************************/
} catch(CDFException ex) {
  Console.WriteLine("Error... "+ex);
} finally {
  try {
    status = CDFselect(id);
    status = CDFcloseCDF(id);
  } catch(CDFException ex) {}
}

}


/******************************************************************************
* QuitCDF.
******************************************************************************/

unsafe static void QuitCDF(string where, int status, void* id)
{
  string text;
  Console.WriteLine("Aborting at "+where);
  if(status < 0) {
    status = CDFgetStatusText(status,out text); 
    Console.WriteLine(" "+text);
  }
  status = CDFcloseCDF(id);
  Console.WriteLine("...test aborted.");
}

}

