#!/usr/bin/perl -w

use strict;
use Math::BigInt;
use Data::Dumper;

BEGIN { unshift @INC,$ENV{"HOME"}.'/PerlCDF39_1/blib/arch',
                     $ENV{"HOME"}.'/PerlCDF39_1/blib/lib'; }
use CDF;

my $id;
my $status;
$status = CDF::CDFlib (&OPEN_, &CDF_, $ARGV[0], \$id,
		       &NULL_);
QuitCDF ("1.0", $status) if ($status < &CDF_OK) ;

print "global 1....\n";
my %meta;
($status, %meta) = CDF::CDFgetGlobalMetaData($id);

if ($status == &CDF_OK && %meta ) {
  print Dumper(\%meta);
} else {
  if ($status != 0) {
    QuitCDF ("2.0", $status);
  }
}
my @g1 = (0,1);
my @g2 = ("Project", "TestDate");
($status, %meta) = CDF::CDFgetGlobalMetaData($id, \@g1);

if ($status == &CDF_OK && %meta ) {
  print Dumper(\%meta);
} else {
  if ($status != 0) {
    QuitCDF ("3.0", $status);
  }
}
($status, %meta) = CDF::CDFgetGlobalMetaData($id, \@g2);

if ($status == &CDF_OK && %meta ) {
  print Dumper(\%meta);
} else {
  if ($status != 0) {
    QuitCDF ("4.0", $status);
  }
}

$status = CDF::CDFlib (&CLOSE_, &CDF_,
		       &NULL_);
QuitCDF ("5.0", $status) if ($status < &CDF_OK) ;

exit;

#############################################################################
# QuitCDF.
#############################################################################
sub QuitCDF {
	my ($where, $status)=@_;

  if ($status < &CDF_OK) {
    my $text;
    CDF::CDFlib (&SELECT_, &CDF_STATUS_, $status,
		   &GET_, &STATUS_TEXT_, \$text,
		   &NULL_);
    print $text;
  }
  CDF::CDFlib (&CLOSE_, &CDF_,
	  &NULL_);
  print "...test aborted.\n";
  exit;
	
}#endsub QuitCDF

