/******************************************************************************
* Copyright 1996-2014 United States Government as represented by the
* Administrator of the National Aeronautics and Space Administration.
* All Rights Reserved.
******************************************************************************/

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;
import java.awt.*;
import java.awt.event.*;

public class ExportVarListTable {

    private JTable table;
    private MyTableModel myModel;
    private ExportCDFTable exportCDFTable;
    private CDFExport cdfexport;
    private Object[][] data;
    private String[] columnNames;
    private int startColToUpdate;
    private static ExportVarListTable aVarListTable;

    private ExportVarListTable(CDFExport myCDFExport, 
			       ExportCDFTable exportCDFTable) {

	this.exportCDFTable = exportCDFTable;
	this.cdfexport = myCDFExport;
	this.startColToUpdate = exportCDFTable.istart;

    }

    public static ExportVarListTable createVarListTable(Object[][] data,
				     			String[] columnNames, 
							CDFExport myCDFExport,
				     			ExportCDFTable exportCDFTable) {

	if (aVarListTable == null) 
	  aVarListTable = new ExportVarListTable(myCDFExport, exportCDFTable);
        aVarListTable.data = data;
        aVarListTable.columnNames = columnNames;

        aVarListTable.myModel = aVarListTable.new MyTableModel();
        aVarListTable.table = new JTable(aVarListTable.myModel);
        aVarListTable.table.setPreferredScrollableViewportSize(new Dimension(850, 450));
//      table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);

        TableColumn column = null;
        for (int i = 0; i < columnNames.length; i++) {
           column = aVarListTable.table.getColumnModel().getColumn(i);
           column.setResizable(true);
           if (i == 0) column.setPreferredWidth(90);
           if (i == 1) column.setPreferredWidth(120);
           if (i == 2) column.setPreferredWidth(390);
           if (i == 3) column.setPreferredWidth(110);
           if (i == 4) column.setPreferredWidth(90);
           if (i == 5) column.setPreferredWidth(50);
        }
        aVarListTable.table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        aVarListTable.table.setRowSelectionAllowed(false);
	return aVarListTable;

    }

    public void setDataTable (Object[][] data) {

	this.data = data;

    }

    public Object[][] getDataTable() {

        return (Object[][]) data;

    }

    public void setColumnNames(String[] columnNames) {

        this.columnNames = columnNames;

    }

    public String[] getColumnNames() {

        return (String[]) columnNames;

    }

    public JTable getTable() {

        return table;

    }

    public MyTableModel getModel() {

        return myModel;

    }

    class MyTableModel extends AbstractTableModel {

        static final long serialVersionUID = 1L;

        public int getColumnCount() {
            return columnNames.length;
        }
        
        public int getRowCount() {
            return data.length;
        }

        public String getColumnName(int col) {
            return columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            return data[row][col];
        }

        /*
         * JTable uses this method to determine the default renderer/
         * editor for each cell.  If we didn't implement this method,
         * then a Boolean column would contain text ("true"/"false"),
         * rather than a check box.
         */
        public Class getColumnClass(int c) {
            return getValueAt(0, c).getClass();
        }

        /*
         * Don't need to implement this method unless your table's
         * editable.
         */
        public boolean isCellEditable(int row, int col) {
            //Note that the data/cell address is constant,
            //no matter where the cell appears onscreen.
            if (col < 5) { 
                return false;
            } else {
	      if (row < startColToUpdate) {
	        if (cdfexport.outSelection == 3 ||
		    cdfexport.outSelection == 4) return false;
	      }
	      return true;
            }
        }

        /*
         * Don't need to implement this method unless your table's
         * data can change.
         */
        public void setValueAt(Object value, int row, int col) {

            data[row][col] = value;
            fireTableCellUpdated(row, col);

	    if (col == 5) { // output column
		if (! ( ((Boolean)value).booleanValue() ) ) {
		  if (exportCDFTable.getSelectAllCB().isSelected()) 
		    exportCDFTable.getSelectAllCB().setSelected(false);
		  if (exportCDFTable.getDeSelectAllCB().isSelected())
		    exportCDFTable.getDeSelectAllCB().setSelected(false);
		} else {
		  if (exportCDFTable.getDeSelectAllCB().isSelected())
		    exportCDFTable.getDeSelectAllCB().setSelected(false);
		}
	    }

        }

    }

}

