Imports System
Imports System.Runtime.InteropServices
Imports CDF

Public Class Qstvb
	Inherits CDFAPIs

	Public Shared Sub Main()
		Dim id As Long
		Dim status As Integer

		Dim N_DIMS As Integer = 2
		Dim DIM_0_SIZE As Integer = 2
		Dim DIM_1_SIZE As Integer = 3

		Dim zN_DIMSa As Integer = 1
		Dim zDIM_0_SIZEa As Integer = 5
		Dim zNUM_ELEMSa As Integer = 8

		Dim dim_n As Integer
		Dim encoding As Integer = IBMPC_ENCODING
		Dim actual_encoding As Integer = IBMPC_ENCODING
		Dim majority As Integer = ROW_MAJOR
		Dim numDims As Integer = N_DIMS
		Dim dimSizes As Integer() = New Integer(1) {2, 3}
		Dim zNumDimsA As Integer = zN_DIMSa
		Dim zDimSizesA As Integer() = New Integer(0) {5}
		Dim var1DataType As Integer = CDF_INT2
		Dim var1DataTypeNew As Integer = CDF_UINT2
		Dim var2DataType As Integer = CDF_REAL4
		Dim var3DataType As Integer = CDF_CHAR
		Dim var3DataTypeNew As Integer = CDF_UCHAR
		Dim var1DataType_out As Integer, _
		    var2DataType_out As Integer, var3DataType_out As Integer
		Dim var1NumElements As Integer = 1
		Dim var2NumElements As Integer = 1
		Dim var3NumElements As Integer = zNUM_ELEMSa
		Dim var3NumElementsNew As Integer = zNUM_ELEMSa
		Dim var1NumElements_out As Integer, _
		    var2NumElements_out As Integer, _
		    var3NumElements_out As Integer
		Dim var1Num_out As Integer, var2Num_out As Integer, _
		    var3Num_out As Integer, varNum_out1 As Integer, _
		    varNum_out2 As Integer
		Dim var1Values As Short(,) = New Short(1, 2) {{1, 2, 3}, {4, 5, 6}}
		Dim var2Values As Single(,) = New Single(1, 2) {{1F, 2F, 3F}, {4F, 5F, 6F}}
		Dim var1Values_out As Short(,) = New Short(1, 2) {}
		Dim var2Values_out As Single(,) = New Single(1, 2) {}
		Dim var3Values As String() = New String(4) {"11111111", "22222222", "33333333", "44444444", "55555555"}
		Dim var1Value_out As Short
		Dim var2Value_out As Single
		Dim var3Value_out As String
		Dim recNum As Integer = 0
		Dim recNumOut As Integer
		Dim recStart As Integer = 2
		Dim recCount As Integer = 1
		Dim recInterval As Integer = 1
		Dim indices As Integer() = New Integer(1) {}
		Dim counts As Integer() = New Integer(1) {2, 3}
		Dim intervals As Integer() = New Integer(1) {1, 1}
		Dim zIndicesA As Integer() = New Integer(0) {}
		Dim zCounts As Integer() = New Integer(0) {5}
		Dim zIntervals As Integer() = New Integer(0) {1}
		Dim var1Buffer_out As Short(,) = New Short(1, 2) {}
		Dim var2Buffer_out As Single(,) = New Single(1, 2) {}
		'  string[] var3Buffer_out = new string[5];
		Dim var3Buffer_out As String()
		Dim attrNum_out As Integer
		Dim entryNum As Integer = 2
		Dim maxEntry_out As Integer
		Dim attrScope As Integer = GLOBAL_SCOPE
		Dim attrScope2 As Integer = VARIABLE_SCOPE
		Dim attrScope3 As Integer = VARIABLE_SCOPE
		Dim attrScope_out As Integer
		Dim entryDataType As Integer = CDF_INT2
		Dim entryDataTypeNew As Integer = CDF_UINT2
		Dim entryDataType_out As Integer
		Dim entryNumElems As Integer = 1
		Dim entryNumElems_out As Integer
		Dim entryValue As Short = 1
		Dim entryValue_out As Short
		Dim encoding_out As Integer
		Dim majority_out As Integer
		Dim dimSizes_out As Integer() = New Integer(1) {}
		Dim zNumDimsA_out As Integer
		Dim zDimSizesA_out As Integer() = New Integer(0) {}
		Dim maxRec_out As Integer
		Dim numAttrs_out As Integer
		Dim version_out As Integer
		Dim release_out As Integer
		Dim increment_out As Integer
		Dim subincrement_out As String
		Dim numDimsX As Integer, encodingX As Integer, _
		    majorityX As Integer, maxrRecX As Integer, _
		    nrVarsX As Integer, nAttrsX As Integer
		Dim numDimsY As Integer, encodingY As Integer, _
		    majorityY As Integer, maxrRecY As Integer, _
		    nrVarsY As Integer, nzVarsY As Integer, _
		    nAttrsY As Integer, maxzRecY As Integer
		Dim dimSizesX As Integer() = New Integer(1) {}, _
		    dimSizesY As Integer() = New Integer(1) {}
		Dim x0 As Integer, x1 As Integer
		Dim var1RecVariance As Integer = VARY
		Dim var1RecVarianceNew As Integer = NOVARY
		Dim var2RecVariance As Integer = VARY
		Dim var3RecVariance As Integer = VARY
		Dim var3RecVarianceNew As Integer = NOVARY
		Dim var1RecVariance_out As Integer, _
		    var2RecVariance_out As Integer, _
		    var3RecVariance_out As Integer
		Dim var1DimVariances As Integer() = New Integer(1) {VARY, VARY}
		Dim var1DimVariancesNew As Integer() = New Integer(1) {NOVARY, NOVARY}
		Dim var2DimVariances As Integer() = New Integer(1) {VARY, VARY}
		Dim var3DimVariances As Integer() = New Integer(0) {VARY}
		Dim var3DimVariancesNew As Integer() = New Integer(0) {NOVARY}
		Dim var1DimVariances_out As Integer() = New Integer(1) {}, _
		    var2DimVariances_out As Integer() = New Integer(1) {}, _
		    var3DimVariances_out As Integer() = New Integer(0) {}
		Dim var1Name As String = "VAR1a"
		Dim var2Name As String = "VAR2a"
		Dim var3Name As String = "zVARa1"
		Dim new_var1Name As String = "VAR1b"
		Dim new_var2Name As String = "VAR2b"
		Dim new_var3Name As String = "zVARa2"
		Dim var1Name_out As String, var2Name_out As String, _
		    var3Name_out As String
		Dim attrName As String = "ATTR1"
		Dim attrName2 As String = "ATTR2"
		Dim attrName3 As String = "ATTR3"
		Dim new_attrName As String = "ATTR1a"
		Dim attrName_out As String
		Dim CopyrightText As String
		Dim errorText As String
		Dim zEntryValue1 As Byte = 4
		Dim zEntryValue1Out As Byte
		Dim zEntryValue2 As Double = 4.0
		Dim zEntryValue2Out As Double
		Dim numZvars As Integer, maxGentry As Integer, _
		    numGentries As Integer, maxZentry As Integer, _
		    numZentries As Integer, numGattrs As Integer, _
		    numVattrs As Integer
		Dim cacheOut1 As Integer, cacheOut2 As Integer, _
		    cacheOut3 As Integer
		Dim pad1 As Short = -999
		Dim pad2 As Single = -8F
		Dim pad3 As String = "********"
		Dim pad1out As Short
		Dim pad2out As Single
		Dim pad3out As String
		Dim blockingfactor1 As Integer = 3
		Dim blockingfactor2 As Integer = 4
		Dim blockingfactor3 As Integer = 5
		Dim blockingfactorOut1 As Integer, _
		    blockingfactorOut2 As Integer, blockingfactorOut3 As Integer
		Dim indicesOut As Integer() = New Integer(9) {}, _
		    countsOut As Integer() = New Integer(9) {}, _
		    intervalsOut As Integer() = New Integer(9) {}
		Dim formatOut As Integer
		Dim maxAllocOut1 As Integer, maxAllocOut2 As Integer, _
		    maxAllocOut3 As Integer
		Dim maxRecOut1 As Integer, maxRecOut2 As Integer, _
		    maxRecOut3 As Integer, maxRecOut As Integer
		Dim allocRecs1 As Integer = 10
		Dim allocRecs2 As Integer = 15
		Dim allocRecs3 As Integer = 8
		Dim varNs1 As Integer() = New Integer(0) {0}, _
		    varNs2 As Integer() = New Integer(0) {2}
		Dim varsRecBuffer2 As String() = New String(4) {"%%%%%%%%", "%%%%%%%%", "%%%%%%%%", "%%%%%%%%", "%%%%%%%%"}
		Dim varsRecBuffer2Out As String() = New String(4) {}

		'
		' Display title.
		'

		Console.WriteLine("Testing C#-CDF Interface... using pointers")

		'
		' Create CDF.
		'

		Try
			status = CDFcreate("TEST", numDims, dimSizes, _
					   encoding, majority, id)
		Catch ex As CDFException
			Dim stat As Integer = ex.CDFgetCurrentStatus()
			If stat < CDF_OK Then
				id = Nothing
				If stat = CDF_EXISTS Then
					status = CDFopen("TEST", id)
					If status < CDF_OK Then
						QuitCDF("1.0", status, id)
					End If

					status = CDFdeleteCDF(id)
					If status < CDF_OK Then
						QuitCDF("1.1", status, id)
					End If

					status = CDFcreate("TEST", numDims, _
							   dimSizes, encoding, _
							   majority, id)
					If status < CDF_OK Then
						QuitCDF("1.2", status, id)
					End If
					status = CDFsetFormat(id, MULTI_FILE)
					If status < CDF_OK Then
						QuitCDF("1.3", status, id)
					End If
				Else
					QuitCDF("1.4", stat, id)
				End If
			End If
		End Try

		Try
			status = CDFsetFormat(id, MULTI_FILE)

			'
		 	' Create variables and set/confirm cache sizes,etc.
			'


			status = CDFcreatezVar(id, var1Name, var1DataType, _
					       var1NumElements, numDims, _
					       dimSizes, var1RecVariance, _
					       var1DimVariances, var1Num_out)

			status = CDFputzVarPadValue(id, var1Num_out, pad1)

			status = CDFcreatezVar(id, var2Name, var2DataType, _
					       var2NumElements, numDims, _
					       dimSizes, var2RecVariance, _
					       var2DimVariances, var2Num_out)

			status = CDFputzVarPadValue(id, var2Num_out, pad2)

			status = CDFcreatezVar(id, var3Name, var3DataType, _
					       var3NumElements, zNumDimsA, _
					       zDimSizesA, var3RecVariance, _
					       var3DimVariances, var3Num_out)

			status = CDFputzVarPadValue(id, var3Num_out, pad3)

			status = CDFsetzVarsCacheSize(id, 5)

			status = CDFgetzVarCacheSize(id, 0, cacheOut1)

			status = CDFgetzVarPadValue(id, 0, pad1out)

			status = CDFgetzVarCacheSize(id, 1, cacheOut2)

			status = CDFgetzVarPadValue(id, 1, pad2out)

			status = CDFgetzVarCacheSize(id, 2, cacheOut3)

			status = CDFgetzVarPadValue(id, 2, pad3out)

			If cacheOut1 <> 5 Then
				QuitCDF("2.14", status, id)
			End If
			If cacheOut2 <> 5 Then
				QuitCDF("2.15", status, id)
			End If
			If cacheOut3 <> 5 Then
				QuitCDF("2.16", status, id)
			End If
			If pad1out <> pad1 Then
				QuitCDF("2.17", status, id)
			End If
			If pad2out <> pad2 Then
				QuitCDF("2.18", status, id)
			End If
			If [String].Compare(pad3out, pad3) <> 0 Then
				QuitCDF("2.19", status, id)
			End If

			status = CDFsetzVarCacheSize(id, 0, 4)

			status = CDFsetzVarCacheSize(id, 2, 8)

			status = CDFgetzVarCacheSize(id, 0, cacheOut1)

			status = CDFgetzVarCacheSize(id, 1, cacheOut2)

			status = CDFgetzVarCacheSize(id, 2, cacheOut3)

			If cacheOut1 <> 4 Then
				QuitCDF("2.25", status, id)
			End If
			If cacheOut2 <> 5 Then
				QuitCDF("2.26", status, id)
			End If
			If cacheOut3 <> 8 Then
				QuitCDF("2.27", status, id)
			End If

			'
			' Modify variables.
			'


			status = CDFsetzVarDataSpec(id, 0, var1DataTypeNew)

			status = CDFsetzVarRecVariance(id, 0, var1RecVarianceNew)

			status = CDFsetzVarDimVariances(id, 0, var1DimVariancesNew)

			status = CDFsetzVarInitialRecs(id, 0, 1)

			status = CDFsetzVarDataSpec(id, 2, var3DataTypeNew)

			status = CDFsetzVarRecVariance(id, 2, var3RecVarianceNew)

			status = CDFsetzVarDimVariances(id, 2, var3DimVariancesNew)

			status = CDFsetzVarInitialRecs(id, 2, 1)

			'
			' Close CDF.
			'


			status = CDFcloseCDF(id)

			'
			' Reopen CDF.
			'


			status = CDFopen("TEST", id)

			status = CDFsetDecoding(id, HOST_DECODING)

			'
			' Delete CDF.
			'


			status = CDFdeleteCDF(id)

			'
			' Create CDF again(previous delete will allow this).
			'


			status = CDFcreateCDF("TEST", id)

			status = CDFsetEncoding(id, IBMPC_ENCODING)

			status = CDFsetMajority(id, ROW_MAJOR)

			status = CDFsetFormat(id, SINGLE_FILE)

			status = CDFsetDecoding(id, HOST_DECODING)

			'
			' Create variables.
			'


			status = CDFcreatezVar(id, var1Name, var1DataType, _
					       var1NumElements, numDims, _
					       dimSizes, var1RecVariance, _
					       var1DimVariances, var1Num_out)

			status = CDFsetzVarAllocRecords(id, var1Num_out, _
							allocRecs1)

			status = CDFsetzVarBlockingFactor(id, var1Num_out, _
							  blockingfactor1)

			status = CDFcreatezVar(id, var2Name, var2DataType, _
					       var2NumElements, numDims, _
					       dimSizes, var2RecVariance, _
					       var2DimVariances, var2Num_out)

			status = CDFsetzVarAllocRecords(id, var2Num_out, _
							allocRecs2)

			status = CDFsetzVarBlockingFactor(id, var2Num_out, _
							  blockingfactor2)

			status = CDFcreatezVar(id, var3Name, var3DataType, _
					       var3NumElements, zNumDimsA, _
					       zDimSizesA, var3RecVariance, _
					       var3DimVariances, var3Num_out)

			status = CDFsetzVarAllocRecords(id, var3Num_out, _
							allocRecs3)

			status = CDFsetzVarBlockingFactor(id, var3Num_out, blockingfactor3)

			'
			' PUT to variables.
			'


			For x0 = 0 To DIM_0_SIZE - 1
				For x1 = 0 To DIM_1_SIZE - 1
					indices(0) = x0
					indices(1) = x1

			status = CDFputzVarData(id, var1num_out, recnum, _
						indices, var1Values(x0,x1))

					If status < CDF_OK Then
						QuitCDF("9.0", status, id)
					End If


			status = CDFputzVarData(id, var2Num_out, recNum, _
						indices, var2Values(x0,x1))

					If status < CDF_OK Then
						QuitCDF("9.1", status, id)
					End If
				Next
			Next

			For x0 = 0 To zDIM_0_SIZEa - 1
				zIndicesA(0) = x0
				status = CDFputzVarData(id, var3Num_out, recNum, _
							zIndicesA, var3Values(x0))
				If status < CDF_OK Then
					QuitCDF("9.2", status, id)
				End If
			Next

			'
			' GET from the variables.
			'


			For x0 = 0 To DIM_0_SIZE - 1
				For x1 = 0 To DIM_1_SIZE - 1
					indices(0) = x0
					indices(1) = x1
					status = CDFgetzVarData(id, var1Num_out, _
								recNum, indices, _
								var1Value_out)
					If status < CDF_OK Then
						QuitCDF("10.0", status, id)
					End If

					status = CDFgetzVarData(id, var2Num_out, _
								recNum, indices, _
								var2Value_out)
					If status < CDF_OK Then
						QuitCDF("10.1", status, id)
					End If

					If var1Value_out <> var1Values(x0, x1) Then
						QuitCDF("10.2", status, id)
					End If
					If var2Value_out <> var2Values(x0, x1) Then
						QuitCDF("10.3", status, id)
					End If
				Next
			Next

			status = CDFgetzVarRecordData(id, var1Num_out, recNum, _
						      var1Values_out)


			status = CDFgetzVarRecordData(id, var2Num_out, recNum, _
						      var2Values_out)


			For x0 = 0 To DIM_0_SIZE - 1
				For x1 = 0 To DIM_1_SIZE - 1
					If var1Values_out(x0, x1) <> var1Values(x0, x1) Then
						QuitCDF("10.2a", status, id)
					End If
					If var2Values_out(x0, x1) <> var2Values(x0, x1) Then
						QuitCDF("10.3a", status, id)
					End If
				Next
			Next

			For x0 = 0 To zDIM_0_SIZEa - 1
				zIndicesA(0) = x0
				status = CDFgetzVarData(id, var3Num_out, _
							recNum, zIndicesA, _
							var3Value_out)
				If status < CDF_OK Then
					QuitCDF("10.4", status, id)
				End If

				If [String].Compare(var3Value_out, var3Values(x0)) <> 0 Then
					QuitCDF("10.5", status, id)
				End If
			Next

			'
			' HyperPUT to the variables.
			'


			For x0 = 0 To DIM_0_SIZE - 1
				For x1 = 0 To DIM_1_SIZE - 1
					var1Values(x0, x1) = CShort(-var1Values(x0, x1))
					var2Values(x0, x1) = -var2Values(x0, x1)
				Next
			Next

			indices(0) = 0
			indices(1) = 0

			status = CDFhyperPutzVarData(id, var1Num_out, recStart, _
						     recCount, recInterval, _
						     indices, counts, _
						     intervals, var1Values)

			status = CDFhyperPutzVarData(id, var2Num_out, recStart, _
						     recCount, recInterval, _
						     indices, counts, _
						     intervals, var2Values)

dim ccc() as char = {"2"C,"3"C,"4"C,"5"C,"6"C,"7"C,"8"C,"9"C}
			For x0 = 0 To zDIM_0_SIZEa - 1
				var3Values(x0) = New String(ccc(x0), zNUM_ELEMSa)
			Next

			zIndicesA(0) = 0

			status = CDFhyperPutzVarData(id, var3Num_out, recStart, _
						     recCount, recInterval, _
						     zIndicesA, zCounts, _
						     zIntervals, var3Values)

			'
			' HyperGET from variables.
			'


			status = CDFhyperGetzVarData(id, var1Num_out, recStart, _
						     recCount, recInterval, _
						     indices, counts, _
						     intervals, var1Buffer_out)

			status = CDFhyperGetzVarData(id, var2Num_out, recStart, _
						     recCount, recInterval, _
						     indices, counts, _
						     intervals, var2Buffer_out)


			For x0 = 0 To DIM_0_SIZE - 1
				For x1 = 0 To DIM_1_SIZE - 1
				   If var1Buffer_out(x0, x1) <> var1Values(x0, x1) Then
						QuitCDF("12.2", status, id)
				   End If
				   If var2Buffer_out(x0, x1) <> var2Values(x0, x1) Then
						QuitCDF("12.3", status, id)
				   End If
				Next
			Next

			status = CDFhyperGetzVarData(id, var3Num_out, recStart, _
						     recCount, recInterval, _
						     zIndicesA, zCounts, _
						     zIntervals, var3Buffer_out)

			For x0 = 0 To zDIM_0_SIZEa - 1
				If [String].Compare(DirectCast(var3Buffer_out, String())(x0), var3Values(x0)) <> 0 Then
					QuitCDF("12.5", status, id)
				End If
			Next

			'
			' Set/confirm sequential access position for a zVariable(and read/write a
			' value).
			'


			status = CDFsetzVarSeqPos(id, var3Num_out, recStart, _
						  zIndicesA)

			status = CDFgetzVarSeqData(id, var3Num_out, var3Value_out)

			status = CDFputzVarSeqData(id, var3Num_out, var3Value_out)

			status = CDFgetzVarSeqPos(id, var3Num_out, recNumOut, _
						  indicesOut)


			If recNumOut <> recStart Then
				QuitCDF("14.4", status, id)
			End If
			If indicesOut(0) <> zIndicesA(0) + 2 Then
				QuitCDF("14.5", status, id)
			End If

			'
			' Create attributes.
			'


			status = CDFcreateAttr(id, attrName, attrScope, _
					       attrNum_out)

			status = CDFcreateAttr(id, attrName2, attrScope2, _
					       attrNum_out)

			status = CDFcreateAttr(id, attrName3, attrScope3, _
					       attrNum_out)

			'
			' PUT to attributes.
			'


			status = CDFputAttrgEntry(id, 0, entryNum, _
						  entryDataType, entryNumElems, _
						  entryValue)

			status = CDFputAttrzEntry(id, 1, _
						  CDFgetVarNum(id, var1Name), _
						  CDF_BYTE, 1, zEntryValue1)

			status = CDFputAttrzEntry(id, 2, _
						  CDFgetVarNum(id, var2Name), _
						  CDF_REAL8, 1, zEntryValue2)

			'
			' GET from attributes.
			'


			status = CDFgetAttrgEntry(id, 0, entryNum, entryValue_out)

			status = CDFgetAttrzEntry(id, 1, _
						  CDFgetVarNum(id, var1Name), _
						  zEntryValue1Out)

			status = CDFgetAttrzEntry(id, 2, _
						  CDFgetVarNum(id, var2Name), _
						  zEntryValue2Out)

			If entryValue_out <> entryValue Then
				QuitCDF("19.6", status, id)
			End If
			If zEntryValue1 <> zEntryValue1Out Then
				QuitCDF("19.7", status, id)
			End If
			If zEntryValue2 <> zEntryValue2Out Then
				QuitCDF("19.8", status, id)
			End If

			'
			' Confirm existence of variables/attributes/entries.
			'


			status = CDFconfirmzVarExistence(id, var3Name)
			If status < CDF_OK Then
				QuitCDF("20.1", status, id)
			End If

			status = CDFconfirmzVarExistence(id, var1Name)
			If status < CDF_OK Then
				QuitCDF("20.2", status, id)
			End If

			status = CDFconfirmAttrExistence(id, attrName3)
			If status < CDF_OK Then
				QuitCDF("20.3", status, id)
			End If

			status = CDFconfirmgEntryExistence(id, 0, entryNum)
			If status < CDF_OK Then
				QuitCDF("20.4", status, id)
			End If

			status = CDFconfirmzEntryExistence(id, 1, _
						  CDFgetVarNum(id, var1Name))
			If status < CDF_OK Then
				QuitCDF("20.5", status, id)
			End If

			'
			' Get CDF documentation.
			'


			status = CDFgetLibraryVersion(version_out, release_out, _
						      increment_out, _
						      subincrement_out)
			Console.WriteLine("CDF Version: {0}.{1}.{2}.{3}", _
					  version_out,release_out, _
					  increment_out, subincrement_out)

			status = CDFgetLibraryCopyright(CopyrightText)

			'
			' Inquire CDF.
			'


			status = CDFgetFormat(id, formatOut)

			status = CDFgetEncoding(id, encoding_out)

			status = CDFgetMajority(id, majority_out)

			status = CDFgetzVarsMaxWrittenRecNum(id, maxRec_out)

			status = CDFgetNumzVars(id, numZvars)

			status = CDFgetNumAttributes(id, numAttrs_out)

			If formatOut <> SINGLE_FILE Then
				QuitCDF("22.9", status, id)
			End If
			If encoding_out <> actual_encoding Then
				QuitCDF("22.12", status, id)
			End If
			If majority_out <> majority Then
				QuitCDF("22.13", status, id)
			End If
			If maxRec_out <> 2 Then
				QuitCDF("22.14", status, id)
			End If
			If numZvars <> 3 Then
				QuitCDF("22.16", status, id)
			End If
			If numAttrs_out <> 3 Then
				QuitCDF("22.17", status, id)
			End If

			'
			' Inquire numbers.
			'


			attrNum_out = CDFgetAttrNum(id, attrName3)

			varNum_out1 = CDFgetVarNum(id, var2Name)

			varNum_out2 = CDFgetVarNum(id, var3Name)

			If attrNum_out <> 2 Then
				QuitCDF("23.3", status, id)
			End If
			If varNum_out1 <> 1 Then
				QuitCDF("23.4", status, id)
			End If
			If varNum_out2 <> 2 Then
				QuitCDF("23.5", status, id)
			End If

			'
			' Rename variables.
			'


			status = CDFrenamezVar(id, CDFgetVarNum(id, var1Name), _
					       new_var1Name)

			status = CDFrenamezVar(id, CDFgetVarNum(id, var2Name), _
					       new_var2Name)

			status = CDFrenamezVar(id, CDFgetVarNum(id, var3Name), _
					       new_var3Name)

			'
			' Inquire variables.
			'


			status = CDFgetzVarName(id, var1Num_out, var1Name_out)

			status = CDFgetzVarDataType(id, var1Num_out, _
						    var1DataType_out)

			status = CDFgetzVarNumElements(id, var1Num_out, _
						       var1NumElements_out)

			status = CDFgetzVarRecVariance(id, var1Num_out, _
						       var1RecVariance_out)

			status = CDFgetzVarDimVariances(id, var1Num_out, _
						        var1dimVariances_out)


			status = CDFgetzVarBlockingFactor(id, var1Num_out, _
							  blockingfactorOut1)

			status = CDFgetzVarMaxAllocRecNum(id, var1Num_out, _
							  maxAllocOut1)

			status = CDFgetzVarMaxWrittenRecNum(id, var1Num_out, _
					 		    maxRecOut1)

			If [String].Compare(var1Name_out, new_var1Name) <> 0 Then
				QuitCDF("26.11", status, id)
			End If
			If var1DataType_out <> var1DataType Then
				QuitCDF("26.12", status, id)
			End If
			If var1NumElements_out <> var1NumElements Then
				QuitCDF("26.13", status, id)
			End If
			If var1RecVariance_out <> var1RecVariance Then
				QuitCDF("26.14", status, id)
			End If
			If var1Num_out <> 0 Then
				QuitCDF("26.15", status, id)
			End If
			If blockingfactorOut1 <> blockingfactor1 Then
				QuitCDF("26.16", status, id)
			End If
			If maxAllocOut1 + 1 <> allocRecs1 Then
				QuitCDF("26.17", status, id)
			End If
			If maxRecOut1 <> 2 Then
				QuitCDF("26.18", status, id)
			End If

			For dim_n = 0 To numDims - 1
				If var1DimVariances_out(dim_n) <> var1DimVariances(dim_n) Then
					QuitCDF("26.19", status, id)
				End If
			Next

			status = CDFgetzVarName(id, var2Num_out, var2Name_out)

			status = CDFgetzVarDataType(id, var2Num_out, _
						    var2DataType_out)

			status = CDFgetzVarNumElements(id, var2Num_out, _
						       var2NumElements_out)

			status = CDFgetzVarRecVariance(id, var2Num_out, _
						       var2RecVariance_out)

			status = CDFgetzVarDimVariances(id, var2Num_out, _
						        var2DimVariances_out)


			status = CDFgetzVarBlockingFactor(id, var2Num_out, _
						          blockingfactorOut2)

			status = CDFgetzVarMaxAllocRecNum(id, var2Num_out, _
						          maxAllocOut2)

			status = CDFgetzVarMaxWrittenRecNum(id, var2Num_out, _
						            maxRecOut2)

			If [String].Compare(var2Name_out, new_var2Name) <> 0 Then
				QuitCDF("26.31", status, id)
			End If
			If var2DataType_out <> var2DataType Then
				QuitCDF("26.32", status, id)
			End If
			If var2NumElements_out <> var2NumElements Then
				QuitCDF("26.33", status, id)
			End If
			If var2RecVariance_out <> var2RecVariance Then
				QuitCDF("26.34", status, id)
			End If
			If var2Num_out <> 1 Then
				QuitCDF("26.35", status, id)
			End If
			If blockingfactorOut2 <> blockingfactor2 Then
				QuitCDF("26.36", status, id)
			End If
			If maxAllocOut2 + 1 <> allocRecs2 Then
				QuitCDF("26.37", status, id)
			End If
			If maxRecOut2 <> 2 Then
				QuitCDF("26.38", status, id)
			End If


			For dim_n = 0 To numDims - 1
				If var2DimVariances_out(dim_n) <> var2DimVariances(dim_n) Then
					QuitCDF("26.39", status, id)
				End If
			Next

			status = CDFgetzVarName(id, var3Num_out, var3Name_out)

			status = CDFgetzVarDataType(id, var3Num_out, _
						    var3DataType_out)

			status = CDFgetzVarNumElements(id, var3Num_out, _
						       var3NumElements_out)

			status = CDFgetzVarRecVariance(id, var3Num_out, _
						       var3RecVariance_out)

			status = CDFgetzVarDimVariances(id, var3Num_out, _
						        var3DimVariances_out)


			status = CDFgetzVarNumDims(id, var3Num_out, _
						   zNumDimsA_out)

			status = CDFgetzVarDimSizes(id, var3Num_out, _
						    zDimSizesA_out)


			status = CDFgetzVarBlockingFactor(id, var3Num_out, _
						          blockingfactorOut3)

			status = CDFgetzVarMaxAllocRecNum(id, var3Num_out, _
						          maxAllocOut3)

			status = CDFgetzVarMaxWrittenRecNum(id, var3Num_out, _
						            maxRecOut3)

			If [String].Compare(var3Name_out, new_var3Name) <> 0 Then
				QuitCDF("26.53", status, id)
			End If
			If var3DataType_out <> var3DataType Then
				QuitCDF("26.54", status, id)
			End If
			If var3NumElements_out <> var3NumElements Then
				QuitCDF("26.55", status, id)
			End If
			If var3RecVariance_out <> var3RecVariance Then
				QuitCDF("26.56", status, id)
			End If
			If zNumDimsA_out <> zNumDimsA Then
				QuitCDF("26.57", status, id)
			End If
			If var3Num_out <> 2 Then
				QuitCDF("26.58", status, id)
			End If
			If blockingfactorOut3 <> blockingfactor3 Then
				QuitCDF("26.59", status, id)
			End If
			If maxAllocOut3 + 1 <> allocRecs3 Then
				QuitCDF("26.60", status, id)
			End If
			If maxRecOut3 <> 2 Then
				QuitCDF("26.61", status, id)
			End If

			For dim_n = 0 To zNumDimsA - 1
				If zDimSizesA_out(dim_n) <> zDimSizesA(dim_n) Then
					QuitCDF("26.62", status, id)
				End If
				If var3DimVariances_out(dim_n) <> var3DimVariances(dim_n) Then
					QuitCDF("26.63", status, id)
				End If
			Next

			'
			' Rename attribute.
			'


			status = CDFrenameAttr(id, CDFgetAttrNum(id, attrName), _
					       new_attrName)

			'
			' Inquire attribute.
			'


			status = CDFgetAttrName(id, _
						CDFgetAttrNum(id, new_attrName), _
						attrName_out)

			status = CDFgetAttrScope(id, _
						 CDFgetAttrNum(id, new_attrName), _
						 attrScope_out)

			status = CDFgetAttrMaxgEntry(id, _
						     CDFgetAttrNum(id, new_attrName), _
						     maxEntry_out)

			If [String].Compare(attrName_out, new_attrName) <> 0 Then
				QuitCDF("28.4", status, id)
			End If
			If attrScope_out <> attrScope Then
				QuitCDF("28.5", status, id)
			End If
			If maxEntry_out <> entryNum Then
				QuitCDF("28.6", status, id)
			End If

			'
			' Inquire attribute entries.
			'


			status = CDFgetAttrgEntryDataType(id, 0, entryNum, _
							  entryDataType_out)

			status = CDFgetAttrgEntryNumElements(id, 0, entryNum, _
							     entryNumElems_out)

			If entryDataType_out <> entryDataType Then
				QuitCDF("29.2", status, id)
			End If
			If entryNumElems_out <> entryNumElems Then
				QuitCDF("29.3", status, id)
			End If

			status = CDFgetAttrzEntryDataType(id, 1, 0, _
							  entryDataType_out)

			status = CDFgetAttrzEntryNumElements(id, 1, 0, _
							     entryNumElems_out)

			If entryDataType_out <> CDF_BYTE Then
				QuitCDF("29.6", status, id)
			End If
			If entryNumElems_out <> 1 Then
				QuitCDF("29.7", status, id)
			End If

			status = CDFgetAttrzEntryDataType(id, 2, 1, _
							  entryDataType_out)

			status = CDFgetAttrzEntryNumElements(id, 2, 1, _
							     entryNumElems_out)

			If entryDataType_out <> CDF_REAL8 Then
				QuitCDF("29.10", status, id)
			End If
			If entryNumElems_out <> 1 Then
				QuitCDF("29.11", status, id)
			End If

			'
			' Get error text.
			'


			status = CDFgetStatusText(CDF_OK, errorText)

			'
			' Select zMode and inquire CDF.
			'


			status = CDFsetzMode(id, zMODEon2)

			status = CDFgetNumgAttributes(id, numGattrs)

			status = CDFgetNumvAttributes(id, numVattrs)

			status = CDFgetNumzVars(id, numZvars)

			status = CDFgetAttrMaxgEntry(id, 0, maxGentry)

			status = CDFgetNumAttrgEntries(id, 0, numGentries)

			status = CDFgetzVarsMaxWrittenRecNum(id, maxRecOut)

			status = CDFgetAttrMaxzEntry(id, 1, maxZentry)

			status = CDFgetNumAttrzEntries(id, 1, numZentries)

			status = CDFsetzMode(id, zMODEoff)

			status = CDFinquire(id, numDimsX, dimSizesX, encodingX, _
					    majorityX, maxrRecX, _
					    nrVarsX, nAttrsX)


			status = CDFinquireCDF(id, numDimsY, dimSizesY, _
					       encodingY, majorityY, maxrRecY, _
					       nrVarsY, maxzRecY, nzVarsY, nAttrsY)


			If numGattrs <> 1 Then
				QuitCDF("31.13", status, id)
			End If
			If numVattrs <> 2 Then
				QuitCDF("31.14", status, id)
			End If
			If numZvars <> 3 Then
				QuitCDF("31.16", status, id)
			End If
			If maxGentry <> entryNum Then
				QuitCDF("31.17", status, id)
			End If
			If numGentries <> 1 Then
				QuitCDF("31.18", status, id)
			End If
			If maxZentry <> 0 Then
				QuitCDF("31.21", status, id)
			End If
			If numZentries <> 1 Then
				QuitCDF("31.22", status, id)
			End If
			If maxRecOut <> 2 Then
				QuitCDF("31.23", status, id)
			End If
			If numDimsX <> numDimsY OrElse numDimsX <> 0 Then
				QuitCDF("31.24", status, id)
			End If
			If encodingX <> encodingY OrElse encodingX <> IBMPC_ENCODING Then
				QuitCDF("31.25", status, id)
			End If
			If majorityX <> majorityY OrElse majorityX <> ROW_MAJOR Then
				QuitCDF("31.26", status, id)
			End If
			' if(maxrRecX != maxrRecY || maxrRecX != 0) QuitCDF("31.27",status,id); 

			If nrVarsX <> nrVarsY OrElse nrVarsX <> 0 Then
				QuitCDF("31.28", status, id)
			End If
			If nAttrsX <> nAttrsY OrElse nAttrsX <> 3 Then
				QuitCDF("31.29", status, id)
			End If
			If nzVarsY <> 3 Then
				QuitCDF("31.30", status, id)
			End If
			If maxzRecY <> 2 Then
				QuitCDF("31.31", status, id)
			End If

			'
			' Attempt to close variables.
			'


			status = CDFclosezVar(id, 0)
			If status <> SINGLE_FILE_FORMAT Then
				QuitCDF("32.0", status, id)
			End If

			status = CDFclosezVar(id, 2)
			If status <> SINGLE_FILE_FORMAT Then
				QuitCDF("32.1", status, id)
			End If

			'
			' Modify entries/attribute.
			'


			status = CDFsetAttrgEntryDataSpec(id, 0, entryNum, _
							  entryDataTypeNew)

			status = CDFsetAttrzEntryDataSpec(id, 1, _
							  CDFgetVarNum(id, new_var1Name), _
							  CDF_UINT1)


			status = CDFsetAttrzEntryDataSpec(id, 2, _
							  CDFgetVarNum(id, new_var2Name), _
							  CDF_EPOCH)


			status = CDFsetAttrScope(id, 0, VARIABLE_SCOPE)

			status = CDFsetAttrScope(id, 0, GLOBAL_SCOPE)

			'
			' Delete entries/attribute/variables.
			'


			status = CDFdeleteAttrgEntry(id, 0, entryNum)

			status = CDFdeleteAttrzEntry(id, 1, 0)

			status = CDFdeleteAttrzEntry(id, 2, 1)

			status = CDFdeleteAttr(id, CDFgetAttrNum(id, new_attrName))

			status = CDFdeletezVar(id, CDFgetVarNum(id, new_var1Name))

			status = CDFdeletezVar(id, CDFgetVarNum(id, new_var3Name))

			'
			' Close CDF.
			'


			status = CDFcloseCDF(id)

			Dim comType As Integer
			Dim comParms As Integer() = New Integer(0) {}
			Dim cSizeo As Long, uSizeo As Long
			status = CDFgetCompressionInfo("TEST", comType, _
						       comParms, cSizeo, uSizeo)


			'
			' Successful completion.
			'

                        Console.WriteLine(" Compression: {0}.{1} size: Compressed: {2} Uncompressed: {3}", CDFUtils.CDFgetStringCompressionType(comType), comParms(0), cSizeo, uSizeo)

		Catch ex As CDFException
			Console.WriteLine("Error... " + ex.toString())
		Finally
			Try
				status = CDFselect(id)
				status = CDFcloseCDF(id)
			Catch ex As CDFException
			End Try
		End Try

	End Sub


	'
	' QuitCDF.
	'


	Private Shared Sub QuitCDF(where As String, status As Integer, id As Long)
		Dim text As String
		Console.WriteLine("Aborting at " + where)
		If status < 0 Then
			status = CDFgetStatusText(status, text)
			Console.WriteLine(" " + text)
		End If
		status = CDFcloseCDF(id)
		Console.WriteLine("...test aborted.")
	End Sub

End Class


