/*****************************************************************************e
*
*  NSSDC/CDF                      Quick Start Test Program(C# interface).
*
*  Version 1.0,15-Jun-21,Mike Liu
*
*  Modification history:
*
*   V1.0   15-Jun-21,M Liu     Original version(for CDF V3.8).
*                              Create a global attribute to write 3 UTF8
*                              strings:
*                                1. simple ASCII string
*                                2. Latin1 string
*                                3. Chinese string
*
******************************************************************************/

using System;
using System.Text;
using System.Runtime.InteropServices;
using CDF;

public class Qst2cs : CDFAPIs {

unsafe public static void Main(string[] args) {
  void* id;
  int status;

  int attrNum, len1, len2, len3;
  StringBuilder sb = new StringBuilder();
  string spdf1="ASCII: ABCDEFG";
  string spdf2="Latin1: ©æêü÷Æ¼®¢¥";
  string spdf3="Chinese: 社安";

  string spdf1o;
  string spdf2o;
  string spdf3o;

  len1 = Encoding.UTF8.GetByteCount(spdf1);
  len2 = Encoding.UTF8.GetByteCount(spdf2);
  len3 = Encoding.UTF8.GetByteCount(spdf3);
Console.WriteLine("length_1="+spdf1.Length+" length_2="+spdf2.Length+" length_3:"+spdf3.Length);
Console.WriteLine("byte_1="+System.Text.ASCIIEncoding.Unicode.GetByteCount(spdf1)+" byte_2="+System.Text.ASCIIEncoding.Unicode.GetByteCount(spdf2)+" byte_3:"+System.Text.ASCIIEncoding.Unicode.GetByteCount(spdf3));
/******************************************************************************
* Display title.
******************************************************************************/

Console.WriteLine("Testing UTF8 in C#-CDF...");

/******************************************************************************
* Create CDF.
******************************************************************************/
Console.WriteLine("spdf1=\""+spdf1+"\"   len="+spdf1.Length+" byte_len="+ len1);
byte[] byte1s = Encoding.UTF8.GetBytes(spdf1);
foreach (byte t in byte1s) {
  sb.Append(t.ToString("X2"));
}
Console.WriteLine(" Hex value: "+sb.ToString());
sb.Length = 0;
Console.WriteLine("spdf2=\""+spdf2+"\"   len="+spdf2.Length+" byte_len="+ len2);
byte[] byte2s = Encoding.UTF8.GetBytes(spdf2);
foreach (byte t in byte2s) {
  sb.Append(t.ToString("X2"));
}
Console.WriteLine(" Hex value: "+sb.ToString());
sb.Length = 0;
/// Need to chcp 936 to correctly show the Chinese
Console.WriteLine("spdf3=\""+spdf3+"\"   len="+spdf3.Length+" byte_len="+ len3);
byte[] byte3s = Encoding.UTF8.GetBytes(spdf3);
foreach (byte t in byte3s) {
  sb.Append(t.ToString("X2"));
}
Console.WriteLine(" Hex value: "+sb.ToString());
sb.Length = 0;
id =(void*) 0;
try {
status = CDFcreateCDF((args.Length==1?args[0]:"TUTF8"),&id);
} catch(CDFException ex) {
  int stat = ex.CDFgetCurrentStatus();
  if(stat < CDF_OK) {
    id = null;
    if(stat == CDF_EXISTS) {
      status = CDFopen((args.Length==1?args[0]:"TUTF8"),&id);
      if(status < CDF_OK) QuitCDF("1.0",status,id);

      status = CDFdeleteCDF(id);
      if(status < CDF_OK) QuitCDF("1.1",status,id);

      status = CDFcreateCDF((args.Length==1?args[0]:"TUTF8"),&id);
      if(status < CDF_OK) QuitCDF("1.2",status,id);
    } else
      QuitCDF("1.4",stat,id);
  }
}

try {

/******************************************************************************
* Create a global attribute.
******************************************************************************/

status = CDFattrCreate(id,"UTF8",GLOBAL_SCOPE,&attrNum);

/******************************************************************************
* Add entries.
******************************************************************************/
/*
status = CDFputAttrgEntry(id,attrNum,0,CDF_CHAR,len1,spdf1);
status = CDFputAttrgEntry(id,attrNum,1,CDF_CHAR,len2,spdf2);
status = CDFputAttrgEntry(id,attrNum,2,CDF_CHAR,len3,spdf3);
*/
status = CDFputAttrgEntry(id,attrNum,0,spdf1);
status = CDFputAttrgEntry(id,attrNum,1,spdf2);
status = CDFputAttrgEntry(id,attrNum,2,spdf3);

/******************************************************************************
* Close CDF.
******************************************************************************/

status = CDFcloseCDF(id);

Console.WriteLine("**** Creation is successful...");
/******************************************************************************
* Reopen CDF.
******************************************************************************/

status = CDFopen((args.Length==1?args[0]:"TUTF8"),&id);

/******************************************************************************
* Get global attribute entries.
******************************************************************************/
attrNum = CDFgetAttrNum(id,"UTF8");
status = CDFgetAttrgEntry(id,attrNum,0,out spdf1o);
status = CDFgetAttrgEntry(id,attrNum,1,out spdf2o);
status = CDFgetAttrgEntry(id,attrNum,2,out spdf3o);

if(String.Compare(spdf1,spdf1o) != 0) QuitCDF("26.1",status,id);
if(String.Compare(spdf2,spdf2o) != 0) QuitCDF("26.2",status,id);
if(String.Compare(spdf3,spdf3o) != 0) QuitCDF("26.3",status,id);

/******************************************************************************
* Close CDF.
******************************************************************************/

status = CDFcloseCDF(id);  

/******************************************************************************
* Successful completion.
******************************************************************************/
} catch(CDFException ex) {
  Console.WriteLine("Error... "+ex);
} finally {
  try {
    status = CDFselect(id);
    status = CDFcloseCDF(id);
  } catch(CDFException ex) {}
}

}


/******************************************************************************
* QuitCDF.
******************************************************************************/

unsafe static void QuitCDF(string where, int status, void* id)
{
  string text;
  Console.WriteLine("Aborting at "+where);
  if(status < 0) {
    status = CDFgetStatusText(status,out text); 
    Console.WriteLine(" "+text);
  }
  status = CDFcloseCDF(id);
  Console.WriteLine("...test aborted.");
  System.Environment.Exit(1);
}

}

