#!/usr/bin/perl -w

#
# testTT2000
#
#   This program tests the PerlCDF internal interface.  PerlCDF must be installed.
#   See README.
#
#  Usage:
#     perl testPerlCDFii.pl
#
# Written By:
#
#    Mike Liu
#    ADNET systems
#
#    1 October, 2011
#
#    Version 1.0
#    Modified by: Michael Liu  - 01 October, 2011
#
#############################################################################

use strict;
use Math::BigInt;

BEGIN { unshift @INC,$ENV{"HOME"}.'/PerlCDF39_2/blib/arch',
                     $ENV{"HOME"}.'/PerlCDF39_2/blib/lib'; }
use CDF;

#############################################################################
# Display title.
#############################################################################

print "\nTesting Perl-CDF Internal/C interface for TT2000 \n\n";

#############################################################################
# Open CDF.
#############################################################################

my ($status, $id);
$status = CDF::CDFlib (&OPEN_, &CDF_, "newtest", \$id,
		       &NULL_);
QuitCDF ("4.0", $status) if ($status < &CDF_OK) ;

my $zRecStart = 0;
my $zRecCount = 6;
my $zRecInterval = 1;
my @zIndicesA = (0);
my @zCounts = (1);
my @zIntervals = (1);
my @zVarAvalues;
my $var = "tt2000";
$status = CDF::CDFlib (&SELECT_, &zVAR_NAME_, $var,
                                &zVAR_RECNUMBER_, $zRecStart,
                                &zVAR_RECCOUNT_, $zRecCount,
                                &zVAR_RECINTERVAL_, $zRecInterval,
                                &zVAR_DIMINDICES_, \@zIndicesA,
                                &zVAR_DIMCOUNTS_, \@zCounts,
                                &zVAR_DIMINTERVALS_, \@zIntervals,
                       &GET_, &zVAR_HYPERDATA_, \@zVarAvalues,
                       &NULL_);
QuitCDF ("10.0z", $status) if ($status < &CDF_OK) ;

my $i;
my $tt2000;
print "TT2000: \n";
for ($i = 0; $i <= $#zVarAvalues; $i++) {
  CDF::encodeTT2000($zVarAvalues[$i], $tt2000);
  print $i,": ",$zVarAvalues[$i]," => ",$tt2000," \n";
}

$var = "newI8";
$zRecCount = 4;
@zCounts = (2);

$status = CDF::CDFlib (&SELECT_, &zVAR_NAME_, $var,
                                &zVAR_RECNUMBER_, $zRecStart,
                                &zVAR_RECCOUNT_, $zRecCount,
                                &zVAR_RECINTERVAL_, $zRecInterval,
                                &zVAR_DIMINDICES_, \@zIndicesA,
                                &zVAR_DIMCOUNTS_, \@zCounts,
                                &zVAR_DIMINTERVALS_, \@zIntervals,
                       &GET_, &zVAR_HYPERDATA_, \@zVarAvalues,
                       &NULL_);
QuitCDF ("10.0z", $status) if ($status < &CDF_OK) ;

print "\nINT8: \n";
for ($i = 0; $i <= $#zVarAvalues; $i++) {
  print $i,": ",$zVarAvalues[$i]," \n";
}

#############################################################################
# Close CDF.
#############################################################################

$status = CDF::CDFlib (&CLOSE_, &CDF_,
		       &NULL_);
QuitCDF ("28.2", $status) if ($status < &CDF_OK) ;

#############################################################################
# Successful completion.
#############################################################################
print "All tests completed successfully\n";

my $tt = 340203790171876765;
my ($y,$m,$d,$h,$n,$s,$l,$u,$o);
CDF::TT2000breakdown($tt,$y,$m,$d,$h,$n,$s,$l,$u,$o);
my $tt1 = "340203790171876765";
my ($y1,$m1,$d1,$h1,$n1,$s1,$l1,$u1,$o1);
CDF::TT2000breakdown($tt1,$y1,$m1,$d1,$h1,$n1,$s1,$l1,$u1,$o1);
#print $y1,"-",$m1,"-",$d1,"T",$h1,":",$n1,":",$s1,".",$l1,$u1,$o1," VS ",$y,"-",$m,"-",$d,"T",$h,":",$n,":",$s,".",$l,$u,$o,"\n";
printf ("%04d-%02d-%02dT%02d:%02d:%02d.%03d%03d%03d VS %04d-%02d-%02dT%02d:%02d:%02d.%03d%03d%03d\n",$y1,$m1,$d1,$h1,$n1,$s1,$l1,$u1,$o1,$y,$m,$d,$h,$n,$s,$l,$u,$o);
exit;

#############################################################################
# QuitCDF.
#############################################################################
sub QuitCDF {
	my ($where, $status)=@_;

  print "Aborting at $where ...\n";
  if ($status < &CDF_OK) {
    my $text;
    CDF::CDFlib (&SELECT_, &CDF_STATUS_, $status,
		   &GET_, &STATUS_TEXT_, \$text,
		   &NULL_);
    print $text;
  }
  CDF::CDFlib (&CLOSE_, &CDF_,
	  &NULL_);
  print "...test aborted.\n";
  exit;
	
}#endsub QuitCDF

#############################################################################
#  QuitEPOCH
#############################################################################
sub QuitEPOCH {
  my ($where) = @_;
  print "Aborting at $where...test aborted.\n";
  exit;

}#endsub QuitEPOCH
