/*****************************************************************************e
*
*  NSSDC/CDF                      Quick Start Test Program(C# interface).
*
*  Version 1.0,15-Oct-09,Mike Liu
*
*  Modification history:
*
*   V1.0   15-Oct-09,M Liu     Original version(for CDF V3.3).
*                              Using pointers (&) to pass arguments for 
*                              retrieving data fields and values to C# APIs.
*
******************************************************************************/

using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization.Json;
using System.IO;
using System.Text;

using CDF;

public class QstReadVariables : CDFAPIs {

unsafe public static void Main(string[] args) {
  void* id;
  int status;

id = (void *) 0;
try {
  status = CDFopen(args[0],&id);
  Dictionary<string,object> cdf = ReadCDFVariables(id);
  CDFUtils.PrintDictionary (cdf);
  status = CDFcloseCDF(id);  


/******************************************************************************
* Successful completion.
******************************************************************************/
} catch(CDFException ex) {
  Console.WriteLine("Error... "+ex);
} finally {
  try {
    status = CDFselect(id);
    status = CDFcloseCDF(id);
  } catch(CDFException ex) {}
}

}


/******************************************************************************
* QuitCDF.
******************************************************************************/

unsafe static void QuitCDF(string where, int status, void* id)
{
  string text;
  Console.WriteLine("Aborting at "+where);
  if(status < 0) {
    status = CDFgetStatusText(status,out text); 
    Console.WriteLine(" "+text);
  }
  status = CDFcloseCDF(id);
  Console.WriteLine("...test aborted.");
  System.Environment.Exit(1);
}

}

