@echo off
@setlocal ENABLEDELAYEDEXPANSION
echo.
echo Checking for the leap seconds table...
if "%CDF_LEAPSECONDSTABLE%"=="" (
  echo CDF_LEAPSECONDSTABLE environment variable is not defined...
  echo Internal hard-coded leap seconds table may be used...
  if "%CDF_BASE%" NEQ "" (
    @echo.
    for /f "delims=" %%a in ('"%CDF_BASE%\bin\cdfleapsecondsinfo.exe" -nodump') do @set result=%%a
    for /f "tokens=13 delims= " %%a in ("!result!") do @set local_leap=%%a
    for /f "tokens=1 delims=-" %%a in ("!local_leap!") do @set lyear=%%a
    for /f "tokens=2 delims=-" %%a in ("!local_leap!") do @set lmonth=%%a
    for /f "tokens=3 delims=-" %%a in ("!local_leap!") do @set lday=%%a
    for /f "delims=" %%a in ('echo "%CDF_BASE%\bin"') do @set ls_folder=%%~dpa
    if !ls_folder:~-1!==\ @set ls_folder=!ls_folder:~0,-1!
  ) else (
    @echo.
    set /p ls_folder=Enter the latest installed CDF directory: 
    if exist "!ls_folder!\bin\cdfleapsecondsinfo.exe" (
      set PATH="!ls_folder!\bin;!ls_folder!\lib;%path%"
      for /f "delims=" %%a in ('"!ls_folder!\bin\cdfleapsecondsinfo.exe" -nodump') do @set result=%%a
      for /f "tokens=13 delims= " %%a in ("!result!") do @set local_leap=%%a
      for /f "tokens=1 delims=-" %%a in ("!local_leap!") do @set lyear=%%a
      for /f "tokens=2 delims=-" %%a in ("!local_leap!") do @set lmonth=%%a
      for /f "tokens=3 delims=-" %%a in ("!local_leap!") do @set lday=%%a
    ) else (
      echo Error... CDF installation not found in !ls_folder!.
      exit /b 0
    )
  )
) else (
  rem for /f "delims=" %%a in ('echo "%CDF_LEAPSECONDSTABLE%"') do @set ls_folder=%%~dpa
  @set ls_folder=!CDF_BASE!
  @set runtail="!CDF_BASE!\bin\tail" -1 "!CDF_LEAPSECONDSTABLE!"
  @set lastone='"!runtail!"'
  for /f "delims=" %%a in (!lastone!) do @set lastline=%%a
  for /f "tokens=1 delims= " %%a in ("!lastline!") do @set lyear=%%a
  for /f "tokens=2 delims= " %%a in ("!lastline!") do @set lmonth=%%a
  for /f "tokens=3 delims= " %%a in ("!lastline!") do @set lday=%%a
)
@set LSfile=%TEMP%\CDFLeapSeconds.txt
@set gettable=""wget" -q -O "%LSfile%" https://cdf.gsfc.nasa.gov/html/CDFLeapSeconds.txt"
@set out2=start "" /B /WAIT "!gettable!"
!out2! 2> out3
FOR /F "usebackq" %%A IN ('%LSfile%') DO set lssize=%%~zA
if %lssize% EQU 0 (
  echo Error... Unable to get the remote https://cdf.gsfc.nasa.gov/html/CDFLeapSeconds.txt.
  exit /b 0
)
set CYGWIN=nodosfilewarning
for /f "delims=" %%a in ('"!ls_folder!\bin\tail" -1 %LSfile%') do @set lastline=%%a
for /f "tokens=1 delims= " %%a in ("!lastline!") do @set ryear=%%a
for /f "tokens=2 delims= " %%a in ("!lastline!") do @set rmonth=%%a
for /f "tokens=3 delims= " %%a in ("!lastline!") do @set rday=%%a
set /a localdate = !lyear!*10000+!lmonth!*100+!lday!
set /a remotedate = !ryear!*10000+!rmonth!*100+!rday!
if %localdate% equ %remotedate% goto goodone
if %localdate% lss %remotedate% goto needupdate
if %localdate% gtr %remotedate% goto newupdate
goto end
:needupdate
  echo.
  echo You are using the leap second table at %CDF_LEAPSECONDSTABLE%
  echo But, newer leap second(s) had been added to CDFLeapSeconds.txt at the CDF
  echo home page. Please update your CDF installation that includes the latest
  echo CDFLeapSeconds.txt from https://cdf.gsfc.nasa.gov.
  goto end
:newupdate
  echo.
  echo Local CDFLeapSeconds.txt has a newer leap second (or more) than the
  echo one at the CDF home page.
  goto end
:goodone
  echo.
  if "%ls_folder%"=="" (
    echo Hard-coded CDFLeapSeconds.txt is up-to-date.
  ) else (
    echo Local CDFLeapSeconds.txt in "%ls_folder%" is up-to-date.
  )
:end
@endlocal
