/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.Attribute;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class RenameAttributeAction
extends AbstractAction
implements CDFConstants {
    static final long serialVersionUID = 1L;
    private static final String DEFAULT_NAME = "Rename Attribute";
    private MYEditor myEditor;
    private AttributePanel attrPanel;

    public RenameAttributeAction(AttributePanel attributePanel, char c) {
        this(attributePanel, "Rename " + c + "Attribute");
    }

    public RenameAttributeAction(AttributePanel attributePanel, String string) {
        super(string);
        this.attrPanel = attributePanel;
        this.myEditor = attributePanel.getMyEditor();
    }

    @Override
    public void putValue(String string, Object object) {
        if (object != null) {
            super.putValue(string, object);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.myEditor.setWaitCursor();
        Attribute attribute = this.attrPanel.getSelectedAttr();
        Object var3_3 = null;
        if (attribute == null) {
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(this.myEditor, "No attribute selected", "MYEditor: Error", 0);
        } else {
            String string = ((Object)attribute).toString();
            String string2 = JOptionPane.showInputDialog(this.myEditor.getFrame(), "Enter a new attribute name", "Rename Attribute: " + string, 3);
            if (string2 != null) {
                this.myEditor.setWaitCursor();
                try {
                    this.attrPanel.renameSelectedAttr(string2);
                    if (this.attrPanel.getScope() == 1L) {
                        this.attrPanel.updateAttrPanel(this.attrPanel.getSelectedAttr(), true);
                    } else if (this.myEditor.variablePanel.getSelectedVar() != null) {
                        this.myEditor.variablePanel.updateVarPanel(this.myEditor.variablePanel.getSelectedVar());
                    }
                }
                catch (CDFException cDFException) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(this.myEditor.sharedInstance(), "CDF Error:\n" + cDFException.getMessage(), "CDFException", 0);
                }
            }
        }
        this.myEditor.setDefaultCursor();
    }
}

