/*
 * Decompiled with CFR 0.152.
 */
package gsfc.nssdc.cdf.util;

import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.Entry;
import gsfc.nssdc.cdf.Variable;
import gsfc.nssdc.cdf.util.CDFTT2000;
import gsfc.nssdc.cdf.util.Epoch;
import gsfc.nssdc.cdf.util.Epoch16;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.StringTokenizer;

public class CDFUtils
implements CDFConstants {
    public static String getSignature(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = object.getClass().getName();
        if (string.indexOf(91) == 0) {
            stringBuffer.append(string);
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            stringBuffer.append("L");
            do {
                stringBuffer.append(stringTokenizer.nextToken());
                if (!stringTokenizer.hasMoreTokens()) continue;
                stringBuffer.append("/");
            } while (stringTokenizer.hasMoreTokens());
            stringBuffer.append(";");
        }
        return stringBuffer.toString();
    }

    public static long getNumElements(long l, Object object) throws CDFException {
        if (l == 51L || l == 52L) {
            String string = CDFUtils.getSignature(object);
            if (string.indexOf("String") != -1) {
                try {
                    byte[] byArray = ((String)object).getBytes("UTF-8");
                    return byArray.length;
                }
                catch (Exception exception) {
                    return ((String)object).length();
                }
            }
            if (string.indexOf("[B") != -1) {
                return ((byte[])object).length;
            }
            return 1L;
        }
        int n = l == 32L ? 2 : 1;
        String string = CDFUtils.getSignature(object);
        if (string.charAt(0) == '[') {
            switch (string.charAt(1)) {
                case 'B': {
                    return ((byte[])object).length / n;
                }
                case 'S': {
                    return ((short[])object).length / n;
                }
                case 'I': {
                    return ((int[])object).length / n;
                }
                case 'J': {
                    return ((long[])object).length / n;
                }
                case 'F': {
                    return ((float[])object).length / n;
                }
                case 'D': {
                    return ((double[])object).length / n;
                }
            }
            throw new CDFException(-2022L);
        }
        return 1L;
    }

    public static long getNumStrings(Object object) {
        String string = CDFUtils.getSignature(object).toLowerCase();
        if (string.charAt(0) == '[' && string.indexOf("string") != -1) {
            return ((String[])object).length;
        }
        if (string.indexOf("string") != -1) {
            int n;
            long l = 1L;
            StringBuffer stringBuffer = new StringBuffer(object.toString());
            while ((n = stringBuffer.indexOf(STRINGDELIMITER)) != -1) {
                stringBuffer = new StringBuffer(stringBuffer.substring(n + STRINGDELIMITER.length()));
                ++l;
            }
            return l;
        }
        return 0L;
    }

    public static void printData(Object object) {
        CDFUtils.printData(object, 0, true, "");
    }

    public static void printData(Object object, int n, boolean bl) {
        CDFUtils.printData(object, n, bl, "");
    }

    public static void printData(Object object, int n, boolean bl, String string) {
        if (object == null) {
            return;
        }
        int n2 = CDFUtils.getNumDimensions(object);
        if (n2 > 1) {
            int n3 = ((Object[])object).length;
            for (int i = 0; i < n3; ++i) {
                Object object2 = ((Object[])object)[i];
                CDFUtils.printData(object2, n, bl, string);
            }
        } else {
            int n4 = 1;
            String string2 = CDFUtils.getSignature(object);
            if (n == 2) {
                n4 = 2;
            }
            if (string2.charAt(0) == '[') {
                int n5 = Array.getLength(object);
                for (int i = 0; i < n5; i += n4) {
                    if (string2.charAt(1) == 'B') {
                        System.out.print(Array.getByte(object, i) + (i == n5 - n4 ? "" : " "));
                        continue;
                    }
                    if (string2.charAt(1) == 'S') {
                        System.out.print(Array.getShort(object, i) + (i == n5 - n4 ? "" : " "));
                        continue;
                    }
                    if (string2.charAt(1) == 'I') {
                        System.out.print(Array.getInt(object, i) + (i == n5 - n4 ? "" : " "));
                        continue;
                    }
                    if (string2.charAt(1) == 'J') {
                        if (n == 0) {
                            System.out.print(Array.getLong(object, i) + (i == n5 - n4 ? "" : " "));
                            continue;
                        }
                        System.out.print(CDFTT2000.encode(Array.getLong(object, i)) + string + (i == n5 - n4 ? "" : " "));
                        continue;
                    }
                    if (string2.charAt(1) == 'F') {
                        System.out.print(Array.getFloat(object, i) + (i == n5 - n4 ? "" : " "));
                        continue;
                    }
                    if (string2.charAt(1) == 'D') {
                        if (n == 1) {
                            System.out.print((!bl ? Epoch.encode(Array.getDouble(object, i)) : Epoch.encode4(Array.getDouble(object, i)) + string) + (i == n5 - n4 ? "" : " "));
                            continue;
                        }
                        if (n == 2) {
                            double[] dArray = new double[]{Array.getDouble(object, i), Array.getDouble(object, i + 1)};
                            System.out.print((!bl ? Epoch16.encode(dArray) : Epoch16.encode4(dArray) + string) + (n5 == 2 ? "" : " "));
                            continue;
                        }
                        System.out.print(Array.getDouble(object, i) + (i == n5 - n4 ? "" : " "));
                        continue;
                    }
                    System.out.print("\"");
                    System.out.print(Array.get((String[])object, i));
                    System.out.print("\" ");
                }
                System.out.println("");
            } else if (n == 1) {
                System.out.println(!bl ? Epoch.encode((Double)object) : Epoch.encode4((Double)object) + string);
            } else if (n == 3) {
                System.out.println(CDFTT2000.encode((Long)object) + string);
            } else if (object instanceof String) {
                int n6 = ((String)object).length();
                if (n6 == 1) {
                    byte[] byArray = ((String)object).getBytes();
                    if (byArray[0] == 0) {
                        System.out.println("\"\"");
                    } else {
                        System.out.println("\"" + object + "\"");
                    }
                } else {
                    System.out.println("\"" + object + "\"");
                }
            } else {
                System.out.println(object);
            }
        }
    }

    public static void printData(Object object, int n) {
        CDFUtils.printData(object, n, true);
    }

    public static void printData(Object object, long l) {
        if (l == 31L) {
            CDFUtils.printData(object, 1);
        } else if (l == 32L) {
            CDFUtils.printData(object, 2);
        } else if (l == 33L) {
            CDFUtils.printData(object, 3);
        } else {
            CDFUtils.printData(object, 0);
        }
    }

    public static void printData(Object object, PrintWriter printWriter) {
        CDFUtils.printData(object, printWriter, 0, true);
    }

    public static void printData(Object object, PrintWriter printWriter, int n) {
        CDFUtils.printData(object, printWriter, n, true);
    }

    public static void printData(Object object, PrintWriter printWriter, int n, boolean bl) {
        CDFUtils.printData(object, printWriter, n, bl, "");
    }

    public static void printData(Object object, PrintWriter printWriter, int n, boolean bl, String string) {
        int n2 = 1;
        String string2 = CDFUtils.getSignature(object);
        if (n == 2) {
            n2 = 2;
        }
        if (string2.charAt(0) == '[') {
            int n3 = Array.getLength(object);
            for (int i = 0; i < n3; i += n2) {
                if (string2.charAt(1) == 'B') {
                    printWriter.print(Array.getByte(object, i) + " ");
                    continue;
                }
                if (string2.charAt(1) == 'S') {
                    printWriter.print(Array.getShort(object, i) + " ");
                    continue;
                }
                if (string2.charAt(1) == 'I') {
                    printWriter.print(Array.getInt(object, i) + " ");
                    continue;
                }
                if (string2.charAt(1) == 'J') {
                    if (n == 0) {
                        printWriter.print(Array.getLong(object, i) + " ");
                        continue;
                    }
                    printWriter.print(CDFTT2000.encode(Array.getLong(object, i)) + string + " ");
                    continue;
                }
                if (string2.charAt(1) == 'F') {
                    printWriter.print(Array.getFloat(object, i) + " ");
                    continue;
                }
                if (string2.charAt(1) != 'D') continue;
                if (n == 1) {
                    printWriter.print((!bl ? Epoch.encode(Array.getDouble(object, i)) : Epoch.encode4(Array.getDouble(object, i)) + string) + " ");
                    continue;
                }
                if (n == 2) {
                    double[] dArray = new double[]{Array.getDouble(object, i), Array.getDouble(object, i + 1)};
                    printWriter.print((!bl ? Epoch16.encode(dArray) : Epoch16.encode4(dArray) + string) + (n3 == 2 ? "" : " "));
                    continue;
                }
                printWriter.print(Array.getDouble(object, i) + " ");
            }
        } else if (n == 1) {
            printWriter.print(!bl ? Epoch.encode((Double)object) : Epoch.encode4((Double)object) + string);
        } else if (n == 3) {
            printWriter.print(CDFTT2000.encode((Long)object) + string);
        } else {
            printWriter.print(object);
        }
    }

    public static void printDataWithFormat(Object object, String string) {
        CDFUtils.printDataWithFormat(object, string, 0, true);
    }

    public static void printDataWithFormat(Object object, String string, int n, boolean bl) {
        CDFUtils.printDataWithFormat(object, string, n, bl, "");
    }

    public static void printDataWithFormat(Object object, String string, int n, boolean bl, String string2) {
        if (string == null) {
            CDFUtils.printData(object, n, bl, string2);
            return;
        }
        String string3 = CDFUtils.CFtoJformat(string);
        if (string3 == null || CDFUtils.isFloatingPadValue(object) == 1) {
            CDFUtils.printData(object, n, bl, string2);
            return;
        }
        int n2 = 1;
        String string4 = CDFUtils.getSignature(object);
        if (n == 2) {
            n2 = 2;
        }
        if (string4.charAt(0) == '[') {
            int n3 = Array.getLength(object);
            for (int i = 0; i < n3; i += n2) {
                if (string4.charAt(1) == 'B') {
                    System.out.print(Array.getByte(object, i) + (i == n3 - n2 ? "" : " "));
                    continue;
                }
                if (string4.charAt(1) == 'S') {
                    System.out.print(Array.getShort(object, i) + (i == n3 - n2 ? "" : " "));
                    continue;
                }
                if (string4.charAt(1) == 'I') {
                    System.out.print(Array.getInt(object, i) + (i == n3 - n2 ? "" : " "));
                    continue;
                }
                if (string4.charAt(1) == 'J') {
                    if (n == 0) {
                        System.out.print(Array.getLong(object, i) + (i == n3 - n2 ? "" : " "));
                        continue;
                    }
                    System.out.print(CDFTT2000.encode(Array.getLong(object, i)) + string2 + (i == n3 - n2 ? "" : " "));
                    continue;
                }
                if (string4.charAt(1) == 'F') {
                    float f = Array.getFloat(object, i);
                    if (CDFUtils.isFloatingPadValue(f) == 0) {
                        System.out.format(string3 + (i == n3 - n2 ? "" : " "), Float.valueOf(f));
                        continue;
                    }
                    System.out.print(f + (i == n3 - n2 ? "" : " "));
                    continue;
                }
                if (string4.charAt(1) == 'D') {
                    if (n == 1) {
                        System.out.print((!bl ? Epoch.encode(Array.getDouble(object, i)) : Epoch.encode4(Array.getDouble(object, i)) + string2) + (i == n3 - n2 ? "" : " "));
                        continue;
                    }
                    if (n == 2) {
                        double[] dArray = new double[]{Array.getDouble(object, i), Array.getDouble(object, i + 1)};
                        System.out.print((!bl ? Epoch16.encode(dArray) : Epoch16.encode4(dArray) + string2) + (n3 == 2 ? "" : " "));
                        continue;
                    }
                    double d = Array.getDouble(object, i);
                    if (CDFUtils.isFloatingPadValue(d) == 0) {
                        System.out.format(string3 + (i == n3 - n2 ? "" : " "), d);
                        continue;
                    }
                    System.out.print(d + (i == n3 - n2 ? "" : " "));
                    continue;
                }
                if (i > 0) {
                    System.out.print(" \"");
                }
                System.out.print(Array.get((String[])object, i));
                if (i >= n3 - 1) continue;
                System.out.print("\" ");
            }
        } else if (n == 1) {
            System.out.print(!bl ? Epoch.encode((Double)object) : Epoch.encode4((Double)object) + string2);
        } else if (n == 3) {
            System.out.print(CDFTT2000.encode((Long)object) + string2);
        } else if ((string4.indexOf("Float") != -1 || string4.indexOf("Double") != -1) && CDFUtils.isFloatingPadValue(object) == 0) {
            System.out.format(string3, object);
        } else {
            System.out.println(object);
        }
    }

    public static void printDataWithFormat(Object object, String string, int n) {
        CDFUtils.printDataWithFormat(object, string, n, false);
    }

    public static void printDataWithFormat(Object object, String string, PrintWriter printWriter) {
        CDFUtils.printDataWithFormat(object, string, printWriter, 0, false);
    }

    public static void printDataWithFormat(Object object, String string, PrintWriter printWriter, int n) {
        CDFUtils.printDataWithFormat(object, string, printWriter, n, false);
    }

    public static void printDataWithFormat(Object object, String string, PrintWriter printWriter, int n, boolean bl) {
        CDFUtils.printDataWithFormat(object, string, printWriter, n, bl, "");
    }

    public static void printDataWithFormat(Object object, String string, PrintWriter printWriter, int n, boolean bl, String string2) {
        if (string == null) {
            CDFUtils.printData(object, printWriter, n, bl, string2);
            return;
        }
        String string3 = CDFUtils.CFtoJformat(string);
        if (string3 == null || CDFUtils.isFloatingPadValue(object) == 1) {
            CDFUtils.printData(object, printWriter, n, bl, string2);
            return;
        }
        int n2 = 1;
        String string4 = CDFUtils.getSignature(object);
        if (n == 2) {
            n2 = 2;
        }
        if (string4.charAt(0) == '[') {
            int n3 = Array.getLength(object);
            for (int i = 0; i < n3; i += n2) {
                if (string4.charAt(1) == 'B') {
                    printWriter.print(Array.getByte(object, i) + " ");
                    continue;
                }
                if (string4.charAt(1) == 'S') {
                    printWriter.print(Array.getShort(object, i) + " ");
                    continue;
                }
                if (string4.charAt(1) == 'I') {
                    printWriter.print(Array.getInt(object, i) + " ");
                    continue;
                }
                if (string4.charAt(1) == 'J') {
                    if (n == 0) {
                        printWriter.print(Array.getLong(object, i) + " ");
                        continue;
                    }
                    printWriter.print(CDFTT2000.encode(Array.getLong(object, i)) + string2 + " ");
                    continue;
                }
                if (string4.charAt(1) == 'F') {
                    float f = Array.getFloat(object, i);
                    if (CDFUtils.isFloatingPadValue(f) == 0) {
                        printWriter.format(string3 + " ", Float.valueOf(f));
                        continue;
                    }
                    printWriter.format(f + " ", new Object[0]);
                    continue;
                }
                if (string4.charAt(1) != 'D') continue;
                if (n == 1) {
                    printWriter.print((!bl ? Epoch.encode(Array.getDouble(object, i)) : Epoch.encode4(Array.getDouble(object, i)) + string2) + " ");
                    continue;
                }
                if (n == 2) {
                    double[] dArray = new double[]{Array.getDouble(object, i), Array.getDouble(object, i + 1)};
                    printWriter.print((!bl ? Epoch16.encode(dArray) : Epoch16.encode4(dArray) + string2) + (n3 == 2 ? "" : " "));
                    continue;
                }
                double d = Array.getDouble(object, i);
                if (CDFUtils.isFloatingPadValue(d) == 0) {
                    printWriter.format(string3 + " ", Array.getDouble(object, i));
                    continue;
                }
                printWriter.print(d + " ");
            }
        } else if (n == 1) {
            printWriter.print(!bl ? Epoch.encode((Double)object) : Epoch.encode4((Double)object) + string2);
        } else if (n == 3) {
            printWriter.print(CDFTT2000.encode((Long)object) + string2);
        } else if ((string4.indexOf("Float") != -1 || string4.indexOf("Double") != -1) && CDFUtils.isFloatingPadValue(object) == 0) {
            printWriter.format(string3 + " ", object);
        } else {
            printWriter.print(object + " ");
        }
    }

    public static String getStringData(Object object) {
        return CDFUtils.getStringData(object, " ", 0);
    }

    public static String mergeFromStrings(Object object) {
        long l = CDFUtils.getNumStrings(object);
        if (l > 1L) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while ((long)n < l) {
                stringBuffer.append(((String[])object)[n]);
                if ((long)n != l - 1L) {
                    stringBuffer.append(STRINGDELIMITER);
                }
                ++n;
            }
            return stringBuffer.toString();
        }
        try {
            return new String(((String)object).getBytes(), "UTF-8");
        }
        catch (Exception exception) {
            return (String)object;
        }
    }

    public static String[] breakIntoStrings(String string) {
        long l = CDFUtils.getNumStrings(string);
        String[] stringArray = new String[(int)l];
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while ((long)n < l) {
            int n2 = stringBuffer.indexOf(STRINGDELIMITER);
            if (n2 != -1) {
                stringArray[n] = stringBuffer.substring(0, n2).toString();
                stringBuffer = new StringBuffer(stringBuffer.substring(n2 + STRINGDELIMITER.length()));
            } else {
                stringArray[n] = new String(stringBuffer);
            }
            ++n;
        }
        return stringArray;
    }

    public static String getStringData(Object object, int n) {
        return CDFUtils.getStringData(object, " ", n);
    }

    public static String getStringData(Object object, String string) {
        return CDFUtils.getStringData(object, string, 0);
    }

    public static String getStringData(Object object, String string, int n) {
        return CDFUtils.getStringData(object, string, 0, "");
    }

    public static String getStringData(Object object, String string, int n, String string2) {
        String string3 = CDFUtils.getSignature(object);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n == 2 ? 2 : 1;
        if (string3.charAt(0) == '[') {
            int n3 = Array.getLength(object);
            for (int i = 0; i < n3; i += n2) {
                Object object2;
                if (i > 0) {
                    stringBuffer.append(string);
                }
                if (string3.charAt(1) == 'B') {
                    stringBuffer.append(Array.getByte(object, i));
                    continue;
                }
                if (string3.charAt(1) == 'S') {
                    stringBuffer.append(Array.getShort(object, i));
                    continue;
                }
                if (string3.charAt(1) == 'I') {
                    stringBuffer.append(Array.getInt(object, i));
                    continue;
                }
                if (string3.charAt(1) == 'J') {
                    if (n == 0) {
                        stringBuffer.append(Array.getLong(object, i));
                        continue;
                    }
                    object2 = CDFTT2000.encode(Array.getLong(object, i));
                    stringBuffer.append((String)object2);
                    continue;
                }
                if (string3.charAt(1) == 'F') {
                    stringBuffer.append(Array.getFloat(object, i));
                    continue;
                }
                if (string3.charAt(1) == 'D') {
                    if (n == 1) {
                        object2 = Epoch.encode(Array.getDouble(object, i));
                        stringBuffer.append((String)object2);
                        continue;
                    }
                    if (n == 2) {
                        object2 = new double[2];
                        object2[0] = Array.getDouble(object, i);
                        object2[1] = Array.getDouble(object, i + 1);
                        String string4 = Epoch16.encode(object2);
                        stringBuffer.append(string4);
                        continue;
                    }
                    stringBuffer.append(Array.getDouble(object, i));
                    continue;
                }
                if (string3.charAt(1) == 'C') {
                    stringBuffer.append(Array.getChar(object, i));
                    continue;
                }
                if (string3.indexOf("String") == -1) continue;
                stringBuffer.append(((String[])object)[i]);
            }
        } else if (string3.indexOf("Byte") != -1) {
            stringBuffer.append(((Byte)object).toString());
        } else if (string3.indexOf("Short") != -1) {
            stringBuffer.append(((Short)object).toString());
        } else if (string3.indexOf("Integer") != -1) {
            stringBuffer.append(((Integer)object).toString());
        } else if (string3.indexOf("Long") != -1) {
            if (n == 0) {
                stringBuffer.append(((Long)object).toString());
            } else {
                stringBuffer.append(CDFTT2000.encode((Long)object) + string2);
            }
        } else if (string3.indexOf("Float") != -1) {
            stringBuffer.append(((Float)object).toString());
        } else if (string3.indexOf("Double") != -1) {
            if (n == 1) {
                String string5 = Epoch.encode((Double)object);
                stringBuffer.append(string5);
            } else {
                stringBuffer.append(((Double)object).toString());
            }
        } else if (string3.indexOf("Character") != -1) {
            stringBuffer.append(((Character)object).toString());
        } else if (string3.indexOf("String") != -1) {
            stringBuffer.append((String)object);
        }
        return stringBuffer.toString();
    }

    public static String getStringFloatingData(Object object, String string, String string2) {
        String string3 = CDFUtils.getSignature(object);
        StringBuffer stringBuffer = new StringBuffer();
        if (string3.charAt(0) == '[') {
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuffer.append(string2);
                }
                if (string3.charAt(1) == 'B') {
                    stringBuffer.append(Array.getByte(object, i));
                    continue;
                }
                if (string3.charAt(1) == 'S') {
                    stringBuffer.append(Array.getShort(object, i));
                    continue;
                }
                if (string3.charAt(1) == 'I') {
                    stringBuffer.append(Array.getInt(object, i));
                    continue;
                }
                if (string3.charAt(1) == 'J') {
                    stringBuffer.append(Array.getLong(object, i));
                    continue;
                }
                if (string3.charAt(1) == 'F') {
                    float f = Array.getFloat(object, i);
                    if (string == null || CDFUtils.isFloatingPadValue(f) == 1) {
                        stringBuffer.append(f);
                        continue;
                    }
                    string = CDFUtils.CFtoJformat(string);
                    stringBuffer.append(String.format(string, Float.valueOf(f)));
                    continue;
                }
                if (string3.charAt(1) != 'D') continue;
                double d = Array.getDouble(object, i);
                if (string == null || CDFUtils.isFloatingPadValue(d) == 1) {
                    stringBuffer.append(d);
                    continue;
                }
                string = CDFUtils.CFtoJformat(string);
                stringBuffer.append(String.format(string, d));
            }
        } else if (string3.indexOf("Byte") != -1) {
            stringBuffer.append(((Byte)object).toString());
        } else if (string3.indexOf("Short") != -1) {
            stringBuffer.append(((Short)object).toString());
        } else if (string3.indexOf("Integer") != -1) {
            stringBuffer.append(((Integer)object).toString());
        } else if (string3.indexOf("Long") != -1) {
            stringBuffer.append(((Long)object).toString());
        } else if (string3.indexOf("Float") != -1) {
            float f = ((Float)object).floatValue();
            if (string == null || CDFUtils.isFloatingPadValue(f) == 1) {
                stringBuffer.append(f);
            } else {
                string = CDFUtils.CFtoJformat(string);
                stringBuffer.append(String.format(string, Float.valueOf(f)));
            }
        } else if (string3.indexOf("Double") != -1) {
            double d = (Double)object;
            if (string == null || CDFUtils.isFloatingPadValue(d) == 1) {
                stringBuffer.append(d);
            } else {
                string = CDFUtils.CFtoJformat(string);
                stringBuffer.append(String.format(string, d));
            }
        }
        return stringBuffer.toString();
    }

    public static String getStringDataType(Variable variable) {
        return CDFUtils.getStringDataType(variable.getDataType());
    }

    public static String getStringDataType(Entry entry) {
        return CDFUtils.getStringDataType(entry.getDataType());
    }

    public static boolean isStringDataType(long l) {
        return l == 51L || l == 52L;
    }

    public static boolean isEpochDataType(long l) {
        return l == 31L || l == 32L || l == 33L;
    }

    public static String getStringDataType(long l) {
        String string = l == 41L ? "CDF_BYTE" : (l == 51L ? "CDF_CHAR" : (l == 52L ? "CDF_UCHAR" : (l == 1L ? "CDF_INT1" : (l == 11L ? "CDF_UINT1" : (l == 2L ? "CDF_INT2" : (l == 12L ? "CDF_UINT2" : (l == 4L ? "CDF_INT4" : (l == 14L ? "CDF_UINT4" : (l == 8L ? "CDF_INT8" : (l == 21L ? "CDF_REAL4" : (l == 44L ? "CDF_FLOAT" : (l == 22L ? "CDF_REAL8" : (l == 45L ? "CDF_DOUBLE" : (l == 31L ? "CDF_EPOCH" : (l == 32L ? "CDF_EPOCH16" : (l == 33L ? "CDF_TIME_TT2000" : "UNKNOWN"))))))))))))))));
        return string;
    }

    public static long getDataTypeValue(String string) {
        long l = string.equals("CDF_BYTE") ? 41L : (string.equals("CDF_CHAR") ? 51L : (string.equals("CDF_UCHAR") ? 52L : (string.equals("CDF_INT1") ? 1L : (string.equals("CDF_UINT1") ? 11L : (string.equals("CDF_INT2") ? 2L : (string.equals("CDF_UINT2") ? 12L : (string.equals("CDF_INT4") ? 4L : (string.equals("CDF_UINT4") ? 14L : (string.equals("CDF_INT8") ? 8L : (string.equals("CDF_REAL4") ? 21L : (string.equals("CDF_FLOAT") ? 44L : (string.equals("CDF_REAL8") ? 22L : (string.equals("CDF_DOUBLE") ? 45L : (string.equals("CDF_EPOCH") ? 31L : (string.equals("CDF_EPOCH16") ? 32L : (string.equals("CDF_TIME_TT2000") ? 33L : -1L))))))))))))))));
        return l;
    }

    public static String getStringCompressionType(long l) {
        String[] stringArray = new String[]{"NONE", "RLE", "HUFF", "AHUFF", " ", "GZIP"};
        if (l > 5L || l == 4L) {
            return "UNKNOWN";
        }
        return stringArray[(int)l];
    }

    public static long getLongCompressionType(String string) {
        String[] stringArray = new String[]{"NONE", "RLE", "HUFF", "Ahuff", " ", "GZIP"};
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            return i;
        }
        if (string.equalsIgnoreCase("NONE")) {
            return 0L;
        }
        return -1L;
    }

    public static String getStringCompressionType(Variable variable) {
        return CDFUtils.getStringCompressionType(variable.getCompressionType());
    }

    public static String getStringCompressionType(CDF cDF) {
        return CDFUtils.getStringCompressionType(cDF.getCompressionType());
    }

    public static String getStringEncoding(long l) {
        String[] stringArray = new String[]{" ", "NETWORK", "SUN", "VAX", "DECSTATION", "SGi", "IBMPC", "IBMRS", "HOST", "PPC", " ", "HP", "NeXT", "ALPHAOSF1", "ALPHAVMSd", "ALPHAVMSg", "ALPHAVMSi", "ARM_LITTLE", "ARM_BIG", "IA64VMSi", "IA64VMSd", "IA64VMSg"};
        if (l == 0L || l == 10L || l > 21L) {
            return "UNKNOWN";
        }
        return stringArray[(int)l];
    }

    public static long getLongEncoding(String string) {
        String[] stringArray = new String[]{" ", "NETWORK", "SUN", "VAX", "DECSTATION", "SGi", "IBMPC", "IBMRS", "HOST", "PPC", " ", "HP", "NeXT", "ALPHAOSF1", "ALPHAVMSd", "ALPHAVMSg", "ALPHAVMSi", "ARM_LITTLE", "ARM_BIG", "IA64VMSi", "IA64VMSd", "IA64VMSg"};
        if ("".equals(string) || string.equals(" ")) {
            return -1L;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (i == 0 || i == 10 || !string.equalsIgnoreCase(stringArray[i])) continue;
            return i;
        }
        return -1L;
    }

    public static String getStringEncoding(CDF cDF) {
        return CDFUtils.getStringEncoding(cDF.getEncoding());
    }

    public static String getStringDecoding(long l) throws CDFException {
        return CDFUtils.getStringEncoding(l);
    }

    public static String getStringDecoding(CDF cDF) throws CDFException {
        return CDFUtils.getStringEncoding(cDF.confirmDecoding());
    }

    public static String getStringMajority(long l) {
        String string = null;
        string = l == 1L ? "ROW" : (l == 2L ? "COLUMN" : "UNKNOWN");
        return string;
    }

    public static long getLongMajority(String string) {
        long l = string.equalsIgnoreCase("ROW") ? 1L : (string.equalsIgnoreCase("COLUMN") ? 2L : -1L);
        return l;
    }

    public static String getStringMajority(CDF cDF) {
        return CDFUtils.getStringMajority(cDF.getMajority());
    }

    public static String getStringFormat(long l) {
        String string = null;
        string = l == 1L ? "SINGLE" : (l == 2L ? "MULTI" : "UNKNOWN");
        return string;
    }

    public static long getLongFormat(String string) {
        long l = string.equalsIgnoreCase("SINGLE") ? 1L : (string.equalsIgnoreCase("MULTI") ? 2L : -1L);
        return l;
    }

    public static String getStringFormat(CDF cDF) {
        return CDFUtils.getStringFormat(cDF.getFormat());
    }

    public static String getStringSparseRecord(long l) {
        String string = null;
        string = l == 0L ? "None" : (l == 1L ? "PAD" : (l == 2L ? "PREV" : "UNKNOWN"));
        return string;
    }

    public static long getLongChecksum(String string) {
        long l = string.equalsIgnoreCase("None") ? 0L : (string.equalsIgnoreCase("md5") ? 1L : (string.equalsIgnoreCase("other") ? 2L : 0L));
        return l;
    }

    public static long getLeapSecondLastUpdated(CDF cDF) throws CDFException {
        return cDF.getLeapSecondLastUpdated();
    }

    public static String getStringChecksum(CDF cDF) {
        return CDFUtils.getStringChecksum(cDF.getChecksum());
    }

    public static String getStringChecksum(long l) {
        String string = null;
        string = l == 0L ? "NONE" : (l == 1L ? "MD5" : "OTHER");
        return string;
    }

    public static long getLongSparseRecord(String string) {
        long l = string.equalsIgnoreCase("None") ? 0L : (string.equalsIgnoreCase("sRecords.PAD") || string.equalsIgnoreCase("PAD") ? 1L : (string.equalsIgnoreCase("sRecords.PREV") || string.equalsIgnoreCase("PREV") ? 2L : -1L));
        return l;
    }

    public static String getStringSparseRecord(Variable variable) {
        return CDFUtils.getStringSparseRecord(variable.getSparseRecords());
    }

    public static boolean cdfFileExists(String string) {
        if (string == null) {
            return false;
        }
        String string2 = null;
        String string3 = null;
        if (string.indexOf(".cdf") == -1 && string.indexOf(".CDF") == -1) {
            string2 = new StringBuffer(string).append(".cdf").toString();
            string3 = new StringBuffer(string).append(".CDF").toString();
        } else {
            string2 = string;
        }
        File file = new File(string2);
        if (file.exists()) {
            return true;
        }
        return string3 != null && (file = new File(string3)).exists();
    }

    public static String CFtoJformat(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.indexOf("%") != -1 ? CDFUtils.CtoJformat(string) : CDFUtils.FtoJformat(string);
        return string2;
    }

    public static String FtoJformat(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = string.substring(0, 1).toLowerCase();
        if (string2.equals("i")) {
            String string3 = string.substring(1);
            if (string3.length() == 0) {
                stringBuffer.append("%d");
            } else {
                int n = string3.indexOf(".");
                if (n == -1) {
                    stringBuffer.append("%").append(string3).append("d");
                } else {
                    String string4 = string3.substring(0, n);
                    String string5 = string3.substring(n + 1);
                    stringBuffer.append("%").append(string4).append("d");
                }
            }
        } else if (string2.equals("f")) {
            String string6 = string.substring(1);
            if (string6.length() == 0) {
                stringBuffer.append("%f");
            } else {
                int n = string6.indexOf(".");
                if (n == -1) {
                    return null;
                }
                String string7 = string6.substring(0, n);
                String string8 = string6.substring(n + 1);
                stringBuffer.append("%").append(string7).append(".").append(string8).append("f");
            }
        } else if (string2.equals("e") || string2.equals("d")) {
            String string9 = string.substring(1);
            if (string9.length() == 0) {
                stringBuffer.append("%d");
            } else {
                int n = string9.indexOf(".");
                if (n == -1) {
                    return null;
                }
                String string10 = string9.substring(0, n);
                String string11 = string9.substring(n + 1);
                stringBuffer.append("%").append(string10).append(".").append(string11).append("e");
            }
        } else if (string2.equals("f")) {
            String string12 = string.substring(1);
            if (string12.length() == 0) {
                stringBuffer.append("%d");
            } else {
                int n = string12.indexOf(".");
                if (n == -1) {
                    return null;
                }
                String string13 = string12.substring(0, n);
                String string14 = string12.substring(n + 1);
                stringBuffer.append("%").append(string13).append(".").append(string14).append("f");
            }
        } else if (string2.equals("g")) {
            String string15 = string.substring(1);
            if (string15.length() == 0) {
                stringBuffer.append("%d");
            } else {
                int n = string15.indexOf(".");
                if (n == -1) {
                    return null;
                }
                String string16 = string15.substring(0, n);
                String string17 = string15.substring(n + 1);
                stringBuffer.append("%").append(string16).append(".").append(string17).append("g");
            }
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public static String CtoJformat(String string) {
        int n;
        if (string == null) {
            return null;
        }
        if (string.startsWith("%")) {
            string = string.substring(1);
        }
        int n2 = string.length();
        int n3 = string.indexOf(".");
        int n4 = 0;
        int n5 = 0;
        for (n = 0; n < n2 && Character.isDigit(string.charAt(n)); ++n) {
            n5 = 10 * n5 + Character.getNumericValue(string.charAt(n));
        }
        if (n3 != -1) {
            n4 = 0;
            for (n = n3 + 1; n < n2 && Character.isDigit(string.charAt(n)); ++n) {
                n4 = 10 * n4 + Character.getNumericValue(string.charAt(n));
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = string.substring(n2 - 1).toLowerCase();
        if (string2.equals("i") || string2.equals("d") || string2.equals("u") || string2.equals("h") || string2.equals("l")) {
            if (n5 == 0) {
                stringBuffer.append("%d");
            } else {
                stringBuffer.append("%").append(n5).append("d");
            }
        } else if (string2.equals("f")) {
            if (n5 == 0) {
                stringBuffer.append("%f");
            } else if (n4 == 0) {
                stringBuffer.append("%").append(n5).append("f");
            } else {
                stringBuffer.append("%").append(n5).append(".").append(n4).append("f");
            }
        } else if (string2.equals("e")) {
            if (n5 == 0) {
                stringBuffer.append("%e");
            } else if (n4 == 0) {
                stringBuffer.append("%").append(n5).append("e");
            } else {
                stringBuffer.append("%").append(n5).append(".").append(n4).append("e");
            }
        } else if (string2.equals("g")) {
            if (n5 == 0) {
                stringBuffer.append("%g");
            } else if (n4 == 0) {
                stringBuffer.append("%").append(n5).append("g");
            } else {
                stringBuffer.append("%").append(n5).append(".").append(n4).append("g");
            }
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public static int isFloatingPadValue(long l, Object object) {
        if (l == 21L || l == 44L) {
            if (((Float)object).floatValue() <= -1.0E30f || ((Float)object).floatValue() >= 1.0E30f) {
                return 1;
            }
            return 0;
        }
        if (l == 22L || l == 45L) {
            if ((Double)object <= -1.0E30 || (Double)object >= 1.0E30) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public static int isFloatingPadValue(Object object) {
        String string = CDFUtils.getSignature(object);
        if (string.charAt(0) == '[') {
            if (string.charAt(1) == 'F') {
                return CDFUtils.isFloatingPadValue(Array.getFloat(object, 0));
            }
            if (string.charAt(1) == 'D') {
                return CDFUtils.isFloatingPadValue(Array.getDouble(object, 0));
            }
            return 0;
        }
        if (object instanceof Float) {
            if (((Float)object).floatValue() <= -1.0E30f || ((Float)object).floatValue() >= 1.0E30f) {
                return 1;
            }
            return 0;
        }
        if (object instanceof Double) {
            if ((Double)object <= -1.0E30 || (Double)object >= 1.0E30) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public static int isFloatingPadValue(long l, float f) {
        if (l == 21L || l == 44L) {
            if (f <= -1.0E30f || f >= 1.0E30f) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public static int isFloatingPadValue(long l, double d) {
        if (l == 22L || l == 45L) {
            if (d <= -1.0E30 || d >= 1.0E30) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public static int isFloatingPadValue(float f) {
        if (f <= -1.0E30f || f >= 1.0E30f) {
            return 1;
        }
        return 0;
    }

    public static int isFloatingPadValue(double d) {
        if (d <= -1.0E30 || d >= 1.0E30) {
            return 1;
        }
        return 0;
    }

    public static int getNumDimensions(Object object) {
        String string = CDFUtils.getSignature(object);
        int n = 0;
        for (int i = 0; i < string.length() && string.charAt(i) == '['; ++i) {
            ++n;
        }
        return n;
    }

    public static long[] getDimensionSizes(Object object) {
        long[] lArray;
        block2: {
            int n = 0;
            n = CDFUtils.getNumDimensions(object);
            if (n == 0) {
                return null;
            }
            lArray = new long[n];
            int n2 = 0;
            Object object2 = object;
            while (object2 instanceof Object[]) {
                lArray[n2] = ((Object[])object2).length;
                object2 = ((Object[])object2)[0];
                ++n2;
            }
            if (!object2.getClass().isArray()) break block2;
            lArray[n2] = Array.getLength(object2);
        }
        return lArray;
    }

    public static byte[] UTF8toUTF16LE(Object object) {
        String string = CDFUtils.getSignature(object);
        try {
            if (string.charAt(0) == '[') {
                return new String((byte[])object, "UTF-8").getBytes("UTF-16LE");
            }
            return ((String)object).getBytes("UTF-16LE");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static byte[] UTF16LEtoUTF8(Object object) {
        String string = CDFUtils.getSignature(object);
        try {
            if (string.charAt(0) == '[') {
                return new String((byte[])object, "UTF-16LE").getBytes("UTF-8");
            }
            return ((String)object).getBytes("UTF-8");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static byte[] UTF8toCp1252(Object object) {
        String string = CDFUtils.getSignature(object);
        try {
            if (string.charAt(0) == '[') {
                return new String((byte[])object, "UTF-8").getBytes("Windows-1252");
            }
            return ((String)object).getBytes("Windows-1252");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static byte[] Cp1252toUTF8(Object object) {
        String string = CDFUtils.getSignature(object);
        try {
            if (string.charAt(0) == '[') {
                return new String((byte[])object, "Windows-1252").getBytes("UTF-8");
            }
            return ((String)object).getBytes("UTF-8");
        }
        catch (Exception exception) {
            return null;
        }
    }
}

