/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.Variable;
import gsfc.nssdc.cdf.util.CDFTT2000;
import gsfc.nssdc.cdf.util.CDFUtils;
import gsfc.nssdc.cdf.util.Epoch;
import gsfc.nssdc.cdf.util.Epoch16;
import java.awt.Component;
import java.io.File;
import java.lang.reflect.Array;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;

public class CDFToolUtils
implements CDFConstants {
    public static Object parseContents(String string, long l) throws NumberFormatException {
        string = string.trim();
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.countTokens() == -1) {
            return null;
        }
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        int n = vector.size();
        if (l == 51L || l == 52L) {
            String string2 = string;
            return string2;
        }
        if (l == 41L || l == 1L) {
            if (n == 1) {
                byte[] byArray = new byte[]{Byte.parseByte(string)};
                return byArray;
            }
            byte[] byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray[i] = Byte.parseByte(((String)vector.elementAt(i)).trim());
            }
            return byArray;
        }
        if (l == 11L || l == 2L) {
            if (n == 1) {
                short[] sArray = new short[]{Short.parseShort(string)};
                if (l == 11L && (sArray[0] < 0 || sArray[0] > 255)) {
                    sArray = null;
                    throw new NumberFormatException(string);
                }
                return sArray;
            }
            short[] sArray = new short[n];
            for (int i = 0; i < n; ++i) {
                sArray[i] = Short.parseShort(((String)vector.elementAt(i)).trim());
                if (l != 11L || sArray[i] >= 0 && sArray[i] <= 255) continue;
                sArray = null;
                throw new NumberFormatException(((String)vector.elementAt(i)).trim());
            }
            return sArray;
        }
        if (l == 12L || l == 4L) {
            if (n == 1) {
                int[] nArray = new int[]{Integer.parseInt(string)};
                if (l == 12L && (nArray[0] < 0 || nArray[0] > 65535)) {
                    nArray = null;
                    throw new NumberFormatException(string);
                }
                return nArray;
            }
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = Integer.parseInt(((String)vector.elementAt(i)).trim());
                if (l != 12L || nArray[i] >= 0 && nArray[i] <= 65535) continue;
                nArray = null;
                throw new NumberFormatException(((String)vector.elementAt(i)).trim());
            }
            return nArray;
        }
        if (l == 14L || l == 8L) {
            if (n == 1) {
                long[] lArray = new long[]{Long.parseLong(string)};
                if (l == 14L && (lArray[0] < 0L || lArray[0] > 0xFFFFFFF5L)) {
                    lArray = null;
                    throw new NumberFormatException(string);
                }
                return lArray;
            }
            long[] lArray = new long[n];
            for (int i = 0; i < n; ++i) {
                lArray[i] = Long.parseLong(((String)vector.elementAt(i)).trim());
                if (l != 14L || lArray[i] >= 0L && lArray[i] <= 0xFFFFFFF5L) continue;
                lArray = null;
                throw new NumberFormatException(((String)vector.elementAt(i)).trim());
            }
            return lArray;
        }
        if (l == 44L || l == 21L) {
            if (n == 1) {
                float[] fArray = new float[]{Float.valueOf(string).floatValue()};
                return fArray;
            }
            float[] fArray = new float[n];
            for (int i = 0; i < n; ++i) {
                fArray[i] = Float.valueOf(((String)vector.elementAt(i)).trim()).floatValue();
            }
            return fArray;
        }
        if (l == 22L || l == 45L) {
            if (n == 1) {
                double[] dArray = new double[]{Double.valueOf(string)};
                return dArray;
            }
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = Double.valueOf(((String)vector.elementAt(i)).trim());
            }
            return dArray;
        }
        if (l == 31L) {
            try {
                if (n == 1) {
                    double[] dArray = new double[]{string.indexOf(":") == -1 ? Double.valueOf(string) : Epoch.parse(string)};
                    return dArray;
                }
                double[] dArray = new double[n];
                for (int i = 0; i < n; ++i) {
                    String string3 = ((String)vector.elementAt(i)).trim();
                    dArray[i] = string3.indexOf(":") == -1 ? Double.valueOf(string3) : Epoch.parse(string3);
                }
                return dArray;
            }
            catch (CDFException cDFException) {
                System.err.println("error parsing Epoch ");
                return null;
            }
        }
        if (l == 32L) {
            try {
                if (n == 1) {
                    double[] dArray = new double[2];
                    if (string.indexOf(":") == -1) {
                        dArray[0] = Double.valueOf(string);
                        dArray[1] = 0.0;
                    } else {
                        dArray = (double[])Epoch16.parse(string);
                    }
                    return dArray;
                }
                double[][] dArray = new double[n][2];
                double[] dArray2 = new double[2];
                for (int i = 0; i < n; ++i) {
                    String string4 = ((String)vector.elementAt(i)).trim();
                    if (string4.indexOf(":") == -1) {
                        dArray[i][0] = Double.valueOf(string4);
                        dArray[i][1] = 0.0;
                        continue;
                    }
                    dArray2 = (double[])Epoch16.parse(string4);
                    dArray[i][0] = dArray2[0];
                    dArray[i][1] = dArray2[1];
                }
                return dArray;
            }
            catch (CDFException cDFException) {
                System.err.println("error parsing Epoch ");
                return null;
            }
        }
        if (l == 33L) {
            try {
                if (n == 1) {
                    long[] lArray = new long[]{CDFTT2000.fromUTCstring(string)};
                    return lArray;
                }
                long[] lArray = new long[n];
                for (int i = 0; i < n; ++i) {
                    String string5 = ((String)vector.elementAt(i)).trim();
                    lArray[i] = CDFTT2000.fromUTCstring(string5);
                }
                return lArray;
            }
            catch (CDFException cDFException) {
                System.err.println("error parsing TT2000 string ");
                return null;
            }
        }
        return null;
    }

    public static Object parseContent(String string, long l, long l2) throws CDFException, NumberFormatException {
        string = string.trim();
        if (l == 51L || l == 52L) {
            String string2 = string.substring(0, 1).equals("\"") ? (string.substring(string.length() - 1).equals("\"") ? new StringBuffer(string).substring(1, string.length() - 1) : string) : string;
            if ((long)string2.length() > l2) {
                throw new CDFException(-2011L);
            }
            return string2;
        }
        return CDFToolUtils.parseContent(string, l);
    }

    public static Object parseContent(String string, long l) throws NumberFormatException {
        string = string.trim();
        if (l == 51L || l == 52L) {
            String string2 = string.substring(0, 1).equals("\"") ? (string.substring(string.length() - 1).equals("\"") ? new StringBuffer(string).substring(1, string.length() - 1) : string) : string;
            return string2;
        }
        if (l == 41L || l == 1L) {
            Byte by = new Byte(string);
            return by;
        }
        if (l == 11L || l == 2L) {
            Short s = new Short(string);
            if (l == 11L && (s < 0 || s > 255)) {
                s = null;
                throw new NumberFormatException(string);
            }
            return s;
        }
        if (l == 12L || l == 4L) {
            Integer n = new Integer(string);
            if (l == 12L && (n.shortValue() < 0 || n > 65535)) {
                n = null;
                throw new NumberFormatException(string);
            }
            return n;
        }
        if (l == 14L || l == 8L) {
            Long l2 = new Long(string);
            if (l == 14L && (l2.shortValue() < 0 || l2 > 0xFFFFFFF5L)) {
                l2 = null;
                throw new NumberFormatException(string);
            }
            return l2;
        }
        if (l == 44L || l == 21L) {
            Float f = new Float(string);
            return f;
        }
        if (l == 22L || l == 45L) {
            Double d = new Double(string);
            return d;
        }
        if (l == 31L) {
            try {
                Double d = new Double(Epoch.parse(string));
                return d;
            }
            catch (CDFException cDFException) {
                System.err.println("error parsing epoch ");
                return null;
            }
        }
        if (l == 32L) {
            try {
                double[] dArray = (double[])Epoch16.parse(string);
                return dArray;
            }
            catch (CDFException cDFException) {
                System.err.println("error parsing epoch16 ");
                return null;
            }
        }
        if (l == 33L) {
            try {
                Long l3 = new Long(CDFTT2000.fromUTCstring(string));
                return l3;
            }
            catch (CDFException cDFException) {
                System.err.println("error parsing TT2000 ");
                return null;
            }
        }
        return null;
    }

    public static String breakdownData(Object object) {
        return CDFToolUtils.breakdownData(object, 0);
    }

    public static String breakdownData(Object object, int n) {
        String string = CDFUtils.getSignature(object);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        if (n == 2) {
            n2 = 2;
        }
        if (string.charAt(0) == '[') {
            int n3 = Array.getLength(object);
            for (int i = 0; i < n3; i += n2) {
                if (i > 0) {
                    stringBuffer.append(",");
                }
                if (string.charAt(1) == 'B') {
                    stringBuffer.append(Array.getByte(object, i));
                    continue;
                }
                if (string.charAt(1) == 'S') {
                    stringBuffer.append(Array.getShort(object, i));
                    continue;
                }
                if (string.charAt(1) == 'I') {
                    stringBuffer.append(Array.getInt(object, i));
                    continue;
                }
                if (string.charAt(1) == 'J') {
                    if (n == 0) {
                        stringBuffer.append(Array.getLong(object, i));
                        continue;
                    }
                    stringBuffer.append(CDFTT2000.toUTCstring(Array.getLong(object, i)));
                    continue;
                }
                if (string.charAt(1) == 'F') {
                    stringBuffer.append(Array.getFloat(object, i));
                    continue;
                }
                if (string.charAt(1) != 'D') continue;
                if (n == 1) {
                    stringBuffer.append(Epoch.encode4(Array.getDouble(object, i)));
                    continue;
                }
                if (n == 2) {
                    double[] dArray = new double[]{Array.getDouble(object, 2 * i), Array.getDouble(object, 2 * i + 1)};
                    stringBuffer.append(Epoch16.encode4(dArray));
                    continue;
                }
                stringBuffer.append(Array.getDouble(object, i));
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
        } else if (n == 1) {
            stringBuffer.append(Epoch.encode4((Double)object));
        } else if (n == 2) {
            stringBuffer.append(Epoch16.encode4((double[])object));
        } else if (n == 3) {
            stringBuffer.append(CDFTT2000.toUTCstring((long)((Long)object)));
        } else {
            stringBuffer.append(object);
        }
        return stringBuffer.toString();
    }

    public static Object retrieveData(Object object, int n) {
        return CDFToolUtils.retrieveData(object, n, 0);
    }

    public static Object retrieveData(Object object, int n, int n2) {
        String string = CDFUtils.getSignature(object);
        if (string.charAt(0) == '[') {
            if (string.charAt(1) == 'B') {
                return new Byte(Array.getByte(object, n));
            }
            if (string.charAt(1) == 'Z') {
                return new Boolean(Array.getBoolean(object, n));
            }
            if (string.charAt(1) == 'C') {
                return new Character(Array.getChar(object, n));
            }
            if (string.charAt(1) == 'S') {
                return new Short(Array.getShort(object, n));
            }
            if (string.charAt(1) == 'I') {
                return new Integer(Array.getInt(object, n));
            }
            if (string.charAt(1) == 'J') {
                return new Long(Array.getLong(object, n));
            }
            if (string.charAt(1) == 'F') {
                return new Float(Array.getFloat(object, n));
            }
            if (string.charAt(1) == 'D') {
                if (n2 == 2) {
                    double[] dArray = new double[]{Array.getDouble(object, 2 * n), Array.getDouble(object, 2 * n + 1)};
                    return dArray;
                }
                return new Double(Array.getDouble(object, n));
            }
            if (string.indexOf("String") != -1) {
                return new String(((String[])object)[n]);
            }
            return null;
        }
        return null;
    }

    public static String getCFormat(Variable variable) {
        String string = null;
        try {
            string = variable.getEntryData("FORMAT").toString();
        }
        catch (CDFException cDFException) {
            string = null;
        }
        if (string != null) {
            if ((string = string.trim()).equals("")) {
                string = null;
            } else if (!string.startsWith("%")) {
                string = CDFToolUtils.FtoCformat(string);
            }
        }
        return string;
    }

    public static String FtoCformat(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        switch (string.charAt(0)) {
            case 'I': 
            case 'i': {
                int n = string.indexOf(46);
                if (n == -1) {
                    String string2 = string.substring(1);
                    if (string2.length() == 0) {
                        stringBuffer.append("%").append("d");
                        break;
                    }
                    stringBuffer.append("%").append(Integer.valueOf(string2)).append("d");
                    break;
                }
                String string3 = string.substring(1, n);
                String string4 = null;
                if (n + 1 < string.length()) {
                    string4 = string.substring(n + 1);
                }
                if (string4 == null || string3.length() == 0) {
                    if (string3.length() == 0) {
                        stringBuffer.append("%").append(Integer.valueOf(string4)).append("d");
                    }
                    if (string4 != null) break;
                    stringBuffer.append("%").append(Integer.valueOf(string3)).append("d");
                    break;
                }
                stringBuffer.append("%").append(Integer.valueOf(string3)).append(".").append(Integer.valueOf(string4)).append("d");
                break;
            }
            case 'O': 
            case 'o': {
                int n = string.indexOf(46);
                if (n == -1) {
                    String string5 = string.substring(1);
                    if (string5.length() == 0) {
                        stringBuffer.append("%").append("o");
                        break;
                    }
                    stringBuffer.append("%").append(Integer.valueOf(string5)).append("o");
                    break;
                }
                String string6 = string.substring(1, n);
                String string7 = null;
                if (n + 1 < string.length()) {
                    string7 = string.substring(n + 1);
                }
                if (string7 == null || string6.length() == 0) {
                    if (string6.length() == 0) {
                        stringBuffer.append("%").append(Integer.valueOf(string7)).append("o");
                    }
                    if (string7 != null) break;
                    stringBuffer.append("%").append(Integer.valueOf(string6)).append("o");
                    break;
                }
                stringBuffer.append("%").append(Integer.valueOf(string6)).append(".").append(Integer.valueOf(string7)).append("o");
                break;
            }
            case 'Z': 
            case 'z': {
                int n = string.indexOf(46);
                if (n == -1) {
                    String string8 = string.substring(1);
                    if (string8.length() == 0) {
                        stringBuffer.append("%").append("X");
                        break;
                    }
                    stringBuffer.append("%").append(Integer.valueOf(string8)).append("X");
                    break;
                }
                String string9 = string.substring(1, n);
                String string10 = null;
                if (n + 1 < string.length()) {
                    string10 = string.substring(n + 1);
                }
                if (string10 == null || string9.length() == 0) {
                    if (string9.length() == 0) {
                        stringBuffer.append("%").append(Integer.valueOf(string10)).append("X");
                    }
                    if (string10 != null) break;
                    stringBuffer.append("%").append(Integer.valueOf(string9)).append("X");
                    break;
                }
                stringBuffer.append("%").append(Integer.valueOf(string9)).append(".").append(Integer.valueOf(string10)).append("X");
                break;
            }
            case 'F': 
            case 'f': {
                int n = string.indexOf(46);
                if (n == -1) {
                    String string11 = string.substring(1);
                    if (string11.length() == 0) {
                        stringBuffer.append("%").append("f");
                        break;
                    }
                    stringBuffer.append("%").append(Integer.valueOf(string11)).append("f");
                    break;
                }
                String string12 = string.substring(1, n);
                String string13 = null;
                if (n + 1 < string.length()) {
                    string13 = string.substring(n + 1);
                }
                if (string13 == null || string12.length() == 0) {
                    if (string12.length() == 0) {
                        stringBuffer.append("%").append(Integer.valueOf(string13)).append("f");
                    }
                    if (string13 != null) break;
                    stringBuffer.append("%").append(Integer.valueOf(string12)).append("f");
                    break;
                }
                stringBuffer.append("%").append(Integer.valueOf(string12)).append(".").append(Integer.valueOf(string13)).append("f");
                break;
            }
            case 'D': 
            case 'E': 
            case 'd': 
            case 'e': {
                int n = string.indexOf(46);
                if (n == -1) {
                    String string14 = string.substring(1);
                    if (string14.length() == 0) {
                        stringBuffer.append("%").append("e");
                        break;
                    }
                    stringBuffer.append("%").append(Integer.valueOf(string14)).append("e");
                    break;
                }
                String string15 = string.substring(1, n);
                String string16 = null;
                if (n + 1 < string.length()) {
                    string16 = string.substring(n + 1);
                }
                if (string16 == null || string15.length() == 0) {
                    if (string15.length() == 0) {
                        stringBuffer.append("%").append(Integer.valueOf(string16)).append("e");
                    }
                    if (string16 != null) break;
                    stringBuffer.append("%").append(Integer.valueOf(string15)).append("e");
                    break;
                }
                stringBuffer.append("%").append(Integer.valueOf(string15)).append(".").append(Integer.valueOf(string16)).append("e");
                break;
            }
            case 'G': 
            case 'g': {
                int n = string.indexOf(46);
                if (n == -1) {
                    String string17 = string.substring(1);
                    if (string17.length() == 0) {
                        stringBuffer.append("%").append("g");
                        break;
                    }
                    stringBuffer.append("%").append(Integer.valueOf(string17)).append("g");
                    break;
                }
                String string18 = string.substring(1, n);
                String string19 = null;
                if (n + 1 < string.length()) {
                    string19 = string.substring(n + 1);
                }
                if (string19 == null || string18.length() == 0) {
                    if (string18.length() == 0) {
                        stringBuffer.append("%").append(Integer.valueOf(string19)).append("g");
                    }
                    if (string19 != null) break;
                    stringBuffer.append("%").append(Integer.valueOf(string18)).append("g");
                    break;
                }
                stringBuffer.append("%").append(Integer.valueOf(string18)).append(".").append(Integer.valueOf(string19)).append("g");
                break;
            }
            case 'A': 
            case 'a': {
                int n = string.indexOf(46);
                if (n == -1) {
                    String string20 = string.substring(1);
                    if (string20.length() == 0) {
                        stringBuffer.append("%").append("s");
                        break;
                    }
                    stringBuffer.append("%").append(Integer.valueOf(string20)).append("s");
                    break;
                }
                String string21 = string.substring(1, n);
                String string22 = null;
                if (n + 1 < string.length()) {
                    string22 = string.substring(n + 1);
                }
                if (string22 == null || string21.length() == 0) {
                    if (string21.length() == 0) {
                        stringBuffer.append("%").append(Integer.valueOf(string22)).append("s");
                    }
                    if (string22 != null) break;
                    stringBuffer.append("%").append(Integer.valueOf(string21)).append("s");
                    break;
                }
                stringBuffer.append("%").append(Integer.valueOf(string21)).append(".").append(Integer.valueOf(string22)).append("s");
                break;
            }
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public static int VariableWidth(int n, Variable variable, long l, String string) {
        int n2;
        if (l == 51L || l == 52L) {
            int n3 = (int)variable.getNumElements();
            return Math.max(10, n3 + 2) + 1;
        }
        if (l == 31L) {
            switch (n) {
                case 0: {
                    return 24;
                }
                case 1: {
                    return 16;
                }
                case 2: {
                    return 14;
                }
                case 3: {
                    return 24;
                }
                case 4: {
                    return 50;
                }
                case 5: {
                    return 68;
                }
                case 6: {
                    return 23;
                }
            }
        } else if (l == 32L) {
            switch (n) {
                case 0: {
                    return 36;
                }
                case 1: {
                    return 24;
                }
                case 2: {
                    return 14;
                }
                case 3: {
                    return 36;
                }
                case 4: {
                    return 50;
                }
                case 5: {
                    return 50;
                }
                case 6: {
                    return 32;
                }
            }
        } else if (l == 33L) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    return 29;
                }
            }
        }
        if (string != null && (n2 = CDFToolUtils.FormatWidth(string)) != 0) {
            return Math.max(10, n2) + 1;
        }
        switch ((int)l) {
            case 1: 
            case 41: {
                n2 = 5;
                break;
            }
            case 11: {
                n2 = 4;
                break;
            }
            case 2: {
                n2 = 7;
                break;
            }
            case 12: {
                n2 = 6;
                break;
            }
            case 4: {
                n2 = 12;
                break;
            }
            case 14: {
                n2 = 12;
                break;
            }
            case 8: {
                n2 = 20;
                break;
            }
            case 21: 
            case 44: {
                n2 = 15;
                break;
            }
            case 22: 
            case 45: {
                n2 = 18;
                break;
            }
            case 31: {
                n2 = 24;
                break;
            }
            case 32: {
                n2 = 36;
                break;
            }
            case 33: {
                n2 = 29;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return Math.max(10, n2) + 1;
    }

    public static int FormatWidth(String string) {
        char c;
        int n;
        int n2 = string.length();
        for (n = 0; n <= n2; ++n) {
            if (n == n2) {
                return 0;
            }
            c = string.charAt(n);
            if (c != '(' && c != ' ' && !Character.isDigit(c)) break;
        }
        while (n <= n2) {
            if (n == n2) {
                return 0;
            }
            c = string.charAt(n);
            if (c != '0' && Character.isDigit(c)) break;
            ++n;
        }
        int n3 = 0;
        for (int i = n; i < n2 && Character.isDigit(c = string.charAt(i)); ++i) {
            ++n3;
        }
        if (n3 == 0) {
            return 0;
        }
        return Integer.parseInt(string.substring(n, n + n3));
    }

    public static int StandardWidth(int n, long l, long l2) {
        switch ((int)l) {
            case 51: 
            case 52: {
                return (int)(1L + l2 + 1L);
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 21: 
            case 22: 
            case 41: 
            case 44: 
            case 45: {
                return CDFToolUtils.FormatWidth(CDFToolUtils.StandardFormat(n, l));
            }
            case 31: {
                switch (n) {
                    case 0: {
                        return 24;
                    }
                    case 1: {
                        return 16;
                    }
                    case 2: {
                        return 14;
                    }
                    case 3: {
                        return 24;
                    }
                    case 4: {
                        return 25;
                    }
                    case 5: {
                        return 13;
                    }
                    case 6: {
                        return 23;
                    }
                }
                break;
            }
            case 32: {
                switch (n) {
                    case 0: {
                        return 36;
                    }
                    case 1: {
                        return 24;
                    }
                    case 2: {
                        return 14;
                    }
                    case 3: {
                        return 36;
                    }
                    case 4: {
                        return 50;
                    }
                    case 5: {
                        return 68;
                    }
                    case 6: {
                        return 32;
                    }
                }
                break;
            }
            case 33: {
                switch (n) {
                    case 0: {
                        return 30;
                    }
                    case 1: {
                        return 19;
                    }
                    case 2: {
                        return 14;
                    }
                    case 3: {
                        return 29;
                    }
                }
                break;
            }
        }
        return 0;
    }

    public static String StandardFormat(int n, long l) {
        switch ((int)l) {
            case 51: 
            case 52: {
                return null;
            }
            case 1: 
            case 41: {
                return new String("%4d");
            }
            case 11: {
                return new String("%3u");
            }
            case 2: {
                return new String("%6d");
            }
            case 12: {
                return new String("%5u");
            }
            case 4: {
                return new String("%11ld");
            }
            case 8: {
                return new String("%20ld");
            }
            case 14: {
                return new String("%10ld");
            }
            case 21: 
            case 44: {
                return new String("%16.9e");
            }
            case 22: 
            case 45: {
                return new String("%25.17e");
            }
            case 31: {
                switch (n) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 6: {
                        return null;
                    }
                    case 4: {
                        return new String("%25.17e");
                    }
                    case 5: {
                        return new String("*Unsupported*");
                    }
                }
                break;
            }
            case 32: {
                switch (n) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 6: {
                        return null;
                    }
                    case 4: {
                        return new String("%25.17e %25.17e");
                    }
                    case 5: {
                        return new String("*Unsupported*");
                    }
                }
                break;
            }
            case 33: {
                switch (n) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        return new String("%20ld");
                    }
                }
                break;
            }
        }
        return null;
    }

    public static StringBuffer CatToString(StringBuffer stringBuffer, String string, int n, int n2, String string2) {
        int n3 = string.length();
        int n4 = string2.length();
        if (n3 > n) {
            if (n4 >= n) {
                stringBuffer = CDFToolUtils.CatNcharacters(stringBuffer, n, '*');
            } else {
                stringBuffer = CDFToolUtils.strcatX(stringBuffer, string, stringBuffer.length() + (n - n4));
                stringBuffer = CDFToolUtils.strcatX(stringBuffer, string2, 0);
            }
        } else {
            switch (n2) {
                case 1: {
                    stringBuffer = CDFToolUtils.strcatX(stringBuffer, string, 0);
                    stringBuffer = CDFToolUtils.CatNcharacters(stringBuffer, n - n3, ' ');
                    break;
                }
                case 2: {
                    int n5 = (n - n3) / 2;
                    int n6 = n - n3 - n5;
                    stringBuffer = CDFToolUtils.CatNcharacters(stringBuffer, n6, ' ');
                    stringBuffer = CDFToolUtils.strcatX(stringBuffer, string, 0);
                    stringBuffer = CDFToolUtils.CatNcharacters(stringBuffer, n5, ' ');
                    break;
                }
                case 3: {
                    stringBuffer = CDFToolUtils.CatNcharacters(stringBuffer, n - n3, ' ');
                    stringBuffer = CDFToolUtils.strcatX(stringBuffer, string, 0);
                }
            }
        }
        return stringBuffer;
    }

    public static StringBuffer CatNcharacters(StringBuffer stringBuffer, int n, char c) {
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(c);
        }
        return stringBuffer;
    }

    public static StringBuffer strcatX(StringBuffer stringBuffer, String string, int n) {
        if (n > 0) {
            int n2;
            int n3 = stringBuffer.length();
            if (n3 + (n2 = string.length()) <= n) {
                stringBuffer.append(string);
            } else {
                stringBuffer.append(string.substring(0, n - n3));
            }
        } else {
            stringBuffer.append(string);
        }
        return stringBuffer;
    }

    public static StringBuffer Justify(StringBuffer stringBuffer, int n) {
        int n2;
        int n3;
        if (n < 0) {
            int n4 = -n - stringBuffer.length();
            if (n4 > 0) {
                stringBuffer = CDFToolUtils.CatNcharacters(stringBuffer, n4, ' ');
            }
        } else if (n > 0 && (n3 = n - (n2 = stringBuffer.length())) > 0) {
            for (int i = 0; i < n3; ++i) {
                stringBuffer.insert(0, ' ');
            }
        }
        return stringBuffer;
    }

    public static String doFileChooser(String string, int n, SimpleFileFilter simpleFileFilter, String string2, Component component) {
        File file;
        MyCDFFileChooser myCDFFileChooser = new MyCDFFileChooser();
        ExampleFileView exampleFileView = new ExampleFileView();
        myCDFFileChooser.setCurrentDirectory(new File(string2));
        myCDFFileChooser.setDialogTitle(string);
        if (simpleFileFilter != null) {
            myCDFFileChooser.addChoosableFileFilter(simpleFileFilter);
            myCDFFileChooser.setFileFilter(simpleFileFilter);
        }
        try {
            exampleFileView.putIcon("cdf", new ImageIcon(((JFrame)component).getClass().getResource("CDF_Logo3.gif")));
            exampleFileView.putIcon("CDF", new ImageIcon(((JFrame)component).getClass().getResource("CDF_Logo3.gif")));
            myCDFFileChooser.setFileView(exampleFileView);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n2 = myCDFFileChooser.showDialog((JFrame)component, "OK");
        if (n2 == 0 && (file = myCDFFileChooser.getSelectedFile()) != null) {
            String string3 = file.getAbsolutePath();
            if (n == 1) {
                int n3 = string3.toLowerCase().lastIndexOf(".cdf");
                if (n3 != -1) {
                    string3 = string3.substring(0, n3);
                }
            } else {
                int n4 = string3.toLowerCase().lastIndexOf(".skt");
                if (n4 != -1) {
                    string3 = string3.substring(0, n4);
                }
            }
            return string3;
        }
        return null;
    }

    public static int getMaxRecNum(CDF cDF) {
        int n = (int)cDF.getNumVars();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            try {
                Variable variable = cDF.getVariable(i);
                int n3 = (int)variable.getMaxWrittenRecord();
                if (n2 >= n3) continue;
                n2 = n3;
                continue;
            }
            catch (CDFException cDFException) {
                System.err.println("Error: " + cDFException);
            }
        }
        return n2;
    }

    public static boolean equivalentDataTypes(long l, long l2) {
        switch ((int)l) {
            case 1: 
            case 11: 
            case 41: 
            case 51: 
            case 52: {
                switch ((int)l2) {
                    case 1: 
                    case 11: 
                    case 41: 
                    case 51: 
                    case 52: {
                        return true;
                    }
                }
                return false;
            }
            case 2: 
            case 12: {
                switch ((int)l2) {
                    case 2: 
                    case 12: {
                        return true;
                    }
                }
                return false;
            }
            case 4: 
            case 14: {
                switch ((int)l2) {
                    case 4: 
                    case 14: {
                        return true;
                    }
                }
                return false;
            }
            case 8: 
            case 33: {
                switch ((int)l2) {
                    case 8: 
                    case 33: {
                        return true;
                    }
                }
                return false;
            }
            case 21: 
            case 44: {
                switch ((int)l2) {
                    case 21: 
                    case 44: {
                        return true;
                    }
                }
                return false;
            }
            case 22: 
            case 31: 
            case 45: {
                switch ((int)l2) {
                    case 22: 
                    case 31: 
                    case 45: {
                        return true;
                    }
                }
                return false;
            }
            case 32: {
                switch ((int)l2) {
                    case 32: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    private static class MyCDFFileChooser
    extends JFileChooser {
        static final long serialVersionUID = 1L;

        private MyCDFFileChooser() {
        }

        @Override
        public String getDescription(File file) {
            if (file.getName().toLowerCase().endsWith(".cdf")) {
                return file.getName();
            }
            return super.getDescription(file);
        }

        @Override
        public String getTypeDescription(File file) {
            if (file.getName().toLowerCase().endsWith(".cdf")) {
                return super.getTypeDescription(new File("dummy"));
            }
            return super.getTypeDescription(file);
        }

        @Override
        public boolean isTraversable(File file) {
            if (file.getName().toLowerCase().endsWith(".cdf")) {
                return false;
            }
            return super.isTraversable(file);
        }
    }
}

