#!/usr/bin/perl -w

use strict;
use Math::BigInt;
use Data::Dumper;

BEGIN { unshift @INC,$ENV{"HOME"}.'/PerlCDF39_0/blib/arch',
                     $ENV{"HOME"}.'/PerlCDF39_0/blib/lib'; }
use CDF;

my $id;
my $status;
my %libinfo;
my %cdfinfo;
($status, %libinfo) = CDF::CDFgetLIBInfo ();
QuitCDF ("2.0", $status) if ($status < &CDF_OK) ;
print Dumper(\%libinfo);

print "cdf 1...\n";
($status, %cdfinfo) = CDF::CDFgetCDFInfo ($ARGV[0]);
QuitCDF ("4.0", $status) if ($status < &CDF_OK) ;

print Dumper(\%cdfinfo);

$status = CDF::CDFlib(&OPEN_, &CDF_, $ARGV[0], \$id, &NULL_);

print "cdf 2...\n";
($status, %cdfinfo) = CDF::CDFgetCDFInfo ($id);
QuitCDF ("6.0", $status) if ($status < &CDF_OK) ;

print Dumper(\%cdfinfo);


$status = CDF::CDFlib(&CLOSE_, &CDF_, &NULL_);
exit;

#############################################################################
# QuitCDF.
#############################################################################
sub QuitCDF {
	my ($where, $status)=@_;

  print "Aborting at $where ...\n";
  if ($status < &CDF_OK) {
    my $text;
    CDF::CDFlib (&SELECT_, &CDF_STATUS_, $status,
		   &GET_, &STATUS_TEXT_, \$text,
		   &NULL_);
    print $text;
  }
  print "...test aborted.\n";
  exit;
	
}#endsub QuitCDF

