Imports System
Imports System.Runtime.InteropServices
Imports CDF

Public Class Qst2cEpoch
	Inherits CDFAPIs

	Public Shared Sub Main()
		Dim year As Integer = 2001, month As Integer = 10, _
		    day As Integer = 1, hour As Integer = 12, _
		    minute As Integer = 10, second As Integer = 20, _
		    msec As Integer = 100
		Dim yearOut As Integer, monthOut As Integer, _
		    dayOut As Integer, hourOut As Integer, _
		    minuteOut As Integer, secondOut As Integer, _
		    msecOut As Integer
		Dim epoch As Double, epochSave As Double
		Dim encodeText As String

		'
		' Display title.
		'


		Console.WriteLine("Testing VB interface for CDF_EPOCH ...")
		Try
			epoch = computeEPOCH(year, month, day, hour, minute, second, _
				msec)

			epochSave = epoch

			encodeEPOCH(epoch, encodeText)
			Console.WriteLine("encodeEPOCH: " + encodeText)
			encodeEPOCHx(epoch, "<dom.02>-<month>-<year> <hour>:<min>:<sec>.<fos>", encodeText)
			Console.WriteLine("encodeEPOCHx: " + encodeText)
			encodeEPOCH1(epoch, encodeText)
			Console.WriteLine("1. encodeEPOCH1: " + encodeText)
			epoch = parseEPOCH1(encodeText)
			encodeEPOCH1(epoch, encodeText)
			Console.WriteLine("2. parseEPOCH1:  " + encodeText)

			epoch = epochSave
			encodeEPOCH2(epoch, encodeText)
			Console.WriteLine("3. encodeEPOCH2: " + encodeText)
			epoch = parseEPOCH2(encodeText)
			encodeEPOCH2(epoch, encodeText)
			Console.WriteLine("4. parseEPOCH2:  " + encodeText)

			epoch = epochSave
			encodeEPOCH3(epoch, encodeText)
			Console.WriteLine("5. encodeEPOCH3: " + encodeText)
			epoch = parseEPOCH3(encodeText)
			encodeEPOCH3(epoch, encodeText)
			Console.WriteLine("6. parseEPOCH3:  " + encodeText)

			epoch = epochSave
			encodeEPOCH4(epoch, encodeText)
			Console.WriteLine("7. encodeEPOCH4: " + encodeText)
			epoch = parseEPOCH4(encodeText)
			encodeEPOCH4(epoch, encodeText)
			Console.WriteLine("8. parseEPOCH4:  " + encodeText)

			epoch = epochSave

			EPOCHbreakdown(epoch, yearOut, monthOut, dayOut, hourOut, minuteOut, _
				secondOut, msecOut)
			If year <> yearOut Then
				Quit("9.2a")
			End If
			If month <> monthOut Then
				Quit("9.3a")
			End If
			If day <> dayOut Then
				Quit("9.4a")
			End If
			If hour <> hourOut Then
				Quit("9.5a")
			End If
			If minute <> minuteOut Then
				Quit("9.6a")
			End If
			If second <> secondOut Then
				Quit("9.7a")
			End If
			If msec <> msecOut Then
				Quit("9.8a")

			End If
		Catch ex As CDFException
			Console.WriteLine("Error: " + ex.toString())
		End Try
	End Sub


	'
	' Quit
	'


	Private Shared Sub Quit(where As String)
		Console.WriteLine("Aborting at " + where)
	End Sub

End Class

