using System;
using System.Runtime.InteropServices;
using CDF;

public class TestEpoch : CDFAPIs {

unsafe public static void Main(string[] argv) {


try {
   string epoch0 =  "01-Jan-2012 12:23:34.678";
   string epoch0b =  "01-Jan-2012 12:23:34.678Z";
   string epoch0c =  "01-Jan-2012 12:23:34Z";
   string epoch0d =  "01-Jan-2012 12:23:34";
   string epoch1 =  "20130203.5678901";
   string epoch2 =  "20120101122334";
   string epoch3 =  "2013-02-03T02:33:34.567Z";
   string epoch3b = "2013-02-03 02:33:34.567Z";
   string epoch3c =  "2013-02-03T02:33:34Z";
   string epoch3d =  "2013-02-03T02:33:34";
   string epoch4 =  "2013-02-03T02:33:34.567";
   string epoch4b = "2013-02-03 02:33:34.567";
   string epoch4c =  "2013-02-03T02:33:34.567";
   string epoch4d =  "2013-02-03T02:33:34";
   string epoch5 =  "2013-02-03/02:33:34.567";

   string epoch;
Console.WriteLine("epoch 0...");
   epoch = toEncodeEPOCH(toParseEPOCH(epoch0), 0);
   if (epoch!=epoch0)
     Console.WriteLine("0 differs: "+epoch+" <== "+epoch0);
   epoch = toEncodeEPOCH(toParseEPOCH(epoch0b), 0);
   if (epoch!=epoch0b)
     Console.WriteLine("0b differs: "+epoch+" <== "+epoch0b);
   epoch = toEncodeEPOCH(toParseEPOCH(epoch0c), 0);
   if (epoch!=epoch0c)
     Console.WriteLine("0c differs: "+epoch+" <== "+epoch0c);
   epoch = toEncodeEPOCH(toParseEPOCH(epoch0d), 0);
   if (epoch!=epoch0d)
     Console.WriteLine("0d differs: "+epoch+" <== "+epoch0d);
Console.WriteLine("1...");
   epoch = toEncodeEPOCH(toParseEPOCH(epoch1), 1);
   if (epoch!=epoch1)
     Console.WriteLine("1 differs: "+epoch+" <== "+epoch1);
Console.WriteLine("2...");
   epoch = toEncodeEPOCH(toParseEPOCH(epoch2), 2);
   if (epoch!=epoch2)
     Console.WriteLine("2 differs: "+epoch+" <== "+epoch2);
Console.WriteLine("3...");
   epoch = toEncodeEPOCH(toParseEPOCH(epoch3), 3);
   if (epoch!=epoch3)
     Console.WriteLine("3 differs: "+epoch+" <== "+epoch3);
Console.WriteLine("3b...");
   epoch = toEncodeEPOCH(toParseEPOCH(epoch3b), 3);
   if (epoch!=epoch3b)
     Console.WriteLine("3b differs: "+epoch+" <== "+epoch3b);
Console.WriteLine("3c...");
   epoch = toEncodeEPOCH(toParseEPOCH(epoch3c), 3);
   if (epoch!=epoch3c)
     Console.WriteLine("3c differs: "+epoch+" <== "+epoch3c);
Console.WriteLine("3d...");
   epoch = toEncodeEPOCH(toParseEPOCH(epoch3d), 3);
   if (epoch!=epoch3d)
     Console.WriteLine("3d differs: "+epoch+" <== "+epoch3d);
Console.WriteLine("4...");
   epoch = toEncodeEPOCH(toParseEPOCH(epoch4), 4);
   if (epoch!=epoch4)
     Console.WriteLine("4 differs: "+epoch+" <== "+epoch4);
Console.WriteLine("4b...");
   epoch = toEncodeEPOCH(toParseEPOCH(epoch4b), 4);
   if (epoch!=epoch4b)
     Console.WriteLine("4b differs: "+epoch+" <== "+epoch4b);
Console.WriteLine("4c...");
   epoch = toEncodeEPOCH(toParseEPOCH(epoch4c), 4);
   if (epoch!=epoch4c)
     Console.WriteLine("4c differs: "+epoch+" <== "+epoch4c);
Console.WriteLine("4d...");
   epoch = toEncodeEPOCH(toParseEPOCH(epoch4d), 4);
   if (epoch!=epoch4d)
     Console.WriteLine("4d differs: "+epoch+" <== "+epoch4d);
Console.WriteLine("5...");
   epoch = toEncodeEPOCH(toParseEPOCH(epoch5), 4);
   if (epoch!=epoch5)
     Console.WriteLine("5 differs: "+epoch+" <== "+epoch5);
Console.WriteLine("5b...");
   epoch = toEncodeEPOCH(UnixTimetoEPOCH(EPOCHtoUnixTime(toParseEPOCH(epoch5))), 4);
   if (epoch!=epoch5)
     Console.WriteLine("5b differs: "+epoch+" <== "+epoch5);

   string epoch160 =  "01-Jan-2012 12:23:34.678.789.890.901";
   string epoch160b =  "01-Jan-2012 12:23:34.678.789.890.901Z";
   string epoch160c =  "01-Jan-2012 12:23:34.678";
   string epoch160d =  "01-Jan-2012 12:23:34.678Z";
   string epoch160e =  "01-Jan-2012 12:23:34";
   string epoch160f =  "01-Jan-2012 12:23:34Z";
   string epoch161 =  "20130203.567890123456789";
   string epoch162 =  "20120101122334";
   string epoch163 =  "2013-02-03T02:33:34.567.678.789.890Z";
   string epoch163b = "2013-02-03 02:33:34.567.678.789.890Z";
   string epoch163c = "2013-02-03 02:33:34.567.678.789.890";
   string epoch163d=  "2013-02-03T02:33:34.567Z";
   string epoch163e=  "2013-02-03T02:33:34Z";
   string epoch164 =  "2013-02-03T02:33:34.567678789890";
   string epoch164b = "2013-02-03 02:33:34.567678789890Z";
   string epoch164c=  "2013-02-03T02:33:34.567";
   string epoch164d=  "2013-02-03T02:33:34";
   string epoch165=  "2013-02-03/02:33:34";

   double[] epoch16 = new double[2];

Console.WriteLine("\n\nepoch16  0...");
   epoch16 = toParseEPOCH16(epoch160);
   epoch = toEncodeEPOCH16(epoch16, 0);
   if (epoch!=epoch160)
     Console.WriteLine("0 differs: "+epoch+" <== "+epoch160);
Console.WriteLine("0b...");
   epoch16 = toParseEPOCH16(epoch160b);
   epoch = toEncodeEPOCH16(epoch16, 0);
   if (epoch!=epoch160b)
     Console.WriteLine("0b differs: "+epoch+" <== "+epoch160b);
Console.WriteLine("0c...");
   epoch16 = toParseEPOCH16(epoch160c);
   epoch = toEncodeEPOCH16(epoch16, 0);
   if (epoch!=epoch160c)
     Console.WriteLine("0c differs: "+epoch+" <== "+epoch160c);
Console.WriteLine("0d...");
   epoch16 = toParseEPOCH16(epoch160d);
   epoch = toEncodeEPOCH16(epoch16, 0);
   if (epoch!=epoch160)
     Console.WriteLine("0d differs: "+epoch+" <== "+epoch160d);
Console.WriteLine("0e...");
   epoch16 = toParseEPOCH16(epoch160e);
   epoch = toEncodeEPOCH16(epoch16, 0);
   if (epoch!=epoch160e)
     Console.WriteLine("0e differs: "+epoch+" <== "+epoch160e);
Console.WriteLine("0f...");
   epoch16 = toParseEPOCH16(epoch160f);
   epoch = toEncodeEPOCH16(epoch16, 0);
   if (epoch!=epoch160f)
     Console.WriteLine("0d differs: "+epoch+" <== "+epoch160f);
Console.WriteLine("1...");
   epoch16 = toParseEPOCH16(epoch161);
   epoch = toEncodeEPOCH16(epoch16, 1);
   if (epoch!=epoch161)
     Console.WriteLine("1 differs: "+epoch+" <== "+epoch161);
Console.WriteLine("2...");
   epoch16 = toParseEPOCH16(epoch162);
   epoch = toEncodeEPOCH16(epoch16, 2);
   if (epoch!=epoch162)
     Console.WriteLine("2 differs: "+epoch+" <== "+epoch162);
Console.WriteLine("3...");
   epoch16 = toParseEPOCH16(epoch163);
   epoch = toEncodeEPOCH16(epoch16, 3);
   if (epoch!=epoch163)
     Console.WriteLine("3 differs: "+epoch+" <== "+epoch163);
Console.WriteLine("3b...");
   epoch16 = toParseEPOCH16(epoch163b);
   epoch = toEncodeEPOCH16(epoch16, 3);
   if (epoch!=epoch163b)
     Console.WriteLine("3b differs: "+epoch+" <== "+epoch163b);
Console.WriteLine("3c...");
   epoch16 = toParseEPOCH16(epoch163c);
   epoch = toEncodeEPOCH16(epoch16, 3);
   if (epoch!=epoch163c)
     Console.WriteLine("3c differs: "+epoch+" <== "+epoch163c);
Console.WriteLine("3d...");
   epoch16 = toParseEPOCH16(epoch163d);
   epoch = toEncodeEPOCH16(epoch16, 3);
   if (epoch!=epoch163d)
     Console.WriteLine("3d differs: "+epoch+" <== "+epoch163d);
Console.WriteLine("3e...");
   epoch16 = toParseEPOCH16(epoch163e);
   epoch = toEncodeEPOCH16(epoch16, 3);
   if (epoch!=epoch163e)
     Console.WriteLine("3e differs: "+epoch+" <== "+epoch163e);
Console.WriteLine("4...");
   epoch16 = toParseEPOCH16(epoch164);
   epoch = toEncodeEPOCH16(epoch16, 4);
   if (epoch!=epoch164)
     Console.WriteLine("4 differs: "+epoch+" <== "+epoch164);
Console.WriteLine("4b...");
   epoch16 = toParseEPOCH16(epoch164b);
   epoch = toEncodeEPOCH16(epoch16, 4);
   if (epoch!=epoch164b)
     Console.WriteLine("4b differs: "+epoch+" <== "+epoch164b);
Console.WriteLine("4c...");
   epoch16 = toParseEPOCH16(epoch164c);
   epoch = toEncodeEPOCH16(epoch16, 4);
   if (epoch!=epoch164c)
     Console.WriteLine("4c differs: "+epoch+" <== "+epoch164c);
Console.WriteLine("4d...");
   epoch16 = toParseEPOCH16(epoch164d);
   epoch = toEncodeEPOCH16(epoch16, 4);
   if (epoch!=epoch164d)
     Console.WriteLine("4d differs: "+epoch+" <== "+epoch164d);
Console.WriteLine("5...");
   epoch16 = toParseEPOCH16(epoch165);
   epoch = toEncodeEPOCH16(epoch16, 4);
   if (epoch!=epoch165)
     Console.WriteLine("5 differs: "+epoch+" <== "+epoch165);
Console.WriteLine("5b...");
   epoch16 = toParseEPOCH16(epoch165);
   double tmp = EPOCH16toUnixTime(epoch16);
   epoch16 = UnixTimetoEPOCH16 (tmp);
   epoch = toEncodeEPOCH16(epoch16, 4);
   if (epoch!=epoch165)
     Console.WriteLine("5b differs: "+epoch+" <== "+epoch165);

   string tt20000 =  "01-Jan-2012 12:23:34.678789890";
   string tt20000b=  "01-Jan-2012 12:23:34.678789890Z";
   string tt20000c =  "01-Jan-2012 12:23:34.678Z";
   string tt20000d =  "01-Jan-2012 12:23:34.678";
   string tt20000e =  "01-Jan-2012 12:23:34Z";
   string tt20000f =  "01-Jan-2012 12:23:34";
   string tt20001 =  "20130203.5678901234";
   string tt20002 =  "20120101122334";
   string tt20003 =  "2013-02-03T02:33:34.567789890";
   string tt20003b = "2013-02-03 02:33:34.567789890";
   string tt20003c=  "2013-02-03T02:33:34.567";
   string tt20003d=  "2013-02-03T02:33:34";
   string tt20004 =  "2013-02-03T02:33:34.567789890Z";
   string tt20004b = "2013-02-03 02:33:34.567789890Z";
   string tt20004c=  "2013-02-03T02:33:34.567Z";
   string tt20004d=  "2013-02-03T02:33:34Z";

Console.WriteLine("\n\ntt2000  0...");
   epoch = toEncodeTT2000(toParseTT2000(tt20000), 0);
   if (epoch!=tt20000)
     Console.WriteLine("0 differs: "+epoch+" <== "+tt20000);
Console.WriteLine("0b...");
   epoch = toEncodeTT2000(toParseTT2000(tt20000b), 0);
   if (epoch!=tt20000b)
     Console.WriteLine("0b differs: "+epoch+" <== "+tt20000b);
Console.WriteLine("0c...");
   epoch = toEncodeTT2000(toParseTT2000(tt20000c), 0);
   if (epoch!=tt20000c)
     Console.WriteLine("0c differs: "+epoch+" <== "+tt20000c);
Console.WriteLine("0d...");
   epoch = toEncodeTT2000(toParseTT2000(tt20000d), 0);
   if (epoch!=tt20000d)
     Console.WriteLine("0d differs: "+epoch+" <== "+tt20000d);
Console.WriteLine("0e...");
   epoch = toEncodeTT2000(toParseTT2000(tt20000e), 0);
   if (epoch!=tt20000e)
     Console.WriteLine("0e differs: "+epoch+" <== "+tt20000e);
Console.WriteLine("0f...");
   epoch = toEncodeTT2000(toParseTT2000(tt20000f), 0);
   if (epoch!=tt20000f)
     Console.WriteLine("0f differs: "+epoch+" <== "+tt20000f);
Console.WriteLine("1...");
   epoch = toEncodeTT2000(toParseTT2000(tt20001), 1);
   if (epoch!=tt20001)
     Console.WriteLine("1 differs: "+epoch+" <== "+tt20001+" len:"+epoch.Length+" <== "+tt20001.Length);
Console.WriteLine("2...");
   epoch = toEncodeTT2000(toParseTT2000(tt20002), 2);
   if (epoch!=tt20002)
     Console.WriteLine("2 differs: "+epoch+" <== "+tt20002+" len:"+epoch.Length+" <== "+tt20002.Length);
Console.WriteLine("3...");
   epoch = toEncodeTT2000(toParseTT2000(tt20003), 3);
   if (epoch!=tt20003)
     Console.WriteLine("3 differs: "+epoch+" <== "+tt20003+" len:"+epoch.Length+" <== "+tt20003.Length);
Console.WriteLine("3b...");
   epoch = toEncodeTT2000(toParseTT2000(tt20003b), 3);
   if (epoch!=tt20003b)
     Console.WriteLine("3b differs: "+epoch+" <== "+tt20003b+" len:"+epoch.Length+" <== "+tt20003b.Length);
Console.WriteLine("3c...");
   epoch = toEncodeTT2000(toParseTT2000(tt20003c), 3);
   if (epoch!=tt20003c)
     Console.WriteLine("3c differs: "+epoch+" <== "+tt20003c+" len:"+epoch.Length+" <== "+tt20003c.Length);
Console.WriteLine("3d...");
   epoch = toEncodeTT2000(toParseTT2000(tt20003d), 3);
   if (epoch!=tt20003d)
     Console.WriteLine("3d differs: "+epoch+" <== "+tt20003d+" len:"+epoch.Length+" <== "+tt20003d.Length);
Console.WriteLine("4...");
   epoch = toEncodeTT2000(toParseTT2000(tt20004), 4);
   if (epoch!=tt20004)
     Console.WriteLine("4 differs: "+epoch+" <== "+tt20004+" len:"+epoch.Length+" <== "+tt20004.Length);
Console.WriteLine("4b...");
   epoch = toEncodeTT2000(toParseTT2000(tt20004b), 4);
   if (epoch!=tt20004b)
     Console.WriteLine("4b differs: "+epoch+" <== "+tt20004b+" len:"+epoch.Length+" <== "+tt20004b.Length);
Console.WriteLine("4c...");
   epoch = toEncodeTT2000(toParseTT2000(tt20004c), 4);
   if (epoch!=tt20004c)
     Console.WriteLine("4c differs: "+epoch+" <== "+tt20004c+" len:"+epoch.Length+" <== "+tt20004c.Length);
Console.WriteLine("4d...");
   epoch = toEncodeTT2000(toParseTT2000(tt20004d), 4);
   if (epoch!=tt20004d)
     Console.WriteLine("4d differs: "+epoch+" <== "+tt20004d+" len:"+epoch.Length+" <== "+tt20004d.Length);

   string[] t2 = new string[2];
   t2[0] = tt20003c;
   t2[1] = tt20003;
   long[] tt2 = toParseTT2000(t2);
   double[] utt2 = TT2000toUnixTime(tt2);
Console.WriteLine("unix time: "+utt2[0]+" "+utt2[1]);
   long[] ttt2 = UnixTimetoTT2000(utt2);
   string[] st2 = toEncodeTT2000(ttt2);
Console.WriteLine(tt20003c+" -> "+st2[0]+" "+tt20003+" -> "+st2[1]);

} catch (Exception ex) {
  Console.WriteLine("exception..."+ex);
}
}
}

